/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 */

/*
 * Licensed to Elasticsearch under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

package org.opensearch.painless.ir;

import org.opensearch.painless.ClassWriter;
import org.opensearch.painless.Location;
import org.opensearch.painless.MethodWriter;
import org.opensearch.painless.phase.IRTreeVisitor;
import org.opensearch.painless.symbol.WriteScope;

public class ConstantNode extends ExpressionNode {

    /* ---- begin node data ---- */

    private Object constant;

    public void setConstant(Object constant) {
        this.constant = constant;
    }

    public Object getConstant() {
        return constant;
    }

    /* ---- end node data, begin visitor ---- */

    @Override
    public <Scope> void visit(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        irTreeVisitor.visitConstant(this, scope);
    }

    @Override
    public <Scope> void visitChildren(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        // do nothing; terminal node
    }

    /* ---- end visitor ---- */

    public ConstantNode(Location location) {
        super(location);
    }

    @Override
    protected void write(ClassWriter classWriter, MethodWriter methodWriter, WriteScope writeScope) {
        switch (constant) {
            case String stringValue -> methodWriter.push(stringValue);
            case Double doubleValue -> methodWriter.push(doubleValue);
            case Float floatValue -> methodWriter.push(floatValue);
            case Long longValue -> methodWriter.push(longValue);
            case Integer intValue -> methodWriter.push(intValue);
            case Character charValue -> methodWriter.push(charValue);
            case Short shortValue -> methodWriter.push(shortValue);
            case Byte byteValue -> methodWriter.push(byteValue);
            case Boolean boolValue -> methodWriter.push(boolValue);
            case null, default -> throw new IllegalStateException("unexpected constant [" + constant + "]");
        }
    }
}
