# Changing the curriculum
OSSU thrives because of the changes made by our many contributors. Read on for details on how to help every student that follows you.
## Non-substantive changes
If you have non-substantive updates to make to the curriculum, such as a course's URL having been moved, spelling/syntax errors, etc., please send a [pull request](https://www.freecodecamp.org/news/how-to-make-your-first-pull-request-on-github-3/) to fix any mistakes that you have found.
## Substantive changes
If you have specific and substantive criticisms of the curriculum, i.e. problems related to the progression/content of courses it would be appropriate to [open an issue](https://help.github.com/articles/creating-an-issue/). While it is acceptable to point out problems, all successful changes naturally require a plan for fixing the problem.
OSSU’s curricular guidelines are [here](CURRICULAR_GUIDELINES.md). Successful critiques of the curriculum will point out ways that OSSU is failing to uphold these guidelines. Examples are:

* OSSU lists a course as required when the course topics are elective in the curricular guide.
* OSSU not having a course to cover required topics from the curricular guide.
* OSSU lists multiple courses that cover the same topics when fewer courses could suffice.
* OSSU recommends a course to teach a topic, but there exists a higher quality course that covers the same material.
## Other ways to contribute
### Responding to Issues
Issues require more than just users to suggest them. Issues require active community members to read and respond to proposals. Even adding simple [emoji reactions](https://github.blog/2016-03-10-add-reactions-to-pull-requests-issues-and-comments/) can help the community.
### Engaging with other students
Learning is enhanced by engaged peers. You can be that peer for someone new to OSSU. When you see a new person posting in Discord, ask them a question about themselves. When you see a cohort starting at _almost_ the right time, join in. Doing so will make OSSU a stronger program for everyone, including you.
# Personal Customization
If you want to customize the curriculum for yourself, you are encouraged to [fork this project](https://help.github.com/articles/fork-a-repo/)!
