# Frequently Asked Questions

This page answers some questions that we frequently receive about the curriculum.
If you have questions that aren't answered here, try asking through one of our [community channels](README.md#community).
If it seems important enough or we get asked that question a lot, we will probably add it here.

Alternatively, you could [contribute](CONTRIBUTING.md) an answer yourself.

## Contents

- [Does OSSU offer a degree?](#does-ossu-offer-a-degree)
- [How can I review the math prerequisites?](#how-can-i-review-the-math-prerequisites)
- [What is a good course to learn a language (C++, Rust, Java, etc)?](#what-is-a-good-course-to-learn-a-particular-language)
- [Why is the Firebase OSSU app different/broken?](#why-is-the-firebase-ossu-app-different-or-broken)
- [In what order should I take the courses?](#in-what-order-should-i-take-the-courses)
- [Does every resource in the main curriculum have to be free?](#does-every-resource-in-the-main-curriculum-have-to-be-free)
- [Are Coursera courses free to access?](#are-coursera-courses-free-to-access)
- [Is it necessary to purchase the Verified Upgrade for edX courses?](#is-it-necessary-to-purchase-the-verified-upgrade-for-edx-courses)
- [What are the alt links?](#what-are-the-alt-links)
- [Why doesn't the curriculum cover/ignore topic X?](#why-doesnt-the-curriculum-coverignore-topic-x)
- [Why is the curriculum missing some pre-requisites?](#why-is-the-curriculum-missing-some-pre-requisites)
- [Why require experience with a sizable project before the Software Engineering courses?](#why-require-experience-with-a-sizable-project-before-the-software-engineering-courses)
- [How can I find a course on a particular subject?](#how-can-i-find-a-course-on-a-particular-subject)

## Questions

### Does OSSU offer a degree?
No. OSSU creates guides to resources that will empower you to learn the curriculum of an undergraduate degree. Individuals who used to be involved in OSSU may be working with other organizations to offer degrees, but Open Source Society University is not involved in those efforts.

### How can I review the math prerequisites?

See our [Pre-College Math](https://ossu.dev/precollege-math) curriculum for a list of resources to use for reviewing the math prerequisites.

### What is a good course to learn a particular language?
OSSU focuses on finding the best courses to learn computer science topics, and isn’t focused on finding language-specific courses. If you are looking to learn a particular language or framework there are two great resources to check.
1. [Hackr.io](https://hackr.io/) allows users to submit and upvote learning resources for topics such as Python or the Java Spring Framework.
2. Most languages have a community on Reddit. When you find the community’s page, check to see if there is a wiki or sidebar with resources. For example, see [/r/python](https://old.reddit.com/r/Python). Note that the sidebar content can be different depending on whether you use www.reddit.com or old.reddit.com.

### Why is the Firebase OSSU app different or broken?

The OSSU curriculum and ecosystem have been collaboratively built by many individuals. The Firebase app was one such contribution. When it was written, it was with the intention of helping future OSSU students.

Unfortunately, the app has not been updated in many years. It does not reflect updates to the curriculum, it contains links to courses that no longer exist, and it has known bugs that prevent students from logging in.

It is our hope that the creators of the Firebase app can bring the app up to date. Until that time, the firebase app should be considered a deprecated product that is no longer supported.

### In what order should I take the courses?

You have a few different options:
- You can progress linearly from top to bottom of the page.
- You can progress linearly through each individual section, but studying different sections in parallel.
- You can design your own custom progression using the pre-requisites to guide you.

We have designed the curriculum to work for any of the above three styles.

### Does every resource in the main curriculum have to be free?

Yes, that is a core goal of OSSU.

At the same time, we recognize that education is a resource that requires payment to instructors to make it sustainable in the long term.
Therefore, we respect the business model of websites like edX, which make their materials free but with some paid add-ons, like official certificates or extra interaction with course instructors.

So we only require that the *learning materials* of a resource be free to access, not that every possible add-on be free.
It would be ideal if graded assignments were always free. In the event that free assessments are not available OSSU looks for alternate assessments to pair with a course.

### Are Coursera courses free to access?

Some courses that require payment to access probably do exist on Coursera, but we don't put those on our curriculum.
All Coursera courses that we put on the curriculum must, at minimum, be **free to audit**.
For some courses, all course features are available for free;
for others (especially those that are part of a specialization), you may only be able to access the lecture videos.
(If you find the policies have changed for any courses on our curriculum, please tell us!)

Unfortunately, for some courses, Coursera's interface is [very aggressive](https://www.deceptive.design/) about convincing you that you have to pay.

You may see something like this on the course page:

<img src="http://i.imgur.com/MxOcYZv.png" alt="Free Trial" style="width: 400px;"/>

When attempting to enroll in such a course:
- Click the blue "Enroll" or "Enroll Now" button.
- A pop-up will appear.
- **Do not click** "Start Free Trial", unless you do want to pay.
- Find the text that says "Audit this course" at the bottom.
- Click **Audit**.

![Audit this course](https://user-images.githubusercontent.com/3349406/27321369-95ca12e6-55cc-11e7-9b5c-f8fedd8fd643.png)

### Is it necessary to purchase the Verified Upgrade for edX courses?

If you just want to watch the videos, it is never necessary for any edX course on our curriculum. Note that a number of edX courses only allow students to audit a course for the estimated number of weeks it takes to complete. Students should not begin a course until they are prepared to focus and complete the course.

### What are the alt links?

Sometimes a course is on multiple platforms that are reasonably similar in quality so we have an alt or two linked in case the main one isn't being offered at the time or you prefer the other one. Both are just as good, go with whichever you prefer or whichever is available when you want to take the course.

### Why doesn't the curriculum cover/ignore topic X?

You can read more about our curricular guidelines and the qualifications of the guidelines' authors [here](CURRICULAR_GUIDELINES.md). If you find a topic that is required by our guidelines and is not included in the curriculum, we should make a change! Read more about [contributing to a change](CONTRIBUTING.md).

### Why is the curriculum missing some pre-requisites?

The curriculum assumes two things:
- You are reasonably fluent in English.
- You have gotten through a standard high school curriculum that included physics and pre-calculus.

Without these assumptions, the curriculum would be out of control with trying to fill in your knowledge gaps.
For those who want to study math pre-requisites, read more [here](#how-can-i-review-the-math-prerequisites)

Of course, if you find that the curriculum is missing a pre-requisite for a course that isn't part of a normal high school curriculum, please let us know!

### Why require experience with a sizable project before the Software Engineering courses?
Software engineering tries to solve the problem of dealing with large programs. Building a sizable program before taking the SE courses will help you understand what SE is trying to solve. We recommend the Jack-to-VM-code compiler project from the nand2tetris course because it's the first project in the curriculum that is complex enough to see value in an SE course. That said, any sizable project will do and can come from outside of the OSSU curriculum. The idea is that you've done some large enough project where the pieces started to feel unmanageable. This experience will expose pain points and lead to a better understanding of SE.

### How can I find a course on a particular subject?
After completing Core CS, learners are ready to pursue computer science
topics of their own interest. How can one find a course on a given topic?
For MOOCs an excellent resource is [Class Central](https://www.classcentral.com/).
For materials from university courses that are online (but not organized)
into a MOOC, [awesome-courses](https://github.com/prakhar1989/awesome-courses) and
[cs-video-courses](https://github.com/Developer-Y/cs-video-courses)
are good resources. For textbooks, [Goodreads](https://www.goodreads.com/genres/computer-science)
is a great platform for reader ratings and reviews.
For learning a particular programming language or framework,
[see this question](#what-is-a-good-course-to-learn-a-particular-language).
