# Introduction to Computer Science and Programming using Python

This course will introduce you to the world of computer science and programming, giving you a flavor of the material to come. If you finish the course wanting more, Computer Science is likely for you!

This course has been developed by MIT and is available on [MIT's OCW](https://ocw.mit.edu) platform.

> Introduction to Computer Science and Programming in Python is intended for students with little or no programming experience. It aims to provide students with an understanding of the role computation can play in solving problems and to help students, regardless of their major, feel justifiably confident of their ability to write small programs that allow them to accomplish useful goals. The class uses the Python programming language.

**Course Link:** <https://ocw.mit.edu/courses/6-100l-introduction-to-cs-and-programming-using-python-fall-2022/pages/material-by-lecture/>

## ⚠️ Under Review

This course is under review. The course has been designed to accommodate people completely new to programming. However, if you find the course difficult to follow, you can try doing one of the [Intro to Programming courses](../intro-programming/README.md) and then return to this course. We would like to hear your feedback regarding this course, and whether you needed to do the [Intro to Programming courses](../intro-programming/README.md) first. Please provide your feedback on this RFC: <https://github.com/ossu/computer-science/issues/1266>.

## Instructions

1. Open the [course link](https://ocw.mit.edu/courses/6-100l-introduction-to-cs-and-programming-using-python-fall-2022/pages/material-by-lecture/) given above. You will see a list of Lectures.
2. Clicking on the link of a particular lecture will present all the materials from that lecture to you.
3. Work through all the course lectures as given in the link above. Watch the videos, do the finger exercises, and then solve the problem sets.
4. You are not supposed to complete the problem sets as soon as they appear on a lecture page. You are supposed to start thinking about it from that point. The actual due dates, according to the [course calendar](https://ocw.mit.edu/courses/6-100l-introduction-to-cs-and-programming-using-python-fall-2022/pages/calendar/) are:

   - PSET 0 - Before lecture 1
   - PSET 1 - Before lecture 9
   - PSET 2 - Before lecture 12
   - PSET 3 - Before lecture 16
   - PSET 4 - Before lecture 20
   - PSET 5 - Before lecture 25

6. There are links to solution of finger exercises on each lecture page. Match your answers to the given solutions to grade yourself.
7. Each problem set come with a script and instructions to check your solution. Use them to grade yourself.
8. You don't need to install the full Anaconda distribution to do this course. See the notes section below for more information.
9. If you are stuck somewhere, feel free to ask questions. You can join the OSSU chat for this course here: <https://discord.gg/jvchSm9>.

## Notes

1. You don't need to install the full anaconda package to do this course. You can just download the Spyder IDE from here: <https://github.com/spyder-ide/spyder/releases/latest>. It comes bundles with python as well as some popular scientific python libraries (all the libraries which this course uses are included), but it is not as large or complex as the full anaconda distribution. You don't need to set up python separately or anything.
2. You can use VS Code, or any text editor/IDE you prefer. If you are using a text editor/IDE other than Spyder/Anaconda, you should note that the course sometimes ask you to run some additional statements after running a python file. To do so, run `python -i file.py`. Then you can run additional statements. 
3. You won't get any certificate for doing this course. If you really want a certificate, you need to do the faster instructor-paced [6.00.1x course on Edx](https://www.edx.org/course/introduction-to-computer-science-and-programming-7) on Edx. Certificate of an introductory course like this is not very valuable, so unless you are absolutely sure, we recommend you to do the 6.100L course linked above instead.
4. If for some reason you want to do the OCW version of the faster paced 6.0001 course, you can do that here: <https://ocw.mit.edu/courses/6-0001-introduction-to-computer-science-and-programming-in-python-fall-2016/>.
5. The course mentions the textbook [Introduction to Computation and Programming Using Python, third edition](https://mitpress.mit.edu/9780262542364/introduction-to-computation-and-programming-using-python/) as required reading. As with any course listed on OSSU, please remember: All paid additions should be considered optional. You will not fail this course if you do not read the textbook. "The book and the course lectures parallel each other, though there is more detail in the book about some topics." You are not missing out on enough for it to matter.

## Extra Practice

1. [https://introcomp.mit.edu/spring25/practice](https://introcomp.mit.edu/spring25/practice)
