# Computer Science - Great Readings

This document consists of great books or articles on computer science.
Some are here because there is a course covering the same material;
some are just great books that you should read at some point in your career.

Once you have made it through most of the curriculum, knowing whether a book is worth your time will become easier.
Or, if you are struggling in one of the courses, perhaps reading a book on the subject will help.

## Programming

Name | Author(s)
:-- | :--:
[Introduction to Computation and Programming Using Python 3e](https://mitpress.mit.edu/books/introduction-computation-and-programming-using-python-third-edition) | John V. Guttag
[Think Python 2e](http://greenteapress.com/wp/think-python-2e/) | Allen B. Downey
[How to Design Programs 2e](https://www.htdp.org/) | Matthias Felleisen, Robert Bruce Findler, Matthew Flatt, Shriram Krishnamurthi
[Structure and Interpretation of Computer Programs 2e](https://mitpress.mit.edu/sites/default/files/sicp/full-text/book/book.html) | Hal Abelson, Jerry Sussman, Julie Sussman
[The Structure and Interpretation of Computer Programs (2021, JavaScript)](https://sourceacademy.org/sicpjs/index) | Harold Abelson, Gerald Jay Sussman, Julie Sussman, Martin Henz, Tobias Wrigstad and Samuel Fang
[Concepts, Techniques, and Models of Computer Programming](https://www.amazon.com/gp/product/0262220695) | Peter Van Roy, Seif Haridi
[Design Patterns: Elements of Reusable Object-Oriented Software](https://www.amazon.com/Design-Patterns-Elements-Reusable-Object-Oriented/dp/0201633612) | Erich Gamma, Richard Helm, Ralph Johnson, John Vlissides
[Refactoring](https://www.refactoring.com/) | Martin Fowler
[Clean Code](https://www.amazon.com/Clean-Code-Handbook-Software-Craftsmanship/dp/0132350882) | Robert Martin
[Code Complete 2e](https://www.amazon.com/Code-Complete-Practical-Handbook-Construction/dp/0735619670) | Steve McConnell
[The Pragmatic Programmer 2e](https://pragprog.com/titles/tpp20/the-pragmatic-programmer-20th-anniversary-edition/) | Andrew Hunt, David Thomas
[Programming Languages: Application and Interpretation](http://cs.brown.edu/~sk/Publications/Books/ProgLangs/) | Shriram Krishnamurthi
[Programming and Programming Languages](https://papl.cs.brown.edu/2018/) | Shriram Krishnamurthi, Benjamin S. Lerner, Joe Gibbs Politz
[Competitive Programming](https://cpbook.net/) | Steven Halim, Felix Halim
[Introduction to computing in Java](https://introcs.cs.princeton.edu/java/home/) | Robert Sedgewick, Kevin Wayne

## Math

Name | Author(s)
:-- | :--:
[Calculus Made Easy](http://www.gutenberg.org/ebooks/33283) | Silvanus P. Thompson
[Ximera: Interactive Calculus Textbooks](https://ximera.osu.edu/) | [Ximera team](https://ximera.osu.edu/about/team)
[Discrete Mathematics with Applications (4th Edition)](http://www.amazon.com/Discrete-Mathematics-Applications-Susanna-Epp/dp/0495391328/) | Susanna S. Epp
[Discrete Mathematics: An Open Introduction](https://discrete.openmathbooks.org/dmoi4/frontmatter.html) | Oscar Levin
[Applied Discrete Structures](http://faculty.uml.edu/klevasseur/ads2/) | Alan Doerr, Ken Levasseur
[Grinstead and Snell’s Introduction to Probability](https://math.dartmouth.edu/~prob/prob/prob.pdf) | Charles M. Grinstead, J. Laurie Snell
[Linear Algebra for Everyone](https://math.mit.edu/~gs/everyone/) | Gilbert Strang
[The Art of Linear Algebra](https://github.com/kenjihiranabe/The-Art-of-Linear-Algebra) | Kenji Hiranabe, Gilbert Strang

## Systems

Name | Author(s)
:-- | :--:
[But How Do It Know?](http://www.buthowdoitknow.com/) | J. Clark Scott
[Computer Systems: A Programmer's Perspective (3rd Edition)](http://csapp.cs.cmu.edu/) | Randal E. Bryant, David R. O'Hallaron
[Modern Operating Systems (4th Edition)](http://www.amazon.com/Modern-Operating-Systems-Andrew-Tanenbaum/dp/013359162X/) | Andrew S. Tanenbaum, Herbert Bos
[Computer Organization and Design: The Hardware/Software Interface (6th Edition)](https://www.amazon.com/Computer-Organization-Design-MIPS-Architecture/dp/0128201096/) | David Patternson, John Hennessy
[Computer Networks (5th Edition)](http://www.amazon.com/Computer-Networks-5th-Andrew-Tanenbaum/dp/0132126958/) | Andrew S. Tanenbaum, David J. Wetherall
[Computer Networking: A Top-Down Approach (8th Edition)](https://gaia.cs.umass.edu/kurose_ross/index.html) | James F Kurose, Keith W Ross
[Computer Networks: A Systems Approach](https://book.systemsapproach.org/) | Larry Peterson and Bruce Davie
[Distributed Systems: Principles and Paradigms](https://www.amazon.com/Distributed-Systems-Principles-Andrew-Tanenbaum/dp/153028175X) | Andrew Tanenbaum
[Operating Systems Design and Implementation](https://www.amazon.com/Operating-Systems-Design-Implementation-3rd/dp/0131429388) | Andrew S. Tanenbaum, Albert S. Woodhull
[Crafting Interpreters](https://www.craftinginterpreters.com/contents.html) | Robert Nystrom
[Principles of Compiler Design](https://www.amazon.com/Principles-Compiler-Addison-Wesley-information-processing/dp/0201000229) | Alfred Aho, Jeffrey Ullman
[Distributed Systems Reading Group](http://dsrg.pdos.csail.mit.edu/papers/) | Various
[System Design: Design large-scale systems](https://github.com/donnemartin/system-design-primer) | Various

## Theory

Name | Author(s)
:-- | :--:
[Introduction to Computing: Explorations in Language, Logic, and Machines](http://www.computingbook.org/) | David Evans
[Introduction to the Theory of Computation (3rd Edition)](https://www.amazon.com/Introduction-Theory-Computation-Michael-Sipser/dp/113318779X) | Michael Sipser
[Introduction to Algorithms (3rd Edition)](http://www.amazon.com/Introduction-Algorithms-3rd-MIT-Press/dp/0262033844/) | Thomas H. Cormen, Charles E. Leiserson, Ronald L. Rivest, Clifford Stein
[The Algorithm Design Manual (3rd Edition)](https://www.algorist.com/) | Steven Skiena
[Algorithms (4th Edition)](https://algs4.cs.princeton.edu/home/) | Robert Sedgewick
[Algorithms Illuminated](https://algorithmsilluminated.org/) | Tim Roughgarden
[Category Theory: A Gentle Introduction](http://www.logicmatters.net/resources/pdfs/GentleIntro.pdf) | Peter Smith
[Category Theory for Programmers: The Preface](https://bartoszmilewski.com/2014/10/28/category-theory-for-programmers-the-preface/) | Bartosz Milewski
[An Introduction to Information Retrieval](https://nlp.stanford.edu/IR-book/pdf/irbookonlinereading.pdf) | Christopher D. Manning, Prabhakar Raghavan, Hinrich Schütze
[Computer Science: An interdisciplinary approach](https://introcs.cs.princeton.edu/java/cs/) | Robert Sedgewick, Kevin Wayne
[DSA CS3: Data Structures & Algorithms](https://opendsa-server.cs.vt.edu/OpenDSA/Books/CS3/html/) ([Coursenotes](https://opendsa-server.cs.vt.edu/OpenDSA/Books/CS3notes/html/) - [Slides](https://opendsa-server.cs.vt.edu/OpenDSA/Books/CS3slides/html/)) | The OpenDSA Project (supported by National Science Foundation)

## Applications

Name | Author(s)
:-- | :--:
[Architecture of a Database System](http://db.cs.berkeley.edu/papers/fntdb07-architecture.pdf) | Joseph M. Hellerstein, Michael Stonebraker, James Hamilton
[Readings in Database Systems (5th Edition)](http://www.redbook.io/) | Peter Bailis, Joseph M. Hellerstein, Michael Stonebraker, editors
[Database Management Systems (3rd Edition)](https://www.amazon.com/gp/product/0072465638) | Raghu Ramakrishnan, Johannes Gehrke
[Transaction Processing: Concepts and Techniques](https://www.amazon.com/Transaction-Processing-Concepts-Techniques-Management/dp/1558601902) | Jim Gray, Andreas Reuter
[Data and Reality: A Timeless Perspective on Perceiving and Managing Information in Our Imprecise World (3rd Edition)](https://www.amazon.com/Data-Reality-Perspective-Perceiving-Information/dp/1935504215) | William Kent
[The Architecture of Open Source Applications](http://aosabook.org/en/) | Michael DiBernardo (editor)
[An Introduction to Statistical Learning](https://www-bcf.usc.edu/~gareth/ISL/) | Gareth James, Daniela Witten, Trevor Hastie and Robert Tibshirani
[Deep Learning](http://www.deeplearningbook.org/) | Ian Goodfellow, Yoshua Bengio and Aaron Courville
[Bayesian Reasoning and Machine Learning](http://web4.cs.ucl.ac.uk/staff/D.Barber/pmwiki/pmwiki.php?n=Brml.HomePage) | David Barber
[Language Implementation Patterns](https://www.amazon.com/gp/product/193435645X) | Terence Parr
[Compilers: Principles, Techniques, and Tools (2nd Edition)](http://www.amazon.com/Compilers-Principles-Techniques-Tools-2nd/dp/0321486811/) | Alfred V. Aho, Monica S. Lam, Ravi Sethi,  Jeffrey D. Ullman
[Compiler Construction](https://inf.ethz.ch/personal/wirth/CompilerConstruction/index.html) | Niklaus Wirth 
[The Mythical Man-Month](https://www.amazon.com/Mythical-Man-Month-Software-Engineering-Anniversary/dp/0201835959/) | Fred Brooks, Jr.
[Physically Based Rendering: From Theory To Implementation](http://www.pbr-book.org/) | Matt Pharr, Wenzel Jakob, and Greg Humphreys


## Tools

Name | Author(s)
:-- | :--:
[The Linux Command Line](https://linuxcommand.org/tlcl.php) | by William Shotts
