## Contributing Guidelines

We have a few guidelines in place to keep the repo clean and easy to navigate. We recommend that you follow these conventions in your pull-request for a speedy merge. Note that every pull request we receive must have Two-Thumbs-Up minimum from PWL organizers/collaborators to be merged.

### Follow the group's ethos

We want to help bring academic research closer to practitioners and we strive to:
* **Adhere to [Papers We Love Code of Conduct](https://github.com/papers-we-love/papers-we-love/blob/master/CODE_OF_CONDUCT.md)**.
* **Keep the quality of papers listed high:** Books, blogposts, and/or reference pdfs don't go through the same review process that academic papers do and we won't add them to this repo.
* **Help people understand why a paper is important:** We ask that you include with your commit an update to the directory README with a short justification of why you love this paper (for example: A paper might be interesting because it spawned a new domain, it was exceptionally well-written, or perhaps it was completely wrong about something.) Take look at this [pull request](https://github.com/papers-we-love/papers-we-love/pull/282/files) as a model.

### Respect content licenses

* **We will only merge pull requests that contain research papers that allow digital distribution.** Papers whose copyright prohibits redistribution will not be accepted; for example [license 8](http://www.acm.org/publications/policies/copyright-policy-v8/) from the [ACM digital library](http://www.acm.org/publications/policies/copyright_policy).
* We encourage papers that do not allow digital distribution to be added to a README, with a link to the source URL, in the appropriate subject's folder. For example, [the distributed systems README](https://github.com/papers-we-love/papers-we-love/blob/master/distributed_systems/README.md).

### Follow our commit, naming, and directory-organization conventions

* Directory names are undercased and separated by underscores (example: artificial_intelligence)
* Paper names are undercased and separated by dashes (example: out-of-the-tar-pit.pdf). Use the full title when possible.
* If your pull request includes a binary file, like a `*.pdf` for example, please still include a link to the source URL in the appropriate subject's folder's README file and highlight it with a :scroll: emoji to show that the directory contains the file itself. Here's an example [pull request](https://github.com/papers-we-love/papers-we-love/pull/366/files).
* After raising [this issue](https://github.com/papers-we-love/papers-we-love/issues/290), it would beneficial to also include the *year* along with the title, link, and description/importance when adding paper(s) to a README.
* Please rebase all multi-commit branches/PRs into 1 single commit.

### Copyright

The name "Papers We Love" and the logos for the organization are copyrighted, and under the ownership of Papers We Love Ltd, all rights reserved. When starting a chapter, please review [our guidelines](https://github.com/papers-we-love/papers-we-love/wiki/Creating-a-PWL-chapter) and ask us about using the logo.
