### Rendering

* :scroll: [Digital Video Stabilization and Rolling Shutter Correction using Gyroscopes](http://graphics.stanford.edu/papers/stabilization/karpenko_gyro.pdf)
This is a really great paper that is both complex and straightforward. This paper "present a robust, real-time video stabilization and rolling shutter correction technique based on gyroscopes". I think this is a great paper because it makes a clever use of a commodity technology (smartphones' gyroscopes) to make a state-of-the-art improvement to a central components of phones: video cameras by removing the shakes and rolling shutter artifacts of a video in real-time.

* [An Improved Illumination Model for Shaded Display](https://www.cs.drexel.edu/~david/Classes/CS586/Papers/p343-whitted.pdf)

* [GigaVoxels : Ray-Guided Streaming for Efficient and Detailed Voxel Rendering](http://maverick.inria.fr/Publications/2009/CNLE09/CNLE09.pdf) - [Web page](http://maverick.inria.fr/Publications/2009/CNLE09/) - [Project page](http://gigavoxels.imag.fr/) - [Video](https://www.youtube.com/watch?v=HScYuRhgEJw)

* [Continuous shading of curved surfaces](http://page.mi.fu-berlin.de/block/htw-lehre/wise2015_2016/bel_und_rend/skripte/gouraud1971.pdf) by Henri Gouraud (1971)

* [Illumination for computer generated pictures](http://users.cs.northwestern.edu/~ago820/cs395/Papers/Phong_1975.pdf) by Bui Tuong Phong (1975)

* [The Rendering Equation](http://www.cs.rpi.edu/~cutler/classes/advancedgraphics/S08/lectures/kajiya.pdf) by James T. Kajiya (1986)

### Surface reconstruction
* [Poisson surface reconstruction](http://research.microsoft.com/en-us/um/people/hoppe/poissonrecon.pdf) - [Code](http://www.cs.jhu.edu/~misha/Code/PoissonRecon/Version5.71/)

* [KinectFusion: Real-time 3D Reconstruction and Interaction Using a Moving Depth Camera](https://www.microsoft.com/en-us/research/wp-content/uploads/2016/02/kinectfusion-uist-comp.pdf)

### Object modeling
* [3-Sweep: Extracting Editable Objects from a Single Photo](http://www.cs.tau.ac.il/~dcor/articles/2013/3-Sweep-Extracting-Editable-Objects.pdf) - [Video](https://www.youtube.com/watch?v=Oie1ZXWceqM)

### Photo editing
* [Deep Photo Style Transfer](https://arxiv.org/pdf/1703.07511.pdf) (2017) - [Code](https://github.com/luanfujun/deep-photo-styletransfer) - A deep-learning approach to photographic style transfer (that is, taking the style of one photo and automatically applying it to another). The images in this paper are gorgeous.

### Lighting
* [Light Propagation Volumes in CryEngine 3](http://www.crytek.com/download/Light_Propagation_Volumes.pdf)

### Bump mapping
* [Interactive Horizon Mapping: Shadows for bump-mapped surfaces](https://www.ppsloan.org/publications/bs.pdf)

### Interior mapping
* [Interior Mapping: A new technique for rendering realistic buildings](http://www.proun-game.com/Oogst3D/CODING/InteriorMapping/InteriorMapping.pdf)

### Procedural modeling
* Both of these papers are great examples of a non-traditional
  application of grammar-driven generation:
  - [Procedural Modeling of Buildings](http://www.peterwonka.net/Publications/pdfs/2006.SG.Mueller.ProceduralModelingOfBuildings.final.pdf)
  - [Instant Architecture](http://www.peterwonka.net/Publications/pdfs/2003.SG.Wonka.InstantArchitecture.high.pdf)

### Mesh Editing
* [PushPull++](http://peterwonka.net/Publications/pdfs/2014.SG.Lipp.PushPull.pdf)

    > Of all the ways to manipulate a 3D mesh, push/ technique popularized by SketchUp is one of the most approachable and fun. PushPull++ is a recent paper that elaborates on the technique, cleaning up a lot of edge cases and unlocking new features, using wonderfully straightforward math. The potential for 3D modeling tools or procedural mesh generation APIs built on these simple ideas is very exciting.
    > The paper presents the technique and the tool that the authors built. I will focus on the technique, as s the part I loved more in this paper (quote by Ramsey Nasser).
    
### Image Processing
* :scroll: [Imaging Vector Fields Using Line Integral Convolution](http://cs.brown.edu/courses/csci2370/2000/1999/cabral.pdf) by Brian Cabral and Leith Leedom    

### Shape grammars

* [Shape Grammars and the Generative Specification of Painting and Sculpture](http://shapegrammar.org/ifip/SGBestPapers72.pdf)
  - A seminal paper that lead to many interesting applications in
    graphics as well as more broadly in design; see also the
    bibliography at [shapegrammar.org](http://shapegrammar.org/).

### Simulating Ocean Water

* [Simulating Ocean Water](http://citeseerx.ist.psu.edu/viewdoc/download?doi=10.1.1.161.9102&rep=rep1&type=pdf)
  - Seminal paper on water surface simulation and rendering.
 

### Matting

* [Blue Screen Matting](https://graphics.stanford.edu/courses/cs148-09-fall/papers/smith-blinn.pdf), by Alvy Ray Smith and James F. Blinn.
* [Bayesian Approach to Digital Matting](https://grail.cs.washington.edu/projects/digital-matting/papers/cvpr2001.pdf), by Yung-Yu Chuang, Brian Curless, David H. Salesin and Richard Szeliski.
* [Learning-based Sampling for Natural Image Matting](https://openaccess.thecvf.com/content_CVPR_2019/papers/Tang_Learning-Based_Sampling_for_Natural_Image_Matting_CVPR_2019_paper.pdf), by Jingwei Tang, Yagız Aksoy, Cengiz Oztireli, Markus Gross and Tunc Ozan Aydın. Disney Research at ETH Zurich.

