# Cryptography 

* [A Method for Obtaining Digital Signatures and Public-Key Cryptosystems (1977)](https://dl.acm.org/doi/10.1145/359340.359342)
* [Twenty Years of Attacks on the RSA Cryptosystem (1999)](https://crypto.stanford.edu/~dabo/papers/RSA-survey.pdf)
* :scroll: [Communication Theory of Secrecy Systems (1949)](communication-theory-of-secrecy-systems.pdf)
* [New Directions in Cryptography (1976)](http://www-ee.stanford.edu/~hellman/publications/24.pdf)
* [RSA Key Extraction via Low-Bandwidth Acoustic Cryptanalysis (2013)](http://www.cs.tau.ac.il/~tromer/papers/acoustic-20131218.pdf)
* [The Moral Character of Cryptographic Work (2015)](http://web.cs.ucdavis.edu/~rogaway/papers/moral-fn.pdf)
* [:scroll:](ntru-prime.pdf) [NTRU Prime (2016)](https://eprint.iacr.org/2016/461.pdf) (Daniel J. Bernstein, Chitchanok Chuengsatiansup, Tanja Lange, and Christine van Vredendaal)
* [Key Reinstallation Attacks: Forcing Nonce Reuse in WPA2 (2017)](https://papers.mathyvanhoef.com/ccs2017.pdf) (Mathy Vanhoef, Frank Piessens)

## Related Works
### [A Mathematical Theory of Cryptography (1945)](https://www.iacr.org/museum/shannon/shannon45.pdf) - Shannon
The original classified memo for Bell Labs that was republished in 1949 as ["Communication Theory of Secrecy Systems"](communication-theory-of-secrecy-systems.pdf).

### :scroll: [A Mathematical Theory of Communication (1948)](../information_theory/a-mathematical-theory-of-communication-1948.pdf) - Shannon
Shannon said that his wartime insights into communication theory and cryptography developed simultaneously and that "they were so close together you couldn’t separate them". ["Communication Theory of Secrecy Systems"](communication-theory-of-secrecy-systems.pdf) incorporates many concepts and formulations that also appeared in his 1948 paper.
