# Functional Programming

* :scroll: [Organizing Programs Without Classes](organizing-programs-without-classes.pdf)
* [:scroll:](functional-programming-with-bananas-lenses-envelops-and-barbed-wire.pdf) [Functional Programming with Bananas, Lenses, Envelopes and Barbed Wire](http://eprints.eemcs.utwente.nl/7281/01/db-utwente-40501F46.pdf)

    From Patrick Thomson's [An introduction to Recursion Schemes](http://patrickthomson.ghost.io/an-introduction-to-recursion-schemes/):

    > In 1991, Erik Meijer, Maarten Fokkinga, and Ross Paterson published their now-classic paper Functional Programming with Bananas, Lenses, Envelopes and Barbed Wire. Though this paper isn’t widely known outside of the functional programming community, its contributions are astonishing: the authors use category theory to express a set of simple, composable combinators, called recursion schemes, that automate the process of traversing and recursing through nested data structures. Though recursion schemes predate Meijer et. al’s work, this paper brings the enormous abstractive power of category theory to bear on the subject of traversing data structures—it’s a magnificent example of how category-theoretical concepts can bring both rigor and simplicity to day-to-day programming tasks.

* :scroll: [Equal Rights for Functional Objects or,
The More Things Change, The More They Are the Same](equal-rights-for-functional-objects.pdf)
* :scroll: [Optimal Purely Functional Priority Queues](optimal-purely-functional-priority-queues.pdf)
* :scroll: [Why Functional Programming Matters](why-functional-programming-matters.pdf)
* [:scroll:](purely-functional-data-structures.pdf) [Purely Functional Data Structures](https://web.archive.org/web/20051229012826id_/http://www.cs.cmu.edu:80/~rwh/theses/okasaki.pdf)


## Applicative Programming

* [Backtracking Iterators](https://www.lri.fr/~filliatr/publis/enum2.pdf)

* [Breadth-First Numbering: Lessons from a Small Exercise in Algorithm Design](http://www.cs.tufts.edu/~nr/cs257/archive/chris-okasaki/breadth-first.pdf)

## Concatenative Programming

* :scroll: [Concatenative Programming: An Overlooked Paradigm in Functional Programming](concatenative-programming-an-overlooked-paradigm.pdf)

## Imperative Programming - Functional Programming

* [Crossing the Gap from Imperative to Functional Programming through Refactoring](http://dig.cs.illinois.edu/papers/lambdaRefactoring.pdf)
