# Clojure

This is a cross-listing of papers related to Clojure, it's core, contrib and popular libraries. Papers noted at Clojure talks, meetups, and conferences can be found here as well.
## Data Structures
* core.rrb-vector
  * [RRB-Trees: Efﬁcient Immutable Vectors](http://infoscience.epfl.ch/record/169879/files/RMTrees.pdf)

## Pattern Matching
* core.match
  * [Compiling Pattern Matching to good Decision Trees](http://www.cs.tufts.edu/~nr/cs257/archive/luc-maranget/jun08.pdf)

## Type Theory
* [:scroll:](a-practical-optional-type-system-for-clojure.pdf) [Practical Optional Types for Clojure](http://frenchy64.github.io/papers/typed-clojure-draft.pdf) (draft)

## Clojure/West 2014
* Applicative Functional Programming 
  * [Backtracking Iterators](https://www.lri.fr/~filliatr/publis/enum2.pdf)
  * [Breadth-First Numbering: Lessons from a Small Exercise in Algorithm Design](http://www.cs.tufts.edu/~nr/cs257/archive/chris-okasaki/breadth-first.pdf)
* Testing
  * QuickCheck
    * [QuickCheck: A Lightweight Tool for Random Testing of Haskell Programs](http://www.cs.tufts.edu/~nr/cs257/archive/john-hughes/quick.pdf)
    * [QuickCheck Testing for Fun and Profit](http://people.inf.elte.hu/center/fulltext.pdf)
    * Property-Based Testing, best explained in John Hughes own talk [Testing the Hard Stuff and Staying Sane](https://www.youtube.com/watch?v=zi0rHwfiX1Q&list=PLZdCLR02grLp__wRg5OTavVj4wefg69hM).
