# Haskell

* [A History of Haskell: Being Lazy With Class](http://research.microsoft.com/en-us/um/people/simonpj/papers/history-of-haskell/history.pdf) by Paul Hudak, John Hughes, Simon Peyton Jones
* :scroll: [Tackling the Awkward Squad: monadic input/output, concurrency, exceptions, and foreign-language calls in Haskell](tackling-the-awkward-squad-monadic-input-output-concurrency-exceptions-and-foreign-language-calls-in-haskell.pdf) by Simon Peyton Jones
* :scroll: [Making a Fast Curry: Push/Enter vs. Eval/Apply for Higher-order Languages](making-a-fast-curry-push-enter-versus-eval-apply-for-higher-order-languages.pdf) by Simon Marlow and Simon Peyton Jones. A classic... describes well the execution model GHC uses for Haskell, and catches the brilliant authors in a design pivot from original intuition to new conclusions based on empirical data.
* :scroll: [A Poor Man's Concurrency Monad](a-poor-mans-concurrency-monad.pdf) by Koen Claessen. Paper describes how without adding any primitives to the language, you could define a concurrency monad transformer in Haskell.
* :scroll: [Parallel Generational-Copying Garbage Collection with a Block-Structured Heap](../../garbage_collection/parallel_generational_copying_garbage_collection_with_a_block_structured_heap.pdf). In Haskell, data immutability forces us to produce a lot of temporary data but also helps to collect this garbage rapidly. This paper explains how the Glasgow Haskell Compiler accomplishes this task in a simple, yet effective, manner with no programmer intervention.
* [Notions of Computation and Monads](https://core.ac.uk/download/pdf/82259574.pdf) by Eugenio Moggi. One of the canonical references for Monads in the functional paradigm. It relates the semantics of computations to equivalences of programs for various notions of computations.
* [The Essence of Functional Programming](https://page.mi.fu-berlin.de/scravy/realworldhaskell/materialien/the-essence-of-functional-programming.pdf) by Philip Wadler. This paper uses monads to structure functional programs in Haskell. A very good reference for understanding monads and more generally in the context of programming languages.
* [Monad Transformers and Modular Interpreters](https://dl.acm.org/doi/pdf/10.1145/199448.199528) by Sheng Liang, Paul Hudak and Mark Jones. Canonical paper on Monad Transformers: the canonical way in which to combine monads and the basis of the popular mtl Haskel library.
* [Extensible Effects: An Alternative to Monad Transformers](http://okmij.org/ftp/Haskell/extensible/exteff.pdf) by Oleg Kiselyov, Amr Sabry and Cameron Swords. A popular position paper introducing algebraic effects as an alternative to Monad Transformers. Effects are modelled using type level Open Unions of Effect Sets (one for each effect) with the Free Monad interpretation of Algebraic Effects. Is the basis for the extensible effects library.
* [Freer Monads, More Extensible Effects](http://okmij.org/ftp/Haskell/extensible/more.pdf) by Oleg Kiselyov and Hiromi Ishii. An extension of the extensible-effects library that removes the Functor constraint on the Free Monad Type.
* [Data types a la carte](https://www.cambridge.org/core/services/aop-cambridge-core/content/view/14416CB20C4637164EA9F77097909409/S0956796808006758a.pdf/data-types-a-la-carte.pdf) by Wouter Swierstra. Popular paper on using smart constructors and injection operators in order to solve Wadler's expression problem. Also a canonical method of developing algebraic effects by using effect Functors, see Wu, Shrijvers and Hinze(below).
* [Effect Handlers in Scope](http://www.cs.ox.ac.uk/people/nicolas.wu/papers/Scope.pdf) by Nicolas Wu, Tom Shrijvers and Ralf Hinze. Very interesting paper on developing algebraic effects, and handlers a la carte. Extends Swierstra's work by introducing higher order syntax to handle the interaction of effects (such as state and exceptions where errors backtrack the state). 
* [Fusion for Free: Efficient Algebraic Handlers](https://people.cs.kuleuven.be/~tom.schrijvers/Research/papers/mpc2015.pdf) by Nicolas Wu and Tom Shrijvers. Under the Interpretation of effectful computations as Free Monad abstract syntax trees and handlers as folds, this paper introduces Term Monads to folds in order to enable fold fusion. The handlers may then be combined into a single fold and inlined by GHC to provide performance that rivals, and in some cases, outperforms extensible effects and mtl libraries (proofs and tests included).
* [Handlers In Action](http://homepages.inf.ed.ac.uk/slindley/papers/handlers.pdf) by Ohad Kammar, Sam Lindley and Nicolas Oury. A popular position paper and basis of a Haskell library to develop algebraic effects and handlers. The template Haskell library supports open handlers by using type families instead of co-product functors a la carte.
* [Composing Fractals](http://web.cecs.pdx.edu/~mpj/pubs/composing-fractals.pdf) by Mark P. Jones. This paper describes a simple but flexible family of Haskell programs for drawing pictures of fractals such as Mandelbrot and Julia sets. Its main goal is to showcase the elegance of a compositional approach to program construction, and the benefits of a clean separation between different aspects of program behavior.
