# Pattern Matching

[Pattern matching algorithms](https://en.wikipedia.org/wiki/Pattern_matching) extend beyond strings, to include trees and other data structures. 

🧭 Part of the pattern-matching group, in PWL

* [Pattern Matching](../pattern_matching/README.md)
* [Stringology](../pattern_stringology/README.md)

----

* :scroll: [Compiling Pattern Matching to good Decision Trees](compiling-pattern-matching-to-good-decision-trees.pdf) by Luc Maranget. Paper address the issue of compiling ML pattern matching to efficient decisions trees.
* :scroll: [Extensible Pattern Matching in an Extensible Language](extensible-pattern-matching-extensible-language.pdf) by Sam Tobin-Hochstadt. Paper present a sophisticated pattern matcher for [Racket](http://racket-lang.org/), implemented as language extension using macros.
* :scroll: [Warnings for pattern matching](warnings-for-pattern-matching.pdf) by Luc Maranget. Paper examine the ML pattern-matching anomalies of useless clauses and non-exhaustive matches.
* :scroll: [Efficient String Matching: An Aid to Bibliographic Search](aho-corasick-string-matching.pdf) by Alfred V. Aho and Margaret J. Corasick. A single-pass pattern matching algorithm used in early versions of fgrep and similar projects. [Aho–Corasick entry](http://xlinux.nist.gov/dads//HTML/ahoCorasick.html) in NIST's Dictionary of Algorithms and Data Structures.

## Clustering Algorithms

* [On the resemblance and containment of documents](https://www.cs.princeton.edu/courses/archive/spr05/cos598E/bib/broder97resemblance.pdf) (Andrei Z. Broder)
