# Sublinear Algorithms

## Hosted Papers :open_file_folder:

* :scroll: **[Probablistic Counting Algorithms for Database Applications](https://github.com/papers-we-love/papers-we-love/blob/master/sublinear_algorithms/1985-Flajolet-Probabilistic-counting.pdf)**

    This paper introduces a class of probabilistic counting algorithms with which one can estimate the number of distinct elements in a large collection of data (typically a large file stored on disk) in a single pass using only a small additional storage (typically less than a hundred binary words) and only a few operations per element scanned. The algorithms are based on statistical observations made on bits of hashed values of records. They are by construction totally insensitive to the replicative structure of elements in the file; they can be used in the context of distributed systems without any degradation of performances and prove especially useful in the context of data bases query optimisation

    *Flajolet, Philippe, and G. Nigel Martin. "Probabilistic counting algorithms for data base applications." Journal of computer and system sciences 31.2 (1985): 182-209.*

* :scroll: **[An Elementary Proof of a Theorem of Johnson and Lindenstrauss](https://github.com/papers-we-love/papers-we-love/blob/master/sublinear_algorithms/An-Elementary-Proof-of-a-Theorem-of-Johnson-and-Lindenstrauss.pdf)**

    A result of Johnson and Lindenstrauss shows that a set of n points in high dimensional Euclidean space can be mapped into an `O(log n/ϵ2)-dimensional` Euclidean space such that the distance between any two points changes by only a factor of `(1 ± ϵ)`. In this note, we prove this theorem using elementary probabilistic techniques.

    *Dasgupta, Sanjoy, and Anupam Gupta. "An elementary proof of a theorem of Johnson and Lindenstrauss." Random Structures & Algorithms 22.1 (2003): 60-65.*

