---
title: "Welcome"
description: "Welcome to the Pathway developer hub"
navigation: true
heading: false
toc: false
---

# Welcome to Pathway Developer Documentation!

Pathway is a Python data processing framework for analytics and AI pipelines over data streams.
It's the ideal solution for real-time processing use cases like streaming ETL or RAG pipelines for unstructured data.

::card-grid{columns="2"}
#default
    ::landing-card
    ---
    icon: 'heroicons:bolt-solid'
    button:
        text: 'Starting examples'
        href: '/developers/user-guide/introduction/first_realtime_app_with_pathway'
    ---
    #title
    Getting Started

    #default
    Install Pathway using `pip`:

    ```bash
    pip install pathway
    ```

    ::
    ::landing-card
    ---
    icon: 'heroicons:book-open-20-solid'
    button:
        text: 'Pathway Templates'
        href: '/developers/templates'
    ---
    #title
    Try Our Templates

    #default
    Pathway offers ready-to-go templates for RAG and ETL pipelines.
    Run Pathway on your data in minutes.
    ::
::


## Key Features:
- **Easy-to-use Python API**: Pathway is fully compatible with Python. Use your favorite Python tools and ML libraries.
- **Scalable Rust engine**: your Python code is run by a powerful Rust engine with multithreading and multiprocessing. No JVM and no GIL!
- **Stateful operations**: use stateful and temporal operations such as groupby and windows.
- **Incremental computations**: using Differential Dataflow, Pathway takes care of out-of-order data points for you, in real time.
- **Batch and streaming alike**: use the same pipeline on static data and live data streams.
- **In-memory data processing**: real-time updates, reduced latency, and higher throughput.
- **Easy to deploy** with Docker or Kubernetes. Pathway comes with an orchestrator and is fully compatible with OpenTelemetry.
- **Exactly once consistency**: obtain the same results in both batch and streaming.
- **Persistence and backfilling**: save the state of the computation to quickly resume after a failure or a pipeline update.
- **LLM tooling**: online ML, RAG pipelines, vector indexes... With Pathway, your ML pipeline works on fresh data.
- **Connect to any data source**: Pathway comes with 350+ connectors, including SharePoint. Or implement your own.

<!-- https://www.canva.com/design/DAGEipyLAgo/kZCSb7DqOXTnVbvghT2m2w/edit?utm_content=DAGEipyLAgo&utm_campaign=designshare&utm_medium=link2&utm_source=sharebutton -->
<!-- ![Pathway Rust engine makes it fast, scalable, and safe.](/assets/content/documentation/why-pathway/why-pathway-rust.svg) -->
::article-img
---
src: '/assets/content/documentation/why-pathway/why-pathway-rust-new.svg'
alt: 'Pathway Rust engine makes it fast, scalable, and safe.'
zoomable: true
class: 'mx-auto mt-16 mb-8'
width: '500'
---
::


## What's next?
- [Installation](/developers/user-guide/introduction/installation)
- [Pathway Overview](/developers/user-guide/introduction/pathway-overview)
- [Examples](/developers/user-guide/introduction/first_realtime_app_with_pathway)
- [Core concepts](/developers/user-guide/introduction/concepts)
- [Why Pathway](/developers/user-guide/introduction/why-pathway)
- [Streaming and Static Modes](/developers/user-guide/introduction/streaming-and-static-modes)
- [Batch Processing](/developers/user-guide/introduction/batch-processing)
- [Deployment](/developers/user-guide/deployment/cloud-deployment)
- [LLM tooling](/developers/user-guide/llm-xpack/overview)


## GitHub repository
Pathway sources are available on GitHub.
Don't hesitate to clone the repo and contribute!

::container{.flex .gap-8 .items-center .w-full .justify-center}
    ::pathway-button{icon="uil:github" type="secondary" href="https://github.com/pathwaycom/pathway"}
    See the sources
    ::
::

## License key
Some features of Pathway such as monitoring or advanced connectors (e.g., SharePoint) require a free license key. To obtain a free license key, you need to register [here](https://pathway.com/get-license).
