---
title: Batch Processing in Python
description: 'Why Pathway makes sense for batch processing?'
thumbnail: '/assets/content/documentation/pathway-batch.png'
thumbnailFit: 'contain'
---

<!-- # Batch Processing in Pathway: How Backfilling and Persistency Optimize Static Data Handling -->
# Batch Processing in Python: Why Pathway Is Ideal for Both Streaming and Static Workloads

Pathway relies on a powerful unified Rust engine for both static and real-time data processing.
On static data, Pathway engine is in "static mode" and processes the data in one single batch, the so-called "batch processing".
On dynamic data, Pathway engine uses its "streaming mode" and makes incremental computations on the data.
While Pathway is the perfect fit for your real-time and streaming use cases, you should also consider it for batch processing on static data.

In this article, you will learn why Pathway is a good choice for your batch-processing pipeline.
This article will cover the following points:

:article-toc-without-title

<!-- https://www.canva.com/design/DAGNpcXkAuw/tRry9yTmiQuNjLo8OzDs9A/edit?utm_content=DAGNpcXkAuw&utm_campaign=designshare&utm_medium=link2&utm_source=sharebutton -->
::article-img
---
src: '/assets/content/documentation/pathway-batch.svg'
alt: '3 reasons to use Pathway for batch processing'
zoomable: true
class: 'mx-auto'
width: '550'
---
::

## Unified Framework for Stream and Batch Processing
Pathway offers a unified Python API for both batch and streaming, allowing you to define your pipeline the same way for either scenario.
Using Pathway, switching between real-time and batch processing is done by simply changing the data sources from static, where batch processing is used, to streaming.
The rest of the pipeline is left untouched.
This can be particularly advantageous in environments where you might start with batch, once-a-day computations and later transition to streaming as data volume grows, or when you want to test on static data before deploying in a real-time context (see our [example](/developers/user-guide/deployment/from-jupyter-to-deploy)), ensuring consistency across both batch and streaming processes.

Pathway's engine ensures consistent computations across both batch and streaming processing.
Except for a few time-related operations that only make sense in streaming, Pathway engine ensures that the real-time output is what you would have if you were processing the received data using batch processing.

By using Pathway for both streaming and batch data processing, you can maintain a unified codebase and avoid the overhead of managing different frameworks for different types of data processing tasks.
This makes the pipeline easier to maintain and reduces the complexity of your data engineering workflow.

## Scalability and Performance

The Pathway engine is built in Rust (no JVM!), avoiding the inherent limitations of Python, such as the Global Interpreter Lock (GIL), on Pathway native operations.
Pathway can scale to handle large volumes of data using multi-processing.

Pathway provides advanced operations such as iterative computations (common in machine learning tasks) or temporal operations.

## Persistence for backfilling and periodic computations.
Pathway provides persistence to save the state of a computation.
It is particularly helpful for backfilling and periodic computations.

Pathway Rust engine is designed to perform incremental computations, only processing the data changes rather than reprocessing the entire dataset.
In a static mode, this is useful when doing periodic computations on static data using batch processing, such as daily statistics, or for backfilling.
Pathway will only process the new or updated portions of the data, instead of doing the computation from scratch.
This can save significant computational resources and time, especially for large datasets.

## Conclusions

While Pathway excels in real-time data processing, its features make it a powerful tool for batch processing as well.
Its powerful Rust engine can lead to significant performance improvements and operational efficiencies, making it a compelling choice even for static data scenarios.

Forced migrations can be challenging, so don't wait until real-time processing becomes a necessity.
Pathway enables a seamless transition from batch to streaming.
Using Pathway for your batch-processing pipelines simplifies your architecture and makes them robust and scalable.
