---
title: 'LLM Examples'
description: 'LLM examples made with Pathway LLM tooling'
tags: ['tutorial', 'LLM']
keywords: ['LLM', 'RAG', 'LLM examples']
---

# LLM Examples

With the LLM tooling provided by Pathway, building LLM and RAG pipelines have become easy.
If you want to see how it works, this page gathers practical examples using Pathway LLM tooling.

## Featured examples

<table class="w-full">
    <tbody>
        <tr>
            <td class="text-center">
                <a href="https://github.com/pathwaycom/llm-app/tree/main/templates/question_answering_rag">Pathway RAG app with always up-to-date knowledge</a>
            </td>
            <td class="text-center">
                This example shows how to create a RAG application using Pathway that provides always up-to-date knowledge to your LLM without the need for a separate ETL.
                You can create a vector store from different data sources, such as SharePoint or Google Drive, and use any LLM model to answer questions using the indexed documents.
            </td>
        </tr>
        <tr>
            <td class="text-center">
                <a href="https://github.com/pathwaycom/llm-app/tree/main/templates/adaptive_rag">Adaptive RAG</a>
            </td>
            <td class="text-center">
                Example of the Adaptive RAG, a technique to dynamically adapt the number of documents in a RAG prompt using feedback from the LLM.
            </td>
        </tr>
        <tr>
            <td class="text-center">
                <a href="https://github.com/pathwaycom/llm-app/tree/main/templates/private_rag">Fully Private RAG with Pathway</a>
            </td>
            <td class="text-center">
                This example shows how to set up a private RAG pipeline with adaptive retrieval using Pathway, Mistral, and Ollama.
            </td>
        </tr>
        <tr>
            <td class="text-center">
                <a href="https://github.com/pathwaycom/llm-app/tree/main/templates/multimodal_rag">Multimodal RAG with Pathway</a>
            </td>
            <td class="text-center">
                This example demonstrates how you can launch a Multimodal RAG with Pathway. It relies on a document processing pipeline that utilizes GPT-4o in the parsing stage. Pathway extracts information from unstructured financial documents in your folders, updating results as documents change or new ones arrive. You can make your AI application run in permanent connection with your drive, in sync with your documents which include visually formatted elements: tables, charts, etc.
                This example highlights the limitations of traditional RAG setups, which struggle to answer questions based on table data. By contrast, our multimodal RAG approach excels in extracting accurate information from tables.
            </td>
        </tr>
    </tbody>
</table>

## Other examples

<table class="w-full">
    <!-- <thead>
        <tr>
            <th class="text-center">Name</th>
            <th class="text-center">Description</th>
        </tr>
    </thead> -->
    <tbody>
        <tr>
            <td class="text-center">
                <a href="https://github.com/pathwaycom/llm-app/tree/main/templates/document_indexing">Realtime Document Indexing with Pathway</a>
            </td>
            <td class="text-center">
                Basic example of a real-time document indexing pipeline powered by Pathway. You can index documents from different data sources, such as SharePoint or Google Drive. You can then query the index to retrieve documents, get statistics about the index, and retrieve file metadata.
            </td>
        </tr>
        <tr>
            <td class="text-center">
                <a href="https://github.com/pathwaycom/llm-app/tree/main/templates/drive_alert">Drive Alert Pipeline</a>
            </td>
            <td class="text-center">
                This example is very similar to the "Alert" example, the only difference is the data source (Google Drive).
                To learn more, you can read [our article](https://pathway.com/developers/templates/rag/llm-alert-pathway/) about it.
            </td>
        </tr>
        <tr>
            <td class="text-center">
                <a href="https://github.com/pathwaycom/llm-app/tree/main/templates/unstructured_to_sql_on_the_fly">Unstructured to SQL</a>
            </td>
            <td class="text-center">
                The example extracts and structures the data out of unstructured data (PDFs and queries) on the fly.
                You can read more about this example in [our article](https://pathway.com/developers/templates/rag/unstructured-to-structured/) about it.
            </td>
        </tr>
    </tbody>
</table>



::shoutout-banner
---
href: "https://discord.gg/pathway"
icon: "ic:baseline-discord"
---
#title
Discuss tricks & tips for RAG
#description
Join our Discord community and dive into discussions on tricks and tips for mastering Retrieval Augmented Generation
::
