---
title: Cloud Deployment of Pathway
description: 'A guide about how to deploy Pathway using the cloud'
---

# Cloud Deployment of Pathway

Local and docker deployment may be not enough.
If you want to scale your Pathway application, you may be interested in our Pathway for Enterprise.
Pathway for Enterprise is specially tailored towards end-to-end data processing and real time intelligent analytics.
It scales using distributed computing on the cloud and supports Kubernetes deployment.

## Deploying on the cloud
Most cloud platforms offer robust support for Docker containers and/or Python deployment, allowing you to deploy your Pathway project on these cloud environments without encountering compatibility issues.
You can easily benefit from the scalability and flexibility of cloud deployment.
You can follow our tutorials to deploy on the most common cloud providers:
 - [**Google Cloud**](/developers/user-guide/deployment/gcp-deploy)
 - [**AWS**](/developers/user-guide/deployment/aws-fargate-deploy)
 - [**Azure**](/developers/user-guide/deployment/azure-aci-deploy)
 - [**Nebius AI Cloud**](/developers/user-guide/deployment/nebius-deploy)



### Deploying a Pathway web service with Render.
Using tools like Render, deploying your web service made with Pathway can be done in a few clicks.
Read [the tutorial](/developers/user-guide/deployment/render-deploy) to learn how to do it.

### Data streaming for real-time enterprise AI apps with Azure
You can see how to build a real-time data pipeline with Azure Event Hubs, Pathway, and Azure OpenAI in our associated [GitHub repository](https://github.com/pathway-labs/azure-openai-real-time-data-app).

## Distributed deployment
A multi-server (distributed) deployment can use Kubernetes and its cloud implementations. Pathway assumes a stateful set deployment with all pods present for a successful operation. Pathway enterprise offering covers distributed multi-server deployment for production use. Support with integration into existing helm charts and k8s tooling is provided.

You can learn more about Pathway Enterprise [here](/pricing).
