---
title: Deploy to GCP
description: 'A guide about how to deploy Pathway to GCP using Google Cloud Run'
---

# Deploy to Google Cloud Platform using Cloud Run: a step-by-step guide.

Google Cloud Platform (GCP) is a suite of cloud computing services from Google, providing a comprehensive infrastructure to deploy and manage applications of all kinds. 
In this article, you will learn how to deploy your Pathway application to GCP using Cloud Run, a compute platform that lets you run containers on scalable infrastructue. 

The entire process is as easy as deploying any dockerized application.
You will see, step by step, how to deploy a Pathway web service hosted on a GitHub repository.

:article-toc-without-title

## Prerequisites

1. Google account
2. GitHub account
3. A GitHub project with Pathway application and Dockerfile

For an easy start, you can fork our [demo repository](https://github.com/pathway-labs/dockerized-pathway-webservice).  

::note
**Note**: Regardless of whether you use a Gmail or Google Workspace account, you can test Cloud Run for free. 
Google may require billing information, but you will not be charged after the trial period.
::

## Create Google Cloud project
The first step is to create a Google Cloud project at [GCP Console](https://console.cloud.google.com/projectcreate)

1. Choose friendly name of your project and click `Create`

::article-img
---
src: '/assets/content/documentation/google-cloud-run/gcr_step_1.png'
alt: 'image Create Google Cloud project'
zoomable: true
---
::


## Create Cloud Run service
Now that you have your project ready, go to [Cloud Run](https://console.cloud.google.com/run).
Make sure your newly created project is selected in top left corner.

1. Click on the "Create Service" button

::article-img
---
src: '/assets/content/documentation/google-cloud-run/gcr_step_2.png'
alt: 'image create a new service'
zoomable: true
---
::

2. Select "Continuously deploy from a repository" and click on "Set up with Cloud Build":

::article-img
---
src: '/assets/content/documentation/google-cloud-run/gcr_step_3.png'
alt: 'image build from GitHub'
zoomable: true
---
::

3. Point to the repository with your Pathway application and click the "Next" button.

::note
**Note**: Google may prompt you to enable additional APIs. In such case simply click **Enable** and wait for a short time.
If you are not authenticated already, choose **Github** as the repository provider and authenticate.
::

When prompted, paste your repository identifier: :textFromQuery{name="target" placeholder="https://github.com/pathway-labs/realtime-indexer-qa-chat"}
::article-img
---
src: '/assets/content/documentation/google-cloud-run/gcr_step_4.png'
alt: 'image choose GitHub repository'
zoomable: true
---
::

4. Choose "Dockerfile" as a build type and save the changes:

::article-img
---
src: '/assets/content/documentation/google-cloud-run/gcr_step_5.png'
alt: 'image choose Dockerfile build type'
zoomable: true
---
::

::note
**Note**: if you are using custom repository, you can adjust Dockerfile path.
::

5. Select "Allow unauthenticated invocations" as an authentication type:

::article-img
---
src: '/assets/content/documentation/google-cloud-run/gcr_step_6.png'
alt: 'image choose authentication type'
zoomable: true
---
::

6. Under container resources section, increase memory to at least 1 GiB and click "Create":

::article-img
---
src: '/assets/content/documentation/google-cloud-run/gcr_step_7.png'
alt: 'image increase memory limits'
zoomable: true
---
::


## Test your deployment
Once your app has been deployed, you will see a green mark next to the project name.
You can now copy the URL of your service and test it with CURL.

::article-img
---
src: '/assets/content/documentation/google-cloud-run/gcr_step_8.png'
alt: 'image copy service URL'
zoomable: true
---
::


If your deployment is ready, you can test it with the following command:
```bash
curl -X POST -d '{"input": "hello, world"}' <YOUR-URL>
```

You can learn more about this example on [GitHub](https://github.com/pathway-labs/dockerized-pathway-webservice).

## Deploy changes

You have successfully deployed a sample Pathway application using Cloud Run. You can now adjust the Pathway pipeline by modifying app.py. 
Once you are ready, commit and push your changes. Cloud Build will automatically detect your changes and start deploying the new version. 
You can monitor this process under the revisions tab.

::article-img
---
src: '/assets/content/documentation/google-cloud-run/gcr_step_9.png'
alt: 'image revisions'
zoomable: true
---
::

## Delete your web service

If you were only testing your web service and wish to delete it, go to [Cloud Run](https://console.cloud.google.com/run), select your service, and click the "Delete" button.

::article-img
---
src: '/assets/content/documentation/google-cloud-run/gcr_step_10.png'
alt: 'image delete service'
zoomable: true
---
::

## Conclusions

In this guide, you learned how to deploy a Pathway application to GCP using Cloud Run, from setting up your Google Cloud project to testing and managing your deployment. 
By leveraging the continuous deployment capabilities of Google Cloud Build, you can deploy changes to your applications in seconds. 
Don't hesitate to explore other methods for deploying Pathway in [our dedicated article](/developers/user-guide/deployment/cloud-deployment).
