---
title: "Licensing Guide"
description: "Quick Licensing Guide of Pathway"
navigation: true
heading: false
toc: false
---

# Pathway Licensing Guide

Pathway offers a flexible licensing model designed to accommodate both community users and enterprise deployments.
This guide explains the different licensing options, usage limitations, and key considerations for developers.

## Pathway Community License (Free Version)

Pathway Community is distributed under the [**Pathway Business Source License (BSL)**](/license#pathway-business-source-license-bsl), which automatically converts to the open-source **Apache 2.0 license** after 4 years.

### What's Included in Pathway Community?
- **Most transformations and features** available in Pathway.
- **Most connectors** for integrating data.
- **Usage**: Permitted for most commercial applications.
- **Resource Limits:**
  - **8 GB RAM** per node
  - **4 CPU cores** per node
- **Deployment:** Self-hosted only (no managed cloud services provided by Pathway).
- **Exclusions:** Cannot be used by cloud providers reselling "Stream Data Processing Services," as detailed in the license terms.

Pathway Community is free to use in production environments, as long as it adheres to these constraints.


## Pathway Scale License (Advanced Features & Higher Limits)
Pathway Scale is intended for demanding users who need extra features and higher resource limits beyond what Pathway Community offers.

You can get a Pathway Scale license [here](/get-license).

### What's Included in Pathway Scale?
- **Enterprise connectors**, including:
  - [SharePoint](/developers/api-docs/pathway-xpacks-sharepoint#pathway.xpacks.connectors.sharepoint.read)
  - [Delta Lake](/developers/api-docs/pathway-io/deltalake)
  - [Iceberg](/developers/api-docs/pathway-io/iceberg)
- **Advanced features**, such as:
  - [Full persistence](/developers/user-guide/deployment/persistence)
  - [Monitoring](/developers/user-guide/deployment/pathway-monitoring)
  - [`SlideParser`](/developers/api-docs/pathway-xpacks-llm/parsers#pathway.xpacks.llm.parsers.SlideParser).
- **Higher Resource Limits:**
  - **16 GB RAM** per node
  - **4 CPU cores** per node
- **License Activation:**
  - Requires setting a license key using [`pathway.set_license_key()`](/get-license#how-to-use-the-license-key).
  - License keys are available in different tiers, which may be **free or paid**, depending on resource needs.
  
### **Additional Terms for Pathway Scale Users**
- By using a Pathway Scale license key, you agree that **anonymized product usage data** is sent to Pathway via an OpenTelemetry collector.
- This data helps improve Pathway and enhance support services.
- All collected data is governed by [**Pathway's Privacy Policy**](/privacy_gdpr_di), which users can review to understand data handling practices.

## Multi-Node Deployments & Licensing Considerations

### Are the Resource Limits Per Node?
Yes, all memory and CPU limitations apply **per node**.

### Can I Buy Multiple Scale Licenses for Multiple Nodes?
Yes, you can:
- Mix & match **free (small) and paid (larger) Scale nodes** to fit your needs.
- Purchase multiple licenses for multiple nodes.
- **Enterprise Licenses** are available to cover all nodes and pipelines under one agreement.
- **Automation Restriction:**
  - Non-enterprise users **cannot automate the launching of new instances**.
  - Scaling up/down must require **manual intervention** by a team member.

## Looking for more?
If you want more, don't hesitate to contact us for an Enterprise License.

::container{.flex .gap-8 .items-center .w-full .justify-center .mt-8}
    ::pathway-button{type="secondary" href="https://calendly.com/d/dj2-4jd-3tw/introductory-call-pathway"}
    Get in touch
    ::
::

