# Contributing to Pathway

Welcome! This guide is intended to help developers that are new to the community
to make contributions to the Pathway project. Please be sure to also read our [code of conduct](CODE_OF_CONDUCT.md). We work hard to make this a welcoming community for all, and we're excited to have you on board!

## The basics:

* Use the [Issue Tracker](https://github.com/pathwaycom/pathway/issues) to
  report bugs, crashes, performance issues, etc... Please include as much detail
  as possible.
  
* [Discussions](https://github.com/pathwaycom/pathway/discussions) is a great
  venue to ask questions, start a design discussion, or post an RFC.

* [Discord](https://discord.com/invite/pathway) is our main gathering place - jump in and ask us anything!

## Contributing Code

We are eager to build Pathway together with the community and are excited to have you here!

Important: Before you contribute any changes to our repositories (make a Pull Request) please get in touch with us and explain what you want to work on. You can do so by filing an issue, or asking us on Discord. That way you can get coding advice and speedier reviews. If you start to work on an issue before hearing back from a Pathway core team engineer there is a chance that we will not be able to accept your changes - something we all want to avoid!

We use a standard GitHub fork + pull request model for merging and reviewing
changes. New pull requests should be made against the main upstream branch.
After a pull request is opened it will be reviewed, and merged after
passing continuous integration tests and being accepted by a project or
sub-system maintainer.

We ask that developers sign our [contributor license
agreement](https://cla-assistant.io/pathwaycom/pathway-examples). The
process of signing the CLA is automated, and you'll be prompted with instructions
the first time you submit a pull request to the project.
