---
title: "Installation"
description: "Installation page of Pathway"
navigation: true
heading: false
toc: false
---

# Installation

## Quick Install

To quickly get started with Pathway, you can install it via pip with the following command:

```
pip install -U pathway
```

It will install all basic dependencies to run your Pathway pipelines, including our powerful Rust engine.


<!-- https://www.canva.com/design/DAGGtZB_-kw/6gGXSnfMNL9LuOXTOSQbQQ/edit?utm_content=DAGGtZB_-kw&utm_campaign=designshare&utm_medium=link2&utm_source=sharebutton -->
::article-img
---
src: '/assets/content/documentation/pathway-installation-new.svg'
alt: 'Install Pathway'
zoomable: true
class: 'mx-auto'
width: '550'
---
::


⚠️ Pathway is available on MacOS and Linux. Pathway is currently not supported on Windows.
Windows users may want to use Windows Subsystem for Linux (WSL), docker, or a VM.

To jumpstart a Pathway project, quickly check our [cookiecutter template](https://github.com/pathwaycom/cookiecutter-pathway).

## Try Pathway in just a few clicks

Ready to see what Pathway can do? Try one of our easy-to-run examples!
Available in both notebook and docker formats, these ready-to-launch examples can be launched in just a few clicks.
Pick one and start your hands-on experience with Pathway today!


::container{.flex .gap-8 .items-center .w-full .justify-center}
    ::pathway-button{href="/developers/user-guide/introduction/first_realtime_app_with_pathway"}
    Starting Example
    ::

    ::pathway-button{type="secondary" href="/developers/templates"}
    See more of our examples
    ::
::


## Optional packages

We separated dependencies into several groups to allow users to have better control over what is installed.

- For a standard usage of the Live Data Framework, run `pip install pathway`. It will install the Rust engine and everything required to run the Live Data Framework. No external LLM-based libraries will be installed.

- To run the AI pipelines or to build Live AI™ systems, consider running `pip install "pathway[xpack-llm]"`, which will install all common LLM libraries, such as OpenAI, Langchain, etc.


You can install several options at once, for example `pip install "pathway[xpack-llm, airbyte]"`.
For more information, please visit our [pyproject.toml](https://github.com/pathwaycom/pathway/blob/main/pyproject.toml) file, which describes the content of all groups.


| **Package** | **Installation Command** | **Description**  | **Notes** |
|--------------|--------------------------|------------------|-----------|
| **Basic LLM Tooling**  | `pip install "pathway[xpack-llm]"` | Install common LLM libraries (OpenAI, Langchain, LlamaIndex) | [Learn more](/developers/user-guide/llm-xpack/overview) / [Examples](/developers/templates?category=llm#llm) |
| **Local LLM Deployment**  | `pip install "pathway[xpack-llm-local]"` | Libraries for local deployment |     |
| **Parsing Documents**     | `pip install "pathway[xpack-llm-docs]"`  | Tools for working with documents (PDFs, Microsoft Word) | |
| **Airbyte Connector**     | `pip install "pathway[airbyte]"`   | Support for Airbyte  | [Example](/developers/templates/etl/etl-python-airbyte) |
| **SharePoint Connector**  | `pip install "pathway[xpack-sharepoint]"`  | Support for SharePoint  | Requires a (free) [license key](/get-license) |
| **All**        | `pip install "pathway[all]"`   | Install all the optional packages  |  |


## Docker

You can also use Pathway with Docker.
The official Pathway Docker image is available on [Docker Hub](https://hub.docker.com/r/pathwaycom/pathway).
You can pull and run the image using the following command:

```
docker pull pathwaycom/pathway
```

For more detailed instructions on how to run Pathway with Docker, please refer to our [dedicated article](/developers/user-guide/deployment/docker-deployment).

## License key

Pathway is distributed on a [BSL 1.1 License](https://github.com/pathwaycom/pathway/blob/main/LICENSE.txt) which allows for unlimited non-commercial use, as well as use of the Pathway package [for most commercial purposes](https://pathway.com/license), free of charge.
The code in the [associated repository](https://github.com/pathwaycom/pathway) automatically converts to Open Source (Apache 2.0 License) after 4 years.
Some [public repos](https://github.com/pathwaycom) which are complementary to this one (examples, libraries, connectors, etc.) are licensed as Open Source, under the MIT license.

Some features of Pathway such as monitoring or advanced connectors (e.g., SharePoint) require a free license key.
To obtain a free license key, you need to register [here](https://pathway.com/get-license).

## Pathway enterprise package installation

::alert{type="info" class="max-w-max" icon="heroicons:information-circle-20-solid"}
Use **python3.10** or above
::

### Configure pip to use private PyPI repository

Create or modify the `pip` configuration file to point to your private repository.

Add the following to `~/.pip/pip.conf`:

```conf [~/.pip/pip.conf]
[global]
extra-index-url = https://<username>:<password>@<URL>
```

Install the package:

```bath
pip install -U pathway
```

Alternatively extra index url can be passed directly to the install command:

```bath
pip install -U pathway --extra-index-url=https://<username>:<password>@<URL>
```

::alert{type="info" icon="heroicons:information-circle-20-solid"}
Replace `<URL>`, `<username>` and `<password>` with credentials obtained from Pathway.
::

### Using Pathway with enterprise license

To use Pathway with an enterprise license, obtain the license file from Pathway and set the license key using one of the following methods:

1. Environment variable

```env
PATHWAY_LICENSE_KEY=file:///path/to/license.lic
```

Or inlined

```
PATHWAY_LICENSE_KEY="-----BEGIN LICENSE FILE-----
...
-----END LICENSE FILE-----"
```

2. Directly in the python code

```python
import pathway as pw

pw.set_license_key("file:///path/to/license.lic")

# or inlined
pw.set_license_key("""-----BEGIN LICENSE FILE-----
...
-----END LICENSE FILE-----""")

pw.run()
```
