---
title: Deploy with Render
description: 'A guide about how to deploy Pathway using the Render'
---

# Deploy with Render: a Step-by-step Guide.

With its full compatibility with Python, deploying with Pathway is as easy as deploying any Python project.
New tools have made deploying on the cloud effortless.
For instance, [Render](https://render.com/) allows you to deploy your Python-based web services in one click.

In this article, you will learn how to deploy your Pathway web service using Render.
You will see, step by step, how to deploy a Pathway web service hosted on a public GitHub repository.
As an example, this tutorial will show you how to deploy [Pathway chatbot answering questions about documents](https://github.com/pathway-labs/realtime-indexer-qa-chat).

:article-toc-without-title

## What this guide is about
This guide will show you how to deploy a Pathway web service using Render.
It relies on the *free* offer of Render.
Here are the requirements for the project:
- Contains a `Dockerfile` at the root.
- It must bind to a port on host `0.0.0.0` to receive HTTP requests from external connections on port `10000`.
- Ports `18012`, `18013`, and `19099` are reserved by Render and cannot be used.

You can learn more about the free offer on the [official documentation](https://docs.render.com/free).

Note that we are going to use to deploy from a public repository, but you can easily deploy from a private one by connecting to your GitHub/GitLab by connecting to your account from Render.

## Create an account on Render
The first step is to create an account at [Render](https://render.com/).

1. Click on the "Sign In" button:

::article-img
---
src: '/assets/content/documentation/render/render-sign-in-button.png'
alt: 'image Sign In button'
zoomable: true
---
::

2. Choose your favorite way of logging. You can either use a GitHub, GitLab, or Google account. You can also create an account with an email and password.

::article-img
---
src: '/assets/content/documentation/render/render-sign-in-choice.png'
alt: 'image Sign In choice'
zoomable: true
---
::

You now have a Render's account.

## Create and deploy your Pathway web service
Now that you have an account, you need to deploy your app.
Render allows you to deploy service types for hosting your app.
In our case, we want to deploy a *web service* as it is available in the free offer.

1. Let's create a new project by clicking on "New Web Service":

::article-img
---
src: '/assets/content/documentation/render/render-create-web-service.png'
alt: 'image create a new web service'
zoomable: true
---
::

2. Select "Build and deploy from a Git repository" and click on "Next":

::article-img
---
src: '/assets/content/documentation/render/render-create-web-service-next.png'
alt: 'image build from GitHub and Next'
zoomable: true
---
::

3. Enter the Git repository that you wish to deploy. In our case, this is the following public repository:
:textFromQuery{name="target" placeholder="https://github.com/pathway-labs/realtime-indexer-qa-chat"}

::article-img
---
src: '/assets/content/documentation/render/render-git-add-continue.png'
alt: 'image public Git repository'
zoomable: true
---
::

::note
**Note**: you can deploy a private repository if you are logged in with your GitHub account.
::

4. Enter the parameters. Everything should be already filled by default value. Select a region near you as some or your data will be processed in this region:

::article-img
---
src: '/assets/content/documentation/render/render-region.png'
alt: 'image chose region'
zoomable: true
---
::

5. Select the "Free" instance type:

::article-img
---
src: '/assets/content/documentation/render/render-free-offer.png'
alt: 'image free offer'
zoomable: true
---
::

You can start most projects with the free instance of Render.
However, this free offer comes with limitations.
You can learn more on the free offer on [Render documentation](https://docs.render.com/free).

6. Enter the environment variables. In our example, you need to enter the OpenAI key by using the variable `OPENAI_API_KEY`:

::article-img
---
src: '/assets/content/documentation/render/render-openai-key.png'
alt: 'image OpenAI API key'
zoomable: true
---
::

You can directly load a `.env` file.

7. Click on "Create Web Service":

::article-img
---
src: '/assets/content/documentation/render/render-create-web-service-create-button.png'
alt: 'image create button'
zoomable: true
---
::

That's it! Your app is being deployed by Render and will be soon available.
The process takes around 5 minutes.

You should have the message "Your service is live" once it is ready:

::article-img
---
src: '/assets/content/documentation/render/render-your-service-is-live.png'
alt: 'image your service is live'
zoomable: true
---
::

## Access your project
Once your app has been deployed, you can access the web service by clicking on the URL:

::article-img
---
src: '/assets/content/documentation/render/render-access-URL.png'
alt: 'image click URL'
zoomable: true
---
::

It will open your web service:
::article-img
---
src: '/assets/content/documentation/render/render-pathway-app.png'
alt: 'image live chatbot'
zoomable: true
---
::

You can then use your app. You can ask the chatbot the question "Can I build an LLM app with Pathway?":
::article-img
---
src: '/assets/content/documentation/render/render-pathway-app-question.png'
alt: 'image create a new web service'
zoomable: true
---
::

You can learn more about this example on [GitHub](https://github.com/pathway-labs/realtime-indexer-qa-chat).

## Stop and delete your web service

To stop and delete the service, you have to go to the settings.

1. Go to the dashboard:

::article-img
---
src: '/assets/content/documentation/render/render-dashboard.png'
alt: 'image go to dashboard'
zoomable: true
---
::

2. Click on the three-dot button then on "Settings":

::article-img
---
src: '/assets/content/documentation/render/render-settings.png'
alt: 'image three-dot and settings buttons'
zoomable: true
---
::

3. Click on "Delete Web Service" at the end of the page:

::article-img
---
src: '/assets/content/documentation/render/render-delete.png'
alt: 'image delete button'
zoomable: true
---
::

4. Copy the delete command and validate:

::article-img
---
src: '/assets/content/documentation/render/render-delete-confirm.png'
alt: 'image delete validate'
zoomable: true
---
::

## Conclusions

By being fully Python-compatible, Pathway allows you to use all the available tools to deploy your app.
Using tools like Render, deploying your Pathway web service app is doable in a few clicks!
Don't hesitate to check out the other ways to deploy Pathway in [our dedicated article](/developers/user-guide/deployment/cloud-deployment).
