---
title: 'Pathway Web Dashboard'
description: 'Tutorial on how to monitor Pathway instance using built-in Web Dashboard'
date: '2026-01-13'
tags: ['tutorial', 'engineering']
keywords: ['Web Dashboard', 'UI', 'monitoring', 'graph', 'charts', 'metrics']
---

# Pathway Web Dashboard

The built-in Pathway Web Dashboard provides a user-friendly interface for monitoring your data pipelines in real time. With interactive pipeline graph plotting, charts and metrics, you can easily track pipeline performance, inspect data flow, and identify bottlenecks. This guide will walk you through the setup and usage of the dashboard to help you get the most out of your Pathway deployment.

<img src="/assets/content/tutorials/web_dashboard.png">

⚠️ Web Dashboard requires a Pathway Scale license.\
To obtain a free license, please visit the [Get License](/get-license) page.

## Quickstart

1. Add to your pipeline `pw.set_monitoring_config(detailed_metrics_dir="YOUR-DIR")`, e.g.:
```python
import pathway as pw

pw.set_license_key(key="YOUR-KEY")
pw.set_monitoring_config(detailed_metrics_dir=".")

# your pipeline here...

pw.run()
```
2. Run your pipeline as usual `python your_pipeline.py` or using `pathway spawn`.

::alert{type="info" icon="heroicons:information-circle-20-solid"}
use `PATHWAY_METRICS_READER_INTERVAL_SECONDS` environment variable to configure frequency of metrics, e.g. run with
`PATHWAY_METRICS_READER_INTERVAL_SECONDS=1 python your_pipeline.py`
::
3. Open the dashboard `pathway web-dashboard`

## Features

- Advanced data flow inspection over the operator graph
- Latency tracking for each operator
- Memory usage tracking to monitor resource consumption

<img src="/assets/content/tutorials/web_dashboard_charts.png">
