---
title: Get help
description: 'This page references where to look for help if you have an issue using Pathway'
---

# How can we help you?

We're here to help you make the most of your experience. Whether you're a beginner or an experienced developer, this page provides resources to assist you with common issues and inquiries.

::card-grid
#default
    ::landing-card
    ---
    icon: 'heroicons:bolt-solid'
    button:
        text: 'Get Pathway'
        href: '/developers/user-guide/introduction/welcome'
    ---
    #title
    Getting started

    #default
    Trouble installing Pathway? Take a look a our installation guide.
    ::
    ::landing-card
    ---
    icon: 'heroicons:book-open-20-solid'
    button:
        text: 'See the API docs'
        href: '/developers/api-docs/pathway'
    ---
    #title
    API docs.

    #default
    Wondering how to use a specific feature of Pathway? The answer to your question is likely in the API docs.
    ::
    ::landing-card
    ---
    icon: 'heroicons:wrench-screwdriver-20-solid'
    button:
        text: 'See more'
        href: '/developers/user-guide/development/troubleshooting'
    ---
    #title
    Troubleshooting

    #default
    You got an error? Try to debug your code with the troubleshooting guide.
    ::
::    
::card-grid
#default
    ::landing-card
    ---
    icon: 'uil:github'
    button:
        text: 'Open a GitHub issue'
        href: 'https://github.com/pathwaycom/pathway/issues'
    ---
    #title
    GitHub issues

    #default
    If you've identified a bug, have a feature request, or need technical support, open an issue on GitHub.
    ::
    ::landing-card
    ---
    icon: 'uil:discord'
    button:
        text: 'Join us on Discord'
        href: 'https://discord.com/invite/pathway'
    ---
    #title
    Connect with Us on Discord

    #default
    Join our community on Discord to connect with other users and get real-time assistance from our team.
    ::
    ::landing-card
    ---
    icon: 'heroicons:chat-bubble-left-ellipsis-20-solid'
    button:
        text: 'Send us an email'
        href: 'mailto:contact@pathway.com'
    ---
    #title
    Contact us

    #default
    For private inquiries or matters that are not suitable for public discussion, feel free to reach out to us via email.
    ::
::    

