---
title: "REST API"
description: "Pathway RAG Templates REST API"
navigation: true
heading: false
toc: false
---

# Pathway RAG REST API



To seamlessly integrate into your workflow, Pathway AI Pipelines include a robust REST API.
**This REST API is the primary interface for interacting with the deployed AI Pipelines.**

The API allows you to easily query the RAG and retrieve the generated results, making it simple to connect the AI Pipelines to other components of your application via simple HTTP requests.

The REST API provides the following endpoints:

|                            | **Type** | **Endpoint**              | **Description**                                                                 |
|----------------------------|----------|---------------------------|---------------------------------------------------------------------------------|
| [Retrieve Closest Documents](#retrieve-closest-documents) | POST     | `/v1/query`               | Retrieve the closest documents from the vector store based on a query.        |
| [Retrieve Vector Store Statistics](#retrieve-vector-store-statistics) | GET      | `/v1/statistics`          | Retrieve statistics about the vector store.                       |
| [Answer with RAG](#answer-with-rag)            | POST     | `/v2/answer`        | Generate an answer to a query using a RAG pipeline.                            |
| [Summarize Texts](#summarize-texts)            | POST     | `/v2/summarize`       | Summarize a list of texts.                         |
| [List Indexed Documents](#list-indexed-documents)     | POST     | `/v2/list_documents`   | List documents indexed in the vector store. |


## Retrieve Closest Documents

**Endpoint**: `POST /v1/query`

Retrieve the closest documents from the vector store based on a given query.

**Request Body**

```json
{
  "query": "string",
  "k": "integer (optional, default: 3)",
  "metadata_filter": "string (optional, default: null)",
  "filepath_globpattern": "string (optional, default: null)"
}
```
- `query`: The query string to search.
- `k`: The number of results to retrieve (default is 3).
- `metadata_filter`: Optional filter for metadata fields.
- `filepath_globpattern`: Optional glob pattern to filter file paths.

**Note**: A null value means no filters will be applied.

**Response**

A list of the closest matching documents.




## Retrieve Vector Store Statistics

**Endpoint**: `GET /v1/statistics`

Retrieve statistical information about the vector store, such as file counts and timestamps.

**Response**

```json
{
  "file_count": "integer",
  "last_modified": "integer (UNIX timestamp)",
  "last_indexed": "integer (UNIX timestamp)"
}
```


## Answer with RAG

**Endpoint**: `POST /v2/answer`

Provide a response to a query using a RAG pipeline.

**Request Body**

```json
{
  "prompt": "string",
  "filters": "string (optional, default: null)",
  "model": "string (optional, default: null)",
  "return_context_docs": "string (optional, default: false)",
}
```
- `prompt`: The input question or prompt.
- `filters`: Optional metadata filter for narrowing document retrieval.
- `model`: Optional LLM to customize the response generation.
- `return_context_docs`: Optional flag telling whether to include context chunks used for generating the answer in the response.

**Response**

```json
{
  "answer": "string"
}
```



## Summarize Texts

**Endpoint**: `POST /v2/summarize`

Summarize a list of texts.

**Request Body**

```json
{
  "text_list": ["string", ...],
  "model": "string (optional, default: null)"
}
```
- `text_list`: List of texts to summarize.
- `model`: Optional LLM model for generating summaries.

**Response**
```json
{
  "summary": "string"
}
```




## List Indexed Documents

**Endpoint**: `POST /v2/list_documents`

List documents currently indexed in the vector store, with optional filtering or metadata selection.

**Query Parameters**

- `filters`: `string (optional)` - Metadata filter for the documents.
- `keys`: `list[string] (default: ["path"])` - Metadata fields to include in the response.


**Request Body**

```json
{
  "filters": "string (optional, default: null)",
  "keys": ["string", ...] (default: ["path"])
}
```

**Response**
```json
[
  {
    "path": "string",
    "last_modified": "string (timestamp)",
    ...
  }
]
```

