# Pathway examples

This repository contains examples of data processing using [Pathway](https://pathway.com/developers/documentation/introduction/welcome), the Python-based programming framework for easy building of realtime and reactive data products.

For a quick start, here is a handpicked selection of examples that illustrate how Pathway can be used in your streaming projects:
- Working with live data streams in Jupyter (short version [GitHub](https://github.com/pathwaycom/pathway/blob/main/examples/notebooks/showcases/live-data-jupyter.ipynb) and [Colab](https://colab.research.google.com/github/pathwaycom/pathway/blob/main/examples/notebooks/showcases/live-data-jupyter.ipynb) | [long version GitHub](https://github.com/pathwaycom/pathway/tree/main/examples/projects/from_jupyter_to_deploy)).
- Realtime Server Log Monitoring with Pathway ([Filebeat+Slack version](https://github.com/pathwaycom/pathway/tree/main/examples/projects/realtime-log-monitoring/filebeat-pathway-slack) | [Logstash+Elastick version](https://github.com/pathwaycom/pathway/tree/main/examples/projects/realtime-log-monitoring/logstash-pathway-elastic)).
- Always up-to-date data indexing pipeline ([GitHub](https://github.com/pathwaycom/pathway/blob/main/examples/notebooks/showcases/live_vector_indexing_pipeline.ipynb) | [Colab](https://colab.research.google.com/github/pathwaycom/pathway/blob/main/examples/notebooks/showcases/live_vector_indexing_pipeline.ipynb)).
- Detecting suspicious user activity with Tumbling Window group-by ([GitHub](https://github.com/pathwaycom/pathway/blob/main/examples/notebooks/tutorials/suspicious_user_activity.ipynb) | [Colab](https://colab.research.google.com/github/pathwaycom/pathway/blob/main/examples/notebooks/tutorials/suspicious_user_activity.ipynb)).
- Build an LLM App with Pathway ([GitHub](https://github.com/pathwaycom/llm-app/tree/main)).
- Realtime Twitter Analysis App with Pathway ([GitHub](https://github.com/pathwaycom/pathway/tree/main/examples/projects/twitter)).
- Upsampling your Signal Processing Data: transforming multiple data streams ([GitHub](https://github.com/pathwaycom/pathway/blob/main/examples/notebooks/tutorials/upsampling.ipynb) | [Colab](https://colab.research.google.com/github/pathwaycom/pathway/blob/main/examples/notebooks/tutorials/upsampling.ipynb)).
- Computing PageRank ([GitHub](https://github.com/pathwaycom/pathway/blob/main/examples/notebooks/tutorials/pagerank.ipynb) | [Colab](https://colab.research.google.com/github/pathwaycom/pathway/blob/main/examples/notebooks/tutorials/pagerank.ipynb)).

Don't hesitate to look for help on [our website](pathway.com/developers/user-guide/development/get-help/) or directly on the [main repo of the Pathway package](https://github.com/pathwaycom/pathway).
