# Awesome Earth [![Awesome](https://awesome.re/badge.svg)](https://awesome.re) <!-- omit in toc -->

The world is simultaneously underwater and on fire, and people want to know what they can do about it. Let's share resources, services, products and ideas you can use to stop kicking the planet in the face.

## Contents<!-- omit in toc -->

<!-- links:start -->

- [Carbon Reduction](#carbon-reduction)
- [Clothing](#clothing)
- [Consumer Products](#consumer-products)
- [Cooking](#cooking)
- [Development](#development)
- [Documentaries](#documentaries)
- [Finance](#finance)
- [Food](#food)
- [Footprint Calculators](#footprint-calculators)
- [Home Improvements](#home-improvements)
- [Hygiene](#hygiene)
- [Jobs](#jobs)
- [Land Management](#land-management)
- [News](#news)
- [Other Services](#other-services)
- [Podcasts](#podcasts)
- [Politics](#politics)
- [Reforestation](#reforestation)
- [Renewable Energy](#renewable-energy)
- [Transportation](#transportation)
- [Travel](#travel)
- [Volunteering](#volunteering)
- [Waste](#waste)
- [YouTube Channels](#youtube-channels)
- [Zero Waste](#zero-waste)

## Carbon Reduction

- [1 Click Impact](https://1clickimpact.com/) - 1ClickImpact is a leading platform that helps businesses and individuals automatically capture carbon and plant trees using API or no-code integrations. Every carbon reduction is trackable in real time with verified data, project maps, and live planting sessions for full transparency. It makes measurable carbon removal and reduction a seamless part of your product or sustainability strategy.
- [1% for the Planet](https://www.onepercentfortheplanet.org/) - A membership program for businesses and individuals, allowing them to donate 1% of their gross yearly profits or salary back to environmental nonprofits to create a healthier planet.
- [Beam](https://www.beamproject.co/) - Make small automatic donations while you shop online, to support the cleantech startups trying to change the world. Clean Tech investment money has dried up over the years, so crowdsourcing is becoming the only option for many, and with a Chrome extension you can chuck in a dollar when you're buying other stuff.
- [Carbon Pricing Dashboard](https://carbonpricingdashboard.worldbank.org/) - Maps and statistics on regional, national, and subnational carbon pricing initiatives.
- [Climate Action Tracker](https://climateactiontracker.org/countries/) - See which countries are on track for the Paris Agreement or similar, and which countries are failing horribly. Hint: it's everyone but Morocco and The Gambia.
- [ClimateWorks](https://www.climateworks.org/) - An NGO partnering with philanthropists to tackle the climate crisis. They seek to ensure investments have the maximum impact.
- [Climworks](http://climeworkspioneers.refr.cc/philsturgeon) - Climeworks Direct Air Capture technology captures CO₂ from air, mixes the CO₂ with water used by a geothermal energy plant, then pumps it deep underground. Through natural processes, the CO₂ reacts with the basaltic rock – and turns into stone within a few years, permanently and safely. Iceland is one of several locations around the world that provide ideal conditions for our pioneering process. Subscribe monthly to offset a little bit of your footprint, and support the growth of this early stage technology.
- [Cool Earth](https://www.coolearth.org/) - This charity was created to tackle climate change by reducing carbon emissions from rainforest loss.
- [Ecologi](https://ecologi.com/?r=5d01f2ed12ae7a358b75fdd7) - Help the planet from your sofa, for less than a cheap bottle of wine per month. Watch your own forest come to life and offset your entire footprint for $6.50/€6 per-month. Then get your friends, family, business, and even your dog signed up!
- [Flight Free (UK)](https://flightfree.co.uk/) - Aviation is the fastest growing contributor to greenhouse gas emissions at a time when we desperately need to reduce them. Pledge to go flight free in 2020.
- [Flight Free (USA)](https://flightfreeusa.org/) - A grassroots campaign which asks people to agree not to fly in the year of 2020 – on condition that 100,000 others will also pledge to do the same.
- [Future Earth](https://futureearth.org/) - Future Earth is a global research programme designed to provide the knowledge needed to support transformations towards sustainability. They focus on systems-based approaches, seeking to deepen the understanding of complex Earth systems and human dynamics across different disciplines.
- [Giki](https://gikibadges.com/) - The Giki app provides accessible, independent, transparent information to help people change habits to live more sustainably. Our 14 badges cover sustainability, health and fairness.
- [Gold Standard](https://www.goldstandard.org/take-action/offset-your-emissions) - Offset carbon emissions by purchasing verified carbon credits from a variety of certified, environmentally friendly projects.
- [Google Cloud Computing](https://cloud.google.com/sustainability/) - Google are a long way from perfect, but Google Cloud advertises 100% renewable energy. They don't _just_ offset, they actually reduce the electricity usage too, and "strive to build the world’s most energy-efficient computing network by squeezing more out of every watt of power we consume." Their main rival, Amazon AWS, does not do that, and actively hosts oil and gas companies, who use the platform to find more places to dig. Switching to Google Cloud (or a host who in turn is on Google Cloud), is one of many ways to make your platform have less impact on the earth.
- [Green-E Carbon Offsets](https://www.green-e.org/certified-resources/carbon-offsets) - Green-e Climate is an excellent resource for carbon offsets. The organization holds retailers accountable by monitoring how offsets are transacted and advertised in the retail market, protecting both the buyer and the seller.
- [No Meat Today](https://nomeat.today/) - Your companion to eat less meat. It's good for you and the planet, but let's be honest, eating less meat is hard. Don't do it alone!
- [Patch](https://www.usepatch.com) - Patch is the API for negative emissions. Developers can use Patch's API to make any transaction carbon neutral with a wide range of negative emission methods (e.g. direct air carbon capture, bio-oil geosequestration, enhanced weathering, reforestation and more).
- [Possible](https://www.wearepossible.org/) - Combining individual and local actions with larger systemic change, we face our climate dread with a can-do attitude and sense of fun. Possible are tackling the climate crisis by inspiring people to act in 5 key areas - eat & buy, travel, energy, nature and talking.
- [Project Wren](https://projectwren.com/) - Project Wren are a startup offering a web based, monthly subscription model for offsetting emissions. They also allow for offsetting of flights.
- [Restons Les Pieds Sur Terre](https://www.facebook.com/restonslespiedssurterre/) - Aviation is the fastest growing contributor to greenhouse gas emissions at a time when we desperately need to reduce them. Pledge to go flight free in 2020.
- [The National Grid ESO](https://www.nationalgrideso.com/news/introducing-our-carbon-intensity-app) - Monitor the generation types that make up your electricity supply and see when the cleanest time to use electricity will be. See the carbon impact level of electricity generation, how your region compares to others in the UK and be notified when a record towards decarbonisation breaks.
- [Trine - Solar Crowd-investing](https://www.trine.com/) - Invest in solar projects bringing clean energy to emerging markets. Local solar partners will distribute and manage the solar products on the ground. If the loan is successful you will receive your investment and interest in return.
- [We Mean Business](https://www.wemeanbusinesscoalition.org/) - A coalition aiming to catalyze business action and driving policy ambition to accelerate the zero-carbon transition.
- [Tradewater](https://tradewater.us/) - Finds and destroys the most potent greenhouse gases before they are released into the atmosphere. These are old refrigerants that would leak into the atmosphere unless collected and destroyed. Work is funded by selling Carbon Offsets. You can subscribe to offset your carbon emissions.

## Clothing

- [4ocean](https://www.4ocean.com/) - Oeko-tex certificated, cruelty free customizable linen clothing brand. All of the packaging are plastic free.
- [Allbirds](https://www.allbirds.com/) - Our shoes are made with merino wool, tencel made from rainfall-fed FSC-certified eucalyptus forests, recycled plastic bottles (for laces), 'Sweetfoam' soles made from castor bean oil and [ProForest](https://proforest.net/en)-protected sugarcane. At 7.6 kg per pair for our wool runners, our process uses 60% less energy than materials used in typical synthetic shoes. We offset the rest, making Allbirds a carbon-neutral business.
- [Alternative Apparel](https://www.alternativeapparel.com/) - Low impact dyes, and post-consumer recycled polyester are used with Fair Labor Association guidelines.
- [Arvin Goods](https://www.arvingoods.com/) - Brand that makes fashionable socks through a sustainable supply chain process they have developed. They have removed excess water from their manufacturing process - leaving more water left for communities to drink!
- [Bam - Bamboo Clothing](https://bambooclothing.co.uk/) - Bamboo clothing company that are entirely dedicated to sustainability beyond purely carbon emissions, they're aiming for zero chemical pollution, zero waste to landfill, zero deforestation in their suppliers (and their suppliers, and _their_ suppliers...) and zero water wasted. They've got active wear, casual wear, underwear, gift cards for birthdays, the whole thing.
- [Boody Eco Wear Essentials](https://boody.co.uk) - Everyday essentials made from hypoallergenic and breathable FSC-certified bamboo viscose yarn, OEKO-TEX 100 certified organic by Ecocert.
- [Cariuma](https://cariuma.com/) - Old-School sneakers, new school ethics. Cariuma's sneakers are handcrafted with premium natural materials, an obsessive eye for detail, and a conscious mind. They care deeply about our craftsmen, and ensure that they earn fair wages and experience safe working conditions. Some of their shoes are carbon _negative_, and they are committed to carbon-neutral shipping processes, which they do by purchasing carbon offsets for each shipment.
- [Dabchy](https://www.dabchy.com/) - Tunisian second hand clothes marketplace.
- [For Days](https://www.fordays.com/) - Subscription service that provides clothing with a zero-waste approach. When you sign up you purchase a membership and receive an organic cotton shirt - each time you want to purchase another article you send them back any old item to swap them out.
- [Knowledge Cotton Apparel](https://knowledgecottonapparel.com) - Clothing made from certified organic cotton, recycled PET, linen, wool, tencel, and recycled nylon sent via certified carbon neutral shipping in recyclable packaging.
- [Kushel](https://www.kushel.de) - Our bathrobes and towels are made from reforested beech wood and organic cotton, made in Portugal. Sourced from FSC-certified reforested forestry operations in Europe without irrigation. This mix needs 90% less water and emits 44% less CO2. By planting 2 trees for each towel and by compensating the carbon emissions and blue-water usage, we are a climate & resource positive textile brand, and the first certified B corporation in Germany.
- [Linen Fox](https://linenfoxclothes.com) - Small runs of customizable Oeko-tex certificated linen clothing with plastic free packaging.
- [Loop A Life - 100% Circular Fashion](https://loopalife.com/) - This circular textile award winning brand sets the new standard by clothing from local raw salvaged materials, recycling them without any chemicals, generating no wastewater, recycling their own products at end-of-life, researching and developing new ways to develop circular products. They organize local sorting campaigns, workshops, collection campaigns, and facilitate other fashion companies in their circular transition. Each sweater saves 500 liters of water, 60mJ of energy, uses zero chemicals, and saves at least 6kg of C02 emissions (when compared to traditional manufacturing).
- [Lost in Samsara - Bags, Jewelry, and Accessories](https://www.lostinsamsara.co.uk) - Stylish products produced ethically from upcycled materials. Bags made from cement bags, tires, and jewelry made from upcycled bullet casings.
- [MUD Jeans](https://mudjeans.eu/) - Zero impact jeans production obeying circular economy principles, paying fair wages and offering a repair service.
- [Mezzoroni](https://mezzoroni.com/) - Oeko-tex certificated, cruelty free customizable linen clothing brand. All of the packaging are plastic free.
- [NN07](https://www.nn07.com/) - Using its [sustainable material matrix](https://www.nn07.com/made-to-last), No Nationality designs made-to-last clothing primarily with recycled and non-cotton natural materials including hemp, linen, wool, alpaca, and silk.
- [Norm Shoes](https://norm.shoes/) - Our shoes are made from 90% recycled materials: recycled polyester (6 plastic bottles per pair), recycled rubber, and fairtrade rubber. The impact for one pair of Norm shoes is only 6,5 kg of CO2 equivalent (80% lower than the industry average). We partner with a Belgian NGO, Graine de Vie, to plant two trees in Madagascar for each pair we sell and we offset our emissions as well.
- [Patagonia](https://www.patagonia.com/) - Sports clothing produced in the most sustainable way ([footprint](https://www.patagonia.com/our-footprint/): working towards carbon neutral, recycled, fair trade, organic, ...)
- [Recover Brands](https://recoverbrands.com/) - Soft and strong T-shirts, each made from 8 plastic bottles. Closed Loop manufacturing from the start.
- [Runamics Running & Sports Gear](https://www.runamics.com) - Crowd-funded for-purpose eco-friendly alternatives to traditional sports gear. We combine merino wool with wood-based cellulosic fibres like Lyocell. We make experiments with highly innovative fibres like biodegradable elastic fibres or “polyester-like” substitutes. WE're climate neutral always working to reduce our footprint, use plastic-free packaging and ship globally with DHL GoGreen.
- [Sustainable Hosiery](https://www.sustainablehosiery.com/) - OEKO-TEX certified, vegan-dyed hosiery made from 76% - 97% recycled post-production and post-consumer nylon waste in Zero Waste factories
- [TenTree](https://www.tentree.ca/) - Ten tree is a brand that actively promotes environmental stewardship. They have a wide variety of comfortable clothes and accessories and with each purchase, they pledge to plant 10 trees.
- [Vesica Piscis Shoes](https://vesicapiscisfootwear.com/) - Hand made stylish shoes made from recycled materials. Recycled cotton, recycled polyester fabric picking from plastic bottles, X-ray plates, fishing nets, etc. They use virgin natural rubber, bamboo, and a small amount of organic cotton.
- [Vinted Used Clothes Marketplace](https://www.vinted.com) - Your community for pre-loved fashion. Buy and sell quality used apparel.
- [Worn Wear](https://wornwear.patagonia.com/) - A set of tools to help our customers partner with Patagonia to take mutual responsibility to extend the life of the products Patagonia makes and customers purchase. You can buy second-hand repaired or re-crafted clothes, or trade in used Patagonia clothes for credit for new items.
- [Woron Store](https://www.woronstore.com/) - Lingerie and base wear essentials made from GOTS-certified, antibacterial 'Lenzing Modal' (Beech wood!) made from CO2-neutral FSC-certified native tree plantations.

## Consumer Products

- [A Good Company - The Plastic-Free Store](https://agood.com/) - Everyday products including notebooks, toothbrushes, phone cases, art supplies, water bottles, etc. designed with by a company with complete transparency that has extremely ambitious environmental standards including plastic-free low-carbon materials including bio-plastics, bamboo, stone paper, and recycled aluminum.
- [Earth Hero](https://earthhero.com/) - Our brands are made with better materials, cleaner production, a lower carbon footprint, higher quality, and with less waste. When you shop on EarthHero, you contribute to a better future for us all.
- [Fairphone](https://www.fairphone.com/) - A phone for everyone who cares about how their products are made. It improves the conditions of the people who make it and uses materials that are better for the planet.
- [Grayl Water Filter](https://grayl.com/) - Water bottle with built in filter that works like a french press. Great for urban and outdoor use.
- [Katadyn Water Filters](https://www.katadyn.com/en/de/products/water-filters#/1/filter?categories=32) - Katadyn develops and manufactures durable and portable water filters, desalinators and chemical disinfectants for daily use, camping, trekking, or global journeys. The vast product line ranges from water filters and Micropur tablets to the smallest manual desalinator for marine applications. Aid organizations as well as the military rely on them.
- [Lehman's](https://www.lehmans.com/) - One-stop shop for non-electric, homesteading, survival, handmade, Amish made, plastic free, durable, quality goods. If you envision switching to live a simpler life, this place has all the tools you need to do so.
- [Palm-Oil Free Products](https://orangutanfoundation.org.au/palm-oil/) - Make sure your makeup, biofuel, popcorn, candy, and other [various products](https://www.ethicalconsumer.org/palm-oil/palm-oil-free-list) are palm-oil free. The World Wildlife Fund estimates that 48 football fields worth of rainforest are cut down every minute! It’s estimated that palm oil plantations now cover around 27 million hectares. The forests being clear cut are often habitat for orangutans, who will be completely gone within 5-10 years at this rate.
- [Pela Case](https://pelacase.com/) - 100% Compostable phone case for iPhone and Android made with flax. Also zero-waste screen protectors and sunglasses.
- [TomatoInk](https://www.tomatoink.com/) - TomatoInk is an eco-friendly, low-cost provider of ink and toner. By packaging ink in remanufactured cartridges, we pass along substantial savings both financial and environmental to you. “Our factory collects high-quality used cartridges. There, they are professionally cleaned and inspected and any defective parts get replaced. The cartridges then get filled with high-quality ink comparable to that used in name-brand cartridges. And finally, every single cartridge is inspected and test printed.”

## Cooking

- [Ecocina Rocket Stoves](http://www.stoveteam.org/) - Wood fired cook stove that uses ~40-50% less fuel than traditional fires and emits ~1/3 the CO2. Learn how to build one! Check out their research center at [Aprovecho](http://aprovecho.org/).
- [Go Sun](https://www.gosun.co/) - An innovative portable ultra-efficient solar cooker that can be used for backpacking, boating, car camping, etc.
- [Insulated Cooking](https://www.milkwood.net/2015/07/06/thermal-cooking/) - Discover a great way not only to use less energy in food preparation, but to serve tastier and more nutritious meals at the same time. Any recipe that calls for boiling, simmering, steaming, or roasting will often taste better— [hot from the haybox](https://www.motherearthnews.com/diy/haybox-cooking-zmaz80jfzraw) — than it would with regular stove preparation ... and you'll save heat energy at the same time. You can pick up a pot-sized [thermal cooker](http://www.cookingworld.biz/thermal-cooker-guide/), or simply put a blanket in a cooler.
- [Preserve Extra Food With A Solar Dehydrator](https://www.motherearthnews.com/diy/tools/solar-food-dehydrator-plans-zm0z14jjzmar) - A solar food dehydrator is a device that removes moisture from food to aid in its preservation. You can [buy a simple one](https://www.kickstarter.com/projects/mixedmediaeng/dryceratop-solar-food-dehydrator-for-mason-jars/description) or make your own. Food drying is a method of preserving fruit, vegetables, and animal proteins that has been practiced since antiquity.
- [Sun Oven](https://www.sunoven.com) - Insulated solar oven that can cook food just like a regular oven.

## Development

- [1 Click Impact](https://docs.1clickimpact.com/) - Comprehensive sustainability API platform for developers featuring Tree Planting API, Carbon Capture API, Ocean Cleanup API, and more. Plant trees with every purchase, offset carbon emissions automatically, clean oceans, and integrate sustainability features seamlessly into your existing products. Easy integration for e-commerce platforms, mobile apps, and web applications to make any business climate-positive with minimal code.
- [Step CI](https://docs.stepci.com/guides/co2-testing.html) - Open-source framework for API Quality Assurance, which tests REST, GraphQL and gRPC automated and from Open API spec. It lets you calculate carbon emissions of your API calls.

## Documentaries

- [Artifishial](https://www.patagonia.com/artifishal.html) - Artifishal is a film about people, rivers, and the fight for the future of wild fish and the environment that supports them. It explores wild salmon’s slide toward extinction, threats posed by fish hatcheries and fish farms, and our continued loss of faith in nature.
- [Biggest Little Farm](https://www.biggestlittlefarmmovie.com/) - The Biggest Little Farm chronicles the eight-year quest of John and Molly Chester as they trade city living for 200 acres of barren farmland and a dream to harvest in harmony with nature. Through dogged perseverance and embracing the opportunity provided by nature's conflicts, the Chesters unlock and uncover a biodiverse design for living that exists far beyond their farm, its seasons, and our wildest imagination. Featuring breathtaking cinematography, captivating animals, and an urgent message to heed Mother Nature's call, The Biggest Little Farm provides us all a vital blueprint for better living and a healthier planet.
- [Garbage Warrior](http://www.garbagewarrior.com/) - Garbage Warrior is a feature-length documentary film telling the epic story of maverick architect Michael Reynolds, his crew of renegade house builders from New Mexico, and their fight to introduce radically different ways of living. Imagine a home that heats itself, that provides its own water, hat grows its own food. Imagine that it needs no expensive technology, that it recycles its own waste, that it has its own power source. And now imagine that it can be built anywhere, by anyone, out of the things society throws away. Thirty years ago, architect Michael Reynolds imagined just such a home - then set out to build it. Reynolds believes that in an age of ecological instability and impending natural disaster, his buildings can - and will - change the way we live.

## Finance

- [Abundance Investment](https://www.abundanceinvestment.com/) - Abundance offer a crowdfunding marketplace for socially and environmentally beneficial projects. Make direct investments in a range of businesses that share your values, through an ISA or a pension.
- [Amalgamated Bank](https://amalgamatedbank.com/) - Personal and business banking from a Certified B Corporation. They're fossil fuel free in our lending, powered by 100% renewable energy and have a long, proud history of providing affordable access to banking and being a champion of immigrants’ and workers’ rights. _NOT_ a FDIC member, but part of GABV (the Global Alliance of Banking on Values).
- [Aspiration](https://www.aspiration.com/) - Aspiration offers socially-conscious and sustainable cash management services and investment products, so you can make money while making the world a better place. And, unlike the Big Banks, we don’t use your deposits to fund oil pipelines or turn your fees into campaign contributions to the politicians that work against you.\*\*
- [Beneficial State Bank](https://beneficialstatebank.com/) - From fairly priced checking accounts for individuals and families that help you stay on track, to business and nonprofit financial tools that assist you in growing your organization. This bank is a B Corp, a FDIC member, and part of GABV (the Global Alliance of Banking on Values). Recommended by Stop The Money Pipeline.
- [Betterment - Socially Responsible Investing](https://www.betterment.com/socially-responsible-investing/?referral_key=philipsturgeon) - Super reliable, tax efficient, Traditional and Roth IRA / 401(k), and they now offer checking too. Betterment is not socially responsible by default, you need to select the SRI portfolio for each and every goal (account) you set up with them. They have divested from oil, but you should review [their SRI strategy](https://www.betterment.com/resources/socially-responsible-investing-portfolio-methodology/#sociallyresponsible) to see if you think it's good enough.
- [Climate-KIC Marketplace](https://www.climate-kic.org/marketplace/) - Marketplace full of investment opportunities into early-stage startups. The dealflow stems from EIT Climate-KIC’s Accelerator programme, the largest climate-focused acceleration programme in the world.
- [Corner Card](https://www.cornercard.ch/de/privatkunden/kreditkarten/liste/detail/climate-creditcard-de) - Discover Switzerland's first climate-friendly credit card: with every card you make an active contribution to the compensation of CO2 emissions - without any additional costs for you. Complete climate compensation Whether a flight ticket, a new shirt or an overnight stay in a hotel - goods and services paid for with the Climate Credit Card are 100% CO2 compensated.
- [Ditch Dirty Banks](https://www.ran.org/bankingonclimatechange2019/#data-panel) - Anyone with a Chase, Wells Fargo, Citi Bank account could do the world a favour by cutting that card in half. Customers of any of the fossil fuel funding banks in this list could. Phone up, tell them to cancel your account because they're funding _still funding coal and fracking_, and put another little ding in their bottom line. Find an ethical bank, they've usually got better fees and more friendly support staff anyway.
- [EQ Investors](https://eqinvestors.co.uk/individuals) - Impact investing is an exciting and rapidly growing industry powered by investors who are determined to generate social and environmental impact as well as financial returns.
- [Ecology Building Society](https://www.ecology.co.uk/) - Need a savings account or a mortgage, but don't want the money being used for the usual awful stuff banks fund? Ecology are dedicated to improving the environment by supporting and promoting ecological building practices and sustainable communities. They'll even give mortgage to folks trying to buy woodlands, or to buy fields and create woodland!
- [Global Alliance for Banking on Values](https://www.gabv.org/) - The Global Alliance for Banking on Values (GABV) is a network of banking leaders from around the world committed to advancing positive change in the banking sector. Their goal is to change the banking system so that it is more transparent, supports economic, social and environmental sustainability, and is composed of a diverse range of banking institutions serving the real economy.
- [Good Money Week](https://goodmoneyweek.com/) - Helping you find sustainable and ethical options for banking, pensions, savings and investments.
- [Hargreaves Lansdown Responsible Investment](https://www.hl.co.uk/) - Hargreaves Lansdown are a big name in finance, offering savings accounts and pensions. They will let you invest in pretty much anything, but they've put together a list of "responsible investment" funds to help you defer some of the thinking to the finance brains. The term 'responsible investment' is often used as a catch-all to describe funds managed with social, environmental, or other responsible criteria in mind, so maybe sift through this list to find ones that sound good to you, whether you use HL or not.
- [Market Forces AU: Sustainable Banks](https://www.marketforces.org.au/info/compare-bank-table/) - Find out which banks do and don’t have a record of funding fossil fuels. Each institution is sorted into categories clearly defining those that fund fossil fuels and those with no current record of funding the industry. Importantly, you can take action and contact every single bank, credit union and building society listed.
- [NextEnergy Solar Fund](https://www.nextenergysolarfund.com/) - NextEnergy Solar Fund is a specialist investment company that invests in operating solar power plants in the UK and Italy, with the objective of securing attractive shareholder returns through RPI-linked dividends. The Company achieves this by acquiring solar power plants on agricultural, industrial and commercial sites. Invest through an ISA or SIPP on usual UK trading platforms like HL/Fidelity/etc.
- [Stop the Money Pipeline](https://www.stopthemoneypipeline.com/) - Banks, insurance companies, and asset managers are funding, insuring and investing in the climate crisis. Stopping this money pipeline is one of the most important ways we can address the climate emergency.
- [Thrive Renewables](https://www.thriverenewables.co.uk/) - Thrive Renewables connects people to sustainable energy. We offer accessible opportunities for individuals and businesses to invest in clean energy projects that deliver financial, environmental and social rewards. With over 25 years in the industry, we have a wide network of professional contacts and are constantly on the look out for new projects which enhance our portfolio, match our investment criteria and have the potential to generate financial, environmental and social returns.
- [Tomorrow One Bank](https://www.tomorrow.one) - German bank which considers the future of our planet to be more important than access to VIP lounges at airports. Skip extra insurance products and fuel discounts, and get a premium account that focuses on climate protection.
- [TreeCard](https://www.treecard.org/) - TreeCard - The wooden debit card that plants trees.
- [Trine - Solar Crowd-investing](https://www.trine.com/) - Invest in solar projects bringing clean energy to emerging markets. Local solar partners will distribute and manage the solar products on the ground. If the loan is successful you will receive your investment and interest in return.
- [Triodos Bank](https://www.triodos.co.uk/) - Modern financial and banking services for savers, investors, and organisations who want to change the world for the better. Current accounts, personal savings, ISAs, business lending, and all sorts of other options for individuals, businesses, and charities.
- [Triodos Crowdfunding](https://www.triodoscrowdfunding.co.uk/) - Invest directly in pioneering organisations delivering positive change, such as community solar schemes, renewable energy projects, ethical food supermarkets.

## Food

- [Able & Cole](https://www.abelandcole.co.uk/) - Get fruit, veg, pantry staples, and other organic food delivered in returnable, reusable, recyclable packaging. Seasonal boxes of veg so its not traveling around the world, sustainably sourced fish, they've even got beer.
- [Agricool - Local, healthy, sustainable food](https://www.agricool.co/fr) - Des fruits et légumes, cultivés au coeur des villes, à moins de 15km de leur lieu de consommation. Frais, locaux, sans pesticides.
- [CrowdFarming.com] - Buying food directly from farmers is the most powerful everyday act available to anyone to create a positive social and environmental impact.
- [NotCo](https://notco.com) - The Not Company is a Foodtech, that reinvents animal-based foods using only plants. Unlike traditional food businesses, the company uses technology to recreate the same products we love to eat in a natural, sustainable and affordable way, keeping it functional, easy to use and mouthwateringly delicious. They use Artificial Intelligence to build a library of thousands of Plants and find how to use them, to recreate the same taste, smell, function, look and feel of the products we love. ALL PLANT-BASED.
- [All Plants - Vegan Prepared Meals](https://allplants.com/) - Get super tasty and 100% plant-based meals cooked by chefs and delivered straight to your door. Two people getting six meals works out at £5 a meal, which is amazing. Use [this referral link](https://allplants.mention-me.com/me/referee/registerko/48827185/206943008/er/796b4fb5d581862f565aa73f01fe733b8576831c/fe/cw?epr=1) to get £10 off your first box. We'll get £10 off our next box, so we'll spend that saving on trees on [Offset Earth](https://offset.earth/philsturgeon). 🥳
- [Bees Wrap](https://www.beeswrap.com/) - Stop using cling film and start using reusable recyclable wraps made from bees wax and organic jojoba oil.
- [Boulder Food Rescue](https://www.boulderfoodrescue.org/) - We facilitate the sustainable redistribution of healthy food that would otherwise be wasted to low-income communities, by bicycle. We work with communities to facilitate their own food redistribution and create decentralized systems to bypass barriers to food access. Our work envisions a world in which everyone has equitable access to healthy food.
- [City Harvest](https://www.cityharvest.org/) - City Harvest is New York City’s largest food rescue organization. They rescue food and deliver it to hundreds of food pantries, soup kitchens and other community partners.
- [EIT Food](https://www.eitfood.eu/) - EIT Food is Europe’s leading food innovation initiative, working to make the food system more sustainable, healthy and trusted by consumers.
- [Farm Drop](https://www.farmdrop.com/) - Next day delivery in London for groceries and household products from local and independent producers.
- [Food Cloud](https://food.cloud/) - FoodCloud is a social enterprise that connects businesses with surplus food to charities in their local communities that need it via a software platform.
- [Foodsharing.de](https://foodsharing.de/) - If you are located in Germany, join your local food rescuing group on foodsharing.de.
- [Forkful](https://www.forkful.app/) - Sustainable, nutritious eating that is as good for you as it is for the planet. With our powerful recipe search, you can view the nutritional benefit and environmental impact of thousands of recipes at a glance, empowering you to make awesome decisions.
- [Geev](https://corporate.geev.com/) - An online application to exchange stuffs and food between people. Easily discuss, meet and give a second life to objects and food. The more you give the more people trust you when you want to get something.
- [Giki](https://gikibadges.com/) - The Giki app provides accessible, independent, transparent information to help people change habits to live more sustainably. Our 14 badges cover sustainability, health and fairness.
- [Grocy](https://grocy.info/) - Grocy is a web-based self-hosted groceries and household management solution for your home. Scan barcodes, track your purchases, automate and optimize your shopping list, waste less by keeping track of what's expiring next, plan meals, and more.
- [GrowNYC Food Scrap Collection Schedule](https://www.grownyc.org/compost/locations) - Interactive map with over 150 residential Food Scrap Drop-Off sites in NYC.
- [Happy Cow](https://www.happycow.net) - Reduce or avoid meat entirely by finding great vegetarian or vegan food all over the world.
- [Karma](https://karma.life/) - Rescue unsold meals, delivered, always 50% off in hundreds of cities across Sweden, United Kingdom, and France.
- [Karma](https://new.karma.life/) - A Swedish company that lets restaurants sell surplus food at a lower price. It lets you pay less for food and prevent food waste.
- [Karrot](https://karrot.world/) - Join or start a group in your home town that rescues food. Karrot is a free and open-source tool for grassroots initiatives and groups of people that want to coordinate face-to-face activities on a local, autonomous and voluntary basis.
- [Kitche](https://kitche.co/) - Kitche works to reduce waste from inside users’ kitchens and makes it easier than ever before to manage food at home, saving money and reducing food waste all within one app. Scan receipts and stop wasting money!
- [Makkelijke Moestuin (Easy Vegetable Garden)](https://www.makkelijkemoestuin.nl/) - We make the vegetable garden easy. Thanks to our stuff and app, you can immediately garden like a pro. Setting up your vegetable garden perfectly is 80% of the work. Our stuff is specially made for that. With the other 20% - maintenance - our app helps you completely. You harvest 5 times as much per m² as from an ordinary vegetable garden. Ka-ching!
- [No Meat Today](https://nomeat.today/) - Your companion to eat less meat. It's good for you and the planet, but let's be honest, eating less meat is hard. Don't do it alone!
- [No Waste](https://www.nowasteapp.com/) - With lists for your freezer, fridge and pantry, you can easily check what food you have left, see what food you need to use first, plan your meals, create a shopping list, avoid unnecessary purchases, reduce food waste and save a bunch of money.
- [Olio](https://olioex.com/) - We connect neighbors to share food, and other things, rather than chuck them away.
- [Pieter Pot](https://www.pieter-pot.nl/) - Your groceries, delivered without packaging. Pieter Pot delivers your groceries with a cargo bike in beautiful glass jars in The Netherlands. Empty pot? Then we fill it again. This is how we make it fun and easy to do shopping without all those unnecessary (plastic) packaging. That's nice, right?
- [Seafood Watch](https://www.seafoodwatch.org/) - Seafood Watch recommends seafood that is fished or farmed in ways that promote healthy oceans. They recommend best options, good alternatives, and things to avoid.
- [The Rotten Fruit Box](https://therottenfruitbox.com/) - 100% Natural Freeze-Dried Fruit Snacks from Spain and Portugal shipped to you. The fruit you’re enjoying would have otherwise gone unused and rotted away on the ground. We also think that the name "Rotten" helps bring attention to the serious issue of food waste. Delicious, healthy, 100% natural, with a long shelf life, our freeze dried fruit snack pouches are ideal for home, work, office, to take to school, camping or just about anywhere. Help reduce food waste. Help small local farmers. 100% compostable packaging, ships with your local postal service because it is the lowest carbon footprint option.
- [Too Good To Go](https://toogoodtogo.co.uk/) - Sell your surplus food, easily and sustainably! Save delicious food and fight food waste. Find your favorite food and go rescue it.
- [We Are Phenix](https://wearephenix.com/en/) - Buy unsold goods from local businesses at a reduced price. Sell expired products to clients, donate to charities, reuse organic waste for animal food, and more. With over 100k meals saved per day, we are well on our way to reach the objective of zero food waste.
- [The Felix Project](https://thefelixproject.org/) - London-based charity that collects fresh, nutritious food that cannot be sold. Deliver this surplus food to charities and schools so they can provide healthy meals and help the most vulnerable in our society. Reducing food waste and poverty.
- [OddBox](https://www.oddbox.co.uk) - English Certified B Corp that is reducing food waste. Collects food rejected by Supermarkets, directly from farms and delivers to your door. £10 off your first box with this link (https://mention-me.com/m/ol/qd4ho-0d5026f88d). I will plant trees through Ecologi with the £10 I get for this.

## Footprint Calculators

- [Carbon Analytics](https://www.co2analytics.com/) - Link a Xero accounts to assess each purchase a company makes, calculating the carbon impact of things like fuel, power purchases, transportation and more as well as supply chain impacts.
- [CarbonFootprint.com](https://www.carbonfootprint.com/) - Measure you carbon footprint, learn how to reduce your consumption, offset your impact, communicate, and comply.
- [CarbonFund.org](https://carbonfund.org/) - Calculate your footprint based on flights, driving, shipping, and make tax-deductible donations to offset your emissions.
- [Cloud Carbon Footprint](https://www.cloudcarbonfootprint.org/) - An open source tool that provides visibility and tooling to measure, monitor and reduce public cloud carbon emissions. It supports multiple cloud providers including AWS, Google Cloud, and Microsoft Azure, and displays energy and carbon emission metrics in a dashabord, command line interface or exportable to CSV.
- [Eaternity](http://eaternity.org) - Eaternity helps you calculate the environmental impact of their food to create a food system that operates within the Earth's environmental limits. Acting as a bridge between science and practical application, Eaternity provides accessible information on the CO₂ balance of food. The company, founded in 2008 at ETH Zurich, has been using a life cycle assessment (LCA) database for over 10 years to achieve this goal. The database has been continuously developed since its creation. By integrating this database into existing production systems, food product producers can measure, improve, and market their specific environmental footprint.
- [Eco Passenger](http://ecopassenger.hafas.de/) - More than a quarter of worldwide greenhouse gases emissions come from the transportation sector, and more important, it is the sector where we have seen the highest growth in these emissions the last decades and it is not stopping. To help, EcoPassenger is a calculator to compare the energy consumption, CO2 and exhaust atmospheric emissions for planes, cars, and trains, for passenger transport.
- [Emitwise](https://www.emitwise.com/) - The Emitwise Reportwise tool calculates company level GHG emissions in line with the GHG Protocol for scope 1 and 2 emissions. Primarily targeting the UK but would also be useful for other countries.
- [How Good](https://howgood.com/) - Future-Proof your products. HowGood data offers data to businesses and consumers about product sustainability from 350+ independent sources on over 1 million products. Extensive data library on product sustainability designed to help brands and retailers use that data to source better and consumers to buy better, to build a better world.
- [Impact Forecast](https://www.impactforecast.org/) - The Climate impact forecast is a quick-and-easy tool to see and improve the carbon footprint of business ideas in the startup phase, and a stepping stone towards more meticulous life cycle assessment for established companies.
- [Joro](https://www.joro.tech/) - Effortlessly track your personal carbon footprint by securely connecting your credit and debit cards. Joro combines financial data and academic datasets to develop real-time carbon footprint estimates. The bank integration uses Plaid, and is US only for now, but has plans to roll out to Europe. Sign up to the newsletter to find out.
- [MyClimate](https://myclimate.org/) - Helping reduce emissions through a whole bunch of different projects, from consulting companies on their footprint (and helping them to reduce), to education at schools, forest restoration, providing people in Rwanda with efficient cook stoves, and [a whole bunch more](https://www.myclimate.org/information/climate-protection-projects/). Fund them via donations, and use their flight/car/house/company footprint calculators.
- [Plan A](https://plana.earth/) - Software that helps your business calculate, monitor and reduce its carbon footprint. Our platform allows you to track your carbon footprint monthly and learn how to reduce it with the support of a custom sustainability action plan, automatically created based on your worst-performing indicators.
- [Protea OSS Carbon Footprint](https://github.com/protea-earth/carbon_footprint) - Open source carbon footprint calculator, the only emissions calculator to use a command line interface.
- [The US EPA's Carbon Footprint Calculator](https://www3.epa.gov/carbon-footprint-calculator/) - The calculator estimates your footprint in three areas- home energy, transportation and waste. Everyone's carbon footprint is different depending on their location, habits, and personal choices.
- [WWF UK Calculator](https://footprint.wwf.org.uk/) - The planet is in crisis - from climate change to the pollution in our oceans and devastation of our forests. It's up to all of us to fix it. Take your first step with our environmental footprint calculator.
- [Zellar](https://zellar.com/) - Get an energy profile for your company to understand your energy consumption, and how much CO2 is being generated to power your business. We’ll then let you compare your profile to other local businesses or similar businesses across the UK, then track performance over time. Get advice and even unlock funds to finance any investments you may need to make on your journey to zero carbon.
- [atmosfair](https://www.atmosfair.de/) - Calculate the footprint for flights and buy compensation or donate to offset any number of carbon emissions. Tax-deductible in Germany.

## Home Improvements

- [All Green](https://www.all-green.co.uk/) - A selection of environmentally friendly products for the home, garden, pets and other stuff.
- [Barry](https://barry.energy) - Få et smart strømforbrug. Udskift din gamle el-leverandør med en app til din strøm.
- [Domestic Renewable Heat Incentive (RHI)](https://www.gov.uk/domestic-renewable-heat-incentive) - You could get money towards renewable heating costs in your home. You can claim for biomass boilers, solar water heating, heat pumps. Payments are made for 7 years and are based on the amount of renewable heat made by your heating system.
- [EPA's Responsible Appliance Disposal](https://www.epa.gov/rad) - RAD is a voluntary partnership program that works with utilities, retailers, manufacturers, state and local government agencies, affiliates, and others to dispose of old refrigerated appliances using the best environmental practices available.
- [Ecobee](https://www.ecobee.com/) - Improve how people consume energy to create a more sustainable future. Live in harmony with a thermostat and sensor that learn and adapt to your schedule. _Lower the manufacturing footprint by buying one of their refurbished products._
- [EnergyStar.gov](https://www.energystar.gov/) - Energy efficiency ratings, suppliers, and tax credits for products, homes, utilities, and local governments. ENERGY STAR is the government-backed symbol for energy efficiency, providing simple, credible, and unbiased information that consumers and businesses rely on to make well-informed decisions.
- [Environmentally Friendly Roof Insulation](https://www.greenlivingtips.com/articles/environmentally-friendly-roof-insulation.html) - However you heat your home, make sure you aren't leaking heat through insufficient insulation, and save money.
- [Hamwells Showers](https://www.hamwells.com/) - Shower systems that utilize heat exchangers to recapture heat and filtered pumps to recycle water up to 7 times before it is drained, thus significantly reducing water usage and energy consumption.
- [Lancey](https://www.lancey.fr/) - An efficient radiator to control your electricity consumption while improving comfort, with a connected thermostat to adapt to your needs and the characteristics of your home. A built-in battery stores electricity during off-peak hours, allowing you to automatically use cheaper and cleaner energy.
- [Lehman's Appliances](https://www.lehmans.com/category/appliances) - Off the grid and super efficient appliances, including gas refrigerators, freezers, composting toilets, wood stoves, water heaters and pumps.
- [Mist Showers](https://www.lowtechmagazine.com/2019/10/mist-showers-sustainable-decadence.html) - The emissions of a typical shower equal 3.5 – 7 km of driving. The mist shower, a satisfying but forgotten technology which uses very little water and energy, could be a solution. You can DIY convert almost any shower into a mist shower. The five-nozzle mist shower offers significant water and energy savings compared to a “normal” shower and does so without sacrificing comfort.
- [NY State Home Energy Assessment tool](https://www.nyserda.ny.gov/All-Programs/Programs/Home-Energy-Efficiency-Upgrades) - Get a home energy audit and receive tools, resources, and aid to upgrade your home to be more energy efficient.
- [Nebia Showers](https://nebia.com/) - Nebia is proud to offer products that transform your mundane shower routine into a ritual, and also contribute to preserving the planet.
- [PlanetCare Microfibre Laundry Filters](https://www.planetcare.org) - 35% of microplastics are fibers that are released when we wash our clothes. With consumer and industrial laundry filters, tackle the problem close to the source – with a filter in your washing machine. PlanteCare makes efficient, practical and affordable laundry filters that allow every household to stop sending microfibres into the environment.
- [PowerX](https://www.powerx.co/) - A plug-and-play smart-controller for water and gas headers. It learns what water temperatures you like and heats only as much water as you need. It will also detect the ideal time to heat your water, as prices change every 15 minutes, so you can save money with no impact on hot water levels. Save hundreds of dollars, reduce carbon emissions equivalent to 10 fully grown trees – every year!
- [Project Sunroof](https://www.google.com/get/sunroof) - Find out if you could save money switching to solar panels. This Google project uses Google Earth imagery to analyze your roof shape and local weather patterns to create a personalized solar plan. Adjust your electric bill to fine-tune your savings estimate and the recommended number of solar panels for your home, then compare loan, lease, and purchase options for your solar panels based on your results.
- [Regency Wood Stove Fireplace Inserts](https://www.regency-fire.com/en/Products/Wood/Wood-Inserts) - If solar heating is not an option, wood stove inserts can update your drafty, open wood fireplace. They'll send less heat out the chimney, and more heat around your house, drastically improving your wood burning efficiency. They pump the smoke back into the fire to burn that off too, which sends less crap into the atmosphere. Try to use [coffee logs](https://www.bio-bean.com/elements/coffee-logs-and-retailers/) instead of wood.
- [Rigo Paint - Made From Flax](https://www.rigoverffabriek.nl/) - Decorating your house? Check out RigoStep water-based paints, and oil paints depend on locally grown flax, which is heated and pressed by traditional windmills to extract the oil. Once mixed with other solvents, this forms the liquid base for the paint.
- [Sense](https://sense.com/) - Sense is a home energy monitor that gives real-time insight into your home’s energy usage. Sense gives people the knowledge they need to reduce their energy costs and usage, with profound effects on the environment- the company estimates that its users are saving a total of 53 million pounds of CO2 annually.
- [Solar Thermal Energy](https://en.wikipedia.org/wiki/Solar_thermal_energy) - Solar thermal technology can be used for cooking, heating your home through radiant floors, radiators, or forced air. It can be used to heat water directly for hot showers too.

## Hygiene

- [A Good Company - The Plastic-Free Store](https://agood.com/) - Everyday products including notebooks, toothbrushes, phone cases, art supplies, water bottles, etc. designed with by a company with complete transparency that has extremely ambitious environmental standards including plastic-free low-carbon materials including bio-plastics, bamboo, stone paper, and recycled aluminum.
- [CuloClean Water Bottle Bidet](https://culoclean.com/) - CuloClean is the portable bidet that you can plumb in your plastic bottle, fully discreet, efficient and portable. It is specially designed so that it fits in the two most common diameters of water bottle on the market.
- [Improve how you do laundry](https://greenlivingideas.com/2014/09/23/3-easy-ways-to-green-your-laundry/) - Six tips for a more sustainable laundry routine.
- [Ocean Savers Cleaning Supplies](https://www.ocean-saver.com/) - "Pre-mixed" cleaning sprays that you will find in the supermarket are over 90% water, with the active ingredient (the part that actually does the cleaning) making up a fraction of the total liquid. Oceansaver provide just the active ingredients, so people can reuse plastic bottles, reducing the consumption of single-use plastic.
- [Smol](https://smolproducts.com/) - Zero plastic dishwasher and laundry tablet subscription. Contains child lock, they're FSC certified, half the price of traditional brands, and animal cruelty free.
- [Sonny](https://www.indiegogo.com/projects/sonny-a-portable-bidet-for-eco-conscious-humans/x/17318484#/) - Never worry about running out of toilet paper again with Sonny, a sustainable alternative to wipes and paper for better hygiene and a greener planet.
- [The Cheeky Panda](https://cheekypanda.com) - 100% bamboo tissues shipped with zero plastic, wipes in recyclable plastic, and carbon balanced through the World Land Trust.
- [The Crappy Planet - Bamboo Toilet Paper](https://www.thecrappyplanet.com/) - According to the EPA, one hardwood tree produces approximately 45 kg of toilet paper and about 83 million toilet rolls are produced every day. Bamboo toilet paper production requires less energy, one-fifth of the water, produces considerably more fiber on less land area, generates 30-35% more oxygen than other plants and trees, and it reduces the amount of carbon dioxide by about the same amount. In addition, the production process requires that water and other materials are collected, reused and recycled. Finally, we invest 25% of our profits to stop deforestation and global warming.
- [The Good Roll](https://www.thegoodroll.nl) - Mail order 100% tree-friendly toilet paper made from post-consumer recycled paper. 50% of net profit from sales of The Good Roll is invested in the installation of safe toilets in East Africa.
- [Who Gives a Crap](https://whogivesacrap.org/) - We make all of our products with environmentally friendly materials, and we donate 50% of our profits to help build toilets for those in need.

## Jobs

- [80,000 Hours](https://80000hours.org/job-board/) - This board presents some of the most promising publicly advertised vacancies we know about. Most of these roles are demanding and difficult to get, but if you’re a good fit for one of them, it could be your best opportunity to work on one of the world’s most pressing problems, or to get the career capital you need to have a big impact later.
- [awesome-sustainability-jobs](https://github.com/pogopaule/awesome-sustainability-jobs) - A curated, open source list of developer jobs in the sustainability sector.
- [Circul'R](https://www.circul-r.com/) - Bridging startups and companies so they can co-create circular economy solutions
- [Data Science for Social Good](https://dssg-berlin.org/) - Berlin based group helping NGOs to make use of their data by connecting them with volunteer data scientists and analysts.
- [GoodWork](https://www.goodwork.ca/) - GoodWork is a Canadian community of environmental changemakers, sustainability professionals, job seekers and volunteers.
- [Green Jobs Network](https://greenjobs.greenjobsearch.org/) - Job board that connects employers with job seekers who are interested in jobs that focus on environmental or social responsibility. Not just tech jobs like some of these boards, they cover all sorts of jobs.
- [GreenJobs](https://greenjobs.com) - Site advertising a wide variety of green jobs to enhance your environmental career.
- [MakeSense Jobs](https://jobs.makesense.org) - Makesense inspires and empowers citizens, entrepreneurs and organizations to build an inclusive and sustainable society together. MakeSense's Job and assignment announcements platform for associations and social entrepreneurs who recruit profiles passionate about the impact. Job types include internship, freelance, civic service, partner, program, volunteer mission, mentoring.
- [Practical guide to finding a climate change job in tech](https://medium.com/@leventov/how-to-find-a-job-in-a-tech-company-helping-to-combat-climate-change-practical-guide-e212e262a32) - Nice guide on finding a job in tech tackling climate change.
- [Reconsidered Jobs](https://www.reconsidered.co/jobs) - Aggregate jobs in social impact, sustainability and corporate social responsibility.
- [TBD Community](https://www.tbd.community/) - More than 3,000 impact-driven companies and organisations use tbd\* to look for new team members, in English and German but many of the jobs are in Germany.
- [Tech Jobs for Good](https://techjobsforgood.com/) - Find tech jobs at social impact companies, foundations, and innovative nonprofits in the United States. They cover all sorts of impact areas, with Environment being one you can select. Some jobs are remote, some are in-office.
- [ClimateTriage](https://climatetriage.com/) - Discover a meaningful way to join open source projects by contributing to Good First Issues focused on climate and sustainability.
- [Terra.do](https://www.terra.do) - Climate learning and career transition platform, runs several fellowships on climate education (broad and sector-specific), hosts climate job fairs, connects to mentors and experts, etc.

## Land Management

- [Creating a Land Trust](https://conservationtools.org/guides/150-what-is-a-land-trust) - A land trust is a charitable organization that acquires land or conservation easements, or that stewards land or easements, for conservation purposes. Land owners may consider designating portions of their land as a land trust, in order to preserve natural features in perpetuity, and be eligible for tax benefits as a result.
- [Dronecoria](http://dronecoria.org/) - Open-source drone reforestation technology. Drones, coupled with native coated seeds, can transform the efficiency with which we restore ecosystems.
- [Droneseed](https://www.droneseed.com/) - They plant native trees & vegetation using drone swarms and spray to protect them. Provide valuable insights to customers by collecting data in the field. Work with governments, nonprofits, and private land owners as a service provider.
- [Farm Bot](https://farm.bot/) - Farm Bot is a fully automated, open-source, crowd-funded project, which helps you grow food for yourself, your family, and your community. Install FarmBot on a raised bed, urban rooftop, or in a small greenhouse at home. Hyper-local food production has never been easier.
- [Natural Resources Conservation Service (NRCS)](https://www.nrcs.usda.gov/) - NRCS will pay you to steward your land, in ways you define. It offers voluntary programs to eligible landowners and agricultural producers to provide financial and technical assistance to help manage natural resources in a sustainable manner. Programs include emergency watershed protection and flood prevention, watershed rehabilitation, surveys and planning, healthy forest reserve easements, agricultural conservation easements, conservation stewardship, and environmental quality incentives.
- [Permaculture Earthworks Handbook](https://newsociety.com/books/p/the-permaculture-earthworks-handbook) - A detailed guide to the proper design and construction of water harvesting earthworks. It covers the function, design, and construction methods for nine main types of water harvesting earthworks across a full range of climates. Free alternatives are an online course by [Permaculture Women](https://www.permaculturewomen.com/freepermaculturecourse.html), and a four-part documentary by [Geoff Lawton](https://www.geofflawtononline.com/).

## News

- [Bloomberg Green](https://www.bloomberg.com/green) - Climate news and insights on the latest in science, environmental impacts, zero-emission tech and green finance.
- [Carbon Brief](https://www.carbonbrief.org/) - UK-based website covering the latest developments in climate science, climate policy and energy policy. Clear, data-driven articles and graphics to help improve the understanding of climate change, both in terms of the science and the policy response.
- [Democracy Now!](https://www.democracynow.org/topics/climate_change) - Independent global news produced daily, hosted by award-winning journalists Amy Goodman and Juan González. Our reporting includes breaking daily news headlines and in-depth interviews with people on the front lines of the world’s most pressing issues by a diversity of voices. Free from government funding, corporate sponsorship, underwriting or advertising revenue.
- [Heated](https://heated.world/) - Original reporting and analysis on the climate crisis at the top of your inbox every morning, Monday through Thursday. News should arm you with the knowledge you need to effectively fight this crisis.
- [iPanda](http://en.ipanda.com/) iPanda offers news and live broadcasts of events concerning the release of pandas into the wild, panda mating and breeding, the debut of new-born baby pandas, etc. Also strive to spread knowledge about the conservation of the giant panda and other rare wildlife species, raising awareness to audience around the world about environmental protection.
- [Metabolic](https://metabolic.nl/news) - Sustainability consultancy in The Netherlands, tracking and reporting on climate action, circular economy, reducing consumption, etc. all over the world.
- [State of the Planet](https://blogs.ei.columbia.edu/category/climate/) - News from the Earth Institute at Columbia University. Columbia’s Earth Institute blends research in the physical and social sciences, education and practical solutions to help guide the world onto a path toward sustainability.
- [The Cleanest Line](https://www.patagonia.com/blog/) - Patagonia's blog on their efforts into political engagement for environmental protection of green spaces, global strikes, their efforts subsidizing solar energy in various communities, and all sorts of other climate action.
- [The Guardian](https://www.theguardian.com/uk/environment) - The Guardian covers international environmental issues and climate change.
- [US Green Build Council](https://www.usgbc.org/articles) - Transforming how buildings are designed, constructed and operated through the LEED construction standard. Articles about benchmarking energy efficiency of materials, city strategy, measuring the health of indoor spaces, reducing off-gassing, and improving air quality.

## Other Services

- [Ecotalk](https://www.ecotalk.co.uk) - UK-based mobile network powered by renewable energy. Profits are used to buy land which is then given back to nature.

## Podcasts

- [Democracy Now!](https://www.democracynow.org/topics/climate_change) - Independent global news produced daily, hosted by award-winning journalists Amy Goodman and Juan González. Our reporting includes breaking daily news headlines and in-depth interviews with people on the front lines of the world’s most pressing issues by a diversity of voices. Free from government funding, corporate sponsorship, underwriting or advertising revenue.
- [How to Save a Planet](https://gimletmedia.com/shows/howtosaveaplanet) - weekly-ish podcast by Gimlet Media that asks the big questions: what do we need to do to solve the climate crisis, and how do we get it done? Journalist Alex Blumberg and scientist and policy nerd Dr. Ayana Elizabeth Johnson talk to people who are making a difference and work to figure out how to build the future we want, tackling a different subject related to the climate crisis each episode.
- [People Fixing the World - BBC World Service](https://www.bbc.co.uk/programmes/p04grdbc) - Brilliant solutions to the world’s problems. We meet people with ideas to make the world a better place and investigate whether they work.

- [TIL Climate Podcast](https://climate.mit.edu/users/tilclimate-podcast) - This MIT podcast breaks down the science, technologies, and policies behind climate change, how it’s impacting us, and what we can do about it. Each quick episode gives you the what, why, and how on climate change -- from real scientists -- to help us make informed decisions for our future.
- [Talking Headways: A Book Club for the Future of Transportation](https://streetsblog.libsyn.com/) - We explore the intersection of sustainable transportation, urban planning, city living, economic development, and anything else that piques our interest. A staple and almost an obligatory source of information on the latest trends in urban mobility and urban planning.
- [The Climate Fix](https://theclimatefix.com/) - We shine a spotlight on people and organisations working on sustainable solutions, help connect them to talent & investment as well as give people hope that there are climate solutions as well as climate problems.
- [The Energy Transition Show](https://xenetwork.org/ets/) - Straight talk about the world’s transition from fossil fuels to renewables with energy expert Chris Nelder.
- [Green Pulse](https://omny.fm/shows/green-pulse-1) - The Straits Times (A Singapore news outlet) analyses the beat of the changing environment, from biodiversity conservation to climate change.

## Politics

- [EU: Right to Repair](https://repair.eu/) - Cracked screens, weak batteries, broken charging ports... We’d like to fix them, but instead we end up buying a new smartphone because repairs are too expensive, difficult or impossible. Reducing the lifespan of a product may drive sales, but this comes at the expense of consumers, workers and the planet. Ask the European Union to give people the Right to Repair by requiring manufacturers to design repairable smartphones and provide spare parts and repair information to all repairers and consumers.
- [Energy Innovation and Carbon Dividend Act](https://energyinnovationact.org/) - The Energy Innovation and Carbon Dividend Act (H.R. 763) will drive down America's carbon pollution and bring climate change under control, while unleashing American technology innovation and ingenuity. This policy was also introduced in the Senate in 2018 as S. 3791.
- [No Fracking in Alaska’s Arctic Wildlife Refuge](https://act.nrdc.org/letter/welcome-arctic-190603) - Alaska’s Arctic National Wildlife Refuge is one of our last truly wild places — and it has been off-limits to oil companies for decades. But the Trump administration is closer than any administration in history to tearing open the Arctic Refuge for destructive oil and gas drilling.
- [Our Children's Trust](https://www.ourchildrenstrust.org/) - Leading the game-changing, youth-driven, global climate recovery campaign to secure the legal right to a stable climate and healthy atmosphere.
- [Save Wild Orcas and Wild Salmon](https://www.change.org/p/wild-salmon-and-southern-resident-killer-whales-are-on-the-brink-of-extinction?signed=true) - Wild salmon and southern resident killer whales are on the brink of extinction. Now a misguided plan to feed the starving whales with hatchery salmon will push both endangered species closer to the edge, while costing taxpayers millions of dollars per year.
  Tell NOAA Regional Administrator Barry Thom, WDFW Director Kelly Susewind, and our elected decision makers to stop wasting money on failed plans and invest in science-based solutions: reduce hatchery production, remove dams and change how we harvest salmon.
- [U.K. Double Tree Cover](https://act.friendsoftheearth.uk/petition/tell-uk-government-double-tree-cover) - Over the centuries the United Kingdom has cleared its forests, leaving it with some of the lowest levels of woodland in Europe. If the government is serious about protecting the climate, it needs to bring back the lost trees.
- [U.S. Gas-powered car free by 2040](https://www.curbed.com/2019/5/21/18632816/zero-emission-vehicles-act-ban-cars) - Federal legislation was proposed in both the House of Representatives and the Senate that could radically shift the way the U.S. tackles its climate crisis. The Zero-Emission Vehicles Act would eliminate the sale of gas-powered passenger cars in the U.S. by 2040.
- [U.S. Save the "Clean Power Plan"](https://www.nrdc.org/save-clean-power-plan) - Fossil-fueled power plants are responsible for nearly 40 percent of America’s carbon footprint. The Clean Power Plan calls for setting limits on this climate-warming pollution from these power plants, specifically at least 32 percent by 2030, compared to 2005 levels. By 2030, the Clean Power Plan could save the United States $20 billion in climate-related costs and deliver up to $34 billion in health benefits.
- [UK Government: Act now on the Climate Emergency](https://secure.greenpeace.org.uk/page/s/declare-climate-emergency) - Now that Parliament has declared a Climate Emergency, we need you to act like it. For starters, that means banning all new oil and gas production in the UK, including fracking, tripling renewable energy by 2030, planting 700 million trees, introducing a Frequent Flyer Tax, ending the sale of all new petrol and diesel cars by 2030, and more.
- [US Damn Removal](https://www.change.org/t/dam-removal-en-us) - [70 percent of the dams in the United States](https://www.ussdams.org/our-news/americas-aging-dams-in-need-of-repair/) are now more than 50 years old, with almost 2,000 of them rated as "high-hazard". About [1,000 dams have failed](https://apnews.com/75b1cd657f3e4fa3be6adaf968eb7df4) over the past four decades, killing 34 people, and now many are no longer adequate to handle the intense rainfall and floods of a changing climate.
  With dams causing wild salmon populations to go extinct, their only benefit is hydropower, yet dams are woefully inefficient by modern standards. For example, the Tugalo Dam in Georgia destroyed 597 acres of temperate rainforest to produce 45 Megawatts, which is the equivalent of 7,500 homes adding 6kw rooftop solar panels. We should tear down these dams as soon as possible, be that when their contract runs out or sooner, instead of wasting tax-payer money operating them or trying to revive them. [More on Last Week Tonight](https://www.youtube.com/watch?v=Wpzvaqypav8).
- [Climate Reality](https://climaterealityproject.org) - an initiative of former United States vice president and 2007 Nobel Peace Prize laureate Al Gore to make urgent action a necessity to address climate change issues through activism and cutting greenhouse gas emissions.

## Reforestation

- [1 Click Impact](https://1clickimpact.com/) - 1ClickImpact is an easy-to-use and transparent platform to automatically plant trees through API or no-code integrations. Every tree is trackable in real time with maps, verified updates, and exclusive access to live planting sessions. It makes reforestation simple, measurable, and a visible part of your brand’s sustainability journey.
- [Arbor Day Foundation](https://www.arborday.org/) - The Arbor Day Foundation is a 501(c)(3) nonprofit conservation and education organization. A million members, donors, and partners support our programs to make our world greener and healthier.
- [Bunq Greencard](https://www.bunq.com/easygreen) - Dutch online-only bank with a credit card which plants trees for the money you spend.
- [Coforest](https://coforest.co.uk/) - To create our first co-forest in the Bath & Bristol area, we’re inviting organisations and individuals to adopt up to an acre of land. You’ll be able to name your forest plot and even help to plant it. Together, we’ll create a whole new forest.
- [DigitalHumani](https://digitalhumani.com) - DigitalHumani offers a Reforestation as a Service, to help enterprises plant trees! Run by a volunteer collective, they provide simple Application Programming Interfaces (APIs) to help connect websites and mobile applications to trusted reforestation organizations to have trees planted.
- [Dronecoria](http://dronecoria.org/) - Open-source drone reforestation technology. Drones, coupled with native coated seeds, can transform the efficiency with which we restore ecosystems.
- [EcoTree](https://ecotree.green/) - Support the European forests and reap the benefits. Plant trees as an original and meaningful gift. Building complex, resistant, and multifunctional forests to promote resilience. For every tree harvested, three new ones are planted.
- [Ecologi](https://ecologi.com/?r=5d01f2ed12ae7a358b75fdd7) - Help the planet from your sofa, for less than a cheap bottle of wine per month. Watch your own forest come to life and offset your entire footprint for $6.50/€6 per-month. Then get your friends, family, business, and even your dog signed up!
- [Eden Reforestation Projects](https://edenprojects.org/) - Eden Reforestation Projects reduces extreme poverty and restores healthy forests by employing local villagers to plant millions of trees every year.
- [Form Ghana](https://www.formghana.com/) - A forest plantation management company based in central Ghana that provides services in the field of reforestation of degraded Forest Reserves and plantation management.
- [Form International](https://www.forminternational.nl/) - Form International is a forest management and services company that manages forest assets in Africa and delivers a range of technical and financial services to clients worldwide.
- [Land Life Company](https://landlifecompany.com/) - Using drones and automated planting, they plant at scale in urban environments using a fraction of the water. Their mission is to reforest the world’s 2 billion hectares of degraded land.
- [MyClimate](https://myclimate.org/) - Helping reduce emissions through a whole bunch of different projects, from consulting companies on their footprint (and helping them to reduce), to education at schools, forest restoration, providing people in Rwanda with efficient cook stoves, and [a whole bunch more](https://www.myclimate.org/information/climate-protection-projects/). Fund them via donations, and use their flight/car/house/company footprint calculators.
- [Reforestum](https://reforestum.com/) - Reforestum is an online marketplace to drive reforestation and forest conservation, incentivizing companies and individuals to easily offset their carbon footprint by acquiring and tracking forest shares and carbon credits. Reforestum offers transparency via remote sensing and AI, together with a comprehensible API for seamless integration.
- [Team Trees](https://teamtrees.org/) - TeamTrees started in May 2019 when the internet challenged [Mr. Beast](https://twitter.com/MrBeastYT) to plant 20 million trees to commemorate hitting the 20M subscriber milestone. Fans then suggested he band together with a bunch of other YouTubers and influencers to make it happen.
- [Tree-Nation](https://tree-nation.com/) - With Tree-Nation you can plant trees everywhere, even in the most remote locations. You will know who is planting your trees, where they are located and how they are being planted.
- [TreeCard](https://www.treecard.org/) - TreeCard - The wooden debit card that plants trees.
- [Treedom](https://www.treedom.net/) - Treedom lets you buy or gift a real tree, where somebody will plant it for you and follow it online.
- [Trees for the Future](https://trees.org/) - TREES plants all sorts of trees and plants, and nearly all of the trees used are either native or naturalized in the environments where they are planted. They partner with farmers to understand their needs and match them with species that will suit their needs and be environmentally benign.
- [Treeware](https://treeware.earth) - Loads of open-source developers have a "Buy me a coffee" button on their software. Now you can have "Buy me a tree!" on your GitHub repository. Get the same "Yay somebody cares about my work" AND lessen the existential dread all in one. Powered by [Offset Earth](https://offset.earth/).
- [WeForest](https://www.weforest.org/) - WeForest empowers communities to advance and implement innovative, high standard, scalable and lasting solutions to restore forest landscapes.

## Renewable Energy

- [Big Clean Switch](https://bigcleanswitch.org/) - Do energy differently. Switch in minutes to a green electricity tariff from one of the UK's leading suppliers.
- [Community Power](https://communitypower.ie/) - Ireland's first community owned electricity supplier which collaborates with Local Sustainable Energy Communities! Whether you are a household, community, business, public or private building, you can switch and buy your electricity from Community Power.
- [Domestic Renewable Heat Incentive (RHI)](https://www.gov.uk/domestic-renewable-heat-incentive) - You could get money towards renewable heating costs in your home. You can claim for biomass boilers, solar water heating, heat pumps. Payments are made for 7 years and are based on the amount of renewable heat made by your heating system.
- [Ecotricity](https://www.ecotricity.co.uk/) - 100% green electricity. They generate 1/5th from their fleet of windmills and sunmills, and buy the rest from other green generators. They also turn our customers’ bills into new sources of green energy, making more green electricity all the time.
- [Electricity Map](https://www.electricitymap.org/) - A map showing the energy consumption, renewable penetration and carbon emissions from energy for many countries around the world. If you're country isn't covered you can contribute a data source.
- [Good Energy](https://www.goodenergy.co.uk/) - One of the few energy suppliers in the UK to generate renewable power from their own wind and solar farms, and buy renewable power from small independent renewable generators. From local farmers and community energy schemes to sustainable businesses that generate their own power and sell them the excess. A true renewable supplier, not just coal power + offset credits.
- [Green-E](https://www.green-e.org/) - Find a renewable energy provider near you. Green-e certified renewable energy and carbon offset products meet the most stringent environmental and consumer protection standards in North America. You can search below for certified green power and renewable energy certificate programs for your home or business, and carbon offset products to offset your emissions from activities like driving and flying. As a third-party certifier, Green-e® doesn't sell renewable energy or offsets, but offers these links to retailers that do.
- [Non-domestic Renewable Heat Incentive (RHI)](https://www.gov.uk/non-domestic-renewable-heat-incentive) - The non-domestic Renewable Heat Incentive helps businesses, public sector and non-profit organisations meet the cost of installing renewable heat technologies.
- [Project Sunroof](https://www.google.com/get/sunroof) - Find out if you could save money switching to solar panels. This Google project uses Google Earth imagery to analyze your roof shape and local weather patterns to create a personalized solar plan. Adjust your electric bill to fine-tune your savings estimate and the recommended number of solar panels for your home, then compare loan, lease, and purchase options for your solar panels based on your results.
- [SparkMeter](http://www.sparkmeter.io/) - Humanitarian smart energy metering solution that purchases wasted unused electricity from utilities and resells it to hard-to-reach places and under served markets, thus reducing overall energy consumption.
- [UK Carbon Intensity](https://carbonintensity.org.uk/) - This officially backed open API from Oxford University and the National Grid ESO gives a snapshot of how much carbon each unit of electricity consumed in the UK emits for every half hour. Also carries forecasts, regional breakdowns with some great charts and re-useable widgets. They also have [an app](https://www.cs.ox.ac.uk/people/alex.rogers/gridcarbon/).

## Transportation

- [Biking vs. Driving Calculator](https://bicycleuniverse.com/car-free-millionaire/) - Riding your bike can make you a millionaire! You're paying more for your car than you think. A typical American who goes car-free for 35 years can save nearly a million dollars, even adjusted for inflation, and even if they pay for taxi, bus, and car-share trips often. Use the calculator to find how much you can save in your particular situation.
- [Change How You Travel from Climate Choice](https://climatechoice.co/change-how-you-travel) - 26% of the greenhouse gases emitted into our atmosphere are from the production and use of vehicles and airplanes. See what what you can do now, and learn about the benefits of changing your travel.
- [Commute on Electric Bicycles](https://ebiketips.road.cc/content/advice/buyers-guide/9-of-the-best-e-bikes-under-1000-2020-electric-bikes-on-a-budget-2209) - Like the idea of cycling but feel like it's a bit far, bit hilly, or no access to a shower at the other end? E-bikes aren't just for the older riders, they've pushed into the mainstream culturally and financially, and are a hell of a lot of fun. Combine it with local "cycle to work schemes" listed here for extra savings, some places do [specific deals on e-bikes](https://urbanebikes.com/pages/cycle-to-work-scheme-electric).
- [Commute on Electric Motorbikes](https://urbanebikes.com/collections/electric-motorbikes) - Electric cars are still priced beyond the reach of many, but swapping a car for an electric motorbike will leave plenty of cash in your pocket. The average used car sells for $20,840 in the USA, and you can get a lot of electric motorbike for $3,000. Finding a used electric motorbike will get that manufacturing footprint off your conscience too.
- [DHL GoGreen](https://www.dpdhl.com/en/responsibility/environment-and-solutions.html) - GoGreen Solutions include both standardized products and customized solutions to help customers develop their own eco-friendly business models and green supply chains. With our carbon reports, climate neutral products, and green optimization, we give customers transparency, offset unavoidable emissions, and identify ways in which our customers can reduce emissions and waste. These optimization measures achieve savings potential that most companies would not be able to achieve on their own.
- [Pod Point](https://pod-point.com) - UK leaders in electric vehicle charging with innovative solutions for homes, workplaces and commercial organizations.
- [Poparide](https://www.poparide.com/) - Get a ride or fill a seat for rideshares between cities in Canada. Having 3 people in the car can be more efficient than some of their big-ass trains and is 1/5th the impact of flying.
- [Share Now](https://www.share-now.com/) - With car-sharing, you don't have to buy or lease a car. Share Now cars are available around every street corner in loads of cities around the world. Find us in 16 major cities in 8 countries in Europe and all over the US – for all your plans, big and small. Includes free parking, no need to pay for maintenance, insurance, or petrol, and loads of them are electric too! Package deals available for businesses to help employees ditch their car when active/public transportation is not an option.
- [TomTom's EV Station Finder](https://www.tomtom.com/products/ev-charging-availability-routing-services/) - With TomTom's EV charging infrastructure, 'eco-routing' to calculate energy efficient routes (!), in-range EV station finder, real-time availability monitoring, on-demand information, TomTom is continuing to invest in the largest electric vehicle map coverage with 330,000+ charging points in 50 countries throughout Europe, The Americas, the Middle East, and Asia.
- [VanMoof](https://www.vanmoof.com/) - "City-proof" bikes, with electric assist, which ship fully assembled. They're baked full of anti-theft tech, and they'll hunt your bike down if it does get stolen. In some countries there is a subscription service where they'll fix things up for you if you have any trouble, but just the base bike alone is a stunning beautiful electric bike with dynamo hubs, built in lights, and sturdy mudguards, so you can ride it all day and night.
- [Waze Carpool](https://www.waze.com/carpool) - Choose to drive or ride, and match with people based on route and time of day.
- [Workhorse - Electric Delivery Vehicles](https://workhorse.com/) - All-electric by design, with composite technology, and a 100-mile range, it's expected to be more economical than traditional delivery vans. Our current delivery vans, E-100 and E-GEN, have more than 4 million miles on them and are used by some of the premier package delivery companies in the world.

## Travel

- [Change How You Travel from Climate Choice](https://climatechoice.co/change-how-you-travel) - 26% of the greenhouse gases emitted into our atmosphere are from the production and use of vehicles and airplanes. See what what you can do now, and learn about the benefits of changing your travel.
- [EcoBnB](https://ecobnb.com/) - Find accommodation for a trip with a focus on sustainability. Most locations get their electricity from renewable sources, you wont find loads of single-use plastics, they recycle more than 80% of their waste, etc.
- [Flight Free (UK)](https://flightfree.co.uk/) - Aviation is the fastest growing contributor to greenhouse gas emissions at a time when we desperately need to reduce them. Pledge to go flight free in 2020.
- [Flight Free (USA)](https://flightfreeusa.org/) - A grassroots campaign which asks people to agree not to fly in the year of 2020 – on condition that 100,000 others will also pledge to do the same.
- [Green Tickets](https://greentickets.app/) - Traveling is amazing, right? We completely agree! But you probably know that traveling can have a large climate impact. With Green Tickets you can take responsibility of your travel behaviour and reduce your footprint, while still enjoying everything that traveling has to offer.
- [Home Exchange](https://www.homeexchange.com/) - Swap homes with another family instead of spending money at a fancy hotel, as hotels have a much higher footprint due to the constant cleaning, overactive AC, etc.
- [Poparide](https://www.poparide.com/) - Get a ride or fill a seat for rideshares between cities in Canada. Having 3 people in the car can be more efficient than some of their big-ass trains and is 1/5th the impact of flying.
- [Restons Les Pieds Sur Terre](https://www.facebook.com/restonslespiedssurterre/) - Aviation is the fastest growing contributor to greenhouse gas emissions at a time when we desperately need to reduce them. Pledge to go flight free in 2020.
- [Seat61](https://www.seat61.com/) - Train travel is a more rewarding, low-stress alternative to flying, which brings us closer to the countries we visit and reduces our contribution to climate change. It's time to rediscover the pleasure, romance & adventure of travel by train or ship. This site explains how to travel comfortably & affordably by train or ferry where you might think air was now the only option. For help with train travel, ask the Man in Seat 61!
- [Slow Travel (Langsamreisen)](https://www.langsamreisen.de/) - A travel company all about sustainable and conscious travel. Piggy back on a cargo ship to get to that new job on the other side of the world. Sailing trips to get around without a footprint. Maybe take the trans-siberian railway.
- [Snow Carbon](http://snowcarbon.co.uk/) - Wish you could avoid airport queues, tedious transfers and long drives? Want to travel sustainably and enjoyably by train instead - to fantastic accommodation in the best ski resorts in the Alps? Snowcarbon is an independent guide founded by ski journalist Daniel Elkan to help you do exactly that.
- [Stay Grounded](https://stay-grounded.org/) - A global network of more than 150 member organisations, among them local airport opposition and climate justice groups, NGOs, trade unions, initiatives fostering alternatives to aviation like night trains, and organisations supporting communities which struggle against offset projects or biofuel plantations
- [The Travel Foundation](https://www.thetravelfoundation.org.uk/) - Find hotels here which aren't all plastic all the time, amongst other things. This charity brings together travel businesses, suppliers, community groups, governments, local authorities and more to develop practical solutions which maximise the benefits and minimise the negative impacts of tourism in destinations.

## Volunteering

- [Citizens Climate Lobby](https://citizensclimatelobby.org/) - If you’re an English, economics or poly sci major, you probably should consider volunteering for Citizens’ Climate Lobby, an organization focused on confronting climate change through policy.
- [Clean Trails](https://www.cleantrails.org/join) - Step by step, and little by little, our aim is to eliminate waste on all the trails that grace our public lands. We believe we can do that in a positive and proactive manner by educating, encouraging, and reconnecting outdoor users to our pristine places.
- [ClimateAction.Tech](https://climateaction.tech/) - A global community of tech professionals using our skills, expertise and platforms to support solutions to the climate crisis. The mission is to empower technology professionals to play our part — to meet, discuss, learn and take climate action.
- [ClimatePrediction.net](https://www.climateprediction.net/) - The world’s largest climate modelling experiment. Evidence of how our climate is changing is vital to reducing greenhouse gas emissions. Help discover how the climate could look by running software on your computer.
- [Earth Hero Climate Action App](https://www.earthhero.org/get-involved/) - Join the volunteer team behind the free climate action app that makes it easy for people to act on climate change. Made up of developers, designers, researchers, writers, marketers, translators, and project managers from around the world.
- [Economists for Future](https://econ4future.org/) - Economists for Future growing movement of people committed to galvanising the economics community behind addressing the greatest challenge of our day. If the discipline which dedicates itself to studying the economy cannot sufficiently engage in the economic transformation that the climate science requires, then who else can be expected to do this?
- [Extinction Rebellion](https://rebellion.global/) - Extinction Rebellion is a decentralised, international and politically non-partisan movement using non-violent direct action and civil disobedience to persuade governments to act justly on the Climate and Ecological Emergency.
- [Eyes of the Reef Hawai'i](https://eorhawaii.org/2013/07/18/become-a-member/) - Network to inform, engage and train people to identify coral bleaching, disease and invasive species outbreaks. They have a broad outreach program that helps to provide critical training for rapid response monitoring and stewardship of precious marine resources.
- [Greenpeace](https://engage.us.greenpeace.org/onlineactions/Hx3BaZLxxkyUUo2Jfzsk7w2) - Greenpeace has many ways for people to get involved. Start small by launching and participating in campaigns and petitions, or go further and discover or create events. Play an active role in achieving a green and peaceful future!
- [Habitat for Humanity](http://www.habitat.org/getinv) - Habitat for Humanity is well known for building simple, affordable homes for people in need. But recently the organization has implemented new programs recognizing climate change as a major threat to the environment and which can destroy the homes they build.
- [MakeSense Jobs](https://jobs.makesense.org) - Makesense inspires and empowers citizens, entrepreneurs and organizations to build an inclusive and sustainable society together. MakeSense's Job and assignment announcements platform for associations and social entrepreneurs who recruit profiles passionate about the impact. Job types include internship, freelance, civic service, partner, program, volunteer mission, mentoring.
- [Oceanic Society](https://www.oceanicsociety.org/) - Oceanic Society was founded in 1969 by a group of San Francisco Bay Area sailors and scientists who were concerned about the state of the oceans and decided to take action. Inspired by the events of their day—like the Santa Barbara oil spill of 1969, the publication of Rachel Carson's Silent Spring, and growing public concern for the environment—they came together to form Oceanic Society, the first non-profit organization in America dedicated to marine conservation. Their aim was to bring greater public awareness and political action to issues of ocean health and to grow the global community of people working toward improved ocean stewardship. Oceanic Society helped put ocean conservation on the public radar. Some of our many accomplishments include: Creating the Oceanic Society Patrol and Farallon Patrol, pioneering ecotourism and volunteer vacations, inspiring a generation of ocean lovers through Oceans magazine, Leading the way in whale watching, strengthening local sea turtle conservation, globally and innovating a focus on behavior change.
- [Precious Plastic](https://preciousplastic.com/) - Open-source community who share instructions for creating plastic shredders, injectors, and sheet presses, so you can create anything you want from used plastic. Collect plastic from neighbors, clean it, shred it, [3D print a mold](https://pinshape.com/blog/low-cost-injection-molding-using-3d-printing/), and create anything you can imagine! You can [buy the machines](https://preciousplastic.com/solutions/machines/overview.html) too if making them is out of your wheelhouse.
- [Take Climate Action](https://takeclimateaction.uk/) - Climate Action groups are made up of people like you and together they’ll bring about big systemic change. Join the network and kick-start climate action in your community.
- [Tell Microsoft to End Big Oil Contracts](https://engage.us.greenpeace.org/onlineactions/Hx3BaZLxxkyUUo2Jfzsk7w2) - Right now, while our planet speeds toward the brink of the climate crisis, Microsoft is putting its foot on the accelerator. As oil and gas profits continue to fall, giant oil corporations have turned to cloud computing and artificial intelligence (AI) to answer their problems. Microsoft promises companies like ExxonMobil that its analytical tools and other AI technologies will help them discover and pump even more oil at a lower cost. This Greenpeace petition will let Microsoft know this is not acceptable.
- [Transition Network](https://transitionnetwork.org) - A global movement of communities coming together to reimagine and actively rebuild our world. The terms transition town, transition initiative and transition model refer to grassroot community projects that aim to increase self-sufficiency to reduce the potential effects of peak oil, climate destruction, and economic instability.
- [Tree Folks](https://www.treefolks.org/volunteer/) - Tree planting and tree care events around Austin, Texas, from October to April.
- [World Cleanup Day](https://www.worldcleanupday.org/) - World Cleanup Day is a civic movement, uniting 180 countries and millions of people across the world to clean up the planet. In one day. Volunteers and partners worldwide come together to rid our planet of trash – cleaning up litter and mismanaged waste from our beaches, rivers, forests, and streets.

## Waste

- [Algramo](https://www.algramoalmacenes.com/) - Vending machines and mobile refill units for refilling reusable plastic bottles with staple goods from shampoo to salad dressing in packaging that is designed to be returned, cleaned, and reused. With over 2,000 bodegas in Santiago and plans to expand in the US soon, Algramo, translates to "by the gram", also solves the issue of "poverty tax" where small packages can cost as much as 50% more than the same product in a larger size.
- [Bio Bean](https://www.bio-bean.com/) - The world’s largest recycler of coffee grounds, Bio Bean recycle spent coffee grounds into sustainable products, like coffee logs for fires, and other biomass fuel.
- [Bio-plastic Trash Bags](https://www.amazon.com/Plant-Based-Kitchen-Handles-Gallon/dp/B071JMFKM5/) - Made from Plant Based (sugar cane) materials instead of fossil fuel.
- [Blue Jeans Go Green](https://bluejeansgogreen.org/) - Send in your used jeans to get transformed into natural cotton fiber insulation, some of which is used to help with building efforts around the country.
- [Boulder Food Rescue](https://www.boulderfoodrescue.org/) - We facilitate the sustainable redistribution of healthy food that would otherwise be wasted to low-income communities, by bicycle. We work with communities to facilitate their own food redistribution and create decentralized systems to bypass barriers to food access. Our work envisions a world in which everyone has equitable access to healthy food.
- [Burying Food Scraps](https://www.youtube.com/watch?v=yQFB9M2UdK0) - Composting can be time consuming, expensive, and if done incorrectly it can actually produce a lot of methane. If you've got a bit of space in your garden, this video shows how simply burying food scraps can be a quick and simple solution to get rid of waste and improve soil quality too.
- [Circular Berlin](http://circular.berlin/) - A Berlin based non-profit developing the local circular economy agenda through research, community-building and practical programmes. Good overview of events and initiatives happening in Berlin.
- [City Harvest](https://www.cityharvest.org/) - City Harvest is New York City’s largest food rescue organization. They rescue food and deliver it to hundreds of food pantries, soup kitchens and other community partners.
- [Donate Toys](https://www.moneycrashers.com/where-donate-used-toys/) - Donate toys that your children have grown out of instead of throwing them away.
- [EU: Right to Repair](https://repair.eu/) - Cracked screens, weak batteries, broken charging ports... We’d like to fix them, but instead we end up buying a new smartphone because repairs are too expensive, difficult or impossible. Reducing the lifespan of a product may drive sales, but this comes at the expense of consumers, workers and the planet. Ask the European Union to give people the Right to Repair by requiring manufacturers to design repairable smartphones and provide spare parts and repair information to all repairers and consumers.
- [Food Cloud](https://food.cloud/) - FoodCloud is a social enterprise that connects businesses with surplus food to charities in their local communities that need it via a software platform.
- [Geev](https://corporate.geev.com/) - An online application to exchange stuffs and food between people. Easily discuss, meet and give a second life to objects and food. The more you give the more people trust you when you want to get something.
- [GrowNYC Food Scrap Collection Schedule](https://www.grownyc.org/compost/locations) - Interactive map with over 150 residential Food Scrap Drop-Off sites in NYC.
- [Karma](https://new.karma.life/) - A Swedish company that lets restaurants sell surplus food at a lower price. It lets you pay less for food and prevent food waste.
- [Litterati](https://www.litterati.org/) - Empowering people to clean the planet. Photograph a piece of litter, tag it, and discard properly. Participate in a challenge and hold wasteful brands accountable.
- [Too Good To Go](https://toogoodtogo.com/) - toogoodtogo maps products that reach the best before date and shows where and how much you can save. Download the app, select a provider near you and start saving today.
- [Olio](https://olioex.com/) - We connect neighbors to share food, and other things, rather than chuck them away.
- [Open Circularity](https://opencircularity.info/) - Lars Zimmermann runs Mifactori Design & Activism Studio in Berlin. This website is where he shares content & thoughts on Open Source Circularity. General idea is - open source all products, allowing them to be repaired or repurposed if they break rather than ending up in landfill.
- [OpenStreetMap: Zero Waste (Overpass)](http://overpass-turbo.eu/?template=key&key=zero_waste) - OpenStreetMap has the tag zero_waste=\* for shops who sell items without packaging.
- [Original Unverpackt](https://original-unverpackt.de/) - Zero packaging supermarket in Berlin. Original Unverpackt hat sich als erster Supermarkt weltweit dem Zero-Waste-Lifestyle gewidmet.
- [Pieter Pot](https://www.pieter-pot.nl/) - Your groceries, delivered without packaging. Pieter Pot delivers your groceries with a cargo bike in beautiful glass jars in The Netherlands. Empty pot? Then we fill it again. This is how we make it fun and easy to do shopping without all those unnecessary (plastic) packaging. That's nice, right?
- [Precious Plastic](https://preciousplastic.com/) - Open-source community who share instructions for creating plastic shredders, injectors, and sheet presses, so you can create anything you want from used plastic. Collect plastic from neighbors, clean it, shred it, [3D print a mold](https://pinshape.com/blog/low-cost-injection-molding-using-3d-printing/), and create anything you can imagine! You can [buy the machines](https://preciousplastic.com/solutions/machines/overview.html) too if making them is out of your wheelhouse.
- [Recycle Now](https://www.recyclenow.com/) - Find out where to recycle pretty much anything, including aerosols, old mobile phones, soft plastics, and get advice on how to reduce waste too.
- [ReNu Furniture](https://renufurniture.co.uk/) - Prevent landfill waste and buy second-hand, upcycled and handmade furniture easily with ReNu Furniture. Based in Brighton and covering the UK southeast, this start up will manage the collection, delivery and payments for every furniture sale - they even plant a tree for every delivery to offset carbon emissions.
- [Repair Café](https://repaircafe.org/) - Repair Cafés are free meeting places and they’re all about repairing things (together). You’ll find tools and materials to help you make any repairs to clothes, furniture, electrical appliances, bicycles, crockery, appliances, toys, et cetera. You’ll also find expert volunteers, with repair skills in all kinds of fields. Repair your stuff, or just enjoy a coffee. They're world-wide, and the site is multi-lingual.
- [Sonny](https://www.indiegogo.com/projects/sonny-a-portable-bidet-for-eco-conscious-humans/x/17318484#/) - Never worry about running out of toilet paper again with Sonny, a sustainable alternative to wipes and paper for better hygiene and a greener planet.
- [The Rotten Fruit Box](https://therottenfruitbox.com/) - 100% Natural Freeze-Dried Fruit Snacks from Spain and Portugal shipped to you. The fruit you’re enjoying would have otherwise gone unused and rotted away on the ground. We also think that the name "Rotten" helps bring attention to the serious issue of food waste. Delicious, healthy, 100% natural, with a long shelf life, our freeze dried fruit snack pouches are ideal for home, work, office, to take to school, camping or just about anywhere. Help reduce food waste. Help small local farmers. 100% compostable packaging, ships with your local postal service because it is the lowest carbon footprint option.
- [Too Good To Go](https://toogoodtogo.co.uk/) - Sell your surplus food, easily and sustainably! Save delicious food and fight food waste. Find your favorite food and go rescue it.
- [Vegware](https://vegware.co.uk/) - Napkins, carrier bags, salad boxes, sushi trays, cutlery, disposable coffee cups, all made from plants using renewable, lower carbon, recycled or reclaimed materials, and designed to be commercially compostable with food waste, where accepted.

## YouTube Channels

- [Climate Town](https://www.youtube.com/channel/UCuVLG9pThvBABcYCm7pkNkA) - Rollie Williams and a ragtag team of climate communicators, creatives and comedians are here to examine climate change in a way that doesn’t make you want to eat a cyanide pill.
- [ClimateAdam](https://www.youtube.com/user/ClimateAdam) - Doctor in climate science from Oxford. Trying to make sense of climate change with fun YouTube vids.
- [Hot Mess](https://www.youtube.com/channel/UCsaEBhRsI6tmmz12fkSEYdw) - A show about how climate change impacts all of us, and about how we can create a better future for our planet and ourselves. Hosted by Miriam Nielsen, Talia Buford, and Joe Hanson.
- [Our Changing Climate](https://www.youtube.com/channel/UCNXvxXpDJXp-mZu3pFMzYHQ) - A bi-weekly video essay series that investigates humanity's relationship to the natural world.
- [Simon Clark](https://www.youtube.com/user/SimonOxfPhys) - PhD in climate physics by day, YouTuber by night. He makes videos about both!

## Zero Waste

- [Kent Zero Water Wastage Technology](https://www.kent.co.in/water-purifiers/zero-water-wastage-technology) - KENT RO Purifiers equipped with the ‘Zero Water Wastage’ Technology push back the rejected water to the overhead tank, thereby rendering wastage to zero. As a result, instead of wasting the rejected water, it gets diluted and reused as normal tap water for household purposes.

<!-- links:end -->

## Contributing

Please send us a PR because all this data is powered by contributions. We're trying to learn about projects from all over the world, so wherever you're from and whatever language you want to write the descriptions in, please send a PR to this file!

## License

The list in this README under [CCO](https://creativecommons.org/publicdomain/zero/1.0/)
but the remaining source code is [MIT](https://choosealicense.com/licenses/mit/).
