export const links = [
  {
    "name": "Carbon Reduction",
    "links": [
      {
        "name": "1% for the Planet",
        "url": "https://www.onepercentfortheplanet.org/",
        "description": "A membership program for businesses and individuals, allowing them to donate 1% of their gross yearly profits or salary back to environmental nonprofits to create a healthier planet."
      },
      {
        "name": "Beam",
        "url": "https://www.beamproject.co/",
        "description": "Make small automatic donations while you shop online, to support the cleantech startups trying to change the world. Clean Tech investment money has dried up over the years, so crowdsourcing is becoming the only option for many, and with a Chrome extension you can chuck in a dollar when you're buying other stuff."
      },
      {
        "name": "Better Future Faster",
        "url": "https://betterfuturefaster.org/",
        "description": "Breaks the climate problem into 4 pillars, lays out explicit actions required for each and allows businesses and policy makers to commit to these actions."
      },
      {
        "name": "Brighter Planet CM1",
        "url": "http://impact.brighterplanet.com/",
        "description": "Brighter Planet offers a free, simple API allowing you to calculate the carbon generated by almost any activity - transport, energy, shopping and more."
      },
      {
        "name": "Carbon Pricing Dashboard",
        "url": "https://carbonpricingdashboard.worldbank.org/",
        "description": "Maps and statistics on regional, national, and subnational carbon pricing initiatives."
      },
      {
        "name": "Climate Action Tracker",
        "url": "https://climateactiontracker.org/countries/",
        "description": "See which countries are on track for the Paris Agreement or similar, and which countries are failing horribly. Hint: it's everyone but Morocco and The Gambia."
      },
      {
        "name": "ClimateWorks",
        "url": "https://www.climateworks.org/",
        "description": "An NGO partnering with philanthropists to tackle the climate crisis. They seek to ensure investments have the maximum impact."
      },
      {
        "name": "Climworks",
        "url": "http://climeworkspioneers.refr.cc/philsturgeon",
        "description": "Climeworks Direct Air Capture technology captures CO₂ from air, mixes the CO₂ with water used by a geothermal energy plant, then pumps it deep underground. Through natural processes, the CO₂ reacts with the basaltic rock – and turns into stone within a few years, permanently and safely. Iceland is one of several locations around the world that provide ideal conditions for our pioneering process. Subscribe monthly to offset a little bit of your footprint, and support the growth of this early stage technology."
      },
      {
        "name": "Cool Earth",
        "url": "https://www.coolearth.org/",
        "description": "This charity was created to tackle climate change by reducing carbon emissions from rainforest loss."
      },
      {
        "name": "Ecologi",
        "url": "https://ecologi.com/?r=5d01f2ed12ae7a358b75fdd7",
        "description": "Help the planet from your sofa, for less than a cheap bottle of wine per month. Watch your own forest come to life and offset your entire footprint for $6.50/€6 per-month. Then get your friends, family, business, and even your dog signed up!"
      },
      {
        "name": "Ecosia",
        "url": "https://www.ecosia.org",
        "description": "The search engine that plants trees. >50% of the ad revenue goes directly to planting trees."
      },
      {
        "name": "Flight Free (UK)",
        "url": "https://flightfree.co.uk/",
        "description": "Aviation is the fastest growing contributor to greenhouse gas emissions at a time when we desperately need to reduce them. Pledge to go flight free in 2020."
      },
      {
        "name": "Flight Free (USA)",
        "url": "https://flightfreeusa.org/",
        "description": "A grassroots campaign which asks people to agree not to fly in the year of 2020 – on condition that 100,000 others will also pledge to do the same."
      },
      {
        "name": "Future Earth",
        "url": "https://futureearth.org/",
        "description": "Future Earth is a global research programme designed to provide the knowledge needed to support transformations towards sustainability. They focus on systems-based approaches, seeking to deepen the understanding of complex Earth systems and human dynamics across different disciplines."
      },
      {
        "name": "Giki",
        "url": "https://gikibadges.com/",
        "description": "The Giki app provides accessible, independent, transparent information to help people change habits to live more sustainably. Our 14 badges cover sustainability, health and fairness."
      },
      {
        "name": "Gold Standard",
        "url": "https://www.goldstandard.org/take-action/offset-your-emissions",
        "description": "Offset carbon emissions by purchasing verified carbon credits from a variety of certified, environmentally friendly projects."
      },
      {
        "name": "Google Cloud Computing",
        "url": "https://cloud.google.com/sustainability/",
        "description": "Google are a long way from perfect, but Google Cloud advertises 100% renewable energy. They don't _just_ offset, they actually reduce the electricity usage too, and \"strive to build the world’s most energy-efficient computing network by squeezing more out of every watt of power we consume.\" Their main rival, Amazon AWS, does not do that, and actively hosts oil and gas companies, who use the platform to find more places to dig. Switching to Google Cloud (or a host who in turn is on Google Cloud), is one of many ways to make your platform have less impact on the earth."
      },
      {
        "name": "Green-E Carbon Offsets",
        "url": "https://www.green-e.org/certified-resources/carbon-offsets",
        "description": "Green-e Climate is an excellent resource for carbon offsets. The organization holds retailers accountable by monitoring how offsets are transacted and advertised in the retail market, protecting both the buyer and the seller."
      },
      {
        "name": "GreenMovi",
        "url": "https://www.greenmovi.com.br",
        "description": "Earn discount coupons anytime, just download the app available for Android and iOS platforms, register, and use it every time you use a non-polluting means of transport and be rewarded with Carb Points."
      },
      {
        "name": "Mijn Impact",
        "url": "https://www.mijnimpact.app/",
        "description": "Discover the effect of your choices. The app that provides easy insight into the CO2 impact of your purchases - and challenges you to reduce your impact with personal goals."
      },
      {
        "name": "No Meat Today",
        "url": "https://nomeat.today/",
        "description": "Your companion to eat less meat. It's good for you and the planet, but let's be honest, eating less meat is hard. Don't do it alone!"
      },
      {
        "name": "Patch",
        "url": "https://www.usepatch.com",
        "description": "Patch is the API for negative emissions. Developers can use Patch's API to make any transaction carbon neutral with a wide range of negative emission methods (e.g. direct air carbon capture, bio-oil geosequestration, enhanced weathering, reforestation and more)."
      },
      {
        "name": "Possible",
        "url": "https://www.wearepossible.org/",
        "description": "Combining individual and local actions with larger systemic change, we face our climate dread with a can-do attitude and sense of fun. Possible are tackling the climate crisis by inspiring people to act in 5 key areas - eat & buy, travel, energy, nature and talking."
      },
      {
        "name": "Project Wren",
        "url": "https://projectwren.com/",
        "description": "Project Wren are a startup offering a web based, monthly subscription model for offsetting emissions. They also allow for offsetting of flights."
      },
      {
        "name": "Restons Les Pieds Sur Terre",
        "url": "https://www.facebook.com/restonslespiedssurterre/",
        "description": "Aviation is the fastest growing contributor to greenhouse gas emissions at a time when we desperately need to reduce them. Pledge to go flight free in 2020."
      },
      {
        "name": "The National Grid ESO",
        "url": "https://www.nationalgrideso.com/news/introducing-our-carbon-intensity-app",
        "description": "Monitor the generation types that make up your electricity supply and see when the cleanest time to use electricity will be. See the carbon impact level of electricity generation, how your region compares to others in the UK and be notified when a record towards decarbonisation breaks."
      },
      {
        "name": "Trine - Solar Crowd-investing",
        "url": "https://www.trine.com/",
        "description": "Invest in solar projects bringing clean energy to emerging markets. Local solar partners will distribute and manage the solar products on the ground. If the loan is successful you will receive your investment and interest in return."
      },
      {
        "name": "We Mean Business",
        "url": "https://www.wemeanbusinesscoalition.org/",
        "description": "A coalition aiming to catalyze business action and driving policy ambition to accelerate the zero-carbon transition."
      },
      {
        "name": "Tradewater",
        "url": "https://tradewater.us/",
        "description": "Finds and destroys the most potent greenhouse gases before they are released into the atmosphere. These are old refrigerants that would leak into the atmosphere unless collected and destroyed. Work is funded by selling Carbon Offsets. You can subscribe to offset your carbon emissions."
      }
    ]
  },
  {
    "name": "Clothing",
    "links": [
      {
        "name": "4ocean",
        "url": "https://www.4ocean.com/",
        "description": "Oeko-tex certificated, cruelty free customizable linen clothing brand. All of the packaging are plastic free."
      },
      {
        "name": "Adidas Parley",
        "url": "https://adidas.com/parley",
        "description": "Shoes, apparel and accessories made from upcycled marine plastic waste. Every piece in the collection is made of at least 75% intercepted plastic trash."
      },
      {
        "name": "Allbirds",
        "url": "https://www.allbirds.com/",
        "description": "Our shoes are made with merino wool, tencel made from rainfall-fed FSC-certified eucalyptus forests, recycled plastic bottles (for laces), 'Sweetfoam' soles made from castor bean oil and [ProForest](https://proforest.net/en)-protected sugarcane. At 7.6 kg per pair for our wool runners, our process uses 60% less energy than materials used in typical synthetic shoes. We offset the rest, making Allbirds a carbon-neutral business."
      },
      {
        "name": "Alternative Apparel",
        "url": "https://www.alternativeapparel.com/",
        "description": "Low impact dyes, and post-consumer recycled polyester are used with Fair Labor Association guidelines."
      },
      {
        "name": "Arvin  Goods",
        "url": "https://www.arvingoods.com/",
        "description": "Brand that makes fashionable socks through a sustainable supply chain process they have developed. They have removed excess water from their manufacturing process - leaving more water left for communities to drink!"
      },
      {
        "name": "Bam - Bamboo Clothing",
        "url": "https://bambooclothing.co.uk/",
        "description": "Bamboo clothing company that are entirely dedicated to sustainability beyond purely carbon emissions, they're aiming for zero chemical pollution, zero waste to landfill, zero deforestation in their suppliers (and their suppliers, and _their_ suppliers...) and zero water wasted. They've got active wear, casual wear, underwear, gift cards for birthdays, the whole thing."
      },
      {
        "name": "Boody Eco Wear Essentials",
        "url": "https://boody.co.uk",
        "description": "Everyday essentials made from hypoallergenic and breathable FSC-certified bamboo viscose yarn, OEKO-TEX 100 certified organic by Ecocert."
      },
      {
        "name": "Cariuma",
        "url": "https://cariuma.com/",
        "description": "Old-School sneakers, new school ethics. Cariuma's sneakers are handcrafted with premium natural materials, an obsessive eye for detail, and a conscious mind. They care deeply about our craftsmen, and ensure that they earn fair wages and experience safe working conditions.  Some of their shoes are carbon _negative_, and they are committed to carbon-neutral shipping processes, which they do by purchasing carbon offsets for each shipment."
      },
      {
        "name": "Dabchy",
        "url": "https://www.dabchy.com/",
        "description": "Tunisian second hand clothes marketplace."
      },
      {
        "name": "For Days",
        "url": "https://www.fordays.com/",
        "description": "Subscription service that provides clothing with a zero-waste approach. When you sign up you purchase a membership and receive an organic cotton shirt - each time you want to purchase another article you send them back any old item to swap them out."
      },
      {
        "name": "Knowledge Cotton Apparel",
        "url": "https://knowledgecottonapparel.com",
        "description": "Clothing made from certified organic cotton, recycled PET, linen, wool, tencel, and recycled nylon sent via certified carbon neutral shipping in recyclable packaging."
      },
      {
        "name": "Kushel",
        "url": "https://www.kushel.de",
        "description": "Our bathrobes and towels are made from reforested beech wood and organic cotton, made in Portugal. Sourced from FSC-certified reforested forestry operations in Europe without irrigation. This mix needs 90% less water and emits 44% less CO2. By planting 2 trees for each towel and by compensating the carbon emissions and blue-water usage, we are a climate & resource positive textile brand, and the first certified B corporation in Germany."
      },
      {
        "name": "Linen Fox",
        "url": "https://linenfoxclothes.com",
        "description": "Small runs of customizable Oeko-tex certificated linen clothing with plastic free packaging."
      },
      {
        "name": "Loop A Life - 100% Circular Fashion",
        "url": "https://loopalife.com/",
        "description": "This circular textile award winning brand sets the new standard by clothing from local raw salvaged materials, recycling them without any chemicals, generating no wastewater, recycling their own products at end-of-life, researching and developing new ways to develop circular products.  They organize local sorting campaigns, workshops, collection campaigns, and facilitate other fashion companies in their circular transition.  Each sweater saves 500 liters of water, 60mJ of energy, uses zero chemicals, and saves at least 6kg of C02 emissions (when compared to traditional manufacturing)."
      },
      {
        "name": "Lost in Samsara - Bags, Jewelry, and Accessories",
        "url": "https://www.lostinsamsara.co.uk",
        "description": "Stylish products produced ethically from upcycled materials.  Bags made from cement bags, tires, and jewelry made from upcycled bullet casings."
      },
      {
        "name": "Love Linen",
        "url": "https://www.lovelinen.com.au/",
        "description": "Linen clothing made with love in Australia"
      },
      {
        "name": "MUD Jeans",
        "url": "https://mudjeans.eu/",
        "description": "Zero impact jeans production obeying circular economy principles, paying fair wages and offering a repair service."
      },
      {
        "name": "Mezzoroni",
        "url": "https://mezzoroni.com/",
        "description": "Oeko-tex certificated, cruelty free customizable linen clothing brand. All of the packaging are plastic free."
      },
      {
        "name": "NN07",
        "url": "https://www.nn07.com/",
        "description": "Using its [sustainable material matrix](https://www.nn07.com/made-to-last), No Nationality designs made-to-last clothing primarily with recycled and non-cotton natural materials including hemp, linen, wool, alpaca, and silk."
      },
      {
        "name": "Norm Shoes",
        "url": "https://norm.shoes/",
        "description": "Our shoes are made from 90% recycled materials: recycled polyester (6 plastic bottles per pair), recycled rubber, and fairtrade rubber.  The impact for one pair of Norm shoes is only 6,5 kg of CO2 equivalent (80% lower than the industry average). We partner with a Belgian NGO, Graine de Vie, to plant two trees in Madagascar for each pair we sell and we offset our emissions as well."
      },
      {
        "name": "Patagonia",
        "url": "https://www.patagonia.com/",
        "description": "Sports clothing produced in the most sustainable way ([footprint](https://www.patagonia.com/our-footprint/): working towards carbon neutral, recycled, fair trade, organic, ...)"
      },
      {
        "name": "Pure Waste",
        "url": "https://www.purewaste.org/",
        "description": "Helsinki based, making 100% recycled clothing out of waste materials."
      },
      {
        "name": "REI Used",
        "url": "https://www.rei.com/used",
        "description": "CO-OP owned company that sells reused hiking and outdoor gear and clothing with the goal of preventing waste and getting more people into outdoor activities. They offer gift cards in exchange for your used gear too."
      },
      {
        "name": "Recover Brands",
        "url": "https://recoverbrands.com/",
        "description": "Soft and strong T-shirts, each made from 8 plastic bottles. Closed Loop manufacturing from the start."
      },
      {
        "name": "Runamics Running & Sports Gear",
        "url": "https://www.runamics.com",
        "description": "Crowd-funded for-purpose eco-friendly alternatives to traditional sports gear. We combine merino wool with wood-based cellulosic fibres like Lyocell. We make experiments with highly innovative fibres like biodegradable elastic fibres or “polyester-like” substitutes.  WE're climate neutral always working to reduce our footprint, use plastic-free packaging and ship globally with DHL GoGreen."
      },
      {
        "name": "Siizu",
        "url": "https://siizu.com/",
        "description": "A mininalistic-styled brand that creates clothing with organic and natural fabrics - one such using oyster shell waste. They use an ethical manufacturing process by having their factories close to each other and their shipping only uses recyclable packaging."
      },
      {
        "name": "Sustainable Hosiery",
        "url": "https://www.sustainablehosiery.com/",
        "description": "OEKO-TEX certified, vegan-dyed hosiery made from 76% - 97% recycled post-production and post-consumer nylon waste in Zero Waste factories"
      },
      {
        "name": "TenTree",
        "url": "https://www.tentree.ca/",
        "description": "Ten tree is a brand that actively promotes environmental stewardship. They have a wide variety of comfortable clothes and accessories and with each purchase, they pledge to plant 10 trees."
      },
      {
        "name": "Vesica Piscis Shoes",
        "url": "https://vesicapiscisfootwear.com/",
        "description": "Hand made stylish shoes made from recycled materials. Recycled cotton, recycled polyester fabric picking from plastic bottles, X-ray plates, fishing nets, etc. They use virgin natural rubber, bamboo, and a small amount of organic cotton."
      },
      {
        "name": "Vinted Used Clothes Marketplace",
        "url": "https://www.vinted.com",
        "description": "Your community for pre-loved fashion. Buy and sell quality used apparel."
      },
      {
        "name": "Worn Wear",
        "url": "https://wornwear.patagonia.com/",
        "description": "A set of tools to help our customers partner with Patagonia to take mutual responsibility to extend the life of the products Patagonia makes and customers purchase. You can buy second-hand repaired or re-crafted clothes, or trade in used Patagonia clothes for credit for new items."
      },
      {
        "name": "Woron Store",
        "url": "https://www.woronstore.com/",
        "description": "Lingerie and base wear essentials made from GOTS-certified, antibacterial 'Lenzing Modal' (Beech wood!) made from CO2-neutral FSC-certified native tree plantations."
      },
      {
        "name": "thredUP",
        "url": "https://www.thredup.com/",
        "description": "Second hand clothes, up-cycled to avoid the electricity, carbon, etc waste of making new clothes, and keeping them from a landfill. Women and kids but nothing for men."
      }
    ]
  },
  {
    "name": "Consumer Products",
    "links": [
      {
        "name": "A Good Company - The Plastic-Free Store",
        "url": "https://agood.com/",
        "description": "Everyday products including notebooks, toothbrushes, phone cases, art supplies, water bottles, etc. designed with by a company with complete transparency that has extremely ambitious environmental standards including plastic-free low-carbon materials including bio-plastics, bamboo, stone paper, and recycled aluminum."
      },
      {
        "name": "Earth Hero",
        "url": "https://earthhero.com/",
        "description": "Our brands are made with better materials, cleaner production, a lower carbon footprint, higher quality, and with less waste. When you shop on EarthHero, you contribute to a better future for us all."
      },
      {
        "name": "Fairphone",
        "url": "https://www.fairphone.com/",
        "description": "A phone for everyone who cares about how their products are made. It improves the conditions of the people who make it and uses materials that are better for the planet."
      },
      {
        "name": "Grayl Water Filter",
        "url": "https://grayl.com/",
        "description": "Water bottle with built in filter that works like a french press. Great for urban and outdoor use."
      },
      {
        "name": "Katadyn Water Filters",
        "url": "https://www.katadyn.com/en/de/products/water-filters#/1/filter?categories=32",
        "description": "Katadyn develops and manufactures durable and portable water filters, desalinators and chemical disinfectants for daily use, camping, trekking, or global journeys. The vast product line ranges from water filters and Micropur tablets to the smallest manual desalinator for marine applications. Aid organizations as well as the military rely on them."
      },
      {
        "name": "Lehman's",
        "url": "https://www.lehmans.com/",
        "description": "One-stop shop for non-electric, homesteading, survival, handmade, Amish made, plastic free, durable, quality goods.  If you envision switching to live a simpler life, this place has all the tools you need to do so."
      },
      {
        "name": "Palm-Oil Free Products",
        "url": "https://orangutanfoundation.org.au/palm-oil/",
        "description": "Make sure your makeup, biofuel, popcorn, candy, and other [various products](https://www.ethicalconsumer.org/palm-oil/palm-oil-free-list) are palm-oil free. The World Wildlife Fund estimates that 48 football fields worth of rainforest are cut down every minute! It’s estimated that palm oil plantations now cover around 27 million hectares. The forests being clear cut are often habitat for orangutans, who will be completely gone within 5-10 years at this rate."
      },
      {
        "name": "Pela Case",
        "url": "https://pelacase.com/",
        "description": "100% Compostable phone case for iPhone and Android made with flax. Also zero-waste screen protectors and sunglasses."
      },
      {
        "name": "TomatoInk",
        "url": "https://www.tomatoink.com/",
        "description": "TomatoInk is an eco-friendly, low-cost provider of ink and toner. By packaging ink in remanufactured cartridges, we pass along substantial savings both financial and environmental to you. “Our factory collects high-quality used cartridges. There, they are professionally cleaned and inspected and any defective parts get replaced. The cartridges then get filled with high-quality ink comparable to that used in name-brand cartridges. And finally, every single cartridge is inspected and test printed.”"
      }
    ]
  },
  {
    "name": "Cooking",
    "links": [
      {
        "name": "Ecocina Rocket Stoves",
        "url": "http://www.stoveteam.org/",
        "description": "Wood fired cook stove that uses ~40-50% less fuel than traditional fires and emits ~1/3 the CO2. Learn how to build one!  Check out their research center at [Aprovecho](http://aprovecho.org/)."
      },
      {
        "name": "Go Sun",
        "url": "https://www.gosun.co/",
        "description": "An innovative portable ultra-efficient solar cooker that can be used for backpacking, boating, car camping, etc."
      },
      {
        "name": "Insulated Cooking",
        "url": "https://www.milkwood.net/2015/07/06/thermal-cooking/",
        "description": "Discover a great way not only to use less energy in food preparation, but to serve tastier and more nutritious meals at the same time.  Any recipe that calls for boiling, simmering, steaming, or roasting will often taste better— [hot from the haybox](https://www.motherearthnews.com/diy/haybox-cooking-zmaz80jfzraw) — than it would with regular stove preparation ... and you'll save heat energy at the same time.  You can pick up a pot-sized [thermal cooker](http://www.cookingworld.biz/thermal-cooker-guide/), or simply put a blanket in a cooler."
      },
      {
        "name": "Preserve Extra Food With A Solar Dehydrator",
        "url": "https://www.motherearthnews.com/diy/tools/solar-food-dehydrator-plans-zm0z14jjzmar",
        "description": "A solar food dehydrator is a device that removes moisture from food to aid in its preservation. You can [buy a simple one](https://www.kickstarter.com/projects/mixedmediaeng/dryceratop-solar-food-dehydrator-for-mason-jars/description) or make your own.  Food drying is a method of preserving fruit, vegetables, and animal proteins that has been practiced since antiquity."
      },
      {
        "name": "Sun Oven",
        "url": "https://www.sunoven.com",
        "description": "Insulated solar oven that can cook food just like a regular oven."
      }
    ]
  },
  {
    "name": "Documentaries",
    "links": [
      {
        "name": "Artifishial",
        "url": "https://www.patagonia.com/artifishal.html",
        "description": "Artifishal is a film about people, rivers, and the fight for the future of wild fish and the environment that supports them. It explores wild salmon’s slide toward extinction, threats posed by fish hatcheries and fish farms, and our continued loss of faith in nature."
      },
      {
        "name": "Before the Flood",
        "url": "https://www.imdb.com/title/tt5929776/",
        "description": "A look at how climate change affects our environment and what society can do to prevent the demise of endangered species, ecosystems and native communities across the planet."
      },
      {
        "name": "Biggest Little Farm",
        "url": "https://www.biggestlittlefarmmovie.com/",
        "description": "The Biggest Little Farm chronicles the eight-year quest of John and Molly Chester as they trade city living for 200 acres of barren farmland and a dream to harvest in harmony with nature. Through dogged perseverance and embracing the opportunity provided by nature's conflicts, the Chesters unlock and uncover a biodiverse design for living that exists far beyond their farm, its seasons, and our wildest imagination. Featuring breathtaking cinematography, captivating animals, and an urgent message to heed Mother Nature's call, The Biggest Little Farm provides us all a vital blueprint for better living and a healthier planet."
      },
      {
        "name": "Blue Planet II",
        "url": "https://www.imdb.com/title/tt6769208/",
        "description": "David Attenborough returns to the world's oceans in this sequel to the acclaimed documentary filming rare and unusual creatures of the deep, as well as documenting the problems our oceans face, including showing how plastic waste is destroying marine life."
      },
      {
        "name": "Chasing Coral",
        "url": "https://www.imdb.com/title/tt6333054/",
        "description": "Coral reefs around the world are vanishing at an unprecedented rate. A team of divers, photographers and scientists set out on a thrilling ocean adventure to discover why and to reveal the underwater mystery to the world."
      },
      {
        "name": "Garbage Warrior",
        "url": "http://www.garbagewarrior.com/",
        "description": "Garbage Warrior is a feature-length documentary film telling the epic story of maverick architect Michael Reynolds, his crew of renegade house builders from New Mexico, and their fight to introduce radically different ways of living. Imagine a home that heats itself, that provides its own water, hat grows its own food. Imagine that it needs no expensive technology, that it recycles its own waste, that it has its own power source. And now imagine that it can be built anywhere, by anyone, out of the things society throws away. Thirty years ago, architect Michael Reynolds imagined just such a home - then set out to build it. Reynolds believes that in an age of ecological instability and impending natural disaster, his buildings can - and will - change the way we live."
      },
      {
        "name": "GasLand Part II",
        "url": "https://www.imdb.com/title/tt2795078/",
        "description": "The gas industry's portrayal of natural gas as a clean and safe alternative to oil is a myth, and that fracked wells inevitably leak over time, contaminating water and air, hurting families, and endangering the earth's climate with the potent greenhouse gas methane."
      },
      {
        "name": "GasLand",
        "url": "https://www.imdb.com/title/tt1558250/",
        "description": "An exploration of the fracking petroleum extraction industry and the serious environmental consequences involved."
      },
      {
        "name": "Green Film Festival in Seoul",
        "url": "http://www.greenfund.org/en/m61.php",
        "description": "Starting with Green Film Festival in Seoul in 2004, Korea Green Foundation has been seeking ways of coexistence of the environment and humans and has been exploring the alternatives and better practice for the future."
      },
      {
        "name": "Flower Island",
        "url": "https://pt.wikipedia.org/wiki/Ilha_das_Flores_(curta-metragem)",
        "description": "\"Ilha das Flores\", from portuguese, it's a brazilizan documentarie made in 1989 which portrays the influence of the economy on the relationship of human beings with each other and with the environment. It also contains a strong criticism of social inequality and the handling of organic waste. The short film depicts the situation of poor families in a given region of Porto Alegre who, on a priority scale, find themselves after pigs. Women and children who, within a specified time of five minutes, ensure the pigs' leftover food daily."
      },
      {
        "name": "More than Honey",
        "url": "https://www.imdb.com/title/tt2263058/",
        "description": "An in-depth look at why bees, worldwide, are facing extinction. With the tenacity of a man out to solve a world-class mystery, he investigates this global phenomenon."
      },
      {
        "name": "No Impact Man",
        "url": "https://www.imdb.com/title/tt1280011/",
        "description": "Follow the Manhattan-based Beavan family as they abandon their high consumption 5th Avenue lifestyle and try to live a year while making no net environmental impact."
      },
      {
        "name": "Our Planet",
        "url": "https://www.imdb.com/title/tt9253866/",
        "description": "Documentary series focusing on the breadth of the diversity of habitats around the world, from the remote Arctic wilderness and mysterious deep oceans to the vast landscapes of Africa and diverse jungles of South America."
      },
      {
        "name": "Tapped",
        "url": "https://www.imdb.com/title/tt1344784/",
        "description": "Examines the role of the bottled water industry and its effects on our health, climate change, pollution, and our reliance on oil."
      },
      {
        "name": "The Coconut Revolution",
        "url": "https://www.imdb.com/title/tt0479000/",
        "description": "This is the modern-day story of a native peoples' remarkable victory over Western Colonial power. A Pacific island rose up in arms against giant mining corporation Rio Tinto Zinc (RTZ) - and won despite a military occupation and blockade."
      },
      {
        "name": "The Power of Community: How Cuba Survived Peak Oil",
        "url": "https://www.imdb.com/title/tt0814275/",
        "description": "A great example of how a community can survive the oil apocalypse. Cubans were on the edge of starvation due to the oil crisis - the average Cuban lost 20 pounds. The Cuban people helped avert disaster from the bottom up by reclaiming land everywhere and began growing vegetables on them. Here we see the importance of recovering lost knowledge to ensure communal survival."
      },
      {
        "name": "Virunga",
        "url": "https://www.imdb.com/title/tt3455224/",
        "description": "A team of brave individuals risk their lives to protect the last mountain gorillas."
      },
      {
        "name": "Where the Heck is Donlin?",
        "url": "https://vimeo.com/64608183",
        "description": "Sited deep in the Bush of Southwestern Alaska, the Donlin Gold prospect is the largest proposed gold mine in Alaska's history. However, an overwhelming majority of Alaskan residents are unfamiliar with the details of it's development and implications. Noting the absence of available data, as well as the lack of awareness surrounding the proposal, Bjorn and Kim took on the ground-truth-trekking model of investigative research, and set out to explore some of the unanswered questions from the source. Completing a three-part, 1,000 mile human powered wilderness expedition through the proposed footprint of the mine, they engaged the people that they encountered on the subjects of perpetual waste storage, the significance of subsistence fisheries, the energy demands of a large-scale mine, and the challenges facing rural residents to name a few."
      }
    ]
  },
  {
    "name": "Finance",
    "links": [
      {
        "name": "Abundance Investment",
        "url": "https://www.abundanceinvestment.com/",
        "description": "Abundance offer a crowdfunding marketplace for socially and environmentally beneficial projects. Make direct investments in a range of businesses that share your values, through an ISA or a pension."
      },
      {
        "name": "Amalgamated Bank",
        "url": "https://amalgamatedbank.com/",
        "description": "Personal and business banking from a Certified B Corporation. They're fossil fuel free in our lending, powered by 100% renewable energy and have a long, proud history of providing affordable access to banking and being a champion of immigrants’ and workers’ rights. _NOT_ a FDIC member, but part of GABV (the Global Alliance of Banking on Values)."
      },
      {
        "name": "Aspiration",
        "url": "https://www.aspiration.com/",
        "description": "Aspiration offers socially-conscious and sustainable cash management services and investment products, so you can make money while making the world a better place. And, unlike the Big Banks, we don’t use your deposits to fund oil pipelines or turn your fees into campaign contributions to the politicians that work against you.**"
      },
      {
        "name": "Beneficial State Bank",
        "url": "https://beneficialstatebank.com/",
        "description": "From fairly priced checking accounts for individuals and families that help you stay on track, to business and nonprofit financial tools that assist you in growing your organization. This bank is a B Corp, a FDIC member, and part of GABV (the Global Alliance of Banking on Values). Recommended by Stop The Money Pipeline."
      },
      {
        "name": "Betterment - Socially Responsible Investing",
        "url": "https://www.betterment.com/socially-responsible-investing/?referral_key=philipsturgeon",
        "description": "Super reliable, tax efficient, Traditional and Roth IRA / 401(k), and they now offer checking too. Betterment is not socially responsible by default, you need to select the SRI portfolio for each and every goal (account) you set up with them. They have divested from oil, but you should review [their SRI strategy](https://www.betterment.com/resources/socially-responsible-investing-portfolio-methodology/#sociallyresponsible) to see if you think it's good enough."
      },
      {
        "name": "Climate-KIC Marketplace",
        "url": "https://www.climate-kic.org/marketplace/",
        "description": "Marketplace full of investment opportunities into early-stage startups. The dealflow stems from EIT Climate-KIC’s Accelerator programme, the largest climate-focused acceleration programme in the world."
      },
      {
        "name": "Corner Card",
        "url": "https://www.cornercard.ch/de/privatkunden/kreditkarten/liste/detail/climate-creditcard-de",
        "description": "Discover Switzerland's first climate-friendly credit card: with every card you make an active contribution to the compensation of CO2 emissions - without any additional costs for you. Complete climate compensation Whether a flight ticket, a new shirt or an overnight stay in a hotel - goods and services paid for with the Climate Credit Card are 100% CO2 compensated."
      },
      {
        "name": "Ditch Dirty Banks",
        "url": "https://www.ran.org/bankingonclimatechange2019/#data-panel",
        "description": "Anyone with a Chase, Wells Fargo, Citi Bank account could do the world a favour by cutting that card in half. Customers of any of the fossil fuel funding banks in this list could. Phone up, tell them to cancel your account because they're funding _still funding coal and fracking_, and put another little ding in their bottom line. Find an ethical bank, they've usually got better fees and more friendly support staff anyway."
      },
      {
        "name": "EQ Investors",
        "url": "https://eqinvestors.co.uk/individuals",
        "description": "Impact investing is an exciting and rapidly growing industry powered by investors who are determined to generate social and environmental impact as well as financial returns."
      },
      {
        "name": "Ecology Building Society",
        "url": "https://www.ecology.co.uk/",
        "description": "Need a savings account or a mortgage, but don't want the money being used for the usual awful stuff banks fund? Ecology are dedicated to improving the environment by supporting and promoting ecological building practices and sustainable communities. They'll even give mortgage to folks trying to buy woodlands, or to buy fields and create woodland!"
      },
      {
        "name": "Global Alliance for Banking on Values",
        "url": "https://www.gabv.org/",
        "description": "The Global Alliance for Banking on Values (GABV) is a network of banking leaders from around the world committed to advancing positive change in the banking sector. Their goal is to change the banking system so that it is more transparent, supports economic, social and environmental sustainability, and is composed of a diverse range of banking institutions serving the real economy."
      },
      {
        "name": "Good Money Week",
        "url": "https://goodmoneyweek.com/",
        "description": "Helping you find sustainable and ethical options for banking, pensions, savings and investments."
      },
      {
        "name": "Hargreaves Lansdown Responsible Investment",
        "url": "https://www.hl.co.uk/",
        "description": "Hargreaves Lansdown are a big name in finance, offering savings accounts and pensions. They will let you invest in pretty much anything, but they've put together a list of \"responsible investment\" funds to help you defer some of the thinking to the finance brains. The term 'responsible investment' is often used as a catch-all to describe funds managed with social, environmental, or other responsible criteria in mind, so maybe sift through this list to find ones that sound good to you, whether you use HL or not."
      },
      {
        "name": "Market Forces AU: Sustainable Banks",
        "url": "https://www.marketforces.org.au/info/compare-bank-table/",
        "description": "Find out which banks do and don’t have a record of funding fossil fuels. Each institution is sorted into categories clearly defining those that fund fossil fuels and those with no current record of funding the industry. Importantly, you can take action and contact every single bank, credit union and building society listed."
      },
      {
        "name": "NextEnergy Solar Fund",
        "url": "https://www.nextenergysolarfund.com/",
        "description": "NextEnergy Solar Fund is a specialist investment company that invests in operating solar power plants in the UK and Italy, with the objective of securing attractive shareholder returns through RPI-linked dividends. The Company achieves this by acquiring solar power plants on agricultural, industrial and commercial sites. Invest through an ISA or SIPP on usual UK trading platforms like HL/Fidelity/etc."
      },
      {
        "name": "Stop the Money Pipeline",
        "url": "https://www.stopthemoneypipeline.com/",
        "description": "Banks, insurance companies, and asset managers are funding, insuring and investing in the climate crisis. Stopping this money pipeline is one of the most important ways we can address the climate emergency."
      },
      {
        "name": "Thrive Renewables",
        "url": "https://www.thriverenewables.co.uk/",
        "description": "Thrive Renewables connects people to sustainable energy. We offer accessible opportunities for individuals and businesses to invest in clean energy projects that deliver financial, environmental and social rewards. With over 25 years in the industry, we have a wide network of professional contacts and are constantly on the look out for new projects which enhance our portfolio, match our investment criteria and have the potential to generate financial, environmental and social returns."
      },
      {
        "name": "Tomorrow One Bank",
        "url": "https://www.tomorrow.one",
        "description": "German bank which considers the future of our planet to be more important than access to VIP lounges at airports. Skip extra insurance products and fuel discounts, and get a premium account that focuses on climate protection."
      },
      {
        "name": "TreeCard",
        "url": "https://www.treecard.org/",
        "description": "TreeCard - The wooden debit card that plants trees."
      },
      {
        "name": "Trine - Solar Crowd-investing",
        "url": "https://www.trine.com/",
        "description": "Invest in solar projects bringing clean energy to emerging markets. Local solar partners will distribute and manage the solar products on the ground. If the loan is successful you will receive your investment and interest in return."
      },
      {
        "name": "Triodos Bank",
        "url": "https://www.triodos.co.uk/",
        "description": "Modern financial and banking services for savers, investors, and organisations who want to change the world for the better. Current accounts, personal savings, ISAs, business lending, and all sorts of other options for individuals, businesses, and charities."
      },
      {
        "name": "Triodos Crowdfunding",
        "url": "https://www.triodoscrowdfunding.co.uk/",
        "description": "Invest directly in pioneering organisations delivering positive change, such as community solar schemes, renewable energy projects, ethical food supermarkets."
      }
    ]
  },
  {
    "name": "Food",
    "links": [
      {
        "name": "Able & Cole",
        "url": "https://www.abelandcole.co.uk/",
        "description": "Get fruit, veg, pantry staples, and other organic food delivered in returnable, reusable, recyclable packaging. Seasonal boxes of veg so its not traveling around the world, sustainably sourced fish, they've even got beer."
      },
      {
        "name": "Agricool - Local, healthy, sustainable food",
        "url": "https://www.agricool.co/fr",
        "description": "Des fruits et légumes, cultivés au coeur des villes, à moins de 15km de leur lieu de consommation. Frais, locaux, sans pesticides."
      },
      {
        "name": "NotCo",
        "url": "https://notco.com",
        "description": "The Not Company is a Foodtech, that reinvents animal-based foods using only plants. Unlike traditional food businesses, the company uses technology to recreate the same products we love to eat in a natural, sustainable and affordable way, keeping it functional, easy to use and mouthwateringly delicious. They use Artificial Intelligence to build a library of thousands of Plants and find how to use them, to recreate the same taste, smell, function, look and feel of the products we love. ALL PLANT-BASED."
      },
      {
        "name": "All Plants - Vegan Prepared Meals",
        "url": "https://allplants.com/",
        "description": "Get super tasty and 100% plant-based meals cooked by chefs and delivered straight to your door. Two people getting six meals works out at £5 a meal, which is amazing. Use [this referral link](https://allplants.mention-me.com/me/referee/registerko/48827185/206943008/er/796b4fb5d581862f565aa73f01fe733b8576831c/fe/cw?epr=1) to get £10 off your first box. We'll get £10 off our next box, so we'll spend that saving on trees on [Offset Earth](https://offset.earth/philsturgeon). 🥳"
      },
      {
        "name": "Bees Wrap",
        "url": "https://www.beeswrap.com/",
        "description": "Stop using cling film and start using reusable recyclable wraps made from bees wax and organic jojoba oil."
      },
      {
        "name": "Boulder Food Rescue",
        "url": "https://www.boulderfoodrescue.org/",
        "description": "We facilitate the sustainable redistribution of healthy food that would otherwise be wasted to low-income communities, by bicycle. We work with communities to facilitate their own food redistribution and create decentralized systems to bypass barriers to food access. Our work envisions a world in which everyone has equitable access to healthy food."
      },
      {
        "name": "City Harvest",
        "url": "https://www.cityharvest.org/",
        "description": "City Harvest is New York City’s largest food rescue organization. They rescue food and deliver it to hundreds of food pantries, soup kitchens and other community partners."
      },
      {
        "name": "EIT Food",
        "url": "https://www.eitfood.eu/",
        "description": "EIT Food is Europe’s leading food innovation initiative, working to make the food system more sustainable, healthy and trusted by consumers."
      },
      {
        "name": "Farm Drop",
        "url": "https://www.farmdrop.com/",
        "description": "Next day delivery in London for groceries and household products from local and independent producers."
      },
      {
        "name": "Food Cloud",
        "url": "https://food.cloud/",
        "description": "FoodCloud is a social enterprise that connects businesses with surplus food to charities in their local communities that need it via a software platform."
      },
      {
        "name": "Foodsharing.de",
        "url": "https://foodsharing.de/",
        "description": "If you are located in Germany, join your local food rescuing group on foodsharing.de."
      },
      {
        "name": "Forkful",
        "url": "https://www.forkful.app/",
        "description": "Sustainable, nutritious eating that is as good for you as it is for the planet. With our powerful recipe search, you can view the nutritional benefit and environmental impact of thousands of recipes at a glance, empowering you to make awesome decisions."
      },
      {
        "name": "Geev",
        "url": "https://corporate.geev.com/",
        "description": "An online application to exchange stuffs and food between people. Easily discuss, meet and give a second life to objects and food.  The more you give the more people trust you when you want to get something."
      },
      {
        "name": "Giki",
        "url": "https://gikibadges.com/",
        "description": "The Giki app provides accessible, independent, transparent information to help people change habits to live more sustainably. Our 14 badges cover sustainability, health and fairness."
      },
      {
        "name": "Grocy",
        "url": "https://grocy.info/",
        "description": "Grocy is a web-based self-hosted groceries and household management solution for your home.  Scan barcodes, track your purchases, automate and optimize your shopping list, waste less by keeping track of what's expiring next, plan meals, and more."
      },
      {
        "name": "GrowNYC Food Scrap Collection Schedule",
        "url": "https://www.grownyc.org/compost/locations",
        "description": "Interactive map with over 150 residential Food Scrap Drop-Off sites in NYC."
      },
      {
        "name": "Happy Cow",
        "url": "https://www.happycow.net",
        "description": "Reduce or avoid meat entirely by finding great vegetarian or vegan food all over the world."
      },
      {
        "name": "Impossible Foods",
        "url": "https://impossiblefoods.com/",
        "description": "We’re making meat from plants so that we never have to use animals again.  Just one Impossible Burger (instead of a burger made from cows) will use 96% less land, 87% less water, and 89% fewer GHG emissions."
      },
      {
        "name": "Karma",
        "url": "https://karma.life/",
        "description": "Rescue unsold meals, delivered, always 50% off in hundreds of cities across Sweden, United Kingdom, and France."
      },
      {
        "name": "Karma",
        "url": "https://new.karma.life/",
        "description": "A Swedish company that lets restaurants sell surplus food at a lower price. It lets you pay less for food and prevent food waste."
      },
      {
        "name": "Karrot",
        "url": "https://karrot.world/",
        "description": "Join or start a group in your home town that rescues food. Karrot is a free and open-source tool for grassroots initiatives and groups of people that want to coordinate face-to-face activities on a local, autonomous and voluntary basis."
      },
      {
        "name": "Kitche",
        "url": "https://kitche.co/",
        "description": "Kitche works to reduce waste from inside users’ kitchens and makes it easier than ever before to manage food at home, saving money and reducing food waste all within one app. Scan receipts and stop wasting money!"
      },
      {
        "name": "Makkelijke Moestuin (Easy Vegetable Garden)",
        "url": "https://www.makkelijkemoestuin.nl/",
        "description": "We make the vegetable garden easy. Thanks to our stuff and app, you can immediately garden like a pro.  Setting up your vegetable garden perfectly is 80% of the work. Our stuff is specially made for that. With the other 20% - maintenance - our app helps you completely.  You harvest 5 times as much per m² as from an ordinary vegetable garden. Ka-ching!"
      },
      {
        "name": "Milk Run",
        "url": "https://localmilkrun.com",
        "description": "Shop for and subscribe to deliveries from our hub of local farmers, butchers, bakers, and makers in Portland, Oregon."
      },
      {
        "name": "No Food Wasted",
        "url": "http://www.nofoodwasted.com/",
        "description": "NoFoodWasted maps products that reach the best before date and shows where and how much you can save. Download the app, select a provider near you and start saving today."
      },
      {
        "name": "No Meat Today",
        "url": "https://nomeat.today/",
        "description": "Your companion to eat less meat. It's good for you and the planet, but let's be honest, eating less meat is hard. Don't do it alone!"
      },
      {
        "name": "No Waste",
        "url": "https://www.nowasteapp.com/",
        "description": "With lists for your freezer, fridge and pantry, you can easily check what food you have left, see what food you need to use first, plan your meals, create a shopping list, avoid unnecessary purchases, reduce food waste and save a bunch of money."
      },
      {
        "name": "Olio",
        "url": "https://olioex.com/",
        "description": "We connect neighbors to share food, and other things, rather than chuck them away."
      },
      {
        "name": "Pieter Pot",
        "url": "https://www.pieter-pot.nl/",
        "description": "Your groceries, delivered without packaging. Pieter Pot delivers your groceries with a cargo bike in beautiful glass jars in The Netherlands. Empty pot? Then we fill it again. This is how we make it fun and easy to do shopping without all those unnecessary (plastic) packaging. That's nice, right?"
      },
      {
        "name": "Rethink Food NYC",
        "url": "https://www.rethinkfood.nyc/",
        "description": "They pick up unused, excess food from restaurants, farms, and other food purveyors, and re-purpose it into delicious and nutritious meals for under-served New Yorkers."
      },
      {
        "name": "Seafood Watch",
        "url": "https://www.seafoodwatch.org/",
        "description": "Seafood Watch recommends seafood that is fished or farmed in ways that promote healthy oceans. They recommend best options, good alternatives, and things to avoid."
      },
      {
        "name": "The Rotten Fruit Box",
        "url": "https://therottenfruitbox.com/",
        "description": "100% Natural Freeze-Dried Fruit Snacks from Spain and Portugal shipped to you. The fruit you’re enjoying would have otherwise gone unused and rotted away on the ground. We also think that the name \"Rotten\" helps bring attention to the serious issue of food waste. Delicious, healthy, 100% natural, with a long shelf life, our freeze dried fruit snack pouches are ideal for home, work, office, to take to school, camping or just about anywhere. Help reduce food waste. Help small local farmers. 100% compostable packaging, ships with your local postal service because it is the lowest carbon footprint option."
      },
      {
        "name": "Tight5 farm",
        "url": "https://tight5.farm",
        "description": "Delivered by cargo bicycle, our microgreens, sprouts, and culinary herbs are grown sustainably at production scale in an ultra-minimalist hydroponic vertical farming unit"
      },
      {
        "name": "Too Good To Go",
        "url": "https://toogoodtogo.co.uk/",
        "description": "Sell your surplus food, easily and sustainably! Save delicious food and fight food waste. Find your favorite food and go rescue it."
      },
      {
        "name": "We Are Phenix",
        "url": "https://wearephenix.com/en/",
        "description": "Buy unsold goods from local businesses at a reduced price.  Sell expired products to clients, donate to charities, reuse organic waste for animal food, and more.  With over 100k meals saved per day, we are well on our way to reach the objective of zero food waste."
      },
      {
        "name": "The Felix Project",
        "url": "https://thefelixproject.org/",
        "description": "London-based charity that collects fresh, nutritious food that cannot be sold. Deliver this surplus food to charities and schools so they can provide healthy meals and help the most vulnerable in our society. Reducing food waste and poverty."
      },
      {
        "name": "OddBox",
        "url": "https://www.oddbox.co.uk",
        "description": "English Certified B Corp that is reducing food waste. Collects food rejected by Supermarkets, directly from farms and delivers to your door. £10 off your first box with this link (https://mention-me.com/m/ol/qd4ho-0d5026f88d). I will plant trees through Ecologi with the £10 I get for this."
      }
    ]
  },
  {
    "name": "Footprint Calculators",
    "links": [
      {
        "name": "Carbon Analytics",
        "url": "https://www.co2analytics.com/",
        "description": "Link a Xero accounts to assess each purchase a company makes, calculating the carbon impact of things like fuel, power purchases, transportation and more as well as supply chain impacts."
      },
      {
        "name": "CarbonFootprint.com",
        "url": "https://www.carbonfootprint.com/",
        "description": "Measure you carbon footprint, learn how to reduce your consumption, offset your impact, communicate, and comply."
      },
      {
        "name": "CarbonFund.org",
        "url": "https://carbonfund.org/",
        "description": "Calculate your footprint based on flights, driving, shipping, and make tax-deductible donations to offset your emissions."
      },
      {
        "name": "Cloud Carbon Footprint",
        "url": "https://www.cloudcarbonfootprint.org/",
        "description": "An open source tool that provides visibility and tooling to measure, monitor and reduce public cloud carbon emissions. It supports multiple cloud providers including AWS, Google Cloud, and Microsoft Azure, and displays energy and carbon emission metrics in a dashabord, command line interface or exportable to CSV."
      },
      {
        "name": "Eaternity",
        "url": "http://eaternity.org",
        "description": "Eaternity helps you calculate the environmental impact of their food to create a food system that operates within the Earth's environmental limits. Acting as a bridge between science and practical application, Eaternity provides accessible information on the CO₂ balance of food. The company, founded in 2008 at ETH Zurich, has been using a life cycle assessment (LCA) database for over 10 years to achieve this goal. The database has been continuously developed since its creation. By integrating this database into existing production systems, food product producers can measure, improve, and market their specific environmental footprint."
      },
      {
        "name": "Eco Passenger",
        "url": "http://ecopassenger.hafas.de/",
        "description": "More than a quarter of worldwide greenhouse gases emissions come from the transportation sector, and more important, it is the sector where we have seen the highest growth in these emissions the last decades and it is not stopping. To help, EcoPassenger is a calculator to compare the energy consumption, CO2 and exhaust atmospheric emissions for planes, cars, and trains, for passenger transport."
      },
      {
        "name": "Emitwise",
        "url": "https://www.emitwise.com/",
        "description": "The Emitwise Reportwise tool calculates company level GHG emissions in line with the GHG Protocol for scope 1 and 2 emissions. Primarily targeting the UK but would also be useful for other countries."
      },
      {
        "name": "How Good",
        "url": "https://howgood.com/",
        "description": "Future-Proof your products.  HowGood data offers data to businesses and consumers about product sustainability from 350+ independent sources on over 1 million products.  Extensive data library on product sustainability designed to help brands and retailers use that data to source better and consumers to buy better, to build a better world."
      },
      {
        "name": "Impact Forecast",
        "url": "https://www.impactforecast.org/",
        "description": "The Climate impact forecast is a quick-and-easy tool to see and improve the carbon footprint of business ideas in the startup phase, and a stepping stone towards more meticulous life cycle assessment for established companies."
      },
      {
        "name": "Joro",
        "url": "https://www.joro.tech/",
        "description": "Effortlessly track your personal carbon footprint by securely connecting your credit and debit cards. Joro combines financial data and academic datasets to develop real-time carbon footprint estimates. The bank integration uses Plaid, and is US only for now, but has plans to roll out to Europe. Sign up to the newsletter to find out."
      },
      {
        "name": "MyClimate",
        "url": "https://myclimate.org/",
        "description": "Helping reduce emissions through a whole bunch of different projects, from consulting companies on their footprint (and helping them to reduce), to education at schools, forest restoration, providing people in Rwanda with efficient cook stoves, and [a whole bunch more](https://www.myclimate.org/information/climate-protection-projects/). Fund them via donations, and use their flight/car/house/company footprint calculators."
      },
      {
        "name": "Plan A",
        "url": "https://plana.earth/",
        "description": "Software that helps your business calculate, monitor and reduce its carbon footprint. Our platform allows you to track your carbon footprint monthly and learn how to reduce it with the support of a custom sustainability action plan, automatically created based on your worst-performing indicators."
      },
      {
        "name": "Protea OSS Carbon Footprint",
        "url": "https://github.com/protea-earth/carbon_footprint",
        "description": "Open source carbon footprint calculator, the only emissions calculator to use a command line interface."
      },
      {
        "name": "The US EPA's Carbon Footprint Calculator",
        "url": "https://www3.epa.gov/carbon-footprint-calculator/",
        "description": "The calculator estimates your footprint in three areas- home energy, transportation and waste. Everyone's carbon footprint is different depending on their location, habits, and personal choices."
      },
      {
        "name": "WWF UK Calculator",
        "url": "https://footprint.wwf.org.uk/",
        "description": "The planet is in crisis - from climate change to the pollution in our oceans and devastation of our forests. It's up to all of us to fix it. Take your first step with our environmental footprint calculator."
      },
      {
        "name": "Zellar",
        "url": "https://zellar.com/",
        "description": "Get an energy profile for your company to understand your energy consumption, and how much CO2 is being generated to power your business. We’ll then let you compare your profile to other local businesses or similar businesses across the UK, then track performance over time. Get advice and even unlock funds to finance any investments you may need to make on your journey to zero carbon."
      },
      {
        "name": "atmosfair",
        "url": "https://www.atmosfair.de/",
        "description": "Calculate the footprint for flights and buy compensation or donate to offset any number of carbon emissions. Tax-deductible in Germany."
      }
    ]
  },
  {
    "name": "Home Improvements",
    "links": [
      {
        "name": "All Green",
        "url": "https://www.all-green.co.uk/",
        "description": "A selection of environmentally friendly products for the home, garden, pets and other stuff."
      },
      {
        "name": "Barry",
        "url": "https://barry.energy",
        "description": "Få et smart strømforbrug. Udskift din gamle el-leverandør med en app til din strøm."
      },
      {
        "name": "Berkley Water Filters",
        "url": "https://www.berkeyfilters.com/",
        "description": "21,000,000 Americans drink water that violates U.S. health standards. Berkey water filter systems are actually water purifiers because they remove bacteria and viruses that conventional filters cannot."
      },
      {
        "name": "Domestic Renewable Heat Incentive (RHI)",
        "url": "https://www.gov.uk/domestic-renewable-heat-incentive",
        "description": "You could get money towards renewable heating costs in your home. You can claim for biomass boilers, solar water heating, heat pumps. Payments are made for 7 years and are based on the amount of renewable heat made by your heating system."
      },
      {
        "name": "EPA's Responsible Appliance Disposal",
        "url": "https://www.epa.gov/rad",
        "description": "RAD is a voluntary partnership program that works with utilities, retailers, manufacturers, state and local government agencies, affiliates, and others to dispose of old refrigerated appliances using the best environmental practices available."
      },
      {
        "name": "Ecobee",
        "url": "https://www.ecobee.com/",
        "description": "Improve how people consume energy to create a more sustainable future. Live in harmony with a thermostat and sensor that learn and adapt to your schedule. _Lower the manufacturing footprint by buying one of their refurbished products._"
      },
      {
        "name": "EnergyStar.gov",
        "url": "https://www.energystar.gov/",
        "description": "Energy efficiency ratings, suppliers, and tax credits for products, homes, utilities, and local governments. ENERGY STAR is the government-backed symbol for energy efficiency, providing simple, credible, and unbiased information that consumers and businesses rely on to make well-informed decisions."
      },
      {
        "name": "Environmentally Friendly Roof Insulation",
        "url": "https://www.greenlivingtips.com/articles/environmentally-friendly-roof-insulation.html",
        "description": "However you heat your home, make sure you aren't leaking heat through insufficient insulation, and save money."
      },
      {
        "name": "Hamwells Showers",
        "url": "https://www.hamwells.com/",
        "description": "Shower systems that utilize heat exchangers to recapture heat and filtered pumps to recycle water up to 7 times before it is drained, thus significantly reducing water usage and energy consumption."
      },
      {
        "name": "Lancey",
        "url": "https://www.lancey.fr/",
        "description": "An efficient radiator to control your electricity consumption while improving comfort, with a connected thermostat to adapt to your needs and the characteristics of your home. A built-in battery stores electricity during off-peak hours, allowing you to automatically use cheaper and cleaner energy."
      },
      {
        "name": "Lehman's Appliances",
        "url": "https://www.lehmans.com/category/appliances",
        "description": "Off the grid and super efficient appliances, including gas refrigerators, freezers, composting toilets, wood stoves, water heaters and pumps."
      },
      {
        "name": "Mist Showers",
        "url": "https://www.lowtechmagazine.com/2019/10/mist-showers-sustainable-decadence.html",
        "description": "The emissions of a typical shower equal 3.5 – 7 km of driving. The mist shower, a satisfying but forgotten technology which uses very little water and energy, could be a solution. You can DIY convert almost any shower into a mist shower. The five-nozzle mist shower offers significant water and energy savings compared to a “normal” shower and does so without sacrificing comfort."
      },
      {
        "name": "NY State Home Energy Assessment tool",
        "url": "https://www.nyserda.ny.gov/All-Programs/Programs/Home-Energy-Efficiency-Upgrades",
        "description": "Get a home energy audit and receive tools, resources, and aid to upgrade your home to be more energy efficient."
      },
      {
        "name": "Nebia Showers",
        "url": "https://nebia.com/",
        "description": "Nebia is proud to offer products that transform your mundane shower routine into a ritual, and also contribute to preserving the planet."
      },
      {
        "name": "PlanetCare Microfibre Laundry Filters",
        "url": "https://www.planetcare.org",
        "description": "35% of microplastics are fibers that are released when we wash our clothes. With consumer and industrial laundry filters, tackle the problem close to the source – with a filter in your washing machine.  PlanteCare makes efficient, practical and affordable laundry filters that allow every household to stop sending microfibres into the environment."
      },
      {
        "name": "PowerX",
        "url": "https://www.powerx.co/",
        "description": "A plug-and-play smart-controller for water and gas headers. It learns what water temperatures you like and heats only as much water as you need. It will also detect the ideal time to heat your water, as prices change every 15 minutes, so you can save money with no impact on hot water levels. Save hundreds of dollars, reduce carbon emissions equivalent to 10 fully grown trees – every year!"
      },
      {
        "name": "Project Sunroof",
        "url": "https://www.google.com/get/sunroof",
        "description": "Find out if you could save money switching to solar panels. This Google project uses Google Earth imagery to analyze your roof shape and local weather patterns to create a personalized solar plan. Adjust your electric bill to fine-tune your savings estimate and the recommended number of solar panels for your home, then compare loan, lease, and purchase options for your solar panels based on your results."
      },
      {
        "name": "Regency Wood Stove Fireplace Inserts",
        "url": "https://www.regency-fire.com/en/Products/Wood/Wood-Inserts",
        "description": "If solar heating is not an option, wood stove inserts can update your drafty, open wood fireplace. They'll send less heat out the chimney, and more heat around your house, drastically improving your wood burning efficiency. They pump the smoke back into the fire to burn that off too, which sends less crap into the atmosphere. Try to use [coffee logs](https://www.bio-bean.com/elements/coffee-logs-and-retailers/) instead of wood."
      },
      {
        "name": "Rigo Paint - Made From Flax",
        "url": "https://www.rigoverffabriek.nl/",
        "description": "Decorating your house? Check out RigoStep water-based paints, and oil paints depend on locally grown flax, which is heated and pressed by traditional windmills to extract the oil. Once mixed with other solvents, this forms the liquid base for the paint."
      },
      {
        "name": "Sense",
        "url": "https://sense.com/",
        "description": "Sense is a home energy monitor that gives real-time insight into your home’s energy usage. Sense gives people the knowledge they need to reduce their energy costs and usage, with profound effects on the environment- the company estimates that its users are saving a total of 53 million pounds of CO2 annually."
      },
      {
        "name": "Solar Thermal Energy",
        "url": "https://en.wikipedia.org/wiki/Solar_thermal_energy",
        "description": "Solar thermal technology can be used for cooking, heating your home through radiant floors, radiators, or forced air. It can be used to heat water directly for hot showers too."
      },
      {
        "name": "Solar Water Heaters",
        "url": "https://www.energy.gov/energysaver/water-heating/solar-water-heaters",
        "description": "Solar hot water systems capture thermal energy from the sun and use it to heat water for your home. Systems can either be passive or active – while passive systems use gravity and natural circulation, active systems use pumps and controls to circulate water."
      }
    ]
  },
  {
    "name": "Hygiene",
    "links": [
      {
        "name": "A Good Company - The Plastic-Free Store",
        "url": "https://agood.com/",
        "description": "Everyday products including notebooks, toothbrushes, phone cases, art supplies, water bottles, etc. designed with by a company with complete transparency that has extremely ambitious environmental standards including plastic-free low-carbon materials including bio-plastics, bamboo, stone paper, and recycled aluminum."
      },
      {
        "name": "Bidet Hose Toilet Attachment",
        "url": "https://www.homedecorous.com/Bidet-Diaper-Handheld-Sprayer-Set-Water-Shattaf-A132",
        "description": "This sprayer will feel nice and sturdy in your hand as the whole thing is stainless steel. You will be able to adjust the water flow from zero to maximum by pushing the switch or by using the lever on the T-valve adapter."
      },
      {
        "name": "Buy a F**king Bidet",
        "url": "https://buyafuckingbidet.com/",
        "description": "Buying a bidet attachment for your toilet is cheap and easy, helps the environment and solves problems during the coronavirus pandemic. No more toilet-paper panic-buying/brawling. Do you have a basic understanding of how screwdrivers and hoses work? Congratulations, you're a goddamn bidet installation expert."
      },
      {
        "name": "By Olive",
        "url": "https://byolive.org/",
        "description": "By Olive is an online store with an extensive range of natural, organic and vegan health and beauty products from a newly launched own brand collection. All packaged responsibly; plastic-free and without waste packaging."
      },
      {
        "name": "CuloClean Water Bottle Bidet",
        "url": "https://culoclean.com/",
        "description": "CuloClean is the portable bidet that you can plumb in your plastic bottle, fully discreet, efficient and portable. It is specially designed so that it fits in the two most common diameters of water bottle on the market."
      },
      {
        "name": "Good Condom Company",
        "url": "https://www.thegoodc.company/",
        "description": "Fuck each other, not the planet. Condoms made of natural latex from sustainably managed rubber plantations in Malaysia."
      },
      {
        "name": "Improve how you do laundry",
        "url": "https://greenlivingideas.com/2014/09/23/3-easy-ways-to-green-your-laundry/",
        "description": "Six tips for a more sustainable laundry routine."
      },
      {
        "name": "Ocean Savers Cleaning Supplies",
        "url": "https://www.ocean-saver.com/",
        "description": "\"Pre-mixed\" cleaning sprays that you will find in the supermarket are over 90% water, with the active ingredient (the part that actually does the cleaning) making up a fraction of the total liquid. Oceansaver provide just the active ingredients, so people can reuse plastic bottles, reducing the consumption of single-use plastic."
      },
      {
        "name": "RazorPit",
        "url": "https://www.razorpit.com/",
        "description": "Cleans and sharpens your razor blades, making them last on average 6 times longer. They say their customers achieve 60-150, which can supposedly save you €120 on blades every year."
      },
      {
        "name": "Smartliners",
        "url": "https://smartlinerpads.com/",
        "description": "Reduce the impact on the environment caused by sanitary waste using Organic Cotton Period Pads."
      },
      {
        "name": "Smol",
        "url": "https://smolproducts.com/",
        "description": "Zero plastic dishwasher and laundry tablet subscription. Contains child lock, they're FSC certified, half the price of traditional brands, and animal cruelty free."
      },
      {
        "name": "Sonny",
        "url": "https://www.indiegogo.com/projects/sonny-a-portable-bidet-for-eco-conscious-humans/x/17318484#/",
        "description": "Never worry about running out of toilet paper again with Sonny, a sustainable alternative to wipes and paper for better hygiene and a greener planet."
      },
      {
        "name": "The Cheeky Panda",
        "url": "https://cheekypanda.com",
        "description": "100% bamboo tissues shipped with zero plastic, wipes in recyclable plastic, and carbon balanced through the World Land Trust."
      },
      {
        "name": "The Crappy Planet - Bamboo Toilet Paper",
        "url": "https://www.thecrappyplanet.com/",
        "description": "According to the EPA, one hardwood tree produces approximately 45 kg of toilet paper and about 83 million toilet rolls are produced every day. Bamboo toilet paper production requires less energy, one-fifth of the water, produces considerably more fiber on less land area, generates 30-35% more oxygen than other plants and trees, and it reduces the amount of carbon dioxide by about the same amount.  In addition, the production process requires that water and other materials are collected, reused and recycled. Finally, we invest 25% of our profits to stop deforestation and global warming."
      },
      {
        "name": "The Good Roll",
        "url": "https://www.thegoodroll.nl",
        "description": "Mail order 100% tree-friendly toilet paper made from post-consumer recycled paper.  50% of net profit from sales of The Good Roll is invested in the installation of safe toilets in East Africa."
      },
      {
        "name": "Who Gives a Crap",
        "url": "https://whogivesacrap.org/",
        "description": "We make all of our products with environmentally friendly materials, and we donate 50% of our profits to help build toilets for those in need."
      }
    ]
  },
  {
    "name": "Jobs",
    "links": [
      {
        "name": "80,000 Hours",
        "url": "https://80000hours.org/job-board/",
        "description": "This board presents some of the most promising publicly advertised vacancies we know about. Most of these roles are demanding and difficult to get, but if you’re a good fit for one of them, it could be your best opportunity to work on one of the world’s most pressing problems, or to get the career capital you need to have a big impact later."
      },
      {
        "name": "awesome-sustainability-jobs",
        "url": "https://github.com/pogopaule/awesome-sustainability-jobs",
        "description": "A curated, open source list of developer jobs in the sustainability sector."
      },
      {
        "name": "Circul'R",
        "url": "https://www.circul-r.com/",
        "description": "Bridging startups and companies so they can co-create circular economy solutions"
      },
      {
        "name": "Climate Careers",
        "url": "https://climate.careers/",
        "description": "Site that helps people find high-impact, high-paying jobs at organizations advancing climate solutions, research, policy, education, and advocacy for climate action. Software engineers, photographers, sales, operations, researchers, all sorts of jobs here."
      },
      {
        "name": "Climate Change Jobs (The Guardian)",
        "url": "https://jobs.theguardian.com/jobs/climate-change/",
        "description": "The Guardian advertises the latest climate change jobs in the UK and some areas of Europe/Asia."
      },
      {
        "name": "Data Science for Social Good",
        "url": "https://dssg-berlin.org/",
        "description": "Berlin based group helping NGOs to make use of their data by connecting them with volunteer data scientists and analysts."
      },
      {
        "name": "GoodWork",
        "url": "https://www.goodwork.ca/",
        "description": "GoodWork is a Canadian community of environmental changemakers, sustainability professionals, job seekers and volunteers."
      },
      {
        "name": "Green Jobs Network",
        "url": "https://greenjobs.greenjobsearch.org/",
        "description": "Job board that connects employers with job seekers who are interested in jobs that focus on environmental or social responsibility. Not just tech jobs like some of these boards, they cover all sorts of jobs."
      },
      {
        "name": "GreenJobs",
        "url": "https://greenjobs.com",
        "description": "Site advertising a wide variety of green jobs to enhance your environmental career."
      },
      {
        "name": "MakeSense Jobs",
        "url": "https://jobs.makesense.org",
        "description": "Makesense inspires and empowers citizens, entrepreneurs and organizations to build an inclusive and sustainable society together.  MakeSense's Job and assignment announcements platform for associations and social entrepreneurs who recruit profiles passionate about the impact. Job types include internship, freelance, civic service, partner, program, volunteer mission, mentoring."
      },
      {
        "name": "Practical guide to finding a climate change job in tech",
        "url": "https://medium.com/@leventov/how-to-find-a-job-in-a-tech-company-helping-to-combat-climate-change-practical-guide-e212e262a32",
        "description": "Nice guide on finding a job in tech tackling climate change."
      },
      {
        "name": "Reconsidered Jobs",
        "url": "https://www.reconsidered.co/jobs",
        "description": "Aggregate jobs in social impact, sustainability and corporate social responsibility."
      },
      {
        "name": "TBD Community",
        "url": "https://www.tbd.community/",
        "description": "More than 3,000 impact-driven companies and organisations use tbd* to look for new team members, in English and German but many of the jobs are in Germany."
      },
      {
        "name": "Tech Jobs for Good",
        "url": "https://techjobsforgood.com/",
        "description": "Find tech jobs at social impact companies, foundations, and innovative nonprofits in the United States. They cover all sorts of impact areas, with Environment being one you can select. Some jobs are remote, some are in-office."
      },
      {
        "name": "Terra.do",
        "url": "https://www.terra.do",
        "description": "Climate learning and career transition platform, runs several fellowships on climate education (broad and sector-specific), hosts climate job fairs, connects to mentors and experts, etc."
      }
    ]
  },
  {
    "name": "Land Management",
    "links": [
      {
        "name": "Creating a Land Trust",
        "url": "https://conservationtools.org/guides/150-what-is-a-land-trust",
        "description": "A land trust is a charitable organization that acquires land or conservation easements, or that stewards land or easements, for conservation purposes. Land owners may consider designating portions of their land as a land trust, in order to preserve natural features in perpetuity, and be eligible for tax benefits as a result."
      },
      {
        "name": "Dronecoria",
        "url": "http://dronecoria.org/",
        "description": "Open-source drone reforestation technology. Drones, coupled with native coated seeds, can transform the efficiency with which we restore ecosystems."
      },
      {
        "name": "Droneseed",
        "url": "https://www.droneseed.com/",
        "description": "They plant native trees & vegetation using drone swarms and spray to protect them. Provide valuable insights to customers by collecting data in the field. Work with governments, nonprofits, and private land owners as a service provider."
      },
      {
        "name": "Farm Bot",
        "url": "https://farm.bot/",
        "description": "Farm Bot is a fully automated, open-source, crowd-funded project, which helps you grow food for yourself, your family, and your community. Install FarmBot on a raised bed, urban rooftop, or in a small greenhouse at home. Hyper-local food production has never been easier."
      },
      {
        "name": "Natural Resources Conservation Service (NRCS)",
        "url": "https://www.nrcs.usda.gov/",
        "description": "NRCS will pay you to steward your land, in ways you define. It offers voluntary programs to eligible landowners and agricultural producers to provide financial and technical assistance to help manage natural resources in a sustainable manner. Programs include emergency watershed protection and flood prevention, watershed rehabilitation, surveys and planning, healthy forest reserve easements, agricultural conservation easements, conservation stewardship, and environmental quality incentives."
      },
      {
        "name": "Permaculture Earthworks Handbook",
        "url": "https://newsociety.com/books/p/the-permaculture-earthworks-handbook",
        "description": "A detailed guide to the proper design and construction of water harvesting earthworks. It covers the function, design, and construction methods for nine main types of water harvesting earthworks across a full range of climates. Free alternatives are an online course by [Permaculture Women](https://www.permaculturewomen.com/freepermaculturecourse.html), and a four-part documentary by [Geoff Lawton](https://www.geofflawtononline.com/)."
      },
      {
        "name": "Woodland Trust",
        "url": "https://www.woodlandtrust.org.uk/",
        "description": "The Woodland Trust is reforesting the United Kingdom, working with communities, local authorities, and land owners, to get trees in the ground."
      }
    ]
  },
  {
    "name": "News",
    "links": [
      {
        "name": "Bloomberg Green",
        "url": "https://www.bloomberg.com/green",
        "description": "Climate news and insights on the latest in science, environmental impacts, zero-emission tech and green finance."
      },
      {
        "name": "Carbon Brief",
        "url": "https://www.carbonbrief.org/",
        "description": "UK-based website covering the latest developments in climate science, climate policy and energy policy. Clear, data-driven articles and graphics to help improve the understanding of climate change, both in terms of the science and the policy response."
      },
      {
        "name": "Democracy Now!",
        "url": "https://www.democracynow.org/topics/climate_change",
        "description": "Independent global news produced daily, hosted by award-winning journalists Amy Goodman and Juan González. Our reporting includes breaking daily news headlines and in-depth interviews with people on the front lines of the world’s most pressing issues by a diversity of voices.  Free from government funding, corporate sponsorship, underwriting or advertising revenue."
      },
      {
        "name": "Good",
        "url": "https://www.good.is/planet",
        "description": "Good and upworthy news covering big issues, 'making purpose contagious'."
      },
      {
        "name": "Heated",
        "url": "https://heated.world/",
        "description": "Original reporting and analysis on the climate crisis at the top of your inbox every morning, Monday through Thursday. News should arm you with the knowledge you need to effectively fight this crisis."
      },
      {
        "name": "Metabolic",
        "url": "https://metabolic.nl/news",
        "description": "Sustainability consultancy in The Netherlands, tracking and reporting on climate action, circular economy, reducing consumption, etc. all over the world."
      },
      {
        "name": "State of the Planet",
        "url": "https://blogs.ei.columbia.edu/category/climate/",
        "description": "News from the Earth Institute at Columbia University.  Columbia’s Earth Institute blends research in the physical and social sciences, education and practical solutions to help guide the world onto a path toward sustainability."
      },
      {
        "name": "The Cleanest Line",
        "url": "https://www.patagonia.com/blog/",
        "description": "Patagonia's blog on their efforts into political engagement for environmental protection of green spaces, global strikes, their efforts subsidizing solar energy in various communities, and all sorts of other climate action."
      },
      {
        "name": "The Guardian",
        "url": "https://www.theguardian.com/uk/environment",
        "description": "The Guardian covers international environmental issues and climate change."
      },
      {
        "name": "US Green Build Council",
        "url": "https://www.usgbc.org/articles",
        "description": "Transforming how buildings are designed, constructed and operated through the LEED construction standard. Articles about benchmarking energy efficiency of materials, city strategy, measuring the health of indoor spaces, reducing off-gassing, and improving air quality."
      }
    ]
  },
  {
    "name": "Other Services",
    "links": [
      {
        "name": "Ecotalk",
        "url": "https://www.ecotalk.co.uk",
        "description": "UK-based mobile network powered by renewable energy. Profits are used to buy land which is then given back to nature."
      }
    ]
  },
  {
    "name": "Podcasts",
    "links": [
      {
        "name": "Democracy Now!",
        "url": "https://www.democracynow.org/topics/climate_change",
        "description": "Independent global news produced daily, hosted by award-winning journalists Amy Goodman and Juan González. Our reporting includes breaking daily news headlines and in-depth interviews with people on the front lines of the world’s most pressing issues by a diversity of voices.  Free from government funding, corporate sponsorship, underwriting or advertising revenue."
      },
      {
        "name": "How to Save a Planet",
        "url": "https://gimletmedia.com/shows/howtosaveaplanet",
        "description": "weekly-ish podcast by Gimlet Media that asks the big questions: what do we need to do to solve the climate crisis, and how do we get it done? Journalist Alex Blumberg and scientist and policy nerd Dr. Ayana Elizabeth Johnson talk to people who are making a difference and work to figure out how to build the future we want, tackling a different subject related to the climate crisis each episode."
      },
      {
        "name": "People Fixing the World - BBC World Service",
        "url": "https://www.bbc.co.uk/programmes/p04grdbc",
        "description": "Brilliant solutions to the world’s problems. We meet people with ideas to make the world a better place and investigate whether they work."
      },
      {
        "name": "Sustainababble",
        "url": "http://www.sustainababble.fish/",
        "description": "A weekly podcast about the environment, for and by the confused. Your hosts Ol and Dave are supposed to be experts in how to save the planet. But why’s everything got to be so confusing? Each week they try to get a little bit closer to enlightenment. They may fail. They sift through the most egregious eco-guff out there, exposing the real eco-villians vs the hapless incompetents."
      },
      {
        "name": "TIL Climate Podcast",
        "url": "https://climate.mit.edu/users/tilclimate-podcast",
        "description": "This MIT podcast breaks down the science, technologies, and policies behind climate change, how it’s impacting us, and what we can do about it. Each quick episode gives you the what, why, and how on climate change -- from real scientists -- to help us make informed decisions for our future."
      },
      {
        "name": "Talking Headways: A Book Club for the Future of Transportation",
        "url": "https://streetsblog.libsyn.com/",
        "description": "We explore the intersection of sustainable transportation, urban planning, city living, economic development, and anything else that piques our interest. A staple and almost an obligatory source of information on the latest trends in urban mobility and urban planning."
      },
      {
        "name": "The Climate Fix",
        "url": "https://theclimatefix.com/",
        "description": "We shine a spotlight on people and organisations working on sustainable solutions, help connect them to talent & investment as well as give people hope that there are climate solutions as well as climate problems."
      },
      {
        "name": "The Energy Transition Show",
        "url": "https://xenetwork.org/ets/",
        "description": "Straight talk about the world’s transition from fossil fuels to renewables with energy expert Chris Nelder."
      },
      {
        "name": "The Yikes Podcast",
        "url": "https://radiopublic.com/the-yikes-podcast-6nKDQq",
        "description": "Climate Change, Human Rights and the messiness of everything going on at the moment can be really overwhelming BUT we want to provide a space to chat about these things and find hope in the midst of it all."
      },
      {
        "name": "You've Been Warmed",
        "url": "https://www.youvebeenwarmed.com/",
        "description": "By interviewing the top scientists, entrepreneurs, activists & politicians, we seek to find answers to all of the above while uncovering the leaders behind our fight for the preservation of our planet."
      },
      {
        "name": "Green Pulse",
        "url": "https://omny.fm/shows/green-pulse-1",
        "description": "The Straits Times (A Singapore news outlet) analyses the beat of the changing environment, from biodiversity conservation to climate change."
      }
    ]
  },
  {
    "name": "Politics",
    "links": [
      {
        "name": "EU: Right to Repair",
        "url": "https://repair.eu/",
        "description": "Cracked screens, weak batteries, broken charging ports... We’d like to fix them, but instead we end up buying a new smartphone because repairs are too expensive, difficult or impossible. Reducing the lifespan of a product may drive sales, but this comes at the expense of consumers, workers and the planet. Ask the European Union to give people the Right to Repair by requiring manufacturers to design repairable smartphones and provide spare parts and repair information to all repairers and consumers."
      },
      {
        "name": "Energy Innovation and Carbon Dividend Act",
        "url": "https://energyinnovationact.org/",
        "description": "The Energy Innovation and Carbon Dividend Act (H.R. 763) will drive down America's carbon pollution and bring climate change under control, while unleashing American technology innovation and ingenuity. This policy was also introduced in the Senate in 2018 as S. 3791."
      },
      {
        "name": "No Fracking in Alaska’s Arctic Wildlife Refuge",
        "url": "https://act.nrdc.org/letter/welcome-arctic-190603",
        "description": "Alaska’s Arctic National Wildlife Refuge is one of our last truly wild places — and it has been off-limits to oil companies for decades. But the Trump administration is closer than any administration in history to tearing open the Arctic Refuge for destructive oil and gas drilling."
      },
      {
        "name": "Our Children's Trust",
        "url": "https://www.ourchildrenstrust.org/",
        "description": "Leading the game-changing, youth-driven, global climate recovery campaign to secure the legal right to a stable climate and healthy atmosphere."
      },
      {
        "name": "Save Wild Orcas and Wild Salmon",
        "url": "https://www.change.org/p/wild-salmon-and-southern-resident-killer-whales-are-on-the-brink-of-extinction?signed=true",
        "description": "Wild salmon and southern resident killer whales are on the brink of extinction. Now a misguided plan to feed the starving whales with hatchery salmon will push both endangered species closer to the edge, while costing taxpayers millions of dollars per year."
      },
      {
        "name": "The Green Flying Duty",
        "url": "https://www.responsiblevacation.com/copy/write-to-politicians",
        "description": "The UK is one of the few countries to tax aviation fuel, but it is too low, and not ringfenced for climate solutions. The Green Flying Duty proposal is a reformed version of the UK's APD, that will be ring-fenced for Research and Development (R&D) in electric aviation and to improve railway connectivity. Suggest this to politicians worldwide."
      },
      {
        "name": "U.K. Double Tree Cover",
        "url": "https://act.friendsoftheearth.uk/petition/tell-uk-government-double-tree-cover",
        "description": "Over the centuries the United Kingdom has cleared its forests, leaving it with some of the lowest levels of woodland in Europe. If the government is serious about protecting the climate, it needs to bring back the lost trees."
      },
      {
        "name": "U.S. Gas-powered car free by 2040",
        "url": "https://www.curbed.com/2019/5/21/18632816/zero-emission-vehicles-act-ban-cars",
        "description": "Federal legislation was proposed in both the House of Representatives and the Senate that could radically shift the way the U.S. tackles its climate crisis. The Zero-Emission Vehicles Act would eliminate the sale of gas-powered passenger cars in the U.S. by 2040."
      },
      {
        "name": "U.S. Save the \"Clean Power Plan\"",
        "url": "https://www.nrdc.org/save-clean-power-plan",
        "description": "Fossil-fueled power plants are responsible for nearly 40 percent of America’s carbon footprint. The Clean Power Plan calls for setting limits on this climate-warming pollution from these power plants, specifically at least 32 percent by 2030, compared to 2005 levels. By 2030, the Clean Power Plan could save the United States $20 billion in climate-related costs and deliver up to $34 billion in health benefits."
      },
      {
        "name": "UK Government: Act now on the Climate Emergency",
        "url": "https://secure.greenpeace.org.uk/page/s/declare-climate-emergency",
        "description": "Now that Parliament has declared a Climate Emergency, we need you to act like it. For starters, that means banning all new oil and gas production in the UK, including fracking, tripling renewable energy by 2030, planting 700 million trees, introducing a Frequent Flyer Tax, ending the sale of all new petrol and diesel cars by 2030, and more."
      },
      {
        "name": "US Damn Removal",
        "url": "https://www.change.org/t/dam-removal-en-us",
        "description": "[70 percent of the dams in the United States](https://www.ussdams.org/our-news/americas-aging-dams-in-need-of-repair/) are now more than 50 years old, with almost 2,000 of them rated as \"high-hazard\". About [1,000 dams have failed](https://apnews.com/75b1cd657f3e4fa3be6adaf968eb7df4) over the past four decades, killing 34 people, and now many are no longer adequate to handle the intense rainfall and floods of a changing climate."
      },
      {
        "name": "Climate Reality",
        "url": "https://climaterealityproject.org",
        "description": "an initiative of former United States vice president and 2007 Nobel Peace Prize laureate Al Gore to make urgent action a necessity to address climate change issues through activism and cutting greenhouse gas emissions."
      }
    ]
  },
  {
    "name": "Reforestation",
    "links": [
      {
        "name": "Arbor Day Foundation",
        "url": "https://www.arborday.org/",
        "description": "The Arbor Day Foundation is a 501(c)(3) nonprofit conservation and education organization. A million members, donors, and partners support our programs to make our world greener and healthier."
      },
      {
        "name": "Bunq Greencard",
        "url": "https://www.bunq.com/easygreen",
        "description": "Dutch online-only bank with a credit card which plants trees for the money you spend."
      },
      {
        "name": "Coforest",
        "url": "https://coforest.co.uk/",
        "description": "To create our first co-forest in the Bath & Bristol area, we’re inviting organisations and individuals to adopt up to an acre of land. You’ll be able to name your forest plot and even help to plant it. Together, we’ll create a whole new forest."
      },
      {
        "name": "DigitalHumani",
        "url": "https://digitalhumani.com",
        "description": "DigitalHumani offers a Reforestation as a Service, to help enterprises plant trees! Run by a volunteer collective, they provide simple Application Programming Interfaces (APIs) to help connect websites and mobile applications to trusted reforestation organizations to have trees planted."
      },
      {
        "name": "Dronecoria",
        "url": "http://dronecoria.org/",
        "description": "Open-source drone reforestation technology. Drones, coupled with native coated seeds, can transform the efficiency with which we restore ecosystems."
      },
      {
        "name": "Droneseed",
        "url": "https://www.droneseed.co/",
        "description": "They plant native trees & vegetation using drone swarms and spray to protect them. Provide valuable insights to customers by collecting data in the field. Work with governments, nonprofits, and private land owners as a service provider."
      },
      {
        "name": "EcoTree",
        "url": "https://ecotree.green/",
        "description": "Support the European forests and reap the benefits. Plant trees as an original and meaningful gift. Building complex, resistant, and multifunctional forests to promote resilience. For every tree harvested, three new ones are planted."
      },
      {
        "name": "Ecologi",
        "url": "https://ecologi.com/?r=5d01f2ed12ae7a358b75fdd7",
        "description": "Help the planet from your sofa, for less than a cheap bottle of wine per month. Watch your own forest come to life and offset your entire footprint for $6.50/€6 per-month. Then get your friends, family, business, and even your dog signed up!"
      },
      {
        "name": "Eden Reforestation Projects",
        "url": "https://edenprojects.org/",
        "description": "Eden Reforestation Projects reduces extreme poverty and restores healthy forests by employing local villagers to plant millions of trees every year."
      },
      {
        "name": "Form Ghana",
        "url": "https://www.formghana.com/",
        "description": "A forest plantation management company based in central Ghana that provides services in the field of reforestation of degraded Forest Reserves and plantation management."
      },
      {
        "name": "Form International",
        "url": "https://www.forminternational.nl/",
        "description": "Form International is a forest management and services company that manages forest assets in Africa and delivers a range of technical and financial services to clients worldwide."
      },
      {
        "name": "Land Life Company",
        "url": "https://landlifecompany.com/",
        "description": "Using drones and automated planting, they plant at scale in urban environments using a fraction of the water. Their mission is to reforest the world’s 2 billion hectares of degraded land."
      },
      {
        "name": "MyClimate",
        "url": "https://myclimate.org/",
        "description": "Helping reduce emissions through a whole bunch of different projects, from consulting companies on their footprint (and helping them to reduce), to education at schools, forest restoration, providing people in Rwanda with efficient cook stoves, and [a whole bunch more](https://www.myclimate.org/information/climate-protection-projects/). Fund them via donations, and use their flight/car/house/company footprint calculators."
      },
      {
        "name": "Reforestum",
        "url": "https://reforestum.com/",
        "description": "Reforestum is an online marketplace to drive reforestation and forest conservation, incentivizing companies and individuals to easily offset their carbon footprint by acquiring and tracking forest shares and carbon credits. Reforestum offers transparency via remote sensing and AI, together with a comprehensible API for seamless integration."
      },
      {
        "name": "Team Trees",
        "url": "https://teamtrees.org/",
        "description": "TeamTrees started in May 2019 when the internet challenged [Mr. Beast](https://twitter.com/MrBeastYT) to plant 20 million trees to commemorate hitting the 20M subscriber milestone. Fans then suggested he band together with a bunch of other YouTubers and influencers to make it happen."
      },
      {
        "name": "Tree-Nation",
        "url": "https://tree-nation.com/",
        "description": "With Tree-Nation you can plant trees everywhere, even in the most remote locations. You will know who is planting your trees, where they are located and how they are being planted."
      },
      {
        "name": "TreeCard",
        "url": "https://www.treecard.org/",
        "description": "TreeCard - The wooden debit card that plants trees."
      },
      {
        "name": "Treedom",
        "url": "https://www.treedom.net/",
        "description": "Treedom lets you buy or gift a real tree, where somebody will plant it for you and follow it online."
      },
      {
        "name": "Trees for the Future",
        "url": "https://trees.org/",
        "description": "TREES plants all sorts of trees and plants, and nearly all of the trees used are either native or naturalized in the environments where they are planted. They partner with farmers to understand their needs and match them with species that will suit their needs and be environmentally benign."
      },
      {
        "name": "Treeware",
        "url": "https://treeware.earth",
        "description": "Loads of open-source developers have a \"Buy me a coffee\" button on their software. Now you can have \"Buy me a tree!\" on your GitHub repository. Get the same \"Yay somebody cares about my work\" AND lessen the existential dread all in one. Powered by [Offset Earth](https://offset.earth/)."
      },
      {
        "name": "WeForest",
        "url": "https://www.weforest.org/",
        "description": "WeForest empowers communities to advance and implement innovative, high standard, scalable and lasting solutions to restore forest landscapes"
      }
    ]
  },
  {
    "name": "Renewable Energy",
    "links": [
      {
        "name": "Big Clean Switch",
        "url": "https://bigcleanswitch.org/",
        "description": "Do energy differently. Switch in minutes to a green electricity tariff from one of the UK's leading suppliers."
      },
      {
        "name": "Community Power",
        "url": "https://communitypower.ie/",
        "description": "Ireland's first community owned electricity supplier which collaborates with Local Sustainable Energy Communities! Whether you are a household, community, business, public or private building, you can switch and buy your electricity from Community Power."
      },
      {
        "name": "Domestic Renewable Heat Incentive (RHI)",
        "url": "https://www.gov.uk/domestic-renewable-heat-incentive",
        "description": "You could get money towards renewable heating costs in your home. You can claim for biomass boilers, solar water heating, heat pumps. Payments are made for 7 years and are based on the amount of renewable heat made by your heating system."
      },
      {
        "name": "Ecotricity",
        "url": "https://www.ecotricity.co.uk/",
        "description": "100% green electricity. They generate 1/5th from their fleet of windmills and sunmills, and buy the rest from other green generators. They also turn our customers’ bills into new sources of green energy, making more green electricity all the time."
      },
      {
        "name": "Electricity Map",
        "url": "https://www.electricitymap.org/",
        "description": "A map showing the energy consumption, renewable penetration and carbon emissions from energy for many countries around the world. If you're country isn't covered you can contribute a data source."
      },
      {
        "name": "Good Energy",
        "url": "https://www.goodenergy.co.uk/",
        "description": "One of the few energy suppliers in the UK to generate renewable power from their own wind and solar farms, and buy renewable power from small independent renewable generators. From local farmers and community energy schemes to sustainable businesses that generate their own power and sell them the excess. A true renewable supplier, not just coal power + offset credits."
      },
      {
        "name": "Green-E",
        "url": "https://www.green-e.org/",
        "description": "Find a renewable energy provider near you. Green-e certified renewable energy and carbon offset products meet the most stringent environmental and consumer protection standards in North America. You can search below for certified green power and renewable energy certificate programs for your home or business, and carbon offset products to offset your emissions from activities like driving and flying. As a third-party certifier, Green-e® doesn't sell renewable energy or offsets, but offers these links to retailers that do."
      },
      {
        "name": "Non-domestic Renewable Heat Incentive (RHI)",
        "url": "https://www.gov.uk/non-domestic-renewable-heat-incentive",
        "description": "The non-domestic Renewable Heat Incentive helps businesses, public sector and non-profit organisations meet the cost of installing renewable heat technologies."
      },
      {
        "name": "Project Sunroof",
        "url": "https://www.google.com/get/sunroof",
        "description": "Find out if you could save money switching to solar panels. This Google project uses Google Earth imagery to analyze your roof shape and local weather patterns to create a personalized solar plan. Adjust your electric bill to fine-tune your savings estimate and the recommended number of solar panels for your home, then compare loan, lease, and purchase options for your solar panels based on your results."
      },
      {
        "name": "SparkMeter",
        "url": "http://www.sparkmeter.io/",
        "description": "Humanitarian smart energy metering solution that purchases wasted unused electricity from utilities and resells it to hard-to-reach places and under served markets, thus reducing overall energy consumption."
      },
      {
        "name": "UK Carbon Intensity",
        "url": "https://carbonintensity.org.uk/",
        "description": "This officially backed open API from Oxford University and the National Grid ESO gives a snapshot of how much carbon each unit of electricity consumed in the UK emits for every half hour. Also carries forecasts, regional breakdowns with some great charts and re-useable widgets. They also have [an app](https://www.cs.ox.ac.uk/people/alex.rogers/gridcarbon/)."
      }
    ]
  },
  {
    "name": "Transportation",
    "links": [
      {
        "name": "Biking vs. Driving Calculator",
        "url": "https://bicycleuniverse.com/car-free-millionaire/",
        "description": "Riding your bike can make you a millionaire! You're paying more for your car than you think. A typical American who goes car-free for 35 years can save nearly a million dollars, even adjusted for inflation, and even if they pay for taxi, bus, and car-share trips often. Use the calculator to find how much you can save in your particular situation."
      },
      {
        "name": "BlaBlaCar",
        "url": "https://www.blablacar.com/",
        "description": "The world’s leading long-distance carpooling platform, which is available in most of Europe and Mexico."
      },
      {
        "name": "British Heart Foundation - Toxic Air Campaign",
        "url": "https://www.bhf.org.uk/toxicair",
        "description": "Air pollution is toxic. Join us in demanding change now. Simply living in the worst hit areas of the UK could be as deadly as smoking over 150 cigarettes each year. British Heart Foundation is calling for the UK Government to update current air quality limits to match World Health Organization recommendations."
      },
      {
        "name": "Change How You Travel from Climate Choice",
        "url": "https://climatechoice.co/change-how-you-travel",
        "description": "26% of the greenhouse gases emitted into our atmosphere are from the production and use of vehicles and airplanes. See what what you can do now, and learn about the benefits of changing your travel."
      },
      {
        "name": "Commute on Electric Bicycles",
        "url": "https://ebiketips.road.cc/content/advice/buyers-guide/9-of-the-best-e-bikes-under-1000-2020-electric-bikes-on-a-budget-2209",
        "description": "Like the idea of cycling but feel like it's a bit far, bit hilly, or no access to a shower at the other end? E-bikes aren't just for the older riders, they've pushed into the mainstream culturally and financially, and are a hell of a lot of fun. Combine it with local \"cycle to work schemes\" listed here for extra savings, some places do [specific deals on e-bikes](https://urbanebikes.com/pages/cycle-to-work-scheme-electric)."
      },
      {
        "name": "Commute on Electric Motorbikes",
        "url": "https://urbanebikes.com/collections/electric-motorbikes",
        "description": "Electric cars are still priced beyond the reach of many, but swapping a car for an electric motorbike will leave plenty of cash in your pocket. The average used car sells for $20,840 in the USA, and you can get a lot of electric motorbike for $3,000. Finding a used electric motorbike will get that manufacturing footprint off your conscience too."
      },
      {
        "name": "Cycle to Work Scheme Ireland",
        "url": "https://www.revenue.ie/en/jobs-and-pensions/taxation-of-employer-benefits/cycle-to-work-scheme.aspx",
        "description": "Under the scheme your employer can buy a bicycle and safety equipment for you, up to €1,000 per bicycle and safety equipment."
      },
      {
        "name": "Cycle to Work Scheme UK",
        "url": "https://www.cyclingweekly.com/news/latest-news/cycle-to-work-scheme-10-things-to-know-5055/amp",
        "description": "This scheme allows employees to spend on bikes and equipment, tax-free, making a claimed saving of up to 42 per cent on the overall value."
      },
      {
        "name": "DHL GoGreen",
        "url": "https://www.dpdhl.com/en/responsibility/environment-and-solutions.html",
        "description": "GoGreen Solutions include both standardized products and customized solutions to help customers develop their own eco-friendly business models and green supply chains. With our carbon reports, climate neutral products, and green optimization, we give customers transparency, offset unavoidable emissions, and identify ways in which our customers can reduce emissions and waste. These optimization measures achieve savings potential that most companies would not be able to achieve on their own."
      },
      {
        "name": "Pod Point",
        "url": "https://pod-point.com",
        "description": "UK leaders in electric vehicle charging with innovative solutions for homes, workplaces and commercial organizations."
      },
      {
        "name": "Poparide",
        "url": "https://www.poparide.com/",
        "description": "Get a ride or fill a seat for rideshares between cities in Canada. Having 3 people in the car can be more efficient than some of their big-ass trains and is 1/5th the impact of flying."
      },
      {
        "name": "Share Now",
        "url": "https://www.share-now.com/",
        "description": "With car-sharing, you don't have to buy or lease a car. Share Now cars are available around every street corner in loads of cities around the world. Find us in 16 major cities in 8 countries in Europe and all over the US – for all your plans, big and small. Includes free parking, no need to pay for maintenance, insurance, or petrol, and loads of them are electric too! Package deals available for businesses to help employees ditch their car when active/public transportation is not an option."
      },
      {
        "name": "TomTom's EV Station Finder",
        "url": "https://www.tomtom.com/products/ev-charging-availability-routing-services/",
        "description": "With TomTom's EV charging infrastructure, 'eco-routing' to calculate energy efficient routes (!), in-range EV station finder, real-time availability monitoring, on-demand information, TomTom is continuing to invest in the largest electric vehicle map coverage with 330,000+ charging points in 50 countries throughout Europe, The Americas, the Middle East, and Asia."
      },
      {
        "name": "VanMoof",
        "url": "https://www.vanmoof.com/",
        "description": "\"City-proof\" bikes, with electric assist, which ship fully assembled. They're baked full of anti-theft tech, and they'll hunt your bike down if it does get stolen. In some countries there is a subscription service where they'll fix things up for you if you have any trouble, but just the base bike alone is a stunning beautiful electric bike with dynamo hubs, built in lights, and sturdy mudguards, so you can ride it all day and night."
      },
      {
        "name": "WageWorks Bicycle Reimbursement Program",
        "url": "https://www.wageworks.com/employees/lifestyle-benefits-programs/bicycle-reimbursement-program/",
        "description": "Ride your bike to work and pay for eligible bike-related expenses, and then get reimbursed for those expenses."
      },
      {
        "name": "Waze Carpool",
        "url": "https://www.waze.com/carpool",
        "description": "Choose to drive or ride, and match with people based on route and time of day."
      },
      {
        "name": "Workhorse - Electric Delivery Vehicles",
        "url": "https://workhorse.com/",
        "description": "All-electric by design, with composite technology, and a 100-mile range, it's expected to be more economical than traditional delivery vans. Our current delivery vans, E-100 and E-GEN, have more than 4 million miles on them and are used by some of the premier package delivery companies in the world."
      }
    ]
  },
  {
    "name": "Travel",
    "links": [
      {
        "name": "BlaBlaCar",
        "url": "https://www.blablacar.com/",
        "description": "The world’s leading long-distance carpooling platform, which is available in most of Europe and Mexico."
      },
      {
        "name": "Change How You Travel from Climate Choice",
        "url": "https://climatechoice.co/change-how-you-travel",
        "description": "26% of the greenhouse gases emitted into our atmosphere are from the production and use of vehicles and airplanes. See what what you can do now, and learn about the benefits of changing your travel."
      },
      {
        "name": "EcoBnB",
        "url": "https://ecobnb.com/",
        "description": "Find accommodation for a trip with a focus on sustainability. Most locations get their electricity from renewable sources, you wont find loads of single-use plastics, they recycle more than 80% of their waste, etc."
      },
      {
        "name": "Flight Free (UK)",
        "url": "https://flightfree.co.uk/",
        "description": "Aviation is the fastest growing contributor to greenhouse gas emissions at a time when we desperately need to reduce them. Pledge to go flight free in 2020."
      },
      {
        "name": "Flight Free (USA)",
        "url": "https://flightfreeusa.org/",
        "description": "A grassroots campaign which asks people to agree not to fly in the year of 2020 – on condition that 100,000 others will also pledge to do the same."
      },
      {
        "name": "Green Tickets",
        "url": "https://greentickets.app/",
        "description": "Traveling is amazing, right? We completely agree! But you probably know that traveling can have a large climate impact. With Green Tickets you can take responsibility of your travel behaviour and reduce your footprint, while still enjoying everything that traveling has to offer."
      },
      {
        "name": "Home Exchange",
        "url": "https://www.homeexchange.com/",
        "description": "Swap homes with another family instead of spending money at a fancy hotel, as hotels have a much higher footprint due to the constant cleaning, overactive AC, etc."
      },
      {
        "name": "Maris - Freighter Cruises",
        "url": "http://www.freightercruises.com/",
        "description": "These giant freight ships are not running on renewable energy, but if you need to cross an ocean this is the way to do it. Europe to North America, England to Australia, Shanghai to Argentina. It's slower, but your carbon footprint will be saved."
      },
      {
        "name": "Poparide",
        "url": "https://www.poparide.com/",
        "description": "Get a ride or fill a seat for rideshares between cities in Canada. Having 3 people in the car can be more efficient than some of their big-ass trains and is 1/5th the impact of flying."
      },
      {
        "name": "Responsible Vacation",
        "url": "https://www.responsiblevacation.com/",
        "description": "A travel company who run sustainable trips all over the world. Sail from Scotland to Iceland, cycle across Vietnam, hike in Peru. Admittedly some of these trips will require a flight to get there, but one trip a year (or alternative years) is probably reasonable. At least when you get there, these vacations will be helping and protecting local nature, wildlife and culture."
      },
      {
        "name": "Restons Les Pieds Sur Terre",
        "url": "https://www.facebook.com/restonslespiedssurterre/",
        "description": "Aviation is the fastest growing contributor to greenhouse gas emissions at a time when we desperately need to reduce them. Pledge to go flight free in 2020."
      },
      {
        "name": "Rome2rio",
        "url": "https://rome2rio.com/",
        "description": "Search any city, town, landmark, or address across the globe and find a whole bunch of different ways to get there. Rome2rio is pretty insistent on showing you flights, but it can help you find bus and train combinations to get from Lisbon to Azerbaijan if that's a trip you need to do."
      },
      {
        "name": "Rubicon 3",
        "url": "https://www.rubicon3.co.uk/",
        "description": "Join the crew of one of our sailing expeditions for one of the greatest adventures you can have. Sail from country to country, exploring the world’s most awe-inspiring areas. Learn to sail as you go from inspiring instructors. Make landfall and explore ashore far from the beaten track."
      },
      {
        "name": "Seat61",
        "url": "https://www.seat61.com/",
        "description": "Train travel is a more rewarding, low-stress alternative to flying, which brings us closer to the countries we visit and reduces our contribution to climate change. It's time to rediscover the pleasure, romance & adventure of travel by train or ship. This site explains how to travel comfortably & affordably by train or ferry where you might think air was now the only option. For help with train travel, ask the Man in Seat 61!"
      },
      {
        "name": "Slow Travel (Langsamreisen)",
        "url": "https://www.langsamreisen.de/",
        "description": "A travel company all about sustainable and conscious travel. Piggy back on a cargo ship to get to that new job on the other side of the world. Sailing trips to get around without a footprint. Maybe take the trans-siberian railway."
      },
      {
        "name": "Snow Carbon",
        "url": "http://snowcarbon.co.uk/",
        "description": "Wish you could avoid airport queues, tedious transfers and long drives? Want to travel sustainably and enjoyably by train instead - to fantastic accommodation in the best ski resorts in the Alps? Snowcarbon is an independent guide founded by ski journalist Daniel Elkan to help you do exactly that."
      },
      {
        "name": "Stay Grounded",
        "url": "https://stay-grounded.org/",
        "description": "A global network of more than 150 member organisations, among them local airport opposition and climate justice groups, NGOs, trade unions, initiatives fostering alternatives to aviation like night trains, and organisations supporting communities which struggle against offset projects or biofuel plantations"
      },
      {
        "name": "Tentrr",
        "url": "https://www.tentrr.com/",
        "description": "AirBnB for camping, with fully setup glamping sites to natural land where you bring your own gear. Land conservation is expensive. With Tentrr Landtrust, your qualifying trust can receive a professionally installed, fully equipped signature campsite. It's an instant revenue generator for your conservation efforts."
      },
      {
        "name": "The Travel Foundation",
        "url": "https://www.thetravelfoundation.org.uk/",
        "description": "Find hotels here which aren't all plastic all the time, amongst other things. This charity brings together travel businesses, suppliers, community groups, governments, local authorities and more to develop practical solutions which maximise the benefits and minimise the negative impacts of tourism in destinations."
      }
    ]
  },
  {
    "name": "Volunteering",
    "links": [
      {
        "name": "Citizens Climate Lobby",
        "url": "https://citizensclimatelobby.org/",
        "description": "If you’re an English, economics or poly sci major, you probably should consider volunteering for Citizens’ Climate Lobby, an organization focused on confronting climate change through policy."
      },
      {
        "name": "Clean Trails",
        "url": "https://www.cleantrails.org/join",
        "description": "Step by step, and little by little, our aim is to eliminate waste on all the trails that grace our public lands.  We believe we can do that in a positive and proactive manner by educating, encouraging, and reconnecting outdoor users to our pristine places."
      },
      {
        "name": "ClimateAction.Tech",
        "url": "https://climateaction.tech/",
        "description": "A global community of tech professionals using our skills, expertise and platforms to support solutions to the climate crisis. The mission is to empower technology professionals to play our part — to meet, discuss, learn and take climate action."
      },
      {
        "name": "ClimatePrediction.net",
        "url": "https://www.climateprediction.net/",
        "description": "The world’s largest climate modelling experiment. Evidence of how our climate is changing is vital to reducing greenhouse gas emissions.  Help discover how the climate could look by running software on your computer."
      },
      {
        "name": "Economists for Future",
        "url": "https://econ4future.org/",
        "description": "Economists for Future growing movement of people committed to galvanising the economics community behind addressing the greatest challenge of our day. If the discipline which dedicates itself to studying the economy cannot sufficiently engage in the economic transformation that the climate science requires, then who else can be expected to do this?"
      },
      {
        "name": "Extinction Rebellion",
        "url": "https://rebellion.global/",
        "description": "Extinction Rebellion is a decentralised, international and politically non-partisan movement using non-violent direct action and civil disobedience to persuade governments to act justly on the Climate and Ecological Emergency."
      },
      {
        "name": "Eyes of the Reef Hawai'i",
        "url": "https://eorhawaii.org/2013/07/18/become-a-member/",
        "description": "Network to inform, engage and train people to identify coral bleaching, disease and invasive species outbreaks. They have a broad outreach program that helps to provide critical training for rapid response monitoring and stewardship of precious marine resources."
      },
      {
        "name": "Greenpeace",
        "url": "https://engage.us.greenpeace.org/onlineactions/Hx3BaZLxxkyUUo2Jfzsk7w2",
        "description": "Greenpeace has many ways for people to get involved. Start small by launching and participating in campaigns and petitions, or go further and discover or create events. Play an active role in achieving a green and peaceful future!"
      },
      {
        "name": "Habitat for Humanity",
        "url": "http://www.habitat.org/getinv",
        "description": "Habitat for Humanity is well known for building simple, affordable homes for people in need. But recently the organization has implemented new programs recognizing climate change as a major threat to the environment and which can destroy the homes they build."
      },
      {
        "name": "MakeSense Jobs",
        "url": "https://jobs.makesense.org",
        "description": "Makesense inspires and empowers citizens, entrepreneurs and organizations to build an inclusive and sustainable society together.  MakeSense's Job and assignment announcements platform for associations and social entrepreneurs who recruit profiles passionate about the impact. Job types include internship, freelance, civic service, partner, program, volunteer mission, mentoring."
      },
      {
        "name": "Oceanic Society",
        "url": "https://www.oceanicsociety.org/",
        "description": "Oceanic Society was founded in 1969 by a group of San Francisco Bay Area sailors and scientists who were concerned about the state of the oceans and decided to take action. Inspired by the events of their day—like the Santa Barbara oil spill of 1969, the publication of Rachel Carson's Silent Spring, and growing public concern for the environment—they came together to form Oceanic Society, the first non-profit organization in America dedicated to marine conservation. Their aim was to bring greater public awareness and political action to issues of ocean health and to grow the global community of people working toward improved ocean stewardship. Oceanic Society helped put ocean conservation on the public radar. Some of our many accomplishments include: Creating the Oceanic Society Patrol and Farallon Patrol, pioneering ecotourism and volunteer vacations, inspiring a generation of ocean lovers through Oceans magazine, Leading the way in whale watching, strengthening local sea turtle conservation, globally and innovating a focus on behavior change."
      },
      {
        "name": "Precious Plastic",
        "url": "https://preciousplastic.com/",
        "description": "Open-source community who share instructions for creating plastic shredders, injectors, and sheet presses, so you can create anything you want from used plastic. Collect plastic from neighbors, clean it, shred it, [3D print a mold](https://pinshape.com/blog/low-cost-injection-molding-using-3d-printing/), and create anything you can imagine! You can [buy the machines](https://preciousplastic.com/solutions/machines/overview.html) too if making them is out of your wheelhouse."
      },
      {
        "name": "Take Climate Action",
        "url": "https://takeclimateaction.uk/",
        "description": "Climate Action groups are made up of people like you and together they’ll bring about big systemic change. Join the network and kick-start climate action in your community."
      },
      {
        "name": "Tell Microsoft to End Big Oil Contracts",
        "url": "https://engage.us.greenpeace.org/onlineactions/Hx3BaZLxxkyUUo2Jfzsk7w2",
        "description": "Right now, while our planet speeds toward the brink of the climate crisis, Microsoft is putting its foot on the accelerator. As oil and gas profits continue to fall, giant oil corporations have turned to cloud computing and artificial intelligence (AI) to answer their problems. Microsoft promises companies like ExxonMobil that its analytical tools and other AI technologies will help them discover and pump even more oil at a lower cost. This Greenpeace petition will let Microsoft know this is not acceptable."
      },
      {
        "name": "Transition Network",
        "url": "https://transitionnetwork.org",
        "description": "A global movement of communities coming together to reimagine and actively rebuild our world. The terms transition town, transition initiative and transition model refer to grassroot community projects that aim to increase self-sufficiency to reduce the potential effects of peak oil, climate destruction, and economic instability."
      },
      {
        "name": "Tree Folks",
        "url": "https://www.treefolks.org/volunteer/",
        "description": "Tree planting and tree care events around Austin, Texas, from October to April."
      },
      {
        "name": "Woodland Trust",
        "url": "https://www.woodlandtrust.org.uk/",
        "description": "The Woodland Trust is reforesting the United Kingdom, working with communities, local authorities, and land owners, to get trees in the ground."
      },
      {
        "name": "World Cleanup Day",
        "url": "https://www.worldcleanupday.org/",
        "description": "World Cleanup Day is a civic movement, uniting 180 countries and millions of people across the world to clean up the planet. In one day. Volunteers and partners worldwide come together to rid our planet of trash – cleaning up litter and mismanaged waste from our beaches, rivers, forests, and streets."
      }
    ]
  },
  {
    "name": "Waste",
    "links": [
      {
        "name": "Algramo",
        "url": "https://www.algramoalmacenes.com/",
        "description": "Vending machines and mobile refill units for refilling reusable plastic bottles with staple goods from shampoo to salad dressing in packaging that is designed to be returned, cleaned, and reused.  With over 2,000 bodegas in Santiago and plans to expand in the US soon, Algramo, translates to \"by the gram\", also solves the issue of \"poverty tax\" where small packages can cost as much as 50% more than the same product in a larger size."
      },
      {
        "name": "Bio Bean",
        "url": "https://www.bio-bean.com/",
        "description": "The world’s largest recycler of coffee grounds, Bio Bean recycle spent coffee grounds into sustainable products, like coffee logs for fires, and other biomass fuel."
      },
      {
        "name": "Bio-plastic Trash Bags",
        "url": "https://www.amazon.com/Plant-Based-Kitchen-Handles-Gallon/dp/B071JMFKM5/",
        "description": "Made from Plant Based (sugar cane) materials instead of fossil fuel."
      },
      {
        "name": "Blue Jeans Go Green",
        "url": "https://bluejeansgogreen.org/",
        "description": "Send in your used jeans to get transformed into natural cotton fiber insulation, some of which is used to help with building efforts around the country."
      },
      {
        "name": "Boulder Food Rescue",
        "url": "https://www.boulderfoodrescue.org/",
        "description": "We facilitate the sustainable redistribution of healthy food that would otherwise be wasted to low-income communities, by bicycle. We work with communities to facilitate their own food redistribution and create decentralized systems to bypass barriers to food access. Our work envisions a world in which everyone has equitable access to healthy food."
      },
      {
        "name": "Burying Food Scraps",
        "url": "https://www.youtube.com/watch?v=yQFB9M2UdK0",
        "description": "Composting can be time consuming, expensive, and if done incorrectly it can actually produce a lot of methane. If you've got a bit of space in your garden, this video shows how simply burying food scraps can be a quick and simple solution to get rid of waste and improve soil quality too."
      },
      {
        "name": "Circular Berlin",
        "url": "http://circular.berlin/",
        "description": "A Berlin based non-profit developing the local circular economy agenda through research, community-building and practical programmes. Good overview of events and initiatives happening in Berlin."
      },
      {
        "name": "City Harvest",
        "url": "https://www.cityharvest.org/",
        "description": "City Harvest is New York City’s largest food rescue organization. They rescue food and deliver it to hundreds of food pantries, soup kitchens and other community partners."
      },
      {
        "name": "Clean Cult",
        "url": "https://cleancult.pvzi.net/qq4kq",
        "description": "Cleaning supplies with zero-waste packaging, and a powerful clean that's better for you and the planet."
      },
      {
        "name": "Donate Toys",
        "url": "https://www.moneycrashers.com/where-donate-used-toys/",
        "description": "Donate toys that your children have grown out of instead of throwing them away."
      },
      {
        "name": "EU: Right to Repair",
        "url": "https://repair.eu/",
        "description": "Cracked screens, weak batteries, broken charging ports... We’d like to fix them, but instead we end up buying a new smartphone because repairs are too expensive, difficult or impossible. Reducing the lifespan of a product may drive sales, but this comes at the expense of consumers, workers and the planet. Ask the European Union to give people the Right to Repair by requiring manufacturers to design repairable smartphones and provide spare parts and repair information to all repairers and consumers."
      },
      {
        "name": "Food Cloud",
        "url": "https://food.cloud/",
        "description": "FoodCloud is a social enterprise that connects businesses with surplus food to charities in their local communities that need it via a software platform."
      },
      {
        "name": "Geev",
        "url": "https://corporate.geev.com/",
        "description": "An online application to exchange stuffs and food between people. Easily discuss, meet and give a second life to objects and food.  The more you give the more people trust you when you want to get something."
      },
      {
        "name": "GrowNYC Food Scrap Collection Schedule",
        "url": "https://www.grownyc.org/compost/locations",
        "description": "Interactive map with over 150 residential Food Scrap Drop-Off sites in NYC."
      },
      {
        "name": "Kaiyo",
        "url": "https://kaiyo.com/",
        "description": "Buy and sell used furniture to keep it out of landfill. They'll even come and pick it up! _I've used this to get rid of a giant sofa which nobody wanted to buy, it was about to go on the street and they got me a cheque._"
      },
      {
        "name": "Karma",
        "url": "https://new.karma.life/",
        "description": "A Swedish company that lets restaurants sell surplus food at a lower price. It lets you pay less for food and prevent food waste."
      },
      {
        "name": "Litterati",
        "url": "https://www.litterati.org/",
        "description": "Empowering people to clean the planet. Photograph a piece of litter, tag it, and discard properly.  Participate in a challenge and hold wasteful brands accountable."
      },
      {
        "name": "No Food Wasted",
        "url": "http://www.nofoodwasted.com/",
        "description": "NoFoodWasted maps products that reach the best before date and shows where and how much you can save. Download the app, select a provider near you and start saving today."
      },
      {
        "name": "Olio",
        "url": "https://olioex.com/",
        "description": "We connect neighbors to share food, and other things, rather than chuck them away."
      },
      {
        "name": "Open Circularity",
        "url": "https://opencircularity.info/",
        "description": "Lars Zimmermann runs Mifactori Design & Activism Studio in Berlin. This website is where he shares content & thoughts on Open Source Circularity. General idea is - open source all products, allowing them to be repaired or repurposed if they break rather than ending up in landfill."
      },
      {
        "name": "OpenStreetMap: Zero Waste (Overpass)",
        "url": "http://overpass-turbo.eu/?template=key&key=zero_waste",
        "description": "OpenStreetMap has the tag zero_waste=* for shops who sell items without packaging."
      },
      {
        "name": "Original Unverpackt",
        "url": "https://original-unverpackt.de/",
        "description": "Zero packaging supermarket in Berlin. Original Unverpackt hat sich als erster Supermarkt weltweit dem Zero-Waste-Lifestyle gewidmet."
      },
      {
        "name": "Pieter Pot",
        "url": "https://www.pieter-pot.nl/",
        "description": "Your groceries, delivered without packaging. Pieter Pot delivers your groceries with a cargo bike in beautiful glass jars in The Netherlands. Empty pot? Then we fill it again. This is how we make it fun and easy to do shopping without all those unnecessary (plastic) packaging. That's nice, right?"
      },
      {
        "name": "Precious Plastic",
        "url": "https://preciousplastic.com/",
        "description": "Open-source community who share instructions for creating plastic shredders, injectors, and sheet presses, so you can create anything you want from used plastic. Collect plastic from neighbors, clean it, shred it, [3D print a mold](https://pinshape.com/blog/low-cost-injection-molding-using-3d-printing/), and create anything you can imagine! You can [buy the machines](https://preciousplastic.com/solutions/machines/overview.html) too if making them is out of your wheelhouse."
      },
      {
        "name": "Pure Waste",
        "url": "https://www.purewaste.org/",
        "description": "Helsinki based, making 100% recycled clothing out of waste materials."
      },
      {
        "name": "Recycle Now",
        "url": "https://www.recyclenow.com/",
        "description": "Find out where to recycle pretty much anything, including aerosols, old mobile phones, soft plastics, and get advice on how to reduce waste too."
      },
      {
        "name": "ReNu Furniture",
        "url": "https://renufurniture.co.uk/",
        "description": "Prevent landfill waste and buy second-hand, upcycled and handmade furniture easily with ReNu Furniture. Based in Brighton and covering the UK southeast, this start up will manage the collection, delivery and payments for every furniture sale - they even plant a tree for every delivery to offset carbon emissions."
      },
      {
        "name": "Repair Café",
        "url": "https://repaircafe.org/",
        "description": "Repair Cafés are free meeting places and they’re all about repairing things (together). You’ll find tools and materials to help you make any repairs to clothes, furniture, electrical appliances, bicycles, crockery, appliances, toys, et cetera. You’ll also find expert volunteers, with repair skills in all kinds of fields. Repair your stuff, or just enjoy a coffee. They're world-wide, and the site is multi-lingual."
      },
      {
        "name": "Rethink Food NYC",
        "url": "https://www.rethinkfood.nyc/",
        "description": "They pick up unused, excess food from restaurants, farms, and other food purveyors, and re-purpose it into delicious and nutritious meals for under-served New Yorkers."
      },
      {
        "name": "Sonny",
        "url": "https://www.indiegogo.com/projects/sonny-a-portable-bidet-for-eco-conscious-humans/x/17318484#/",
        "description": "Never worry about running out of toilet paper again with Sonny, a sustainable alternative to wipes and paper for better hygiene and a greener planet."
      },
      {
        "name": "The Rotten Fruit Box",
        "url": "https://therottenfruitbox.com/",
        "description": "100% Natural Freeze-Dried Fruit Snacks from Spain and Portugal shipped to you. The fruit you’re enjoying would have otherwise gone unused and rotted away on the ground. We also think that the name \"Rotten\" helps bring attention to the serious issue of food waste. Delicious, healthy, 100% natural, with a long shelf life, our freeze dried fruit snack pouches are ideal for home, work, office, to take to school, camping or just about anywhere. Help reduce food waste. Help small local farmers. 100% compostable packaging, ships with your local postal service because it is the lowest carbon footprint option."
      },
      {
        "name": "Too Good To Go",
        "url": "https://toogoodtogo.co.uk/",
        "description": "Sell your surplus food, easily and sustainably! Save delicious food and fight food waste. Find your favorite food and go rescue it."
      },
      {
        "name": "Vegware",
        "url": "https://vegware.co.uk/",
        "description": "Napkins, carrier bags, salad boxes, sushi trays, cutlery, disposable coffee cups, all made from plants using renewable, lower carbon, recycled or reclaimed materials, and designed to be commercially compostable with food waste, where accepted."
      },
      {
        "name": "What is my lamp worth?",
        "url": "https://www.watismijnlampwaard.nl/",
        "description": "Find the nearest collection points for discarded electrical appliances and energy-efficient light bulbs. This site helps you responsibly recycle, donate, repair, or sell electrical appliances and lights."
      }
    ]
  },
  {
    "name": "YouTube Channels",
    "links": [
      {
        "name": "Climate Town",
        "url": "https://www.youtube.com/channel/UCuVLG9pThvBABcYCm7pkNkA",
        "description": "Rollie Williams and a ragtag team of climate communicators, creatives and comedians are here to examine climate change in a way that doesn’t make you want to eat a cyanide pill."
      },
      {
        "name": "ClimateAdam",
        "url": "https://www.youtube.com/user/ClimateAdam",
        "description": "Doctor in climate science from Oxford. Trying to make sense of climate change with fun YouTube vids."
      },
      {
        "name": "Hot Mess",
        "url": "https://www.youtube.com/channel/UCsaEBhRsI6tmmz12fkSEYdw",
        "description": "A show about how climate change impacts all of us, and about how we can create a better future for our planet and ourselves. Hosted by Miriam Nielsen, Talia Buford, and Joe Hanson."
      },
      {
        "name": "Our Changing Climate",
        "url": "https://www.youtube.com/channel/UCNXvxXpDJXp-mZu3pFMzYHQ",
        "description": "A bi-weekly video essay series that investigates humanity's relationship to the natural world."
      },
      {
        "name": "Simon Clark",
        "url": "https://www.youtube.com/user/SimonOxfPhys",
        "description": "PhD in climate physics by day, YouTuber by night. He makes videos about both!"
      }
    ]
  },
  {
    "name": "Zero Waste",
    "links": [
      {
        "name": "Berkley Water Filters",
        "url": "https://www.berkeyfilters.com/",
        "description": "21,000,000 Americans drink water that violates U.S. health standards. Berkey water filter systems are actually water purifiers because they remove bacteria and viruses that conventional filters cannot."
      },
      {
        "name": "Kent Zero Water Wastage Technology",
        "url": "https://www.kent.co.in/water-purifiers/zero-water-wastage-technology",
        "description": "KENT RO Purifiers equipped with the ‘Zero Water Wastage’ Technology push back the rejected water to the overhead tank, thereby rendering wastage to zero. As a result, instead of wasting the rejected water, it gets diluted and reused as normal tap water for household purposes."
      }
    ]
  }
];