# Flappy Monorepo

[English](./README.md) | [简体中文](./README.zh-Hans.md) | 日本語

このモノレポは、さまざまなプログラミング言語で実装されたすべてのFlappyライブラリを集約しています。Flappyは、大規模言語モデル（LLM）を使用するAIアプリケーションとエージェントの作成を効率化するために開発されたライブラリです。

## 概要

Flappyは、さまざまなセクターで増え続けるLLMベースのAIアプリケーションの需要を満たすように慎重に設計されています。私たちの目標は、LLMの入力と出力を管理し、**制御された**、一貫性のある、機械可読なデータを提供するライブラリを提供することです。

Flappyの特徴は、抽象クラスをJSON Schemaスキーマに変換する能力です。ユーザーは、Java、Python、PHP、またはTypeScriptなどの好みのプログラミング言語でこれらのクラスを定義できます。これらの定義には、型と関数のシグネチャが含まれます。

機械の可読性を高め、相互運用性を維持するために、FlappyはLLMの出力に対してAST（抽象構文木）の解析を行います。このプロセスにより、生成されたJSONデータが定義されたJSON Schemaスキーマに厳密に準拠することを保証します。プログラミング言語の柔軟性とJSON Schemaの標準化を統合することで、FlappyはAIアプリケーション開発を新たな信頼性と効率性のレベルへと推進します。

Flappyは、OpenAIのCode Interpreterに似た機能も提供します。これは、LLMによって生成されたPythonまたはTypeScriptのコードを**本番環境で安全にサンドボックス化**して実行します。この戦略は、AI生成コードの実行に安全な環境を提供し、ランタイムエラーや潜在的なセキュリティ問題のリスクを最小限に抑えます。

最後に、Flappyは異なるLLMのための抽象化レイヤーを提供し、ユーザーが**異なるLLM間で簡単に切り替える**ことを可能にします。ユーザーは、アプリケーションの安定性を確保するために、フォールバックとしてのLLMを指定することもできます。

## はじめに

Flappyを始めるためには、以下のリストから好みの言語実装を選んでください：

- [Node.js](./packages/nodejs/README.md)
- [Kotlin&Java](./packages/kotlin/README.md)
- Ruby (近日公開)
- PHP (近日公開)
- [C#](./packages/csharp/README.md)
- Go (近日公開)
- Python (近日公開)

## 貢献

コミュニティからの貢献を大歓迎します！詳細は、私たちの[貢献ガイドライン](./CONTRIBUTING.md)を参照してください。

## ライセンス

このプロジェクトは[Apache License 2.0](./LICENSE)の下で提供されています。Copyright (c) 2023 Pleisto Inc.
