<!-- Thank you for contributing to Pydantic AI! -->

<!-- Please add the issue number that should be closed when this PR is merged. -->
<!-- If there is no issue, please create one first, even for simple bug fixes. -->

- Closes #<issue>

### Pre-Review Checklist

<!-- These checks need to be completed before a PR is reviewed, -->
<!-- but you can submit a draft early to indicate that the issue is being worked on. -->

- [ ] Any **AI generated code** has been reviewed line-by-line by the human PR author, who stands by it.
- [ ] No **breaking changes** in accordance with the [version policy](https://github.com/pydantic/pydantic-ai/blob/main/docs/version-policy.md).
- [ ] **Linting and type checking** pass per `make format` and `make typecheck`.
- [ ] **PR title** is fit for the [release changelog](https://github.com/pydantic/pydantic-ai/releases).

### Pre-Merge Checklist

<!-- These checks need to be completed before a PR is merged, -->
<!-- but as PRs often change significantly during review, -->
<!-- it's OK for them to be incomplete when review is first requested. -->

- [ ] New **tests** for any fix or new behavior, maintaining 100% coverage.
- [ ] Updated **documentation** for new features and behaviors, including docstrings for API docs.
