from importlib.metadata import version as _metadata_version

from .agent import (
    Agent,
    CallToolsNode,
    EndStrategy,
    InstrumentationSettings,
    ModelRequestNode,
    UserPromptNode,
    capture_run_messages,
)
from .builtin_tools import (
    CodeExecutionTool,
    FileSearchTool,
    ImageGenerationTool,
    MCPServerTool,
    MemoryTool,
    UrlContextTool,  # pyright: ignore[reportDeprecated]
    WebFetchTool,
    WebSearchTool,
    WebSearchUserLocation,
)
from .embeddings import (
    Embedder,
    EmbeddingModel,
    EmbeddingResult,
    EmbeddingSettings,
)
from .exceptions import (
    AgentRunError,
    ApprovalRequired,
    CallDeferred,
    FallbackExceptionGroup,
    IncompleteToolCall,
    ModelAPIError,
    ModelHTTPError,
    ModelRetry,
    UnexpectedModelBehavior,
    UsageLimitExceeded,
    UserError,
)
from .format_prompt import format_as_xml
from .messages import (
    AgentStreamEvent,
    AudioFormat,
    AudioMediaType,
    AudioUrl,
    BaseToolCallPart,
    BaseToolReturnPart,
    BinaryContent,
    BinaryImage,
    BuiltinToolCallPart,
    BuiltinToolReturnPart,
    CachePoint,
    DocumentFormat,
    DocumentMediaType,
    DocumentUrl,
    FilePart,
    FileUrl,
    FinalResultEvent,
    FinishReason,
    FunctionToolCallEvent,
    FunctionToolResultEvent,
    HandleResponseEvent,
    ImageFormat,
    ImageMediaType,
    ImageUrl,
    ModelMessage,
    ModelMessagesTypeAdapter,
    ModelRequest,
    ModelRequestPart,
    ModelResponse,
    ModelResponsePart,
    ModelResponsePartDelta,
    ModelResponseStreamEvent,
    MultiModalContent,
    PartDeltaEvent,
    PartEndEvent,
    PartStartEvent,
    RetryPromptPart,
    SystemPromptPart,
    TextPart,
    TextPartDelta,
    ThinkingPart,
    ThinkingPartDelta,
    ToolCallPart,
    ToolCallPartDelta,
    ToolReturn,
    ToolReturnPart,
    UserContent,
    UserPromptPart,
    VideoFormat,
    VideoMediaType,
    VideoUrl,
)
from .output import NativeOutput, PromptedOutput, StructuredDict, TextOutput, ToolOutput
from .profiles import (
    DEFAULT_PROFILE,
    InlineDefsJsonSchemaTransformer,
    JsonSchemaTransformer,
    ModelProfile,
    ModelProfileSpec,
)
from .run import AgentRun, AgentRunResult, AgentRunResultEvent
from .settings import ModelSettings
from .tools import DeferredToolRequests, DeferredToolResults, RunContext, Tool, ToolApproved, ToolDefinition, ToolDenied
from .toolsets import (
    AbstractToolset,
    ApprovalRequiredToolset,
    CombinedToolset,
    ExternalToolset,
    FilteredToolset,
    FunctionToolset,
    PrefixedToolset,
    PreparedToolset,
    RenamedToolset,
    ToolsetFunc,
    ToolsetTool,
    WrapperToolset,
)
from .usage import RequestUsage, RunUsage, UsageLimits

__all__ = (
    '__version__',
    # agent
    'Agent',
    'EndStrategy',
    'CallToolsNode',
    'ModelRequestNode',
    'UserPromptNode',
    'capture_run_messages',
    'InstrumentationSettings',
    # embeddings
    'Embedder',
    'EmbeddingModel',
    'EmbeddingSettings',
    'EmbeddingResult',
    # exceptions
    'AgentRunError',
    'CallDeferred',
    'ApprovalRequired',
    'ModelRetry',
    'ModelAPIError',
    'ModelHTTPError',
    'FallbackExceptionGroup',
    'IncompleteToolCall',
    'UnexpectedModelBehavior',
    'UsageLimitExceeded',
    'UserError',
    # messages
    'AgentStreamEvent',
    'AudioFormat',
    'AudioMediaType',
    'AudioUrl',
    'BaseToolCallPart',
    'BaseToolReturnPart',
    'BinaryContent',
    'BuiltinToolCallPart',
    'BuiltinToolReturnPart',
    'CachePoint',
    'DocumentFormat',
    'DocumentMediaType',
    'DocumentUrl',
    'FileUrl',
    'FilePart',
    'FinalResultEvent',
    'FinishReason',
    'FunctionToolCallEvent',
    'FunctionToolResultEvent',
    'HandleResponseEvent',
    'ImageFormat',
    'ImageMediaType',
    'ImageUrl',
    'BinaryImage',
    'ModelMessage',
    'ModelMessagesTypeAdapter',
    'ModelRequest',
    'ModelRequestPart',
    'ModelResponse',
    'ModelResponsePart',
    'ModelResponsePartDelta',
    'ModelResponseStreamEvent',
    'MultiModalContent',
    'PartDeltaEvent',
    'PartEndEvent',
    'PartStartEvent',
    'RetryPromptPart',
    'SystemPromptPart',
    'TextPart',
    'TextPartDelta',
    'ThinkingPart',
    'ThinkingPartDelta',
    'ToolCallPart',
    'ToolCallPartDelta',
    'ToolReturn',
    'ToolReturnPart',
    'UserContent',
    'UserPromptPart',
    'VideoFormat',
    'VideoMediaType',
    'VideoUrl',
    # profiles
    'ModelProfile',
    'ModelProfileSpec',
    'DEFAULT_PROFILE',
    'InlineDefsJsonSchemaTransformer',
    'JsonSchemaTransformer',
    # tools
    'Tool',
    'ToolDefinition',
    'RunContext',
    'DeferredToolRequests',
    'DeferredToolResults',
    'ToolApproved',
    'ToolDenied',
    # toolsets
    'AbstractToolset',
    'ApprovalRequiredToolset',
    'CombinedToolset',
    'ExternalToolset',
    'FilteredToolset',
    'FunctionToolset',
    'PrefixedToolset',
    'PreparedToolset',
    'RenamedToolset',
    'ToolsetFunc',
    'ToolsetTool',
    'WrapperToolset',
    # builtin_tools
    'CodeExecutionTool',
    'FileSearchTool',
    'ImageGenerationTool',
    'MCPServerTool',
    'MemoryTool',
    'UrlContextTool',
    'WebFetchTool',
    'WebSearchTool',
    'WebSearchUserLocation',
    # output
    'ToolOutput',
    'NativeOutput',
    'PromptedOutput',
    'TextOutput',
    'StructuredDict',
    # format_prompt
    'format_as_xml',
    # settings
    'ModelSettings',
    # usage
    'RunUsage',
    'RequestUsage',
    'UsageLimits',
    # run
    'AgentRun',
    'AgentRunResult',
    'AgentRunResultEvent',
)
__version__ = _metadata_version('pydantic_ai_slim')
