#!/bin/sh

whereami=$(dirname $0)

if [ ! -f "/etc/rpm/macros.dist" ] && \
   [ ! -f "/etc/rpm/macros.disttag" ];   then echo "please install 'buildsys-macros' rpm and try again" ; exit 1 ; fi
if [ ! -f "$(which rpmbuild)" ];         then echo "please install 'rpm-build' rpm and try again" ; exit 1 ; fi
if [ ! -f "$(which spectool)" ];         then echo "please install 'rpmdevtools' rpm and try again" ; exit 1 ; fi
if [ ! -f "$(which rpmdev-setuptree)" ]; then echo "please install 'rpmdevtools' rpm and try again" ; exit 1 ; fi

# creates ~/rpmbuild
/usr/bin/rpmdev-setuptree -d

RPMDIR=`rpm --eval "%{_rpmdir}"`
SRCDIR=`rpm --eval "%{_sourcedir}"`
SPECDIR=`rpm --eval "%{_specdir}"`
SRPMDIR=`rpm --eval "%{_srcrpmdir}"`
BUILDDIR=`rpm --eval "%{_builddir}"`


cp -f ${whereami}/runit.spec $SPECDIR
cp -f ${whereami}/*.patch $SRCDIR 
/usr/bin/spectool -C $SRCDIR -g ${whereami}/runit.spec 
rpmbuild -bb $SPECDIR/runit.spec
