[![Testing python-mode](https://github.com/python-mode/python-mode/workflows/Testing%20python-mode/badge.svg?branch=develop)](https://github.com/python-mode/python-mode/actions?query=workflow%3A%22Testing+python-mode%22+branch%3Adevelop)

![](https://raw.github.com/python-mode/python-mode/develop/logo.png)
# Python-mode, a Python IDE for Vim

-------------------------------------------------------------------------------

*This project needs contributors.*

**Documentation:**
- ``:help pymode``
- <https://github.com/python-mode/python-mode/wiki>

-------------------------------------------------------------------------------

<p align="center">
  <img width="100" height="100" src="https://vignette.wikia.nocookie.net/sqmegapolis/images/4/42/Warning-2-256.png/revision/latest?cb=20130403220740">
</p>

***Important notes***:

  * From 2017-11-19 onwards python-mode uses submodules instead of
  hard coding 3rd party libraries into its codebase. Please issue the command:
  `git submodule update --init --recursive` inside your python-mode folder.

  * From 2019-12-14 onwards `python-mode` **dropped python2 support**. If you
  still need to use it with python2 you should look for the `last-py2-support`
  branch and/or tag.

If you are a new user please clone the repos using the recursive flag:

> git clone --recurse-submodules https://github.com/python-mode/python-mode

-------------------------------------------------------------------------------

Python-mode is a Vim plugin that magically converts Vim into a Python IDE.

Why Python-mode?

1.  **Be more productive**: Pymode saves time by bringing all the tools
    necessary for professional developers so that you can focus on bigger
    things. It has been finely tuned based on decades of experience working
    with Vim and is constantly kept up to date.
2.  **Get smart assistance**: Pymode knows all about your code. We use the
    best-in-class intellisense code completion, on-the-fly error checking and
    quick-fixes; easy project navigation and much more.
3.  **Use the full power and capabilities of Vim**: Unlike traditional IDEs
    which can only provide a small subset of Vim functionalities, you can do
    everything and anything that you can in Vim.
4.  **Modular structure**: We attempt to create Python-mode with the same
    principles of python: i.e. have a modular structure, so that as and when
    better libraries evolve, we can provide you the best experience, while
    abstracting the details so that you can get back to what you do best.
5.  **Written mostly in Python**: 96.1% written in Python. Well, we love Python
    :)

The plugin contains all you need to develop python applications in Vim.

* Support Python 3.10.13, 3.11.9, 3.12.4, 3.13.0
* Syntax highlighting
* Virtualenv support
* Run python code (`<leader>r`)
* Add/remove breakpoints (`<leader>b`)
* Improved Python indentation
* Python motions and operators (`]]`, `3[[`, `]]M`, `vaC`, `viM`,
  `daC`, `ciM`, ...)
* Improved Python folding
* Run multiple code checkers simultaneously (`:PymodeLint`)
* Autofix PEP8 errors (`:PymodeLintAuto`)
* Search in python documentation (`<leader>K`)
* Code refactoring
* Intellisense code-completion
* Go to definition (`<C-c>g`)
* And more, more ...

See a screencast here: <http://www.youtube.com/watch?v=67OZNp9Z0CQ>.

Another old presentation here: <http://www.youtube.com/watch?v=YhqsjUUHj6g>.

**To read python-mode documentation in Vim, use** `:help pymode`.

# Requirements

Vim >= 7.3 (most features needed +python3 support) (also
`--with-features=big` if you want `g:pymode_lint_signs`).

# How to install

## Manually (according to vim's package structure)

As of vim8 there is an officially supported way of adding plugins. See `:tab
help packages` in vim for details.

    cd ~/.vim/pack/python-mode/start
    git clone --recurse-submodules https://github.com/python-mode/python-mode.git
    cd python-mode

Note. Windows OS users need to add `-c core.symlinks=true`. See below.

## pathogen

    cd ~/.vim
    mkdir -p bundle && cd bundle
    git clone --recurse-submodules https://github.com/python-mode/python-mode.git


Enable [pathogen](https://github.com/tpope/vim-pathogen) in your `~/.vimrc`:

    " Pathogen load
    filetype off

    call pathogen#infect()
    call pathogen#helptags()

    filetype plugin indent on
    syntax on

## vim-plug

Include the following in the [vim-plug](https://github.com/junegunn/vim-plug)
section of your `~/.vimrc`:

    Plug 'python-mode/python-mode', { 'for': 'python', 'branch': 'develop' }

## NeoBundle

Add the following:

    " python-mode: PyLint, Rope, Pydoc, breakpoints from box.
    " https://github.com/python-mode/python-mode
    NeoBundleLazy 'python-mode/python-mode', { 'on_ft': 'python' }

## Manually

    % git clone --recurse-submodules https://github.com/python-mode/python-mode.git
    % cd python-mode
    % cp -R * ~/.vim

Then rebuild **helptags** in vim:

    :helptags ~/.vim/doc/

**filetype-plugin** (`:help filetype-plugin-on`) and **filetype-indent**
(`:help filetype-indent-on`) must be enabled to use python-mode.

# Docker Testing Environment

For consistent testing across different Python versions, python-mode provides a
Docker-based testing environment. This is especially useful for contributors
and developers who want to test the plugin with different Python versions.

## Quick Start

```bash
# Run tests with default Python version (3.13.0)
./scripts/user/run-tests-docker.sh

# Run tests with specific Python version
./scripts/user/run-tests-docker.sh 3.11

# Run tests with all supported Python versions
./scripts/user/test-all-python-versions.sh
```

## Supported Python Versions

The Docker environment supports the following Python versions:
- 3.10.13
- 3.11.9
- 3.12.4
- 3.13.0 (default)

For detailed information about the Docker testing environment, see
[README-Docker.md](README-Docker.md).

## Prerequisites

- Docker
- Docker Compose

# Troubleshooting/Debugging

First read our short
[FAQ](https://github.com/python-mode/python-mode/blob/develop/doc/pymode.txt)
or using `:help pymode-faq`.
If your question is not described there then you already know what to do
(because you read the first item of our FAQ :) ).

Nevertheless just a refresher on how to submit bugs:

**(From the FAQ)**

Clear all python cache/compiled files (`*.pyc` files and `__pycache__`
directory and everything under it) from your _python-mode_ install directory.

In Linux/Unix/MacOS you can run:

`find <path_to_pymode> -type f -iname '*.pyc' -o -iname '*.pyo' -delete && find . -type d -name '__pycache__' -delete`

Then start python mode with:

`vim -i NONE -u <path_to_pymode>/debugvimrc.vim`

Reproduce the error and submit your python mode debug file. You can check its
location with `:messages` for something like:

> pymode debug msg 1: Starting debug on: 2017-11-18 16:44:13 with file /tmp/pymode_debug_file.txt

Please submit the entire content of the file along with a reasoning of why the
plugin seems broken.

***Do check for sensitive information in the file before submitting.***

Please, also provide more contextual information such as:

* your Operational System (Linux, WIndows, Mac) and which version
* the `vim --version` output
* which is your default python (`python --version`)
* the python version that vim has loaded in your tests:
    * `:PymodePython import sys; print(sys.version_info)` output.
* and if you are using virtualenvs and/or conda, also state that, please.
* It would be good also to provide the output of the two following commands:
* `git status` (under your _python-mode_ directory)
* `tree <python-mode-directory>` or something similar (such as `ls -lR`)

If you're using the Docker testing environment, also provide:
* The output of `docker --version` and `docker compose version`
* The Python version used in Docker (if testing with a specific version)
* Any Docker-related error messages
* The output of `./scripts/user/run-tests-docker.sh --help` (if available)

# Frequent problems

Read this section before opening an issue on the tracker.

## Python 2/3 vim support

Vim [has issues](https://github.com/vim/vim/issues/3585) to work with both
python2 and python3 at the same time, so if your VIM is compiled with support
to both version you may find problems. The best way to handle it is to build
your vim again with only python3 support.
[Here](https://github.com/ycm-core/YouCompleteMe/wiki/Building-Vim-from-source)
is a good reference on how to build vim from source.

## Python 3 syntax

`python-mode` supports only python3, so, if you are using python2  we cannot
help you that much. Look for our branch with python2-support (old version,
not maintained anymore) (`last-py2-support`).

## Python 3 Support

`python-mode` supports only Python 3. The project has completely removed Python 2
support since version 0.11.0. Currently supported Python versions are:
3.10.13, 3.11.9, 3.12.4, and 3.13.0.

If you need Python 2 support, you can use the legacy `last-py2-support` branch,
but it is no longer maintained.

## Vim Python Support

Vim [has issues](https://github.com/vim/vim/issues/3585) when compiled with
both Python 2 and Python 3 support. For best compatibility with python-mode,
build Vim with only Python 3 support. See
[this guide](https://github.com/ycm-core/YouCompleteMe/wiki/Building-Vim-from-source)
for building Vim from source.

## Symlinks on Windows

Users on Windows OS might need to add `-c core.symlinks=true` switch to
correctly clone / pull repository. Example: `git clone --recurse-submodules
https://github.com/python-mode/python-mode -c core.symlinks=true`

## Docker Testing Issues

If you encounter issues with the Docker testing environment:

1. **Build Failures**: Ensure Docker and Docker Compose are properly installed
   and up to date. The Dockerfile requires Ubuntu 24.04 packages.

2. **Python Version Issues**: Verify that the requested Python version is
   supported (3.10.13, 3.11.9, 3.12.4, 3.13.0). Use the major.minor format
   (e.g., `3.11`) when specifying versions.

3. **Vim Build Issues**: The Docker environment builds Vim from source with
   Python support for each version. Ensure sufficient disk space and memory
   for the build process.

4. **Test Failures**: If tests fail in Docker but pass locally, check that
   all git submodules are properly initialized and the correct Python version
   is active.

For detailed troubleshooting, see [README-Docker.md](README-Docker.md).

## Error updating the plugin

If you are trying to update the plugin (using a plugin manager or manually) and
you are seeing an error such as:

> Server does not allow request for unadvertised object

Then we probably changed some repo reference or some of our dependencies had a
`git push --force` in its git history. So the best way for you to handle it is
to run, inside the `python-mode` directory:

* `git submodule update --recursive --init --force`
* `git submodule sync --recursive`

# Documentation

Documentation is available in your vim `:help pymode`.

# Bugtracker

If you have any suggestions, bug reports or annoyances please report them to
the issue tracker at:
<https://github.com/python-mode/python-mode/issues>

# Contributing

The contributing guidelines for this plugin are outlined at
`:help pymode-development`.

Before contributing, please:

1. **Test with Docker**: Use the Docker testing environment to ensure your
    changes work across all supported Python versions (3.10.13, 3.11.9, 3.12.4, 3.13.0)

2. **Run Full Test Suite**: Use `./scripts/user/test-all-python-versions.sh` to test
    with all supported Python versions

3. **Check CI**: Ensure the GitHub Actions CI passes for your changes

4. **Follow Development Guidelines**: See `:help pymode-development` for detailed
    development guidelines

* Author: Kirill Klenov (<https://github.com/klen>)
* Maintainers:
    * Felipe Vieira (<https://github.com/fmv1992>)
    * Diego Rabatone Oliveira (<https://github.com/diraol>)

Also see the AUTHORS file.

Development of python-mode happens at github:
<https://github.com/python-mode/python-mode>

Please make a pull request to development branch and add yourself to AUTHORS.

### Python libraries

Vendored Python modules are located mostly in
[pymode/libs/](https://github.com/python-mode/python-mode/tree/develop/pymode/libs).

# Copyright

Copyright © 2013-2015 Kirill Klenov (<https://github.com/klen>).

# License

Licensed under a [GNU lesser general public license]().

If you like this plugin, I would very appreciated if you kindly send me
a postcard :) My address is here: "Russia, 143500, MO, Istra, pos. Severny 8-3"
to "Kirill Klenov". **Thanks for support!**
