# tuple definition from typeshed,
from typing import (
    Generic,
    Sequence,
    TypeVar,
    Iterable,
    Iterator,
    Any,
    overload,
    Self,
    Protocol,
)
from types import GenericAlias

_T = TypeVar("_T")
_T_co = TypeVar('_T_co', covariant=True)

class tuple(Sequence[_T_co], Generic[_T_co]):
    def __new__(cls, iterable: Iterable[_T_co] = ..., /) -> Self: ...
    def __len__(self) -> int: ...
    def __contains__(self, key: object, /) -> bool: ...
    @overload
    def __getitem__(self, key: SupportsIndex, /) -> _T_co: ...
    @overload
    def __getitem__(self, key: slice, /) -> tuple[_T_co, ...]: ...
    def __iter__(self) -> Iterator[_T_co]: ...
    def __lt__(self, value: tuple[_T_co, ...], /) -> bool: ...
    def __le__(self, value: tuple[_T_co, ...], /) -> bool: ...
    def __gt__(self, value: tuple[_T_co, ...], /) -> bool: ...
    def __ge__(self, value: tuple[_T_co, ...], /) -> bool: ...
    def __eq__(self, value: object, /) -> bool: ...
    def __hash__(self) -> int: ...
    @overload
    def __add__(self, value: tuple[_T_co, ...], /) -> tuple[_T_co, ...]: ...
    @overload
    def __add__(self, value: tuple[_T, ...], /) -> tuple[_T_co | _T, ...]: ...
    def __mul__(self, value: SupportsIndex, /) -> tuple[_T_co, ...]: ...
    def __rmul__(self, value: SupportsIndex, /) -> tuple[_T_co, ...]: ...
    def count(self, value: Any, /) -> int: ...
    def index(self, value: Any, start: SupportsIndex = ..., stop: SupportsIndex = ..., /) -> int: ...
    def __class_getitem__(cls, item: Any, /) -> GenericAlias: ...

class dict: pass
class int: pass
class slice: pass
class bool(int): pass
class str: pass # For convenience
class object: pass
class type: pass
class ellipsis: pass
class SupportsIndex(Protocol):
    def __index__(self) -> int: pass
class list(Sequence[_T], Generic[_T]):
    @overload
    def __getitem__(self, i: int) -> _T: ...
    @overload
    def __getitem__(self, s: slice) -> list[_T]: ...
    def __contains__(self, item: object) -> bool: ...
    def __iter__(self) -> Iterator[_T]: ...
