#!/usr/bin/env python3
# Copyright (c) Meta Platforms, Inc. and affiliates
# Owner(s): ["oncall: distributed"]

"""
LocalTensor Tutorial Examples
=============================

This package contains example code and tests for the LocalTensor tutorial.
Each example module demonstrates specific LocalTensor patterns that are:
1. Included in the tutorial documentation via literalinclude
2. Directly tested to ensure correctness

Modules:
- example_01_basic_operations: Basic LocalTensor creation and arithmetic
- example_02_collective_operations: Simulating distributed collectives
- example_03_dtensor_integration: Working with DTensor
- example_04_uneven_sharding: Handling uneven data distribution
- example_05_rank_specific: Rank-specific computations
- example_06_multidim_mesh: Multi-dimensional device meshes
- test_local_tensor_tutorial_examples: Test suite for all examples
"""
