Appreciate and recognize [all contributors](https://github.com/qazbnm456/awesome-web-security/graphs/contributors).

Please note that this project is released with a [Contributor Code of Conduct](https://github.com/qazbnm456/awesome-web-security/blob/master/code-of-conduct.md). By participating in this project you agree to abide by its terms.

# Table of Contents

- [Awesome Web Security contribution guidelines](#contribution-guidelines)
- [Quality Standard](#quality-standard)
- [Adding to this list](#adding-to-this-list)
- [Adding something to an awesome list](#adding-something-to-an-awesome-list)
- [Updating your Pull Request](#updating-your-pull-request)

# Contribution Guidelines

(your commit message will be a tweet, keep that in mind :)

- **To add to the list:** Submit a pull request
- **To remove from the list:** Submit a pull request
- want to change something: Submit a pull request
- want to try something else: Submit a pull request
- don't know what to do: Submit a pull request or open an issue, let us know what's going on.

`awesome-web-security` is a hand-crafted list for high-quality information about web security and its resources. It would be nice if it is related or compatible with web security in some way. But if it's awesome, let's us know why and you're on!

- Each item should be limited to one link, no duplicates, no redirection (careful with `http` vs `https`!)
- The link should be the name of the slide or project or website
- Description should be clear and concise (read it out loud to be sure)
- Description should follow the link, on the same line
- if you want to add more than one link, please don't do all PR on the exact same line, it usually results in conflicts and your PR cannot be automatically merged...

Please contribute links to slides/projects you have used or are familiar with. This will help ensure high-quality entries.

# Quality standard

Note that we can help you achieve those standards, just try your best, be brave.
We'll guide you to the best of our abilities.

To be on the list, it would be *nice* if entries adhere to these quality standards:

- Generally useful to the community
- Clearly stating "what is it for": mention the problem it solves. Just try your best, make it clear for the next person.
- Solves a real problem (even a small one)
- if it is a **WIP** (work in progress, not safe for production), mention it.

If your PR is not merged, we will tell you why so that you may be able to improve it.

# Awesome Related Contribution Guidelines

## Adding to this list

Please ensure your pull request adheres to the following guidelines:

- Search previous suggestions before making a new one, as yours may be a duplicate.
- Make sure the list is useful before submitting. That implies it has enough content and every item has a good succinct description.
- Make an individual pull request for each suggestion.
- Use [title-casing](http://titlecapitalization.com) (AP style).
- Use the following format: `[List Name](link)`
- Link additions should be added to the bottom of the relevant category.
- New categories or improvements to the existing categorization are welcome.
- Check your spelling and grammar.
- Make sure your text editor is set to remove trailing whitespace.
- The pull request and commit should have a useful title.
- The body of your commit message should contain a link to the repository.

Thank you for your suggestions!

## Adding something to an awesome list

If you have something awesome to contribute to an awesome list, this is how you do it.

You'll need a [GitHub account](https://github.com/join)!

1. Access the awesome list's GitHub page. For example: https://github.com/sindresorhus/awesome
2. Click on the `readme.md` file: ![Step 2 Click on Readme.md](https://cloud.githubusercontent.com/assets/170270/9402920/53a7e3ea-480c-11e5-9d81-aecf64be55eb.png)
3. Now click on the edit icon. ![Step 3 - Click on Edit](https://cloud.githubusercontent.com/assets/170270/9402927/6506af22-480c-11e5-8c18-7ea823530099.png)
4. You can start editing the text of the file in the in-browser editor. Make sure you follow guidelines above. You can use [GitHub Flavored Markdown](https://help.github.com/articles/github-flavored-markdown/). ![Step 4 - Edit the file](https://cloud.githubusercontent.com/assets/170270/9402932/7301c3a0-480c-11e5-81f5-7e343b71674f.png)
5. Say why you're proposing the changes, and then click on "Propose file change". ![Step 5 - Propose Changes](https://cloud.githubusercontent.com/assets/170270/9402937/7dd0652a-480c-11e5-9138-bd14244593d5.png)
6. Submit the [pull request](https://help.github.com/articles/using-pull-requests/)!

## Updating your Pull Request

Sometimes, a maintainer of an awesome list will ask you to edit your Pull Request before it is included. This is normally due to spelling errors or because your PR didn't match the awesome-* list guidelines.

[Here](https://github.com/RichardLitt/knowledge/blob/master/github/amending-a-commit-guide.md) is a write up on how to change a Pull Request, and the different ways you can do that.
