[awesome-docker]: https://github.com/veggiemonk/awesome-docker/blob/master/CONTRIBUTING.md


Contributing Guidelines:
=======================================================================

We appreciate and recognize all contributors.


## Contribution Guidelines

* To add to the list: Submit a pull request
* To remove from the list: Submit a pull request
* Want to change something: Submit a pull request
* Want to try something else: Submit a pull request
* Don't know what to do: Submit a pull request
* Each item should be limited to one link
* The link should be the name of the package or project or website
* Descriptions should be clear and concise (read it out loud to be sure)
* Descriptions should follow the link, on the same line
* If you want to add more than one link, please don't do all PR on the exact same line, it usually results in conflicts and your PR cannot be automatically merged...
* Please contribute links to packages/projects you have used or are familiar with. This will help ensure high-quality entries.

## Test your change locally

#### Prerequisite

Ruby 2.0+

#### Verify checks as:
```
$ make test
```

In case the following error occours:

```
ERROR:  While executing gem ... (Gem::FilePermissionError)
    You don't have write permissions for the /var/lib/gems/x.x.0 directory.
Makefile:2: recipe for target 'awesome_bot' failed
```

Try:

```
$ sudo make test
```

## Quality standard

To be on the list, it would be nice if entries adhere to these quality standards:

* Generally useful to the community
* Clearly "what is it" --> which category it belongs : article, video, twitter account, etc.
* Clearly stating "what is it for": mention the problem it solves. Just try your best, make it clear for the next person
* Solves a real problem (even a small one)
* If it is a WIP (work in progress, not safe for production), mention it.

## Minimum Criteria of Submission

If you planning to add a new project, please ensure that it covers the minimum criteria mentioned here ==> https://github.com/ramitsurana/awesome-kubernetes/blob/master/docs/guidelines/CRITERIA_OF_SUBMISSION.md


-----------------------------------------------------------------------


Abstract adopted from [awesome-docker][awesome-docker].
