Managed Kubernetes
=======================================================================

  - [Avisi Cloud](https://avisi.cloud) - Managed Multi-cloud Kubernetes management platform
  - [Claudie](https://github.com/berops/claudie) - Multi-cloud clusters with each nodepool in a different cloud provider.
  - [Platform9](http://platform9.com)
  - [OpenShift Online](https://www.openshift.com/products/online/)
  - [Eldarion Cloud](http://eldarion.cloud/)
  - [Hasura](https://hasura.io/)
  - [ELASTX](https://www.elastx.se/en/kubernetes/)
  - [Nirmata](https://www.nirmata.com/)
  - [Spectro Cloud](https://www.spectrocloud.com)
  - [Flant Managed Kubernetes](https://flant.com/services/managed-kubernetes-as-a-service)
  - [Giant Swarm](https://www.giantswarm.io/)
  - [APPUiO Cloud](https://www.appuio.ch/offering/cloud/) - Shared multi-teant OpenShift cluster - Kubernetes Namespace as a Service
  - [Thalassa Cloud](https://thalassa.cloud/products/compute/kubernetes/)

### [Cluster Managers](#cluster-manager)

  - [Gardener](https://github.com/gardener/gardener) - Alibaba, AWS, Azure, GCP, and OpenStack cluster manager
  - [Gravity](https://gravitational.com/gravity) - Formerly Telekube
  - [Kommander](https://d2iq.com/solutions/ksphere/kommander) - Federated management and governance for on-prem or cloud Kubernetes clusters
  - [Kqueen](https://github.com/Mirantis/kqueen)
  - [Kubermatic](http://www.loodse.com/)
  - [KubeSphere](https://github.com/kubesphere/kubesphere) - Full-stack and easy-to-use container platform, with awesome user experience and wizard UI, supports installing on Linux and Kubernetes.
  - [Kublr](https://kublr.com/how-it-works/) - AWS, Azure, GCP, vSphere, vCloud Director, and On-Prem cluster manager
  - [PKS](https://pivotal.io/platform/pivotal-container-service) - Cluster manager by Pivotal, VMWare and Google
  - [Rancher](https://rancher.com/)
  - [Spectro Cloud](https://www.spectrocloud.com) - Enterprise Kubernetes Management at scale

### [Developer Platform](#developer-platform)

  - [DevSpace](https://github.com/covexo/devspace) - Build, test and run code directly inside any Kubernetes cluster
  - [Draft](http://draft.sh) - A tool for developers to create cloud native applications with Kubernetes
  - [Eclipse Che](https://github.com/eclipse/che) - Cloud development workspaces with SSH and multi-user support
  - [Garden](https://garden.io) - Orchestrates your development workflows to make developing microservices faster and easier
  - [Humanitec](https://humanitec.com) - The fastest way to build your Internal Developer Platform
  - [Knative](https://github.com/knative/) - Platform to build, deploy, and manage modern serverless workloads
  - [Okteto](https://github.com/okteto/okteto) - Develop directly in any Kubernetes cluster. No commit, build or push required
  - [Mantl](https://github.com/mantl/mantl) - A modern platform for rapidly deploying globally distributed services
  - [Spring Cloud Kubernetes](https://github.com/spring-cloud/spring-cloud-kubernetes) - Spring Cloud integration with Kubernetes
  - [VAMP](http://vamp.io) - Cloud-Native Release Management & Orchestration
  - [Tilt](https://github.com/windmilleng/tilt) - Manages local development instances for teams that deploy to Kubernetes

### [Enterprise Kubernetes Products](#enterprise-kubernetes-products)

  - [Avisi Cloud](https://avisi.cloud) - Managed Multi-cloud Kubernetes management platform
  - [Canonical Distribution of Kubernetes - CDK](https://www.ubuntu.com/kubernetes)
  - [IBM Cloud Private](https://www.ibm.com/cloud/private)
  - [Kublr](https://kublr.com/) - Kubernetes for the Enterprise - multi-cloud and on-prem Kubernetes operations center
  - [NetApp Kubernetes Service](https://cloud.netapp.com/kubernetes-service)
  - [OpenShift - Container Platform](http://www.openshift.com/container-platform/index.html)
  - [Spectro Cloud](https://www.spectrocloud.com) - Enterprise Kubernetes Management at scale
  - [SUSE Container as a Service](http://www.suse.com/betaprogram/caasp-beta/)
  - [VMware Tanzu Kubernetes Grid (TKG)](https://tanzu.vmware.com/kubernetes-grid) - Enterprise-ready multi-cloud Kubernetes runtime
  

### [Public/Private Cloud](#publicprivate-cloud)

   - [Alibaba Cloud](https://www.alibabacloud.com/product/kubernetes) - Alibaba Cloud Container Service for Kubernetes
   - [AWS EKS](https://aws.amazon.com/eks/) - Amazon Elastic Container Service
   - [Azure AKS](https://docs.microsoft.com/en-us/azure/aks/) - Azure Kubernetes Service
   - [DigitalOcean](https://www.digitalocean.com/products/kubernetes/) - DigitalOcean Kubernetes
   - [GKE](https://cloud.google.com/container-engine/) - Google Kubernetes Engine
   - [IKS](https://www.ibm.com/cloud/container-service) - IBM Cloud Kubernetes Service
   - [OKE](https://cloud.oracle.com/containers/kubernetes-engine) - Oracle Kubernetes Engine
   - [OVH Managed Kubernetes](https://www.ovh.co.uk/kubernetes/) - OVH Managed Kubernetes
   - [Rackspace](https://www.rackspace.com/en-in) - Rackspace
   - [VMware Cloud PKS](https://cloud.vmware.com/vmware-cloud-pks)

### [PaaS](#paas)

   *Kubernetes Platform as a Service providers*

  - [Alauda Container Platform](http://www.alauda.cn/?lang=EN)
  - [Cloud Foundry](https://github.com/cloudfoundry/cf-for-k8s)
  - [Devtron Labs](https://github.com/devtron-labs/devtron) - An open source software delivery workflow for Kubernetes written in go.
  - [Eldarion Cloud](http://eldarion.cloud)
  - [Hasura](http://www.hasura.io)
  - [KubeSail](https://kubesail.com) - An easy, free way to try Kubernetes
  - [KubeSphere](https://github.com/kubesphere/kubesphere) - Full-stack and easy-to-use container platform, with awesome user experience and wizard UI.
  - [Kyma](https://kyma-project.io/) - A platform for extending apps with serverless functions. It provides a selection of cloud-native projects glued together to simplify the creation and management of services.
  - [OpenShift Online/Dedicated/Container Platform](https://www.openshift.com/)
  - [OpenShift Origin (OKD)](http://www.okd.io)
  - [Rancher](http://rancher.com/running-kubernetes-aws-rancher/)
  - [RIO](https://rio.io/) - Kubernetes based MicroPaaS
  - [teresa](https://github.com/luizalabs/teresa) - Simple PAAS that runs on top of Kubernetes.
  - [gopaddle](https://gopaddle.io) - Simplest, fastest and cheapest way to modernize applications
