Projects
=======================================================================

*Kubernetes-related projects that you might find helpful*


## Related Software

*Projects built to make life with Kubernetes even better, more powerful, more scalable*

* [Ambassador](http://www.getambassador.io) - API Gateway built on the Envoy Proxy
* [Argo](https://github.com/argoproj/argo) - The Workflow Engine for Kubernetes
* [Bitnami Kubernetes Production Runtime](https://kubeprod.io)
* [Capact](https://github.com/capactio/capact) - A framework to manage applications and infrastructure in a unified way
* [Client Libraries](https://github.com/kubernetes/website/blob/master/content/en/docs/reference/using-api/client-libraries.md)
* [Clusterpedia](https://github.com/clusterpedia-io/clusterpedia) - Complex resource searches across multiple clusters, support simultaneous search of a single kind of resource or multiple kinds of resources existing in multiple clusters.
* [Escalator](https://github.com/atlassian/escalator) - A batch or job optimized horizontal autoscaler for Kubernetes
* [Fairwinds Pluto](https://github.com/FairwindsOps/pluto) - A cli tool to help discover deprecated apiVersions in Kubernetes
* [Fairwinds Polaris](https://github.com/reactiveops/polaris) - An open source dashboard for Kubernetes best practices
* [Fission Workflows](https://github.com/fission/fission-workflows) - Workflow-based serverless function composition
* [Forecastle](https://github.com/stakater/Forecastle) - A dashboard which dynamically discovers and provides a launchpad to access applications deployed on Kubernetes
* [Gefyra](https://github.com/gefyrahq/gefyra) - Connect Docker containers to any Kubernetes environment
* [Getdeck](https://github.com/Getdeck/getdeck) - A CLI that creates reproducible Kubernetes environments for development and testing
* [Git Webhook Proxy](https://github.com/stakater/GitWebhookProxy) - A proxy to let webhooks reach running services behind a firewall
* [Hypernetes](https://github.com/hyperhq/hypernetes)
* [Ingress Monitor Controller](https://github.com/stakater/IngressMonitorController) - Watches ingress endpoints and automatically registers liveness alerts on the configured uptime checker
* [k8s-label-rules-webhook](https://github.com/circa10a/k8s-label-rules-webhook) - An admission webhook to enforce standards for labels of resources being created in your k8s cluster
* [kmachine](https://github.com/skippbox/kmachine)
* [KEDA](https://github.com/kedacore/keda) - Kubernetes-based Event Driven Autoscaling
* [kube-fledged](https://github.com/senthilrch/kube-fledged) - A K8S add-on for creating and managing a cache of container images directly on cluster worker nodes
* [kube-openvpn](https://github.com/pieterlange/kube-openvpn)
* [Kubeform](http://capgemini.github.io/kubeform/)
* [Kubefuse](http://opencredo.com/introducing-kubefuse-file-system-kubernetes/)
* [Kubefwd](https://github.com/txn2/kubefwd) - Bulk port forwarding Kubernetes services for local development.
* [Kubernetes Cluster Federation (previously Ubernetes)](https://github.com/kubernetes-sigs/kubefed)
* [Kubernetes Ec2 Autoscaler](https://github.com/openai/kubernetes-ec2-autoscaler)
* [Kubic-Project](https://github.com/kubic-project)
* [Reloader](https://github.com/stakater/Reloader) - Auto-load updates of ConfigMaps and Secrets into pods for Deployments, StatefulSets and DaemonSets
* [Telepresence](http://www.telepresence.io) - Locally develop/debug services against a remote Kubernetes cluster
* [krane](https://github.com/Shopify/krane) - A command-line tool that helps you ship changes to a Kubernetes namespace and understand the result
* [ktunnel](https://github.com/omrikiei/ktunnel) - A command-line tool that establishes a reverse tunnel between Kubernetes and your cluster, use it to locally develop/debug services or integrate with local resources.
* [k8s-platform-lcm](https://github.com/arminc/k8s-platform-lcm) - A faster and easier way to manage the lifecycle of applications and tools, running and living around your Kubernetes platform
* [Pixie](https://github.com/pixie-labs/pixie) - Live-debug multi-cluster K8s environments without changing code and moving data off-cluster.
* [KubeEdge](https://kubeedge.io) - An open platform to enable Edge computing
* [k8s-image-swapper](https://github.com/estahn/k8s-image-swapper) - Mirror images into your own registry and swap image references automatically.
* [configurator](https://github.com/gopaddle-io/configurator) - A version control and a sync service that keeps Kubernetes ConfigMaps and Secrets in sync with the deployment.
* [KubeDiagrams](https://github.com/philippemerle/KubeDiagrams) - A command-line tool to generate Kubernetes architecture diagrams from Kubernetes manifest files, kustomization files, Helm charts, and actual cluster state.

## Package Managers

* [CNAB](https://cnab.io) - CNABs facilitate the bundling, installing and managing of container-native apps - and their coupled services.
* [Helm](http://helm.sh) - For further information, please check out - [Awesome Helm](https://github.com/cdwv/awesome-helm).
* [Cloudsmith](https://cloudsmith.io/l/helm-repository/) - A fully managed package management SaaS, with first-class support for public and private Kubernetes registries (Docker + Helm Charts, plus many others).

## Monitoring Services

*To maintain regular surveillance over kubernetes*

* [Alaz](https://github.com/ddosify/alaz) - Effortless, Low-Overhead, eBPF-based Kubernetes Monitoring
* [Console](http://github.com/kubernetes/dashboard)
* [BotKube](https://github.com/infracloudio/botkube) - App that helps you monitor your Kubernetes cluster, debug critical deployments & gives recommendations for the standard practices
* [Datadog](http://www.datadoghq.com/)
* [Dynatrace](https://www.dynatrace.com/technologies/kubernetes-monitoring/) - Kubernetes cluster and workload monitoring
* [eventrouter](https://github.com/heptiolabs/eventrouter) - simple introspective kubernetes service that forwards events to a specified sink.
* [Goldpinger](https://github.com/bloomberg/goldpinger) display, monitor and alert on inter-cluster connectivity
* [Grafana Kubernetes App](https://github.com/grafana/kubernetes-app)
* [Heapster](https://github.com/kubernetes/heapster)
* [HolmesGPT](https://github.com/robusta-dev/holmesgpt) - On-Call/DevOps Assistant - Get a head start on fixing alerts with AI. Investigate Prometheus alerts, Jira/Pagerduty/Opsgenie tickets automatically.
* [Instana](https://www.instana.com/) - Automatic Kubernetes Application Performance Monitoring
* [kail](https://github.com/boz/kail) - Kubernetes Log Viewer. Streams logs from all containers of all matching pods.
* [KRR](https://github.com/robusta-dev/krr) - Kubernetes CPU/Memory requests/limits recommendations based on existing data in Prometheus/Coralogix/Thanos/Mimir and more!
* [Kubebox](https://github.com/astefanutti/kubebox) - Terminal console for Kubernetes
* [Kubecost](https://kubecost.com/) - monitor resources following their financial cost
* [Kubedash](https://github.com/kubernetes/kubedash) - **Deprecated** repository is archived and read-only
* [Kubernetes Operational View](https://codeberg.org/hjacobs/kube-ops-view) - read-only system dashboard for multiple K8s clusters
* [K8Dash](https://github.com/herbrandson/k8dash) - Realtime K8S alternative dashboard
* [Kubernetes Web View](https://codeberg.org/hjacobs/kube-web-view) - list and view all Kubernetes resources (incl. CRDs) with permalink-friendly URLs in a plain-HTML frontend
* [Kubespy](https://github.com/pulumi/kubespy) - Tools for observing Kubernetes resources in real time, powered by Pulumi.
* [Kubetail](https://github.com/johanhaleby/kubetail)
* [Kubewatch](https://github.com/robusta-dev/kubewatch) - Kubernetes watcher that publishes k8s events and trigger handler notification to available collaboration hubs/notification channels.
* [kwatch](https://github.com/abahmed/kwatch) - monitor & detect crashes in your Kubernetes(K8s) cluster instantly
* [Mizu](https://github.com/up9inc/mizu) - API traffic viewer for Kubernetes enabling you to view all API communication between microservices, multiprotocol support: HTTP1.1, HTTP/2, AMQP, Kafka, Redis. 
* [Netdata](https://www.netdata.cloud) - Open-source Kubernetes monitoring. Deploy via a Netdata [Helm chart](https://github.com/netdata/helmchart).
* [Netsil](https://github.com/netsil/manifests)
* [New Relic](https://newrelic.com/platform/kubernetes) - Kubernetes monitoring and visualization service.
* [NexClipper](https://github.com/NexClipper/NexClipper) - An open source software for monitoring Kubernetes and containers.
* [Outcold Solutions](https://www.outcoldsolutions.com) - monitoring Kubernetes, OpenShift and Docker in Splunk Enterprise and Splunk Cloud (metrics and log forwarding)
* [Prometheus](http://prometheus.io)
* [Replex.io](https://replex.io) - Kubernetes Governance & Cost Control.
* [Robusta.dev](https://github.com/robusta-dev/robusta) - Better Prometheus Alerts for Kubernetes with ability to Enrich, Group, and Remediate your Alerts.
* [Searchlight](https://github.com/appscode/searchlight)
* [Sematext](https://sematext.com/)
* [StatusBay](https://github.com/similarweb/statusbay) - Kubernetes deployment visibility (inc. Slack notifications, metrics and checks enrichment, resources consolidation, etc)
* [Sysdig Monitoring](https://www.sysdig.com/)
* [Sysdig Open Source](http://www.sysdig.org/)
* [The Elastic Stack](https://www.elastic.co/docker-kubernetes-container-monitoring) - An open-source solution for monitoring and visualising K8s metrics, logs, application traces and more.
* [Weave Scope](http://www.weave.works/products/weave-scope/)
* [kube-state-metrics](https://github.com/kubernetes/kube-state-metrics) - Simple service that listens to the Kubernetes API server and generates metrics about the state of the objects.
* [loki](https://github.com/grafana/loki) - Loki is a horizontally-scalable, highly-available, multi-tenant log aggregation system inspired by Prometheus.
* [Loghouse](https://github.com/flant/loghouse) - Efficiently store big amounts of your logs (in ClickHouse database), process them using a simple query language and monitor them online through web UI.
* [kube-eventer](https://github.com/AliyunContainerService/kube-eventer) - kube-eventer emit kubernetes events to sinks (kafka, slack, webhook, etc)
* [VictoriaMetrics](https://docs.victoriametrics.com/) - VictoriaMetrics: fast, cost-effective monitoring solution and time series database.
* [VictoriaLogs](https://docs.victoriametrics.com/victorialogs/) - VictoriaLogs is a fast and easy-to-use, open source logs solution. Highly scalable on cloud, kubernetes or on-premise setups.

## Testing

*Test your applications running on Kubernetes*

* [Chainsaw](https://github.com/kyverno/chainsaw) - The ultimate end to end testing tool for Kubernetes operators
* [chaoskube](https://github.com/linki/chaoskube) - periodically kills random pods in your Kubernetes cluster
* [DETIK](https://github.com/bats-core/bats-detik) - BATS extension for end-to-end tests of K8s applications
* [k8s-testsuite](https://github.com/mrahbar/k8s-testsuite) - Helm chart for network and loadtesting of a Kubernetes cluster
* [kboom](https://github.com/mhausenblas/kboom) - The Kubernetes scale & soak load tester
* [Krucible](https://usekrucible.com/) - Quickly create temporary Kubernetes clusters for testing
* [kind](https://github.com/bsycorp/kind) - A single node cluster to run your CI tests against thats ready in 30 seconds
* [k3d](https://github.com/rancher/k3d) - Quickly create single- or multi-node k3s clusters in containerized nodes
* [kube-monkey](https://github.com/asobti/kube-monkey) - Chaos Monkey for Kubernetes clusters
* [Kubeadm-dind-cluster](https://github.com/kubernetes-sigs/kubeadm-dind-cluster) - multi-node test cluster based on kubeadm
* [KUTTL](https://kuttl.dev) - KUTTL (Kubernetes Test Tool) is a toolkit for testing Kubernetes Operators
* [PowerfulSeal](https://github.com/bloomberg/powerfulseal) - kills targeted pods and machines to test your software reliability
* [Sonobuoy](https://github.com/vmware-tanzu/sonobuoy) - Diagnostic tool that runs Kubernetes conformance tests
* [Test-Infra](https://github.com/kubernetes/test-infra)
* [predator](https://github.com/Zooz/predator) - Distributed performance testing platform for Kubernetes
* [Octopus](https://github.com/kyma-incubator/octopus) - Octopus is a testing framework that allows you to run integration tests defined as Docker images on a Kubernetes cluster.
* [KubePug](https://github.com/rikatz/kubepug) - Kubernetes Pre-Upgrade Checker
* [KubeLibrary](https://github.com/devopsspiral/KubeLibrary) - RobotFramework library for testing Kubernetes cluster
* [Speedscale](https://speedscale.com/kubernetes/) - Speedscale is a traffic replay framework that simulates production conditions, so you can validate changes quickly and easily.
* [Stoat](https://docs.stoat.dev/) - Stoat helps you access and browse logs for Kubernetes tests run on GitHub actions 

## Continuous Delivery

*Build-test-deploy automated workflow software designed to make production environments more stable and life better for engineers*

* [Jenkins](https://jenkins.io)
   * [Jenkins-Kubernetes Plugin](https://github.com/jenkinsci/kubernetes-plugin) by [Carlos Sanchez](https://www.twitter.com/csanchez)
   * [Automated Image Builds with Jenkins, Packer, and Kubernetes](https://cloudplatform.googleblog.com/2015/05/Automated-Compute-Engine-and-Docker-Image-Builds-with-Jenkins-Packer-and-Kubernetes.html)
   * [Lab: Build a Continuous Deployment Pipeline with Jenkins and Kubernetes](https://github.com/GoogleCloudPlatform/continuous-deployment-on-kubernetes)
   * [Jenkins Operator - Kubernetes native Jenkins operator](https://github.com/jenkinsci/kubernetes-operator)
* [Jenkins X](http://jenkins-x.io/) - automated CI/CD for Kubernetes with GitOps Promotion and Preview Environments on Pull Requests using best of breed OSS tools like: Jenkins, Helm, Skaffold, Kaniko, Knative Build, Knative Pipeline and Prow
* [Apollo](https://github.com/logzio/apollo) - Open Source application providing teams with self service UI for creating and deploying their services to Kubernetes.
* [Argo CD](https://github.com/argoproj/argo-cd) - Declarative continuous deployment for Kubernetes.
* [autoapply](https://github.com/autoapply/autoapply) - Automatically apply changes from a Git repository to a Kubernetes cluster
* [Buildkite](https://github.com/buildkite/charts) - Lean CI/CD cloud hosted control plane with agents on your infrastructure.
* [Codefresh](https://codefresh.io/) - Kubernetes CI/CD platform (with private Docker and Helm Chart repositories)
* [Dispatch](https://d2iq.com/solutions/ksphere/dispatch) - Enterprise grade Kubernetes GitOps framework based on Tekton and Argo CD
* [GitLab](http://blog.lwolf.org/post/how-to-easily-deploy-gitlab-on-kubernetes/)
* [k8s-deploy-helper](https://github.com/lifechurch/k8s-deploy-helper) - Framework to easily deploy Kubernetes applications via GitLab.
* [kb8or](https://github.com/UKHomeOffice/kb8or)
* [Keel](https://keel.sh/)
* [Kit](http://invisionapp.github.io/kit/)
* [Kontinuous](https://github.com/AcalephStorage/kontinuous)
* [Razee](https://github.com/razee-io/Razee)
* [Shipper](https://github.com/bookingcom/shipper) - Kubernetes native multi-cluster canary or blue-green rollouts using Helm.
* [Vili](https://github.com/airware/vili)
* [Weave Flux – GitOps reconcoliation operator](https://github.com/weaveworks/flux)
* [Wercker](http://blog.wercker.com/topic/kubernetes)
* [Werf](https://werf.io) - GitOps tool with advanced features to build images and deploy them to Kubernetes. Integrates with any existing CI system.
* [Buddy](https://buddy.works)
* [PipeCD](https://pipecd.dev/) - Continuous Delivery for Declarative Kubernetes, Serverless and Infrastructure Applications

## Serverless Implementations

* [FaaS-netes](https://github.com/alexellis/faas-netes)
* [Fission](https://github.com/platform9/fission)
* [Funktion](https://github.com/fabric8io/funktion)
* [Iron.io](http://iron.io)
* [Kubeless](https://github.com/skippbox/kubeless)
* [Nuclio](https://github.com/nuclio/nuclio)
* [OpenFaaS](https://github.com/alexellis/faas)
* [OpenWhisk](https://github.com/apache/openwhisk)
* [Virtual Kubelet](https://github.com/virtual-kubelet/virtual-kubelet) - Allows nodes to be backed by other services and providers.

## Operators

* [Addon-operator](https://github.com/flant/addon-operator) - adds hooks and values to helm charts in order to enhance the capabilities of helm and transform charts into smart modules that configure themselves and respond to changes in the cluster.
* [Kube cert manager](https://github.com/kelseyhightower/kube-cert-manager)
* [Cert Operator](https://github.com/giantswarm/cert-operator)
* [cert-manager](https://github.com/jetstack/cert-manager)
* [Container Linux Update Operator](https://github.com/coreos/container-linux-update-operator)
* [Couchbase](https://www.couchbase.com/products/cloud/kubernetes)
* [DB Operator](https://github.com/k8sdb/operator)
* [Elasticsearch](https://github.com/upmc-enterprises/elasticsearch-operator)
* [etcd](https://github.com/coreos/etcd-operator)
* [Istio](https://github.com/banzaicloud/istio-operator)
* [K8s Operator Workshop](https://github.com/lukebond/cc-au-k8s-operators-workshop)
* [k8tz](https://github.com/k8tz/k8tz) - Kubernetes admission controller and a CLI tool to inject timezones into Pods and CronJobs
* [Kafka](https://github.com/krallistic/kafka-operator)
* [Kong API](https://github.com/upmc-enterprises/kong-operator)
* [kooper](https://github.com/spotahome/kooper) - Simple Go library to create Kubernetes operators and controllers
* [Kubernetes Operators](https://github.com/sapcc/kubernetes-operators)
* [KubeVirt](https://github.com/kubevirt)
* [KUDO](https://kudo.dev) - KUDO (Kubernetes Universal Declarative Operator) is a toolset for writing Kubernetes Operators
* [Kured](https://github.com/weaveworks/kured) - Kured (Kubernetes Reboot Daemon) is a Kubernetes daemonset that performs safe automatic node reboots
* [Memcached](https://github.com/kbst/memcached)
* [MongoDB](https://github.com/kbst/mongodb)
* [MySQL](https://github.com/oracle/mysql-operator)
* [Operator Kit](https://github.com/rook/operator-kit)
* [Operator SDK](https://github.com/operator-framework/operator-sdk)
* [OperatorHub.io](https://www.operatorhub.io) - A new home for the Kubernetes community to share Operators
* [PlanetScaleDB Operator](https://docs.planetscale.com/psdb-operator/overview)
* [PostgreSQL](https://github.com/CrunchyData/postgres-operator)
* [PostgreSQL](https://github.com/zalando-incubator/postgres-operator) - manage PostgreSQL clusters using StatefulSets and [Patroni](https://github.com/zalando/patroni).
* [Prometheus](https://github.com/coreos/prometheus-operator)
* [Shell-operator](https://github.com/flant/shell-operator) - a tool for running event-driven scripts in a Kubernetes cluster.
* [Terraform Controller](http://github.com/appvia/terraform-controller) - manages the lifecycle of terraform resources and leverages guardrails to provide an environment where developers to self-serve cloud resources
* [TiDB Operator](https://github.com/pingcap/tidb-operator) - TiDB Operator manages TiDB clusters on Kubernetes and automates tasks related to operating a TiDB cluster.
* [Vitess Operator](https://github.com/planetscale/vitess-operator)

## Custom Schedulers

* [bashScheduler](https://github.com/rothgar/bashScheduler) - Written in bash
* [escheduler](https://github.com/agonzalezro/escheduler) - Written in elixir
* [firmament](https://github.com/camsas/firmament)
* [ksched](https://github.com/coreos/ksched) - Experimental flow based scheduler
* [Scheduler](https://github.com/kelseyhightower/scheduler) - Cost based scheduler
* [Sticky Node Scheduler](https://github.com/philipn/kubernetes-sticky-node-scheduler)

## Container Support

*A list of linux containers supported by kubernetes.*

* [Docker](http://docker.com)
* [containerd](https://github.com/containerd/containerd)
* [cri-containerd](https://github.com/kubernetes-incubator/cri-containerd) - Containerd-based implementation of Kubernetes Container Runtime Interface
* [CRI-O](https://github.com/kubernetes-incubator/cri-o)
* [Hyper.sh/frakti](https://github.com/kubernetes/frakti) - Hypervisor-based container runtime
* [virtlet](https://github.com/Mirantis/virtlet) - Kubernetes CRI implementation for running VM workloads
* [infranetes](https://github.com/apporbit/infranetes)
* [Kata Containers](https://katacontainers.io)

## Database

* [Apache Ignite](https://apacheignite.readme.io/docs/kubernetes-deployment) - Memory-centric distributed database, caching, processing platform
* [Cassandra / DataStax](http://blog.kubernetes.io/2016/07/thousand-instances-of-cassandra-using-kubernetes-pet-set.html)
* [CockroachDB](http://www.cockroachlabs.com/blog/running-cockroachdb-on-kubernetes/)
* [Couchbase](https://docs.couchbase.com/operator/current/install-kubernetes.html)
* [CrateDB](https://crate.io/docs/crate/guide/en/latest/deployment/containers/kubernetes.html)
* [Hazelcast](http://ppires.wordpress.com/2014/12/24/clustering-hazelcast-on-kubernetes/)
* [Minio](http://minio.io)
* [MongoDB](http://www.mongodb.com/blog/post/running-mongodb-as-a-microservice-with-docker-and-kubernetes)
* [PlanetScaleDB](https://www.planetscale.com)
* [RDS](https://github.com/sorenmat/k8s-rds) - Provision RDS databases via CRD from Kubernetes
* [TiDB](https://github.com/pingcap/tidb) -  Distributed HTAP database compatible with the MySQL protocol
* [Vitess](http://vitess.io/) - Horizontal scaling of MySql by Youtube
* [YugabyteDB](https://docs.yugabyte.com/latest/deploy/kubernetes/) - Horizontally scalable, Postgres-compatible SQL database.

## Networking

* [Antrea](https://github.com/vmware-tanzu/antrea/) - A Kubernetes networking solution based on Open vSwitch
* [AWS VPC CNI](https://github.com/aws/amazon-vpc-cni-k8s) - Networking plugin using Elastic Network Interfaces
* [Calico](http://www.projectcalico.org/)
* [Canal](https://github.com/tigera/canal) by [Tigera](https://github.com/tigera)
* [Cilium](https://github.com/cilium/cilium)
* [Cisco ACI](https://www.cisco.com/c/en/us/td/docs/switches/datacenter/aci/apic/sw/kb/b_Kubernetes_Integration_with_ACI.html) - CNI plugin from Cisco support ACI fabrics
* [CNI-Genie](https://github.com/Huawei-PaaS/CNI-Genie)
* [cni-ipvlan-vpc-k8s](https://github.com/lyft/cni-ipvlan-vpc-k8s)
* [External DNS](https://github.com/kubernetes-incubator/external-dns) - To control DNS records dynamically via Kube resources
* [Goldpinger](https://github.com/bloomberg/goldpinger) display, monitor and alert on inter-cluster connectivity
* [illuminatio](https://github.com/inovex/illuminatio) is a tool for automatically testing kubernetes network policies
* [Infoblox](https://github.com/infobloxopen/cni-infoblox)
* [Kube-router](http://github.com/cloudnativelabs/kube-router)
* [KubeIP](http://github.com/doitintl/kubeip) Set static ip for nodes on GKE (useful for whitelisting ips)
* [kubernetes-network-policy-recipes](https://github.com/ahmetb/kubernetes-network-policy-recipes)
* [Kuryr](https://github.com/openstack/kuryr-kubernetes)
* [Linen](https://github.com/John-Lin/linen-cni)
* [Multus-cni](https://github.com/k8snetworkplumbingwg/multus-cni) - Multi-homed pod cni
* [Network-Controller](https://github.com/linkernetworks/network-controller) - Open vSwitch, Multiple network interfaces that associate with Kubernetes pods
* [NSX-T](https://www.vmware.com/products/nsx/cloud-native-apps.html) - CNI plugin supporting load balancing and distributed firewalls.
* [Nuage](https://github.com/nuagenetworks/nuage-kubernetes)
* [OpenContrail](https://github.com/Juniper/contrail-kubernetes)
* [OpenVSwitch](http://openvswitch.org/)
* [Romana](http://romana.io/)
* [Weave Net](http://www.weave.works/docs/net/latest/kubernetes/kube-addon/)
* [Submariner: Cross-Cluster Network Connectivity for Kubernetes](https://submariner.io) - Submariner enables direct networking between pods in different Kubernetes clusters on prem or in the cloud.

## Service mesh

* [Consul](https://www.consul.io/docs/platform/k8s/index.html)
* [Envoy](https://www.envoyproxy.io/)
* [Istio](http://istio.io/)
* [Linkerd](http://linkerd.io/getting-started/k8s/)
* [Weave Mesh](https://github.com/weaveworks/mesh)
* [Maesh: Simpler Service Mesh](https://github.com/containous/maesh) - Maesh is a straight-forward, easy to configure, and non-invasive service mesh that allows visibility and management of the traffic flows inside any Kubernetes cluster.
* [Cilium](https://cilium.io/) - eBPF-based Networking, Observability, and Security

## RPC

* [gRPC](http://grpc.io)


## Secret generation and management

* [CyberArk Conjur Kubernetes Authenticator](https://developer.conjur.net/reference/integrations/kubernetesopenshift.html) - Secure your Kubernetes-deployed applications with CyberArk Conjur
* [External Secrets Operator](https://github.com/external-secrets/external-secrets/)
* [k8sec](https://github.com/dtan4/k8sec)
* [Kamus](https://github.com/Soluto/kamus) - A GitOps, zero-trust solution for secrets encryption/decryption solution.
* [kubernetes-vault](https://github.com/Boostport/kubernetes-vault)
* [kubesec](https://github.com/shyiko/kubesec) - Secure Secret management
* [Sealed Secrets](https://github.com/bitnami-labs/sealed-secrets)
* [Secure GitOps Using Weave Cloud Deploy And Bitnami's Sealed Secrets](https://engineering.bitnami.com/articles/secure-gitops.html)
* [Vault auth plugin backend: Kubernetes](http://www.vaultproject.io/docs/auth/kubernetes.html)
* [Vault controller](https://github.com/kelseyhightower/vault-controller)

## Web applications

* [Kubernator](https://github.com/smpio/kubernator)
* [Kubernetes Resource Report](https://codeberg.org/hjacobs/kube-resource-report) - report Kubernetes cluster and pod resource requests vs usage and generate static HTML
* [Kubeapps](https://github.com/kubeapps/kubeapps) - A web-based UI for deploying and managing applications in Kubernetes clusters
* [Kubevious](https://github.com/kubevious/kubevious) - An open source UI to make Kubernetes configuration and state obvious and safe.
* [Octant](https://github.com/vmware-tanzu/octant) - A web-based, highly extensible platform for developers to better understand the complexity of Kubernetes clusters.
* [KubeHelper](https://github.com/KubeHelper/kubehelper) - KubeHelper - simplifies many daily Kubernetes cluster tasks through a web interface.
* [Portainer](https://github.com/portainer/portainer) - Containerized web-based UI for managing for Docker, Docker Swarm and Kubernetes environments.
* [CyclopsUI](https://github.com/cyclops-ui/cyclops) - Dynamically rendered UI for Kubernetes resources based on Helm templating engine

## Desktop applications

* [Kubernetic](https://kubernetic.com/)
* [Kube Forwarder](http://kube-forwarder.pixelpoint.io) – An open source Kubernetes port forwarding manager
* [Lens](https://github.com/lensapp/lens) - The Ultimate Dashboard For Kubernetes.
* [Monokle](https://github.com/kubeshop/monokle/) - helps you create, edit and validate yaml manifests, visualize and validate resource links and dependencies, connect and compare resources to your clusters, debug the output of kustomize and helm, and more!
* [Aptakube](https://aptakube.com) - A modern, lightweight and multi-cluster desktop client for Kubernetes. Connect to multiple clusters simultaneously, as if it was just one big cluster. View, edit and manage all your resources from your desktop.
* [Kubernetes Insider for Docker Desktop](https://github.com/spurin/kubernetes-insider) - The Kubernetes Insider provides quick and easy access to Kubernetes Pods/Deployments and Services, running in Docker Desktop Kubernetes.
* [K8Studio](https://github.com/guiqui/k8Studio) - K8Studio is a cross-platform client IDE to manage Kubernetes Clusters.
* [KFtray](https://github.com/hcavarsan/kftray) - Manage and run multiple kubectl port-forward configurations directly in the menu bar, syncing configurations with git repositories.

## Mobile applications

* [Cabin](https://github.com/bitnami/cabin)

## API/CLI adaptors

* [awesome-kubectl-plugins](https://github.com/ishantanu/awesome-kubectl-plugins) - Curated list of kubectl plugins.
* [click](https://github.com/databricks/click) - A CLI focused REPL for quickly interacting with Kubernetes objects.
* [kconf](https://github.com/particledecay/kconf) - Manage multiple kubeconfigs easily and switch between them
* [Ksql](https://github.com/brendandburns/ksql)
* [kube-prompt](https://github.com/c-bata/kube-prompt) - Interactive kubernetes client built using go-prompt.
* [kube-ps1](https://github.com/jonmosco/kube-ps1) - Kubernetes prompt helper for bash and zsh.
* [Kube-shell](https://github.com/cloudnativelabs/kube-shell) - Integrated shell for working with the Kubernetes CLI
* [kube-tmux](https://github.com/jonmosco/kube-tmux) - Kubernetes tmux plugin to display the current context and namespace
* [Kubectl Aliases](https://github.com/ahmetb/kubectl-aliases) - Aliases for Kubectl
* [kubectl-plugins](https://github.com/jordanwilson230/kubectl-plugins) - A collection of kubectl plugins handling everything from easy context switches to connecting to a container as any user (root included) via exec. Slightly tailored towards GKE users.
* [kubectl-trace](https://github.com/iovisor/kubectl-trace) - Schedule bpftrace programs on your kubernetes cluster using this kubectl plugin
* [kubectld](https://github.com/rancher/kubectld)
* [kubectx](https://github.com/ahmetb/kubectx) - switch between clusters on kubectl
* [Kubefuse](http://opencredo.com/introducing-kubefuse-file-system-kubernetes/)
* [kubens](https://github.com/ahmetb/kubectx) - switch between namespaces on kubectl
* [kubensx](https://github.com/shyiko/kubensx) - Simpler Cluster/User/Namespace switching for Kubernetes (featuring interactive mode and wildcard/fuzzy matching).
* [kubent](https://github.com/doitintl/kube-no-trouble) - Easily check your cluster for use of deprecated APIs
* [kubeplay](https://github.com/errordeveloper/kubeplay)
* [Kubesh](https://github.com/projectodd/kubernetes/blob/kubesh/cmd/kubesh/README.md) - Work around kubectl
* [Kui](https://github.com/IBM/kui) - Hybrid CLI/GUI alternative to kubectl
* [StackStorm](https://github.com/StackStorm/st2)
* [stern](https://github.com/stern/stern) - Multi pod and container log tailing
* [Vikube](https://github.com/c9s/vikube.vim) - Kubernetes operations from Vim, in Vim
* [K9s](https://github.com/derailed/k9s) - Kubernetes CLI To Manage Your Clusters In Style!
* [tubectl](https://github.com/reconquest/tubekit) - Kubernetes CLI on steroids with pattern matching
* [webkubectl](https://github.com/webkubectl/webkubectl) - A web based tool helps you to manage kubernetes credentials and run kubectl command in web browser.
* [kubectl-neat](https://github.com/itaysk/kubectl-neat) - Clean up Kuberntes yaml and json output
* [Kubie](https://github.com/sbstp/kubie) - An alternative to kubectx, kubens and the k on prompt modification script
* [kube-shell](https://github.com/cloudnativelabs/kube-shell) - An integrated shell for working with the Kubernetes CLI
* [Portainer](https://github.com/portainer/portainer) - Secure REST API proxy to Kubernetes environments, enabling integrations with external tools.
* [kubernetes-el](https://github.com/kubernetes-el/kubernetes-el) - Kubernetes client for Emacs

## Application deployment orchestration

* [AppController](https://github.com/Mirantis/k8s-AppController)
* [Brigade](https://github.com/Azure/brigade) - Event Based Scripting using JavaScript
* [Deployment manager](https://cloud.google.com/deployment-manager/)
* [ElasticKube](https://github.com/ElasticBox/elastickube)
* [Gitkube](https://github.com/hasura/gitkube/) - Build and deploy docker images on Kubernetes using `git push`.
* [IBM UrbanCode](https://developer.ibm.com/urbancode/plugin/kubernetes/)
* [Kb8or](https://github.com/UKHomeOffice/kb8or)
* [Psykube](https://github.com/commercialtribe/psykube)
* [Skaffold](https://github.com/GoogleCloudPlatform/skaffold) - Command line tool that facilitates continuous development for Kubernetes applications.
* [kubedog](https://github.com/flant/kubedog) - Kubedog is a library and cli utility that allows watching and following kubernetes resources in CI/CD deploy pipelines.
* [kapp](https://github.com/k14s/kapp) - simple deployment tool focused on the concept of "Kubernetes application" — a set of resources with the same label

## Configuration

* [Ansible](https://docs.ansible.com/ansible/latest/modules/k8s_module.html)
* [Astrobase](https://www.astrobase.cloud)
* [cdk8s](https://cdk8s.io) - Define Kubernetes apps and reusable components using familiar programming languages
* [Chef](http://supermarket.chef.io/cookbooks/kubernetes)
* [Habitat](http://www.habitat.sh/docs/best-practices/#kubernetes)
* [Jsonnet](https://github.com/google/jsonnet/tree/master/case_studies/kubernetes)
* [K8comp](https://github.com/cststack/k8comp)
* [kapitan](https://github.com/deepmind/kapitan) - Manage complex deployments using jsonnet and jinja2
* [kenv](https://github.com/thisendout/kenv)
* [Kompose](https://github.com/kubernetes/kompose)
* [Konfd](https://github.com/kelseyhightower/konfd)
* [Ktmpl](https://github.com/jimmycuadra/ktmpl)
* [kubecfg](https://github.com/bitnami/kubecfg) - Combines jsonnet and kubectl to let you declare systems in an easy to override way
* [kubediff](https://github.com/weaveworks/kubediff)
* [kubegen](https://github.com/errordeveloper/kubegen)
* [kustomize](https://github.com/kubernetes-sigs/kustomize) - Customization using partial specs
* [Pulumi](https://www.pulumi.com/kubernetes/) - Provides a SDK for k8s deployments targeting on-premises clusters and major cloud vendors' managed services.
* [Puppet](http://forge.puppet.com/garethr/kubernetes/readme)
* [Saltstack](http://docs.saltstack.com/en/latest/ref/modules/all/salt.modules.k8s.html)
* [Cue](https://cue.googlesource.com/cue/+/HEAD/doc/tutorial/kubernetes/README.md) - A data constraint language which aims to simplify tasks involving defining and using data. Cue is a superset of JSON
* [ytt](https://github.com/k14s/ytt) - YAML templating tool that works on YAML structure allowing you to focus on your data instead of how to properly escape it.
* [kosko](https://github.com/tommy351/kosko) - Write Kubernetes manifests in JavaScript and validate against Kubernetes OpenAPI definitions.
* [MicroConfig](https://microconfig.io) - Awesome tool for microservice configuration management. Works with app configs, helm values, kubernetes resources and more.
* [Untrak](https://github.com/yanc0/untrak) - Finds untracked resources in Kubernetes cluster, garbage collect them.
* [Project Syn](https://syn.tools) - Brings a hierarchical configuration management based on GitOps principles

## Security
* [kubiscan](https://github.com/cyberark/KubiScan) - A tool to scan Kubernetes cluster for risky pods and RBAC permissions
* [kubeletctl](https://github.com/cyberark/kubeletctl) - A client for kubelet with advanced capabilities like scanning for pods vulnerable for RCE
* [Anchore Engine](https://github.com/anchore/anchore-engine) - An open-source project that provides a centralized service for inspection, analysis, and certification of container images.
* [Aquasec](http://blog.aquasec.com/topic/kubernetes)
* [Authenticator](https://github.com/kubernetes-sigs/aws-iam-authenticator) - A tool for using AWS IAM credentials to authenticate to a Kubernetes cluster
* [Deepfence ThreatStryker](https://deepfence.io/threatstryker) - Full life cycle Cloud Native Security Observability Platform for kubernetes, virtual machines and serverless.
* [Deepfence ThreatMapper](https://github.com/deepfence/ThreatMapper) - Apache v2, powerful runtime vulnerability scanner for kubernetes, virtual machines and serverless.
* [Dex](https://github.com/dexidp/dex) - OpenID and OAuth for Kubernetes
* [Fairwinds Insights](https://fairwinds.com/insights) - Security policy and enforcement for Kubernetes
* [Guard](https://github.com/appscode/guard) - Authenticaton webhook server with support for Github, Gitlab, Google, Azure and LDAP (AD) as identity providers.
* [kiam](https://github.com/uswitch/kiam) -  Allows cluster users to associate AWS IAM roles to Pods.
* [kube-bench](https://github.com/aquasecurity/kube-bench) - The Kubernetes Bench for Security is a Go application that checks whether Kubernetes is deployed according to security best practices.
* [kube-hunter](https://github.com/aquasecurity/kube-hunter) - Hunt for security weaknesses in Kubernetes clusters.
* [kube-psp-advisor](https://github.com/sysdiglabs/kube-psp-advisor) - Help building an adaptive and fine-grained pod security policy.
* [kube2iam](https://github.com/jtblin/kube2iam) - Provides different AWS IAM roles for pods running on Kubernetes
* [kubeaudit](https://github.com/Shopify/kubeaudit) - Helps you audit your Kubernetes clusters against common security controls
* [Kubesec.io](http://kubesec.io/)
* [Pomerium](http://www.pomerium.io/) - a zero-trust identity-aware access proxy inspired by BeyondCorp.
* [Rakkess](https://github.com/corneliusweig/rakkess) - Kubectl plugin to show an access matrix for all available resources.
* [Sysdig Falco](https://sysdig.com/opensource/falco/)
* [Sysdig Secure](http://www.sysdig.com/products/secure)
* [Tigera Calico Enterprise Edition](https://www.tigera.io/tigera-products/calico-enterprise/)
* [Twistlock](http://www.twistlock.com/)
* [M9sweeper](https://github.com/m9sweeper/m9sweeper) - Free security platform that wraps trivy, kubesec, kube-bench, OPA Gatekeeper, Project Falco, and kube-hunter

## Load balancing

* [Apache APISIX - Cloud-Native API gateway and ingress controller](https://github.com/apache/apisix)
* [Avi Networks - Software Load Balancer | Intelligent WAF | Elastic Service Mesh](https://avinetworks.com/)
* [AWS ALB Ingress Controller](https://github.com/kubernetes-sigs/aws-alb-ingress-controller)
* [Cloudflare Warp Ingress](https://github.com/cloudflare/cloudflare-ingress-controller)
* [Contour](https://github.com/projectcontour/contour) - Kubernetes ingress controller for Lyft's Envoy proxy
* [F5 Big IP Controller](https://github.com/F5Networks/k8s-bigip-ctlr)
* [Gimbal](https://github.com/vmware-tanzu/gimbal) - Platform capable of routing traffic to multiple Kubernetes and OpenStack clusters
* [Gloo - Envoy-based API gateway and ingress controller](https://github.com/solo-io/gloo)
* [HAProxy Ingress](https://github.com/jcmoraisjr/haproxy-ingress)
* [k8gb](https://www.k8gb.io/) - A cloud native Kubernetes Global Balancer
* [Linode NodeBalancer Ingress](https://github.com/linode/linode-cloud-controller-manager)
* [LoxiLB](https://github.com/loxilb-io/loxilb) - eBPF based cloud-native load-balancer for any Kubernetes environments.
* [MetalLB](https://metallb.universe.tf/) - load-balancer implementation for bare metal Kubernetes clusters, using standard routing protocols.
* [Porter](https://github.com/kubesphere/porter) - a load balancer which is designed for a bare metal Kubernetes cluster. It's implemented by physical switch, and uses BGP and ECMP to achieve optimal performance and HA.
* [PureLB](http://purelb.io) - open-source load-balancer orchestrator for Kubernetes clusters. It uses standard Linux networking and routing protocols, and works with the operating system to announce service addresses.
* [NGINX Ingress Controller](https://github.com/kubernetes/ingress-nginx)
* [Nginx Plus](http://www.nginx.com/blog/load-balancing-kubernetes-services-nginx-plus/)
* [Skipper](https://github.com/zalando/skipper) - HTTP router and reverse proxy for service composition, including use cases like Kubernetes Ingress
* [Kong Ingress](https://github.com/Kong/kubernetes-ingress-controller): Kubernetes ingress controller for using Kong proxy
* [Emissary Ingress](https://github.com/emissary-ingress/emissary): Emissary ingress built on top of Envoy
* [Traefik](https://containo.us/traefik/)
* [Voyager - Secure HAProxy based Ingress Controller](https://github.com/appscode/voyager)
* [Yggdrasil - Envoy Control Plane for Kubernetes Multi-cluster Ingress](https://github.com/uswitch/yggdrasil)

## Big Data

* [Kube-Yarn](https://github.com/Comcast/kube-yarn)
* [Spark](https://github.com/kubernetes/examples/tree/master/staging/spark)

## Machine Learning

* [nos](https://github.com/nebuly-ai/nos) - `nos` is an open-source platform to efficiently run AI workloads on Kubernetes, increasing GPU utilization and reducing infrastructure and operational costs.
* [FfDL](https://github.com/IBM/FfDL) - Deep Learning Platform offering TensorFlow, Caffe, PyTorch etc. as a Service on Kubernetes
* [Fiber](https://github.com/uber/fiber) - Distributed computing library for AI on Kubernetes.
* [kubeflow](https://github.com/google/kubeflow) - Machine Learning Toolkit for Kubernetes.
* [mxnet-operator](https://github.com/deepinsight/mxnet-operator) - Tools for ML/MXNet on Kubernetes.
* [Polyaxon](https://github.com/polyaxon/polyaxon) - An open source platform for reproducible machine learning and deep learning on kubernetes
* [seldon-core](https://github.com/SeldonIO/seldon-core) - Open source framework for deploying machine learning models on Kubernetes
* [TensorFlow k8s](https://github.com/tensorflow/k8s)

## Service Discovery

* [Consul](http://consul.io)
  * [Kelsey Hightower Consul](https://github.com/kelseyhightower/consul-on-kubernetes)
  * [Bridge between Kubernetes and Consul](https://github.com/Beldur/kube2consul)

## Operating System

* [Bottlerocket](https://github.com/bottlerocket-os/bottlerocket)
* [Fedora CoreOS](https://getfedora.org/en/coreos/)
* [Flatcar Container Linux](https://www.flatcar-linux.org/)
* [GCI](https://cloud.google.com/container-optimized-os/docs/)
* [Kairos](https://github.com/kairos-io/kairos)
* [k3OS](https://github.com/rancher/k3os)
* [LinuxKit](https://github.com/linuxkit/kubernetes)
* [Talos](https://github.com/talos-systems/talos)

## YAML/JSON Config

* [cdk8s](https://cdk8s.io) - Define Kubernetes apps and reusable components using familiar programming languages
* [kompose](https://github.com/kubernetes/kompose) - Translates Docker Compose file into Kubernetes resources
* [kube-libsonnet](https://github.com/bitnami-labs/kube-libsonnet/blob/master/kube.libsonnet) - Generic library of Kubernetes objects for Jsonnet/Kubecfg with object to array mapping for painless overrides.
* [kubegen](https://github.com/errordeveloper/kubegen) - Reduces the verbosity of Kubernetes resource definitions, and adds macros for templating
* [kubeval](https://github.com/garethr/kubeval) - CLI tool for validating a Kubernetes YAML or JSON configuration file
* [KubeQ](https://kubeq.click) - A fast, simple, and powerful web-based Kubernetes manifest validator. No installation or config needed—just paste your manifest and get instant feedback on quality, security, and best practices. Powered by kubeval, kube-score, and kubeaudit. Great for pre-commit validation, reviewing charts, teaching, and CI/CD linting.
* [helmify](https://github.com/arttor/helmify) - CLI tool to convert K8s YAMLs into a Helm chart

## Static Analysis

* [kube-score](https://github.com/zegl/kube-score) - Kubernetes object analysis with recommendations for improved reliability and security
* [popeye](https://github.com/derailed/popeye) - Kubernetes cluster resource sanitzer

## Tuning

* [Ktune](https://github.com/skippbox/ktune)

## Backup and Disaster Recovery

* [Kanister](https://github.com/kanisterio/kanister) - An extensible framework for application-level data management on Kubernetes.
* [Velero](https://github.com/vmware-tanzu/velero) - Utility for managing backup and restore of Kubernetes clusters. Formerly Heptio Ark.
* [K8up](https://github.com/vshn/k8up) - Kubernetes and OpenShift Backup Operator based on restic
* [burry.sh](https://github.com/mhausenblas/burry.sh) - Cloud Native backup and recovery for etcd, zookeeper and consul
* [kube-backup](https://github.com/pieterlange/kube-backup) - Sync kubernetes state to git.
* [Stash](https://github.com/stashed/stash) - Stash is a Kubernetes operator that uses restic or Kubernetes CSI Driver VolumeSnapshotter  to backup your volumes and kubernetes state.
* [Fairwinds Gemini](https://github.com/FairwindsOps/gemini) - Create and retire VolumeSnapshot objects on a regular schedule

## Policy Management

* [Kyverno](https://github.com/nirmata/kyverno) - Kubernetes Native Policy Management

## Plugins

* [Krew - Plugin Manager](https://github.com/kubernetes-sigs/krew/)
* [Kboom](https://github.com/mhausenblas/kboom)
* [View-utilization](https://github.com/etopeter/kubectl-view-utilization)

## Debug

* [Kubectl-Debug](https://github.com/aylei/kubectl-debug)
* [mirrord](https://github.com/metalbear-co/mirrord) - Connect your local process and your k8s cluster, letting you run local code in cloud conditions. 

## Benchmark Tools

* [Kubestone](https://github.com/xridge/kubestone/)

## Chaos Engineering

* [Chaosblade](https://github.com/chaosblade-io/chaosblade): An easy to use and powerful chaos engineering experiment toolkit.
* [Chaos Mesh](https://github.com/pingcap/chaos-mesh): A cloud-native Chaos Engineering platform that orchestrates chaos on Kubernetes environments.
* [chaoskube](https://github.com/linki/chaoskube): `chaoskube` periodically kills random pods in your Kubernetes cluster.
* [Chaos Toolkit](https://github.com/chaostoolkit/chaostoolkit): An Open API for Chaos Engineering.
* [KubeInvaders](https://github.com/lucky-sideburn/KubeInvaders) - Gamified Chaos engineering tool for Kubernetes Clusters. It is like Space Invaders but alien ships are pods.
* [Litmus](https://github.com/litmuschaos/litmus): A toolset to do chaos engineering in a kubernetes native way.

Persistent Volume Providers
=======================================================================

*List of some Persistent Volume Providers for Kubernetes.Check out [Persistent Volume Providers](https://github.com/kubernetes/examples/tree/master/staging/persistent-volume-provisioning) for more info*

* [AWS](http://aws.amazon.com)
* [CephRBD](http://ceph.com/ceph-storage/block-storage/)
* [GCE](https://cloud.google.com/compute/)
* [Glusterfs](http://www.gluster.org/)
* [Hitachi](https://knowledge.hitachivantara.com/Documents/Adapters_and_Drivers/Storage_Adapters_and_Drivers/Containers/1.0/Storage_Plug-in_for_Containers_Quick_Reference_Guide_v1.0.0)
* [HPE](https://github.com/hpe-storage/dory)
* [Kube-Aliyun](https://github.com/kubeup/kube-aliyun)
* [Linode](https://www.linode.com/products/block-storage/)
* [Microsoft](https://github.com/Microsoft/K8s-Storage-Plugins)
* [NetApp Trident](https://github.com/NetApp/trident)
* [OpenEBS](http://github.com/openebs/openebs/)
* [OpenStack Cinder](http://wiki.openstack.org/cinder)
* [Portworx](http://portworx.com/)
* [Pure Storage](https://hub.docker.com/r/purestorage/k8s/)
* [QuoByte](http://www.quobyte.com/)
* [Rancher Longhorn](https://github.com/rancher/longhorn)
* [Rook](http://rook.io/)
* [StorageOS](http://storageos.com)
* [Stork](https://github.com/libopenstorage/stork)
* [simplyblock](https://simplyblock.io)

Container Storage Interface Plugins
=======================================================================

*List of some [Container Storage Interface](https://kubernetes-csi.github.io/docs/) plugins for Kubernetes. Check out [Kubernetes-CSI Drivers](https://kubernetes-csi.github.io/docs/drivers.html) for a complete list*

* [Alibaba Cloud](https://github.com/kubernetes-sigs/alibaba-cloud-csi-driver)
* [AWS EBS](https://github.com/kubernetes-sigs/aws-ebs-csi-driver)
* [AWS EFS](https://github.com/kubernetes-sigs/aws-efs-csi-driver)
* [AWS FSx for Lustre](https://github.com/kubernetes-sigs/aws-fsx-csi-driver)
* [Ceph](https://github.com/ceph/ceph-csi)
* [Cinder](https://github.com/kubernetes/cloud-provider-openstack/tree/master/pkg/csi/cinder)
* [Cloudscale](https://github.com/cloudscale-ch/csi-cloudscale)
* [DigitalOcean](https://github.com/digitalocean/csi-digitalocean)
* [Ember](https://ember-csi.io)
* [Google Compute Engine Persistent Disk](https://github.com/kubernetes-sigs/gcp-compute-persistent-disk-csi-driver)
* [Intel PMEM-CSI](https://github.com/intel/pmem-CSI)
* [JuiceFS](https://github.com/juicedata/juicefs-csi-driver)
* [KaDalu - Gluster](https://github.com/kadalu/kadalu)
* [Linode Block Storage](https://github.com/linode/linode-blockstorage-csi-driver)
* [Longhorn](https://github.com/longhorn/longhorn)
* [NetApp Trident](https://github.com/NetApp/trident)
* [Nexenta](https://nexentaedge.io/docs/kubernetes-csi.html)
* [OpenEBS](http://github.com/openebs/openebs/)
* [OpenSDS](https://github.com/opensds/nbp/tree/master/csi)
* [OpenStack Cinder](https://github.com/kubernetes/cloud-provider-openstack/tree/master/pkg/csi/cinder)
* [Portworx](https://github.com/libopenstorage/openstorage/tree/master/csi)
* [Quobyte](https://github.com/quobyte/quobyte-csi)
* [S3](https://github.com/ctrox/csi-s3)
* [Vault](https://github.com/kubevault/csi-driver)
* [VMware vSphere](https://github.com/kubernetes-sigs/vsphere-csi-driver)

Cluster API Providers
=======================================================================

*List of some [Cluster API](https://github.com/kubernetes-sigs/cluster-api) providers for Kubernetes. Check out [Kubernetes-CAPI Providers](https://cluster-api.sigs.k8s.io/reference/providers.html) for more info*

  ### Bootstrap

   - [Kubeadm](https://github.com/kubernetes-sigs/cluster-api/tree/master/bootstrap/kubeadm)

  ### Infrastructure

   - [AWS](https://github.com/kubernetes-sigs/cluster-api-provider-aws)
   - [Azure](https://github.com/kubernetes-sigs/cluster-api-provider-azure)
   - [Metal3-io](https://github.com/metal3-io/cluster-api-provider-baremetal)
   - [DigitalOcean](https://github.com/kubernetes-sigs/cluster-api-provider-digitalocean)
   - [GCP](https://github.com/kubernetes-sigs/cluster-api-provider-gcp)
   - [IBM Cloud](https://github.com/kubernetes-sigs/cluster-api-provider-ibmcloud)
   - [OpenStack](https://github.com/kubernetes-sigs/cluster-api-provider-openstack)
   - [VMware vSphere](https://github.com/kubernetes-sigs/cluster-api-provider-vsphere)

Developer Libraries/ Scripts
=======================================================================

*List of some libraries & scripts for executions and good referrals*

  ### [Python](#python)

   - [Pykube](https://github.com/hjacobs/pykube)
   - [kr8s](https://github.com/kr8s-org/kr8s)

  ### [Jenkins](#jenkins)

   - [Jenkinsfile with Helm, Go, Docker, Kubectl, JNLP](https://github.com/lachie83/croc-hunter/blob/master/Jenkinsfile)
