(governance)=

# Governance

```{toctree}
:hidden:

people
```

## Summary

Ray adopts a technical governance structure that is hierarchical.
- A community of **contributors** who file issues, make pull requests, and contribute to the project.
- A set of **committers** who drive Ray development.
- A **technical steering committee** which drives the overall project direction.
- A few **lead maintainers** who are the catch-all decision makers.

All committers are expected to have a strong bias toward Ray’s design philosophy.

## Committers

Committers are responsible for approving pull requests before they are merged. Approval from a committer is required before a pull request can be merged.

The criteria for becoming a committer will be outlined by the TSC. Committers are added by a supermajority (greater than 67%) of the TSC and removed by a majority vote (greater than 50%) of the TSC.

Committers are automatically moved to emeritus status after 12 months with no merged pull requests authored or reviewed. Reactivation is by a TSC vote.

## Technical Steering Committee

The technical steering committee (the "TSC") is responsible for all technical oversight of Ray. In particular, shepherding and approving [Ray Enhancement Proposals](https://github.com/ray-project/enhancements).

The TSC can have up to 7 members. This ceiling can be raised by a supermajority (greater than 67%) of the TSC.

The TSC members are listed in {ref}`people`.

The TSC makes decisions by consensus. For difficult decisions, in case of a failure to reach consensus, the decision is made by a majority vote (greater than 50%) of the lead maintainers.

Any member of the TSC can nominate someone to become a member of the TSC. The addition or removal of a TSC member requires a supermajority (greater than 67%) of the entire TSC and a majority (greater than 50%) of the lead maintainers.

## Lead maintainers

There may be difficult decisions in which the TSC cannot come to a consensus. To make such difficult decisions, the TSC has assigned a small set of lead maintainers among them.

The lead maintainers are listed in {ref}`people`.

Any lead maintainer can be removed by a supermajority (greater than 67%) of the TSC.

Following the resignation, removal, or permanent unavailability of a lead maintainer, a supermajority (greater than 67%) of the TSC can decide to replace the lead maintainer. Replacement is handled by a ranked-choice ballot among the TSC. The number of lead maintainers must stay between 1 and 3 (inclusive).

## General Project Policies

Ray has been established as Ray a Series of LF Projects, LLC. Policies applicable to Ray and participants in Ray, including guidelines on the usage of trademarks, are located at https://www.lfprojects.org/policies/.

Ray participants acknowledge that the copyright in all new contributions will be retained by the copyright holder as independent works of authorship and that no contributor or copyright holder will be required to assign copyrights to the project. Except as described below, all code contributions to the project must be made using the Apache License, Version 2.0 available at http://www.apache.org/licenses/LICENSE-2.0 (the “Project License”). All outbound code will be made available under the Project License. The lead maintainers may approve the use of an alternative open license or licenses for inbound or outbound contributions on an exception basis.

## Amendments

Charter amendments require (a) a supermajority (greater than 67%) of the TSC, (b) a majority (greater than 50%) of the lead maintainers, and \(c) approval of LF Projects, LLC.
