import os
import sys
from pathlib import Path

import pytest

if __name__ == "__main__":
    curr_dir = Path(__file__).parent
    test_paths = curr_dir.rglob("test_*.py")
    sorted_path = sorted(map(lambda path: str(path.absolute()), test_paths))
    serve_tests_files = list(sorted_path)

    print("Testing the following files")
    for test_file in serve_tests_files:
        print("->", test_file.split("/")[-1])

    print("Setting RAY_SERVE_INTENTIONALLY_CRASH=1")
    os.environ["RAY_SERVE_INTENTIONALLY_CRASH"] = "1"

    sys.exit(pytest.main(["-v", "-s"] + serve_tests_files))
