from setuptools import find_packages, setup

setup(
    name="ray_release",
    packages=find_packages(
        where=".",
        include=[
            package for package in find_packages() if package.startswith("ray_release")
        ],
    ),
    version="0.0.1",
    author="Ray Team",
    description="The Ray OSS release testing package",
    url="https://github.com/ray-project/ray",
    install_requires=[
        # Keep this in sync with requirements_py310.in
        "aioboto3",
        "anyscale >= 0.26.1",
        "aws_requests_auth",
        "azure-identity",
        "azure-storage-blob",
        "bazel-runfiles",
        "boto3",
        "click",
        "freezegun",
        "google-cloud-storage",
        "jinja2",
        "msal",
        "protobuf >= 3.15.3, != 3.19.5",
        "pytest",
        "pyyaml",
        "pybuildkite",
        "pydantic >= 2.5.0",
        "PyGithub",
        "requests",
        "twine == 6.2.0",
        "docker >= 7.1.0",
    ],
)
