// Copyright 2021 The Ray Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include "ray/common/runtime_env_common.h"
namespace ray {

bool IsRuntimeEnvEmpty(const std::string &serialized_runtime_env) {
  return serialized_runtime_env == "{}" || serialized_runtime_env == "";
}

bool IsRuntimeEnvInfoEmpty(const std::string &serialized_runtime_env_info) {
  return serialized_runtime_env_info == "{}" || serialized_runtime_env_info == "";
}

}  // namespace ray
