// Copyright 2024 The Ray Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include "ray/common/source_location.h"

namespace ray {

bool IsValidSourceLoc(const SourceLocation &loc) { return !loc.filename.empty(); }

std::ostream &operator<<(std::ostream &os, const SourceLocation &loc) {
  if (IsValidSourceLoc(loc)) {
    os << loc.filename << ":" << loc.line_no;
  }
  return os;
}

}  // namespace ray
