import pytest

from reflex.base import Base

pytest.importorskip("pydantic")


@pytest.fixture
def child() -> Base:
    """A child class.

    Returns:
        A child class.
    """

    class Child(Base):
        num: float
        key: str

    return Child(num=3.15, key="pi")


def test_get_fields(child):
    """Test that the fields are set correctly.

    Args:
        child: A child class.
    """
    assert child.__fields__.keys() == {"num", "key"}


def test_json(child):
    """Test converting to json.

    Args:
        child: A child class.
    """
    assert child.json().replace(" ", "") == '{"num":3.15,"key":"pi"}'


@pytest.fixture
def complex_child() -> Base:
    """A child class.

    Returns:
        A child class.
    """

    class Child(Base):
        num: float
        key: str
        name: str
        age: int
        active: bool

    return Child(num=3.15, key="pi", name="John Doe", age=30, active=True)


def test_complex_get_fields(complex_child):
    """Test that the fields are set correctly.

    Args:
        complex_child: A child class.
    """
    assert complex_child.__fields__.keys() == {"num", "key", "name", "age", "active"}


def test_complex_json(complex_child):
    """Test converting to json.

    Args:
        complex_child: A child class.
    """
    assert (
        complex_child.json().replace(" ", "")
        == '{"num":3.15,"key":"pi","name":"JohnDoe","age":30,"active":true}'
    )
