from AppKit import NSApp, NSRunAlertPanel, NSTerminateNow
from Foundation import NSObject
from PyObjCTools import AppHelper


def exception_handler():
    import os
    import sys
    import traceback

    typ, info, trace = sys.exc_info()
    if typ in (KeyboardInterrupt, SystemExit):
        return
    tracetop = traceback.extract_tb(trace)[-1]
    tracetext = "File %s, Line %d" % tracetop[:2]
    if tracetop[2] != "?":
        tracetext += ", Function %s" % tracetop[2]
    exception_message = '%s:\n%s\n\n%s\n"%s"'
    message = exception_message % (str(type), str(info), tracetext, tracetop[3])
    title = os.path.splitext(os.path.basename(sys.argv[0]))[0]
    title = title.capitalize() + " Error"
    NSRunAlertPanel(title, message, None, None, None)


class PygameAppDelegate(NSObject):
    def applicationDidFinishLaunching_(self, aNotification):
        try:
            import aliens

            aliens.main()
        except:  # noqa: E722, B001
            exception_handler()
        NSApp().terminate_(self)

    def applicationShouldTerminate_(self, app):
        import pygame
        import pygame.event

        pygame.event.post(pygame.event.Event(pygame.QUIT))
        return NSTerminateNow


if __name__ == "__main__":
    AppHelper.runEventLoop()
