""" """

import types
import typing

DEFAULT_IMPORT_LEVEL: int

# This is a type defined in altgraph, for now
# I'm not bothering with creating stubs for this
# type.
class Graph(typing.Protocol):
    def node_list(self) -> typing.Iterator[str]: ...

class DependencyInfo(typing.NamedTuple):
    conditional: bool
    function: bool
    tryexcept: bool
    fromlist: bool

class Node:
    debug: int
    graphident: str | None
    identifier: str
    filename: str | None
    packagepath: list[str] | None
    code: types.CodeType | None
    globalnames: set[str]
    starimports: set[str]
    path: list[str]

    # XXX: Custom attributes in py2app
    _py2app_global_reads: typing.Set[str]
    _py2app_global_writes: typing.Set[str]

    def __contains__(self, name: str) -> bool: ...
    def __getitem__(self, name: str) -> typing.Any: ...
    def __setitem__(self, name: str, value: typing.Any) -> None: ...
    def get(self, name: str, default: typing.Any = None) -> typing.Any: ...
    def __eq__(self, other: typing.Any) -> bool: ...
    def __ne__(self, other: typing.Any) -> bool: ...
    def __lt__(self, other: typing.Any) -> bool: ...
    def __le__(self, other: typing.Any) -> bool: ...
    def __gt__(self, other: typing.Any) -> bool: ...
    def __ge__(self, other: typing.Any) -> bool: ...
    def __hash__(self) -> int: ...
    def infoTuple(self) -> tuple[str]: ...
    def __repr__(self) -> str: ...

class Alias: ...
class AliasNode(Node): ...
class BadModule(Node): ...
class ExcludedModule(BadModule): ...
class MissingModule(BadModule): ...

class InvalidRelativeImport(BadModule):
    relative_path: str

class Script(Node): ...

class BaseModule(Node):
    def __init__(
        self,
        name: str,
        filename: typing.Optional[str] = None,
        path: typing.Optional[typing.List[str]] = None,
    ) -> None: ...

class BuiltinModule(BaseModule): ...
class SourceModule(BaseModule): ...
class InvalidSourceModule(SourceModule): ...
class CompiledModule(BaseModule): ...
class InvalidCompiledModule(BaseModule): ...
class Package(BaseModule): ...
class NamespacePackage(Package): ...
class Extension(BaseModule): ...
class FlatPackage(BaseModule): ...
class ArchiveModule(BaseModule): ...
class RuntimeModule(MissingModule): ...

class ModuleGraph:
    replace_paths: typing.Sequence[str] | None
    graph: Graph
    lazynodes: typing.Dict[str, Alias | typing.Tuple[str, ...] | None]
    path: list[str]

    def __init__(
        self,
        path: list[str] | None = None,
        excludes: typing.Sequence[str] = (),
        replace_paths: typing.Sequence[str] | None = (),
        implies: typing.Sequence[str] | None = (),
        graph: typing.Any = None,
        debug: int = 0,
    ): ...
    def findNode(self, node: str | Node | None) -> Node | None: ...
    def _replace_paths_in_code(self, co: types.CodeType) -> types.CodeType: ...
    def _scan_code(self, co: types.CodeType, m: Node) -> None: ...
    def import_hook(
        self,
        name: str,
        caller: Node | None = None,
        fromlist: typing.Sequence[str] | None = None,
        level: int = DEFAULT_IMPORT_LEVEL,
        attr: object | None = None,
    ) -> Node: ...
    def removeReference(self, fromnode: Node | str, tonode: Node | str) -> None: ...
    def run_script(
        self, pathname: str, caller: typing.Optional[Node] = None
    ) -> Node: ...
    def filterStack(
        self, filters: typing.Sequence[typing.Callable[[Node], bool]]
    ) -> typing.Tuple[int, int, int]: ...
    def create_xref(self, fn: typing.IO[str]) -> None: ...
    def graphreport(
        self,
        fileobj: typing.Optional[typing.IO[str]] = None,
        flatpackages: typing.Union[
            typing.Dict[str, str], typing.Sequence[typing.Tuple[str, str]]
        ] = (),
    ) -> None: ...
    def nodes(self) -> typing.Iterator[Node]: ...
    def flatten(
        self,
        condition: typing.Optional[typing.Callable[[Node], bool]] = None,
        start: typing.Optional[typing.Union[str, Node]] = None,
    ) -> typing.Iterable[Node]: ...
    def getReferers(
        self, tonode: typing.Union[str, Node], collapse_missing_modules: bool = True
    ) -> typing.Iterator[Node]: ...
    def edgeData(
        self, fromNode: typing.Union[str, Node], toNode: typing.Union[str, Node]
    ) -> typing.Optional[DependencyInfo]: ...
    def get_edges(
        self, node: str | Node | None
    ) -> typing.Tuple[typing.Iterator[Node], typing.Iterator[Node]]: ...
    def _load_module(
        self,
        fqname: str,
        fp: typing.IO | None,
        pathname: str | None,
        info: tuple[str, str, int],
    ) -> Node: ...
    def createReference(
        self,
        fromnode: str | Node,
        tonode: str | Node,
        edge_data: str | DependencyInfo | None = "direct",
    ) -> None: ...
    def implyNodeReference(
        self,
        node: str | Node,
        other: str | Node,
        edge_data: str | DependencyInfo | None = None,
    ) -> None: ...

def find_module(
    name: str, path: list[str] | None = None
) -> tuple[typing.IO[bytes] | None, str, tuple[str, str, int]]: ...
