# Contribution Guidelines

When making a pull request, please follow these guidelines:

- One commit per suggestion is preferred
- Commit message should follow this format: `Add some tool name` (For
  example, `Add cuckoo-sandbox`) [Why?](http://chris.beams.io/posts/git-commit/)
- Multiple commits per pull request is OK
- Lists within each section are alphabetized, please keep them that way
- Add sections if necessary, use existing sections if possible
- Clear, concise descriptions for each link, starting with a capital, ending
  with a period
- Use the following format: `[Item Name](homepage link) - Description.`
- No duplication of tools, put them where they make the most sense
- Wrap lines at ~80 chars, no trailing whitespace or unnecessary newlines
- Prefer quality over quantity, only submit awesome stuff
- By submitting a pull request, you agree to release your submission under
  the [LICENSE](LICENSE)
- Indent wrapped lines even with the start of the line before

```
- That means lines wrap like
  this
- Not
like this
```


The rules above take precedence, but in case I missed something, check [the
awesome guidelines](https://github.com/sindresorhus/awesome/blob/master/contributing.md)
too.

Properly formatted pull requests will almost always be approved faster than
issues or poorly formatted pull requests, because they mean less work for me!

Thanks!
