# Contribution Guidelines

* Use the following format: `[Package Name](Link URL) - Description`
* The link should be the name of the package or project
* Keep descriptions concise, clear and simple
* New categories, or improvements to the existing ones are also welcome

## General Quality Standard

To get on the list, PR's should follow some quality standards. They should:

* Generally useful to the community.
* Actively maintained (even if that just means acknowledging open issues when they arise).
* Stable.
* Documented.

### Extension Quality Standard

To add an awesome Magento related extension, there are some additional Quality Gates to pass:

* Make sure your Extension's README explains the following parts:
 * General Purpose of the Extension.
 * How to Install.
 * Supported Magento Versions.
 * Requirements (e.g. PHP Version).
* At least one stable release.

If you need help to pass the quality gates, add your questions to the PR too. 

## Blog Quality Standard

Make sure you pass the following Quality Gates:

* The Blog itself should contain posts from at least 3 Months ago.
* The Blog should be focused on Magento.
* There should be at least one article a month.

Thanks to all contributors, you're awesome and wouldn't be possible without you!
