# SaltStack's Security Disclosure Policy

**Email**
- saltproject-security.pdl@broadcom.com

**GPG key ID:**
- 37654A06

**GPG key fingerprint:**
- `99EF 26F2 6469 2D24 973A 7007 E8BF 76A7 3765 4A06`

**GPG Public Key**

```
-----BEGIN PGP PUBLIC KEY BLOCK-----
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=pPmt
-----END PGP PUBLIC KEY BLOCK-----
```

## Reporting a Vulnerability - Private Disclosure Process

The Salt Project Security Team is available at
saltproject-security.pdl@broadcom.com for security-related bug reports or
questions. Emails will be addressed within 3 business days.

We request the disclosure of any security-related bugs or issues be reported
non-publicly until such time as the issue can be resolved and a security-fix
release can be prepared. At that time we will release the fix and make a public
announcement with upgrade instructions and download locations.

**IMPORTANT: Do not file public issues on GitHub for security vulnerabilities**

## Proposed Email Content

Provide a descriptive subject line and in the body of the email include the
following information:

* Basic identity information, such as your name and your affiliation or company.
* Detailed steps to reproduce the vulnerability (POC scripts, screenshots, and
  logs are all helpful to us).
* Description of the effects of the vulnerability on Salt and the related
  hardware and software configurations, so that the VMware Security Team can
  reproduce it.
* How the vulnerability affects Salt usage and an estimation of the attack
  surface, if there is one.
* List other projects or dependencies that were used in conjunction with Salt to
  produce the vulnerability.


## When to report a vulnerability

* When you think Salt has a potential security vulnerability.
* When you suspect a potential vulnerability but you are unsure that it impacts
  Salt.
* When you know of or suspect a potential vulnerability on another project that
  is used by Salt.

## Security response procedure

We take security and the trust of our customers and users very seriously. Our
disclosure policy is intended to resolve security issues as quickly and safely
as is possible.

1.  A security report sent to saltproject-security.pdl@broadcom.com is assigned
    to a team member. This person is the primary contact for questions and will
    coordinate the fix, release, and announcement.

2.  The reported issue is reproduced and confirmed. A list of affected projects
    and releases is made.

3.  Fixes are implemented for all affected projects and releases that are
    actively supported. Back-ports of the fix are made to any old releases that
    are actively supported.

4.  A new release is created and pushed to all affected repositories. The
    release documentation provides a full description of the issue, plus any
    upgrade instructions or other relevant details.

5.  An announcement is made to the
    [salt-users](https://groups.google.com/forum/#!forum/salt-users) and
    [salt-announce](https://groups.google.com/forum/#!forum/salt-announce)
    mailing lists. The announcement contains a description of the issue and a
    link to the full release documentation and download locations.

## Receiving security announcements

Keep an eye on the
[Salt Project Security Announcements](https://saltproject.io/security-announcements/)
landing page. Salt Project recommends subscribing to the
[Salt Project Security RSS feed](https://saltproject.io/security-announcements/index.xml)
to receive notification when new information is available regarding security
announcements.

Other channels to receive security announcements include the
[Salt Project GitHub Discussions](https://github.com/saltstack/salt/discussions)
and the
[Salt Project Community Discord](https://discord.gg/J7b7EscrAs).

## Confidentiality, integrity and availability

We consider vulnerabilities leading to the compromise of data confidentiality,
elevation of privilege, or integrity to be our highest priority concerns.
Availability, in particular in areas relating to DoS and resource exhaustion, is
also a serious security concern. The Salt Project Security Team takes all
vulnerabilities, potential vulnerabilities, and suspected vulnerabilities
seriously and will investigate them in an urgent and expeditious manner.

Note that we do not currently consider the default settings for Salt to be
secure-by-default. It is necessary for operators to explicitly configure
settings, role based access control, and other resource related features in
Salt to provide a hardened Salt environment. We will not act on any security
disclosure that relates to a lack of safe defaults. Over time, we will work
towards improved safe-by-default configuration, taking into account backwards
compatibility.

## Guidance on Salt and security best practices

Reference the following documentation to ensure Salt best practices are being
implemented in your infrastructure:

- [Docs: Hardening Salt](https://docs.saltproject.io/en/master/topics/hardening.html)
- [Docs: Salt Best Practices](https://docs.saltproject.io/en/master/topics/best_practices.html)
- [Blog: How I Hardened My Salt Environment](https://saltproject.io/blog/how-i-hardened-my-salt-environment/)
